/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;

public class SwitchCaseObfVisitor7 {
    public static byte[] transform(byte[] classData) throws AnalyzerException {
        ClassNode classNode = new ClassNode();
        ClassReader cr = new ClassReader(classData);
        cr.accept(classNode, 0);
        if (!new ObfVisitor(cr){}.shouldObf() || (classNode.access & 0x4200) != 0) {
            return classData;
        }
        for (MethodNode methodNode : classNode.methods) {
            if ((methodNode.access & 0x500) != 0 || methodNode.name.contains("init>")) continue;
            SwitchCaseObfVisitor7.transformMethod(classNode, methodNode);
        }
        ClassWriter1 writer = new ClassWriter1(3);
        classNode.accept(writer);
        return writer.toByteArray();
    }

    private static void transformMethod(ClassNode classNode, MethodNode methodNode) {
        Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicInterpreter());
        try {
            analyzer.analyze(classNode.name, methodNode);
        }
        catch (AnalyzerException e) {
            throw new RuntimeException("Initial analysis failed", e);
        }
        int switchVarIndex = SwitchCaseObfVisitor7.findNextAvailableLocalIndex(methodNode);
        InsnList newInstructions = new InsnList();
        HashMap<LabelNode, Integer> labelToKeyMap = new HashMap<LabelNode, Integer>();
        ArrayList<LabelNode> allLabels = new ArrayList<LabelNode>();
        for (AbstractInsnNode insn : methodNode.instructions) {
            if (!(insn instanceof LabelNode)) continue;
            allLabels.add((LabelNode)insn);
        }
        for (LabelNode label : allLabels) {
            labelToKeyMap.put(label, new Random().nextInt());
        }
        LabelNode defaultLabel = new LabelNode();
        LabelNode switchStart = new LabelNode();
        LabelNode switchEnd = new LabelNode();
        newInstructions.add(new LdcInsnNode((Object)0));
        newInstructions.add(new VarInsnNode(54, switchVarIndex));
        newInstructions.add(switchStart);
        int[] keys = labelToKeyMap.values().stream().mapToInt(i -> i).toArray();
        LabelNode[] labels = allLabels.toArray(new LabelNode[0]);
        newInstructions.add(new VarInsnNode(21, switchVarIndex));
        newInstructions.add(new LookupSwitchInsnNode(defaultLabel, keys, labels));
        boolean afterStore = false;
        for (AbstractInsnNode insn : methodNode.instructions) {
            if (afterStore && SwitchCaseObfVisitor7.isControlFlowBoundary(insn)) {
                SwitchCaseObfVisitor7.insertSwitchBlock(newInstructions, switchVarIndex, switchStart, defaultLabel);
                afterStore = false;
            }
            if (insn instanceof JumpInsnNode) {
                JumpInsnNode jump = (JumpInsnNode)insn;
                if (labelToKeyMap.containsKey(jump.label)) {
                    newInstructions.add(new LdcInsnNode(labelToKeyMap.get(jump.label)));
                    newInstructions.add(new VarInsnNode(54, switchVarIndex));
                    newInstructions.add(new JumpInsnNode(167, switchStart));
                    continue;
                }
            }
            newInstructions.add(insn);
            if (!SwitchCaseObfVisitor7.isStoreInstruction(insn)) continue;
            afterStore = true;
        }
        newInstructions.add(defaultLabel);
        newInstructions.add(new MethodInsnNode(184, "java/lang/Thread", "currentThread", "()Ljava/lang/Thread;"));
        newInstructions.add(new InsnNode(87));
        newInstructions.add(new InsnNode(177));
        methodNode.instructions = newInstructions;
        methodNode.maxLocals = Math.max(methodNode.maxLocals, switchVarIndex + 1);
    }

    private static boolean isStoreInstruction(AbstractInsnNode insn) {
        int opcode = insn.getOpcode();
        return opcode == 54 || opcode == 55 || opcode == 56 || opcode == 57 || opcode == 58;
    }

    private static boolean isControlFlowBoundary(AbstractInsnNode insn) {
        return insn instanceof LabelNode || insn instanceof JumpInsnNode || insn instanceof TableSwitchInsnNode || insn instanceof LookupSwitchInsnNode;
    }

    private static void insertSwitchBlock(InsnList insns, int varIndex, LabelNode switchStart, LabelNode defaultLabel) {
        insns.add(new JumpInsnNode(167, switchStart));
        insns.add(defaultLabel);
        insns.add(new MethodInsnNode(184, "java/lang/System", "currentTimeMillis", "()J"));
        insns.add(new InsnNode(88));
        insns.add(new JumpInsnNode(167, switchStart));
    }

    private static int findNextAvailableLocalIndex(MethodNode methodNode) {
        int max = 0;
        for (AbstractInsnNode insn : methodNode.instructions) {
            if (!(insn instanceof VarInsnNode)) continue;
            max = Math.max(max, ((VarInsnNode)insn).var);
        }
        return max + 1;
    }
}

