/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;

public class SwitchCaseObfVisitor6 {
    public static byte[] transform(byte[] classData) throws AnalyzerException {
        ClassNode classNode = new ClassNode();
        ClassReader cr = new ClassReader(classData);
        cr.accept(classNode, 0);
        if (!new ObfVisitor(cr){}.shouldObf() || (classNode.access & 0x4200) != 0) {
            return classData;
        }
        for (MethodNode methodNode : classNode.methods) {
            if ((methodNode.access & 0x500) != 0 || methodNode.name.contains("init>")) continue;
            SwitchCaseObfVisitor6.transformMethod(classNode, methodNode);
        }
        ClassWriter1 writer = new ClassWriter1(3);
        classNode.accept(writer);
        return writer.toByteArray();
    }

    private static void transformMethod(ClassNode classNode, MethodNode methodNode) {
        SwitchCaseObfVisitor6.addMoreGoto(classNode, methodNode);
        Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicInterpreter());
        try {
            analyzer.analyze(methodNode.name, methodNode);
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
        Frame<BasicValue>[] frames = analyzer.getFrames();
        InsnList insnList = new InsnList();
        int variableIndex = 0;
        ArrayList variableIndexes = new ArrayList();
        for (AbstractInsnNode insnNode : methodNode.instructions) {
            if (insnNode instanceof VarInsnNode) {
                variableIndex = Math.max(((VarInsnNode)insnNode).var, variableIndex);
                int opcode = insnNode.getOpcode();
                if (opcode == 54 || opcode == 55 || opcode == 56 || opcode == 57 || opcode == 58) {
                    insnList.add(new EmptyFlagInsnNode());
                }
            }
            insnList.add(insnNode);
        }
        variableIndex += 2;
        methodNode.instructions = insnList;
        try {
            analyzer.analyze(methodNode.name, methodNode);
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
        ArrayList list = new ArrayList();
        ArrayList gotolist = new ArrayList();
        ArrayList gotolistMap = new ArrayList();
        ArrayList<LabelNode> tempList = new ArrayList<LabelNode>();
        ArrayList<LabelNode> tempGotolist = new ArrayList<LabelNode>();
        for (AbstractInsnNode abstractInsnNode : methodNode.instructions) {
            if (abstractInsnNode instanceof LabelNode) {
                tempList.add((LabelNode)abstractInsnNode);
            }
            if (abstractInsnNode instanceof JumpInsnNode) {
                Frame<BasicValue> frame = frames[methodNode.instructions.indexOf(abstractInsnNode)];
                if (frame != null && frame.getStackSize() == 0) {
                    tempGotolist.add(((JumpInsnNode)abstractInsnNode).label);
                } else if (frame != null) {
                    // empty if block
                }
            }
            if (!(abstractInsnNode instanceof EmptyFlagInsnNode)) continue;
            list.add(tempList);
            gotolist.add(tempGotolist);
            tempList = new ArrayList();
            tempGotolist = new ArrayList();
        }
        list.add(tempList);
        gotolist.add(tempGotolist);
        for (List list2 : gotolist) {
            HashMap<LabelNode, Integer> tempMap = new HashMap<LabelNode, Integer>();
            for (LabelNode labelNode : list2) {
                tempMap.put(labelNode, Main.r.nextInt());
            }
            gotolistMap.add(tempMap);
        }
        insnList = new InsnList();
        Iterator insnNodeListIterator = methodNode.instructions.iterator();
        Iterator iterator = list.iterator();
        Iterator gotolistIterator = gotolist.iterator();
        Iterator gotolistMapIterator = gotolistMap.iterator();
        List currentList = null;
        List currentGotolist = null;
        Map currentGotolistMap = null;
        LabelNode defaultBlock = null;
        LabelNode startBlock = null;
        LabelNode loopBlock = null;
        LabelNode newLabel = null;
        while (insnNodeListIterator.hasNext()) {
            AbstractInsnNode insnNode = (AbstractInsnNode)insnNodeListIterator.next();
            if (currentList != null && insnNode instanceof EmptyFlagInsnNode) {
                insnList.add(new JumpInsnNode(167, newLabel));
                insnList.add(defaultBlock);
                insnList.add(new InsnNode(1));
                insnList.add(new InsnNode(191));
            }
            if (currentList == null || insnNode instanceof EmptyFlagInsnNode) {
                currentList = (List)iterator.next();
                currentGotolist = (List)gotolistIterator.next();
                currentGotolistMap = (Map)gotolistMapIterator.next();
                defaultBlock = new LabelNode();
                startBlock = new LabelNode();
                int startInt = Main.r.nextInt();
                currentGotolistMap.put(startBlock, startInt);
                loopBlock = new LabelNode();
                int[] keys = new int[currentGotolistMap.size()];
                LabelNode[] labels = new LabelNode[currentGotolistMap.size()];
                int[] i = new int[]{0};
                currentGotolistMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(entry -> {
                    keys[i[0]] = (Integer)entry.getValue();
                    labels[i[0]] = (LabelNode)entry.getKey();
                    i[0] = i[0] + 1;
                });
                int initVariableCount = Type.getMethodType(methodNode.desc).getArgumentTypes().length;
                if ((methodNode.access & 8) == 0) {
                    ++initVariableCount;
                }
                if (newLabel != null) {
                    insnList.add(newLabel);
                }
                insnList.add(new LdcInsnNode((Object)startInt));
                insnList.add(new VarInsnNode(54, variableIndex));
                insnList.add(loopBlock);
                insnList.add(new VarInsnNode(21, variableIndex));
                insnList.add(new LookupSwitchInsnNode(defaultBlock, keys, labels));
                insnList.add(startBlock);
                newLabel = new LabelNode();
            }
            if (insnNode instanceof LabelNode) {
                insnList.add(insnNode);
                continue;
            }
            if (insnNode instanceof JumpInsnNode) {
                Integer value = (Integer)currentGotolistMap.get(((JumpInsnNode)insnNode).label);
                if (value == null) {
                    insnList.add(insnNode);
                    continue;
                }
                insnList.add(new LdcInsnNode(value));
                insnList.add(new VarInsnNode(54, variableIndex));
                insnList.add(new JumpInsnNode(insnNode.getOpcode(), loopBlock));
                continue;
            }
            insnList.add(insnNode);
        }
        insnList.add(defaultBlock);
        insnList.add(new InsnNode(1));
        insnList.add(new InsnNode(191));
        methodNode.instructions = insnList;
    }

    private static void addMoreGoto(ClassNode classNode, MethodNode methodNode) {
        try {
            Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicInterpreter());
            analyzer.analyze(methodNode.name, methodNode);
            Frame<BasicValue>[] frames = analyzer.getFrames();
            InsnList newInstructions = new InsnList();
            int index = 0;
            int count = 0;
            for (AbstractInsnNode insn : methodNode.instructions) {
                Frame<BasicValue> frame = frames[index];
                if (insn instanceof LabelNode) {
                    if (frame != null && frame.getStackSize() == 0) {
                        if ((count++ % 5 == 0 || Main.r.nextBoolean() && Main.r.nextBoolean()) && count > 15) {
                            LabelNode target = (LabelNode)insn;
                            newInstructions.add(new JumpInsnNode(167, target));
                            newInstructions.add(target);
                        }
                    } else if (frame == null) {
                        newInstructions.add(insn);
                        ++index;
                        continue;
                    }
                }
                newInstructions.add(insn);
                ++index;
            }
            methodNode.instructions = newInstructions;
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
    }
}

