/*
 * Decompiled with CFR 0.152.
 */
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;

public class SwitchCaseObfVisitor5 {
    public static byte[] transform(byte[] classData) throws AnalyzerException {
        ClassNode classNode = new ClassNode();
        ClassReader cr = new ClassReader(classData);
        cr.accept(classNode, 0);
        if (!new ObfVisitor(cr){}.shouldObf() || (classNode.access & 0x4200) != 0) {
            return classData;
        }
        for (MethodNode methodNode : classNode.methods) {
            if ((methodNode.access & 0x500) != 0 || methodNode.name.contains("init>")) continue;
            SwitchCaseObfVisitor5.transformMethod(classNode, methodNode);
        }
        ClassWriter1 writer = new ClassWriter1(3);
        classNode.accept(writer);
        return writer.toByteArray();
    }

    private static void transformMethod(ClassNode classNode, MethodNode methodNode) {
        SwitchCaseObfVisitor5.addMoreGoto(classNode, methodNode);
        SwitchCaseObfVisitor5.fixLocalVars(methodNode);
        Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicInterpreter());
        try {
            analyzer.analyze(methodNode.name, methodNode);
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
        Frame<BasicValue>[] frames = analyzer.getFrames();
        int variableIndex = 0;
        ArrayList<AbstractMap.SimpleEntry<Character, Integer>> variableIndexes = new ArrayList<AbstractMap.SimpleEntry<Character, Integer>>();
        for (AbstractInsnNode insnNode : methodNode.instructions) {
            char ch;
            if (!(insnNode instanceof VarInsnNode)) continue;
            variableIndex = Math.max(((VarInsnNode)insnNode).var, variableIndex);
            switch (insnNode.getOpcode()) {
                case 21: 
                case 54: {
                    ch = 'I';
                    break;
                }
                case 22: 
                case 55: {
                    ch = 'J';
                    break;
                }
                case 23: 
                case 56: {
                    ch = 'F';
                    break;
                }
                case 24: 
                case 57: {
                    ch = 'D';
                    break;
                }
                case 25: 
                case 58: {
                    ch = 'A';
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown opcode: " + insnNode.getOpcode());
                }
            }
            AbstractMap.SimpleEntry<Character, Integer> entry2 = new AbstractMap.SimpleEntry<Character, Integer>(Character.valueOf(ch), ((VarInsnNode)insnNode).var);
            if (ch == 'A') {
                Iterator it = variableIndexes.iterator();
                while (it.hasNext()) {
                    Map.Entry entry1 = (Map.Entry)it.next();
                    if (entry1.getValue() != entry2.getValue()) continue;
                    it.remove();
                }
            }
            if (variableIndexes.contains(entry2)) continue;
            variableIndexes.add(entry2);
        }
        int checkCastVariableIndex = (variableIndex += 2) + 1;
        ArrayList<LabelNode> list = new ArrayList<LabelNode>();
        ArrayList<LabelNode> gotolist = new ArrayList<LabelNode>();
        HashMap<LabelNode, Integer> gotolistMap = new HashMap<LabelNode, Integer>();
        for (AbstractInsnNode insnNode : methodNode.instructions) {
            if (insnNode instanceof LabelNode) {
                list.add((LabelNode)insnNode);
            }
            if (!(insnNode instanceof JumpInsnNode)) continue;
            Frame<BasicValue> frame = frames[methodNode.instructions.indexOf(insnNode)];
            if (frame != null && frame.getStackSize() == 0) {
                gotolist.add(((JumpInsnNode)insnNode).label);
                continue;
            }
            if (frame == null) continue;
        }
        for (LabelNode labelNode : gotolist) {
            gotolistMap.put(labelNode, Main.r.nextInt());
        }
        LabelNode defaultBlock = new LabelNode();
        LabelNode startBlock = new LabelNode();
        int startInt = Main.r.nextInt();
        gotolistMap.put(startBlock, startInt);
        LabelNode loopBlock = new LabelNode();
        int[] keys = new int[gotolistMap.size()];
        LabelNode[] labels = new LabelNode[gotolistMap.size()];
        int[] i = new int[]{0};
        gotolistMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(entry -> {
            keys[i[0]] = (Integer)entry.getValue();
            labels[i[0]] = (LabelNode)entry.getKey();
            i[0] = i[0] + 1;
        });
        InsnList insnList = new InsnList();
        int initVariableCount = Type.getMethodType(methodNode.desc).getArgumentTypes().length;
        if ((methodNode.access & 8) == 0) {
            ++initVariableCount;
        }
        block20: for (Map.Entry entry2 : variableIndexes) {
            if ((Integer)entry2.getValue() < initVariableCount) continue;
            switch (((Character)entry2.getKey()).charValue()) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    insnList.add(new InsnNode(3));
                    insnList.add(new VarInsnNode(54, (Integer)entry2.getValue()));
                    continue block20;
                }
                case 'J': {
                    insnList.add(new InsnNode(9));
                    insnList.add(new VarInsnNode(55, (Integer)entry2.getValue()));
                    continue block20;
                }
                case 'F': {
                    insnList.add(new InsnNode(11));
                    insnList.add(new VarInsnNode(56, (Integer)entry2.getValue()));
                    continue block20;
                }
                case 'D': {
                    insnList.add(new InsnNode(14));
                    insnList.add(new VarInsnNode(57, (Integer)entry2.getValue()));
                    continue block20;
                }
                case 'A': {
                    insnList.add(new InsnNode(1));
                    insnList.add(new VarInsnNode(58, (Integer)entry2.getValue()));
                    continue block20;
                }
            }
            throw new IllegalStateException("Unknown type: " + entry2.getKey());
        }
        insnList.add(new LdcInsnNode((Object)startInt));
        insnList.add(new VarInsnNode(54, variableIndex));
        insnList.add(loopBlock);
        insnList.add(new VarInsnNode(21, variableIndex));
        insnList.add(new LookupSwitchInsnNode(defaultBlock, keys, labels));
        insnList.add(startBlock);
        for (AbstractInsnNode abstractInsnNode : methodNode.instructions) {
            if (abstractInsnNode instanceof LabelNode) {
                if (list.contains(abstractInsnNode)) {
                    insnList.add(abstractInsnNode);
                    continue;
                }
                throw new IllegalStateException("NO LABEL");
            }
            if (abstractInsnNode instanceof JumpInsnNode && gotolist.contains(((JumpInsnNode)abstractInsnNode).label)) {
                insnList.add(new LdcInsnNode(gotolistMap.get(((JumpInsnNode)abstractInsnNode).label)));
                insnList.add(new VarInsnNode(54, variableIndex));
                insnList.add(new JumpInsnNode(abstractInsnNode.getOpcode(), loopBlock));
                continue;
            }
            insnList.add(abstractInsnNode);
        }
        insnList.add(defaultBlock);
        insnList.add(new InsnNode(1));
        insnList.add(new InsnNode(191));
        methodNode.instructions = insnList;
        methodNode.localVariables = null;
        methodNode.parameters = null;
        methodNode.signature = null;
        for (FieldNode fieldNode : classNode.fields) {
            fieldNode.signature = null;
        }
        classNode.signature = null;
        classNode.innerClasses.clear();
        classNode.sourceFile = null;
        classNode.sourceDebug = null;
    }

    private static void addMoreGoto(ClassNode classNode, MethodNode methodNode) {
        try {
            Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicInterpreter());
            analyzer.analyze(methodNode.name, methodNode);
            Frame<BasicValue>[] frames = analyzer.getFrames();
            InsnList newInstructions = new InsnList();
            int index = 0;
            int count = 0;
            for (AbstractInsnNode insn : methodNode.instructions) {
                Frame<BasicValue> frame = frames[index];
                if (insn instanceof LabelNode) {
                    if (frame != null && frame.getStackSize() == 0) {
                        if ((count++ % 5 == 0 || Main.r.nextBoolean() && Main.r.nextBoolean()) && count > 15) {
                            LabelNode target = (LabelNode)insn;
                            newInstructions.add(new JumpInsnNode(167, target));
                            newInstructions.add(target);
                        }
                    } else if (frame == null) {
                        newInstructions.add(insn);
                        ++index;
                        continue;
                    }
                }
                newInstructions.add(insn);
                ++index;
            }
            methodNode.instructions = newInstructions;
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
    }

    public static void fixLocalVars(MethodNode methodNode) {
        boolean isStatic = (methodNode.access & 8) != 0;
        Type[] argTypes = Type.getArgumentTypes(methodNode.desc);
        int parametersSize = argTypes.length + (isStatic ? 0 : 1);
        HashMap<Integer, Set<Type>> varTypeMap = new HashMap<Integer, Set<Type>>();
        for (AbstractInsnNode insn : methodNode.instructions) {
            if (insn instanceof VarInsnNode) {
                SwitchCaseObfVisitor5.processVarInsn((VarInsnNode)insn, parametersSize, varTypeMap);
                continue;
            }
            if (!(insn instanceof IincInsnNode)) continue;
            SwitchCaseObfVisitor5.processIincInsn((IincInsnNode)insn, parametersSize, varTypeMap);
        }
        List conflictVars = varTypeMap.entrySet().stream().filter(e -> ((Set)e.getValue()).size() > 1).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
        if (conflictVars.isEmpty()) {
            return;
        }
        int currentMaxIndex = parametersSize;
        HashMap<Integer, Integer> indexRemap = new HashMap<Integer, Integer>();
        Iterator iterator = conflictVars.iterator();
        while (iterator.hasNext()) {
            int oldIndex = (Integer)iterator.next();
            int slotSize = SwitchCaseObfVisitor5.getMaxSlotSize((Set)varTypeMap.get(oldIndex));
            indexRemap.put(oldIndex, currentMaxIndex);
            currentMaxIndex += slotSize;
        }
        SwitchCaseObfVisitor5.updateInstructions(methodNode.instructions, indexRemap);
    }

    private static void processVarInsn(VarInsnNode insn, int paramsSize, Map<Integer, Set<Type>> varTypeMap) {
        int varIndex = insn.var;
        if (varIndex < paramsSize) {
            return;
        }
        Type type = SwitchCaseObfVisitor5.getVarInsnType(insn.getOpcode());
        varTypeMap.computeIfAbsent(varIndex, k -> new HashSet()).add(type);
    }

    private static void processIincInsn(IincInsnNode insn, int paramsSize, Map<Integer, Set<Type>> varTypeMap) {
        int varIndex = insn.var;
        if (varIndex < paramsSize) {
            return;
        }
        varTypeMap.computeIfAbsent(varIndex, k -> new HashSet()).add(Type.INT_TYPE);
    }

    private static Type getVarInsnType(int opcode) {
        switch (opcode) {
            case 21: 
            case 54: {
                return Type.INT_TYPE;
            }
            case 22: 
            case 55: {
                return Type.LONG_TYPE;
            }
            case 23: 
            case 56: {
                return Type.FLOAT_TYPE;
            }
            case 24: 
            case 57: {
                return Type.DOUBLE_TYPE;
            }
            case 25: 
            case 58: {
                return Type.getType("Ljava/lang/Object;");
            }
        }
        throw new IllegalArgumentException("Unexpected opcode: " + opcode);
    }

    private static int getMaxSlotSize(Set<Type> types) {
        return types.stream().mapToInt(Type::getSize).max().orElse(1);
    }

    private static void updateInstructions(InsnList instructions, Map<Integer, Integer> indexRemap) {
        for (AbstractInsnNode insn : instructions) {
            if (insn instanceof VarInsnNode) {
                VarInsnNode varInsn = (VarInsnNode)insn;
                varInsn.var = indexRemap.getOrDefault(varInsn.var, varInsn.var);
                continue;
            }
            if (!(insn instanceof IincInsnNode)) continue;
            IincInsnNode iinc = (IincInsnNode)insn;
            iinc.var = indexRemap.getOrDefault(iinc.var, iinc.var);
        }
    }

    static interface Adder {
        public void add(char var1, int var2);
    }
}

