/*
 * Decompiled with CFR 0.152.
 */
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;

public class SwitchCaseObfVisitor4 {
    public static byte[] transform(byte[] classData) throws AnalyzerException {
        ClassNode classNode = new ClassNode();
        ClassReader cr = new ClassReader(classData);
        cr.accept(classNode, 0);
        if (!new ObfVisitor(cr){}.shouldObf() || (classNode.access & 0x4200) != 0) {
            return classData;
        }
        for (MethodNode methodNode : classNode.methods) {
            if ((methodNode.access & 0x500) != 0 || methodNode.name.contains("init>")) continue;
            SwitchCaseObfVisitor4.transformMethod(classNode, methodNode);
        }
        ClassWriter1 writer = new ClassWriter1(2);
        classNode.accept(writer);
        return writer.toByteArray();
    }

    private static void transformMethod(ClassNode classNode, MethodNode methodNode) {
        int variableExceptionIndexStart;
        SwitchCaseObfVisitor4.addMoreGoto(classNode, methodNode);
        Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicInterpreter());
        try {
            analyzer.analyze(methodNode.name, methodNode);
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
        Frame<BasicValue>[] frames = analyzer.getFrames();
        int variableIndex = 0;
        ArrayList<AbstractMap.SimpleEntry<Character, Integer>> variableIndexes = new ArrayList<AbstractMap.SimpleEntry<Character, Integer>>();
        for (AbstractInsnNode insnNode : methodNode.instructions) {
            AbstractMap.SimpleEntry<Character, Integer> entry2;
            char ch;
            if (!(insnNode instanceof VarInsnNode)) continue;
            variableIndex = Math.max(((VarInsnNode)insnNode).var, variableIndex);
            switch (insnNode.getOpcode()) {
                case 21: 
                case 54: {
                    ch = 'I';
                    break;
                }
                case 22: 
                case 55: {
                    ch = 'J';
                    break;
                }
                case 23: 
                case 56: {
                    ch = 'F';
                    break;
                }
                case 24: 
                case 57: {
                    ch = 'D';
                    break;
                }
                case 25: 
                case 58: {
                    ch = 'A';
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown opcode: " + insnNode.getOpcode());
                }
            }
            if (variableIndexes.contains(entry2 = new AbstractMap.SimpleEntry<Character, Integer>(Character.valueOf(ch), ((VarInsnNode)insnNode).var))) continue;
            variableIndexes.add(entry2);
        }
        int variableExceptionIndex = variableExceptionIndexStart = (variableIndex += 2) + 1;
        ArrayList<LabelNode> list = new ArrayList<LabelNode>();
        ArrayList<LabelNode> gotolist = new ArrayList<LabelNode>();
        HashMap<LabelNode, Integer> gotolistMap = new HashMap<LabelNode, Integer>();
        for (AbstractInsnNode insnNode : methodNode.instructions) {
            Frame<BasicValue> frame;
            if (insnNode instanceof LabelNode) {
                list.add((LabelNode)insnNode);
            }
            if (!(insnNode instanceof JumpInsnNode) || (frame = frames[methodNode.instructions.indexOf(insnNode)]) == null || frame.getStackSize() != 0) continue;
            gotolist.add(((JumpInsnNode)insnNode).label);
        }
        for (LabelNode labelNode : gotolist) {
            gotolistMap.put(labelNode, Main.r.nextInt());
        }
        LabelNode defaultBlock = new LabelNode();
        LabelNode startBlock = new LabelNode();
        int startInt = Main.r.nextInt();
        gotolistMap.put(startBlock, startInt);
        LabelNode loopBlock = new LabelNode();
        int[] keys = new int[gotolistMap.size()];
        LabelNode[] labels = new LabelNode[gotolistMap.size()];
        int[] i = new int[]{0};
        gotolistMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(entry -> {
            keys[i[0]] = (Integer)entry.getValue();
            labels[i[0]] = (LabelNode)entry.getKey();
            i[0] = i[0] + 1;
        });
        InsnList insnList = new InsnList();
        int initVariableCount = Type.getMethodType(methodNode.desc).getArgumentTypes().length;
        if ((methodNode.access & 8) == 0) {
            ++initVariableCount;
        }
        block19: for (Map.Entry entry2 : variableIndexes) {
            if ((Integer)entry2.getValue() < initVariableCount) continue;
            switch (((Character)entry2.getKey()).charValue()) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    insnList.add(new InsnNode(3));
                    insnList.add(new VarInsnNode(54, (Integer)entry2.getValue()));
                    continue block19;
                }
                case 'J': {
                    insnList.add(new InsnNode(9));
                    insnList.add(new VarInsnNode(55, (Integer)entry2.getValue()));
                    continue block19;
                }
                case 'F': {
                    insnList.add(new InsnNode(11));
                    insnList.add(new VarInsnNode(56, (Integer)entry2.getValue()));
                    continue block19;
                }
                case 'D': {
                    insnList.add(new InsnNode(14));
                    insnList.add(new VarInsnNode(57, (Integer)entry2.getValue()));
                    continue block19;
                }
                case 'A': {
                    insnList.add(new InsnNode(1));
                    insnList.add(new VarInsnNode(58, (Integer)entry2.getValue()));
                    continue block19;
                }
            }
            throw new IllegalStateException("Unknown type: " + entry2.getKey());
        }
        insnList.add(new LdcInsnNode((Object)startInt));
        insnList.add(new VarInsnNode(54, variableIndex));
        insnList.add(loopBlock);
        insnList.add(new VarInsnNode(21, variableIndex));
        insnList.add(new LookupSwitchInsnNode(defaultBlock, keys, labels));
        insnList.add(startBlock);
        LabelNode lastGotoLabel = null;
        HashMap<LabelNode, Integer> hashMap = new HashMap<LabelNode, Integer>();
        HashMap tryCatchHandler_variableExceptionIndex = new HashMap();
        ArrayList<LabelNode> currentTryCatchHandler = new ArrayList<LabelNode>();
        HashMap<LabelNode, LabelNode> tryCatchBlockEnd = new HashMap<LabelNode, LabelNode>();
        boolean isInNewTCB = false;
        ArrayList<LabelNode> tryCatchBlockHandlers = new ArrayList<LabelNode>();
        for (TryCatchBlockNode tryCatchBlock : methodNode.tryCatchBlocks) {
            tryCatchBlockHandlers.add(tryCatchBlock.handler);
        }
        for (AbstractInsnNode insnNode : methodNode.instructions) {
            if (insnNode instanceof LabelNode) {
                if (!list.contains(insnNode)) {
                    throw new IllegalStateException("NO LABEL");
                }
                insnList.add(insnNode);
                if (tryCatchBlockHandlers.contains(insnNode)) {
                    currentTryCatchHandler.add((LabelNode)insnNode);
                    hashMap.put((LabelNode)insnNode, -1);
                    tryCatchBlockEnd.put(lastGotoLabel, (LabelNode)insnNode);
                    isInNewTCB = true;
                }
                if (tryCatchBlockEnd.containsKey(insnNode)) {
                    LabelNode label = (LabelNode)tryCatchBlockEnd.get(insnNode);
                    hashMap.remove(label);
                    currentTryCatchHandler.remove(label);
                }
            } else if (insnNode instanceof JumpInsnNode && gotolist.contains(((JumpInsnNode)insnNode).label)) {
                if (insnNode.getOpcode() == 167) {
                    lastGotoLabel = ((JumpInsnNode)insnNode).label;
                }
                insnList.add(new LdcInsnNode(gotolistMap.get(((JumpInsnNode)insnNode).label)));
                insnList.add(new VarInsnNode(54, variableIndex));
                insnList.add(new JumpInsnNode(insnNode.getOpcode(), loopBlock));
                if (hashMap.size() > 0) {
                    Iterator it = hashMap.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry3 = it.next();
                        if (methodNode.instructions.indexOf(((JumpInsnNode)insnNode).label) >= methodNode.instructions.indexOf((AbstractInsnNode)entry3.getKey())) continue;
                        it.remove();
                        currentTryCatchHandler.remove(entry3.getKey());
                    }
                }
            } else if (hashMap.size() > 0 && insnNode instanceof VarInsnNode) {
                Integer exceptionVar = (Integer)hashMap.get(currentTryCatchHandler.get(currentTryCatchHandler.size() - 1));
                if (exceptionVar == -1) {
                    if (insnNode.getOpcode() == 58) {
                        exceptionVar = ((VarInsnNode)insnNode).var;
                        isInNewTCB = false;
                        hashMap.put((LabelNode)currentTryCatchHandler.get(currentTryCatchHandler.size() - 1), exceptionVar);
                        tryCatchHandler_variableExceptionIndex.put(currentTryCatchHandler.get(currentTryCatchHandler.size() - 1), variableExceptionIndex);
                        insnList.add(new VarInsnNode(insnNode.getOpcode(), variableExceptionIndex));
                        ++variableExceptionIndex;
                    } else {
                        insnList.add(insnNode);
                    }
                } else if (((VarInsnNode)insnNode).var == exceptionVar) {
                    insnList.add(new VarInsnNode(insnNode.getOpcode(), (Integer)tryCatchHandler_variableExceptionIndex.get(currentTryCatchHandler.get(currentTryCatchHandler.size() - 1))));
                } else {
                    insnList.add(insnNode);
                }
            } else {
                insnList.add(insnNode);
            }
            if (hashMap.size() <= 0 || insnNode.getOpcode() != 87 || !isInNewTCB) continue;
            tryCatchBlockHandlers.remove(currentTryCatchHandler.get(currentTryCatchHandler.size() - 1));
            currentTryCatchHandler.remove(currentTryCatchHandler.size() - 1);
            isInNewTCB = false;
        }
        insnList.add(defaultBlock);
        insnList.add(new InsnNode(1));
        insnList.add(new InsnNode(191));
        InsnList insnList2 = new InsnList();
        for (int k = variableExceptionIndexStart; k < variableExceptionIndex; ++k) {
            insnList2.add(new InsnNode(1));
            insnList2.add(new VarInsnNode(58, k));
        }
        insnList2.add(insnList);
        methodNode.instructions = insnList2;
    }

    private static void addMoreGoto(ClassNode classNode, MethodNode methodNode) {
        try {
            Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicInterpreter());
            analyzer.analyze(methodNode.name, methodNode);
            Frame<BasicValue>[] frames = analyzer.getFrames();
            InsnList newInstructions = new InsnList();
            int index = 0;
            int count = 0;
            for (AbstractInsnNode insn : methodNode.instructions) {
                Frame<BasicValue> frame = frames[index];
                if (insn instanceof LabelNode) {
                    if (frame != null && frame.getStackSize() == 0) {
                        if (count++ % 5 == 0 && count > 1) {
                            LabelNode target = (LabelNode)insn;
                            newInstructions.add(new JumpInsnNode(167, target));
                            newInstructions.add(target);
                        }
                    } else if (frame == null) {
                        newInstructions.add(insn);
                        ++index;
                        continue;
                    }
                }
                newInstructions.add(insn);
                ++index;
            }
            methodNode.instructions = newInstructions;
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
    }

    private static void insertCheckcast(MethodNode methodNode) {
        ArrayList<AbstractInsnNode> newInstructions = new ArrayList<AbstractInsnNode>();
        Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicInterpreter());
        try {
            analyzer.analyze(methodNode.name, methodNode);
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
        Frame<BasicValue>[] frames = analyzer.getFrames();
        block2: for (AbstractInsnNode insn : methodNode.instructions) {
            InsnNode insnNode;
            newInstructions.add(insn);
            if (insn instanceof MethodInsnNode) {
                int index;
                VarInsnNode varInsnNode;
                AbstractInsnNode node;
                ListIterator listIterator;
                MethodInsnNode methodInsnNode = (MethodInsnNode)insn;
                if (methodInsnNode.getOpcode() != 182) continue;
                Type[] types = Type.getArgumentTypes(methodInsnNode.desc);
                Type owner = Type.getObjectType(methodInsnNode.owner);
                ArrayList<VarInsnNode> checked = new ArrayList<VarInsnNode>();
                block3: for (int i = types.length - 1; i >= 0; --i) {
                    if (types[i].getSort() >= 1 && types[i].getSort() <= 7) continue;
                    listIterator = newInstructions.listIterator(newInstructions.size());
                    while (listIterator.hasPrevious()) {
                        node = (AbstractInsnNode)listIterator.previous();
                        if (!(node instanceof VarInsnNode) || checked.contains(node) || node.getOpcode() != 25) continue;
                        varInsnNode = (VarInsnNode)node;
                        index = newInstructions.indexOf(varInsnNode) + 1;
                        newInstructions.add(index, new TypeInsnNode(192, types[i].getInternalName()));
                        newInstructions.add(index, new TypeInsnNode(192, "java/lang/Object"));
                        checked.add(varInsnNode);
                        continue block3;
                    }
                }
                listIterator = newInstructions.listIterator();
                while (listIterator.hasPrevious()) {
                    node = (AbstractInsnNode)listIterator.previous();
                    if (!(node instanceof VarInsnNode) || checked.contains(node) || node.getOpcode() != 25) continue;
                    varInsnNode = (VarInsnNode)node;
                    index = newInstructions.indexOf(varInsnNode) + 1;
                    newInstructions.add(index, new TypeInsnNode(192, owner.getInternalName()));
                    newInstructions.add(index, new TypeInsnNode(192, "java/lang/Object"));
                    checked.add(varInsnNode);
                    continue block2;
                }
                continue;
            }
            if (!(insn instanceof InsnNode) || (insnNode = (InsnNode)insn).getOpcode() != 176) continue;
            int index = newInstructions.indexOf(insnNode);
            Type returnType = Type.getReturnType(methodNode.desc);
            newInstructions.add(index, new TypeInsnNode(192, returnType.getInternalName()));
            newInstructions.add(index, new TypeInsnNode(192, "java/lang/Object"));
        }
        methodNode.instructions = new InsnList();
        newInstructions.forEach(methodNode.instructions::add);
    }
}

