/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;

public class SwitchCaseObfVisitor3 {
    public static byte[] transform(byte[] classData) throws AnalyzerException {
        ClassNode classNode = new ClassNode();
        ClassReader cr = new ClassReader(classData);
        cr.accept(classNode, 0);
        for (MethodNode method : classNode.methods) {
            if ("<init>".equals(method.name) || "<clinit>".equals(method.name)) continue;
            SwitchCaseObfVisitor3.transformMethod(method);
        }
        ClassWriter cw = new ClassWriter(0);
        for (MethodNode method : classNode.methods) {
            System.out.println(method.name + method.desc);
            for (AbstractInsnNode instruction : method.instructions) {
                if (instruction instanceof LineNumberNode) {
                    System.out.println(((LineNumberNode)instruction).line + " " + ((LineNumberNode)instruction).start + " " + ((LineNumberNode)instruction).hashCode());
                }
                if (instruction instanceof JumpInsnNode) {
                    System.out.println(((JumpInsnNode)instruction).label);
                }
                if (instruction instanceof TableSwitchInsnNode) {
                    System.out.println("======================TABLE======================");
                    for (LabelNode label : ((TableSwitchInsnNode)instruction).labels) {
                        System.out.println("label = " + label);
                    }
                    System.out.println("=======================END=======================");
                }
                if (!(instruction instanceof LabelNode)) continue;
                System.out.println("visitlabel -> " + instruction);
            }
        }
        classNode.accept(cw);
        return cw.toByteArray();
    }

    private static void transformMethod(MethodNode method) throws AnalyzerException {
        ControlFlowGraph cfg = SwitchCaseObfVisitor3.analyzeControlFlow(method);
        int stateVarIndex = SwitchCaseObfVisitor3.insertStateVariable(method);
        SwitchCaseObfVisitor3.generateStateMachine(method, cfg, stateVarIndex);
    }

    private static ControlFlowGraph analyzeControlFlow(MethodNode method) throws AnalyzerException {
        ControlFlowGraph cfg = new ControlFlowGraph();
        Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicInterpreter());
        analyzer.analyze(method.name, method);
        HashSet<LabelNode> labels = new HashSet<LabelNode>();
        for (AbstractInsnNode insn : method.instructions) {
            if (insn instanceof LabelNode) {
                labels.add((LabelNode)insn);
                continue;
            }
            if (insn instanceof JumpInsnNode) {
                labels.add(((JumpInsnNode)insn).label);
                continue;
            }
            if (insn instanceof TableSwitchInsnNode) {
                TableSwitchInsnNode tswitch = (TableSwitchInsnNode)insn;
                labels.add(tswitch.dflt);
                labels.addAll(tswitch.labels);
                continue;
            }
            if (!(insn instanceof LookupSwitchInsnNode)) continue;
            LookupSwitchInsnNode lswitch = (LookupSwitchInsnNode)insn;
            labels.add(lswitch.dflt);
            labels.addAll(lswitch.labels);
        }
        int currentBlock = 0;
        boolean isNewBlock = true;
        for (AbstractInsnNode insn : method.instructions) {
            if (labels.contains(insn)) {
                ++currentBlock;
                isNewBlock = true;
            }
            if (isNewBlock) {
                cfg.blockMap.put(insn, currentBlock);
                isNewBlock = false;
            } else {
                cfg.blockMap.put(insn, currentBlock);
            }
            if (!(insn instanceof JumpInsnNode) && !(insn instanceof TableSwitchInsnNode) && !(insn instanceof LookupSwitchInsnNode)) continue;
            ++currentBlock;
            isNewBlock = true;
        }
        for (AbstractInsnNode insn : method.instructions) {
            if (!(insn instanceof LabelNode)) continue;
            cfg.originalLabels.add((LabelNode)insn);
        }
        return cfg;
    }

    private static int insertStateVariable(MethodNode method) {
        int stateVarIndex = new LocalVariablesSorter(method.access, method.desc, method).newLocal(Type.INT_TYPE);
        InsnList initCode = new InsnList();
        initCode.add(new InsnNode(4));
        initCode.add(new VarInsnNode(54, stateVarIndex));
        method.instructions.insert(initCode);
        return stateVarIndex;
    }

    private static void generateStateMachine(MethodNode method, ControlFlowGraph cfg, int stateVarIndex) {
        InsnList newInstructions = new InsnList();
        HashMap<LabelNode, LabelNode> labelMap = new HashMap<LabelNode, LabelNode>();
        for (LabelNode originalLabel : cfg.originalLabels) {
            labelMap.put(originalLabel, new LabelNode());
        }
        LabelNode loopLabel = new LabelNode();
        newInstructions.add(loopLabel);
        newInstructions.add(new FrameNode(1, 1, new Object[]{Opcodes.INTEGER}, 0, null));
        newInstructions.add(new VarInsnNode(21, stateVarIndex));
        LabelNode defaultLabel = new LabelNode();
        LabelNode[] caseLabels = SwitchCaseObfVisitor3.generateCaseLabels(cfg, labelMap);
        newInstructions.add(new TableSwitchInsnNode(1, caseLabels.length, defaultLabel, caseLabels));
        HashMap<Integer, List> blockToInsns = new HashMap<Integer, List>();
        for (AbstractInsnNode insn : method.instructions) {
            Integer blockId = cfg.blockMap.get(insn);
            if (blockId == null) {
                blockId = 0;
            }
            blockToInsns.computeIfAbsent(blockId, k -> new ArrayList()).add(insn);
        }
        for (int blockId = 1; blockId <= caseLabels.length; ++blockId) {
            LabelNode caseLabel = caseLabels[blockId - 1];
            newInstructions.add(caseLabel);
            newInstructions.add(new FrameNode(3, 0, null, 0, null));
            List blockInsns = (List)blockToInsns.get(blockId);
            if (blockInsns == null) continue;
            for (AbstractInsnNode insn : blockInsns) {
                if (insn instanceof LabelNode) {
                    LabelNode newLabel = (LabelNode)labelMap.get(insn);
                    newInstructions.add(newLabel);
                    continue;
                }
                if (insn instanceof LineNumberNode) {
                    LineNumberNode lineNode = (LineNumberNode)insn;
                    LabelNode newStart = (LabelNode)labelMap.get(lineNode.start);
                    newInstructions.add(new LineNumberNode(lineNode.line, newStart));
                    continue;
                }
                if (insn instanceof JumpInsnNode) {
                    JumpInsnNode jump = (JumpInsnNode)insn;
                    LabelNode newTarget = (LabelNode)labelMap.get(jump.label);
                    newInstructions.add(new JumpInsnNode(jump.getOpcode(), newTarget));
                    continue;
                }
                newInstructions.add(insn.clone(labelMap));
            }
            newInstructions.add(new IntInsnNode(16, blockId + 1));
            newInstructions.add(new VarInsnNode(54, stateVarIndex));
            newInstructions.add(new JumpInsnNode(167, loopLabel));
        }
        newInstructions.add(defaultLabel);
        newInstructions.add(new InsnNode(177));
        method.instructions = newInstructions;
    }

    private static LabelNode[] generateCaseLabels(ControlFlowGraph cfg, Map<LabelNode, LabelNode> labelMap) {
        return labelMap.values().toArray(new LabelNode[0]);
    }

    private static class ControlFlowGraph {
        public Map<AbstractInsnNode, Integer> blockMap = new HashMap<AbstractInsnNode, Integer>();
        public Set<LabelNode> originalLabels = new HashSet<LabelNode>();

        private ControlFlowGraph() {
        }
    }
}

