/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;

public class SwitchCaseObfVisitor2 {
    public static byte[] transform(byte[] classData) throws AnalyzerException {
        ClassNode classNode = new ClassNode();
        ClassReader cr = new ClassReader(classData);
        cr.accept(classNode, 0);
        for (MethodNode method : classNode.methods) {
            System.out.println(method.name + method.desc);
            for (AbstractInsnNode instruction : method.instructions) {
                if (!(instruction instanceof LineNumberNode)) continue;
                System.out.println(((LineNumberNode)instruction).line + " " + ((LineNumberNode)instruction).start + " " + ((LineNumberNode)instruction).hashCode());
            }
        }
        for (MethodNode method : classNode.methods) {
            if ("<init>".equals(method.name) || "<clinit>".equals(method.name)) continue;
            SwitchCaseObfVisitor2.transformMethod(method);
        }
        for (MethodNode method : classNode.methods) {
            System.out.println(method.name + method.desc);
            for (AbstractInsnNode instruction : method.instructions) {
                if (!(instruction instanceof LineNumberNode)) continue;
                System.out.println(((LineNumberNode)instruction).line + " " + ((LineNumberNode)instruction).start + " " + ((LineNumberNode)instruction).hashCode());
            }
        }
        ClassWriter cw = new ClassWriter(2);
        classNode.accept(cw);
        return cw.toByteArray();
    }

    private static void transformMethod(MethodNode method) throws AnalyzerException {
        ControlFlowGraph cfg = SwitchCaseObfVisitor2.analyzeControlFlow(method);
        int stateVarIndex = SwitchCaseObfVisitor2.insertStateVariable(method);
        SwitchCaseObfVisitor2.generateStateMachine(method, cfg, stateVarIndex);
    }

    private static ControlFlowGraph analyzeControlFlow(MethodNode method) throws AnalyzerException {
        ControlFlowGraph cfg = new ControlFlowGraph();
        Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicInterpreter());
        analyzer.analyze(method.name, method);
        InsnList instructions = method.instructions;
        HashMap<AbstractInsnNode, Integer> blockMap = new HashMap<AbstractInsnNode, Integer>();
        int blockId = 0;
        for (AbstractInsnNode insn : instructions) {
            if (insn instanceof LabelNode) {
                ++blockId;
            }
            blockMap.put(insn, blockId);
        }
        cfg.blockMap = blockMap;
        return cfg;
    }

    private static int insertStateVariable(MethodNode method) {
        int stateVarIndex = new LocalVariablesSorter(method.access, method.desc, method).newLocal(Type.INT_TYPE);
        InsnList initCode = new InsnList();
        initCode.add(new InsnNode(4));
        initCode.add(new VarInsnNode(54, stateVarIndex));
        method.instructions.insert(initCode);
        return stateVarIndex;
    }

    private static void generateStateMachine(MethodNode method, ControlFlowGraph cfg, int stateVarIndex) {
        InsnList newInstructions = new InsnList();
        HashMap<LabelNode, LabelNode> labelMap = new HashMap<LabelNode, LabelNode>();
        LabelNode loopLabel = new LabelNode();
        newInstructions.add(loopLabel);
        newInstructions.add(new FrameNode(1, 1, new Object[]{Opcodes.INTEGER}, 0, null));
        newInstructions.add(new VarInsnNode(21, stateVarIndex));
        LabelNode defaultLabel = new LabelNode();
        LabelNode[] caseLabels = SwitchCaseObfVisitor2.generateCaseLabels(cfg, labelMap);
        newInstructions.add(new TableSwitchInsnNode(1, caseLabels.length, defaultLabel, caseLabels));
        HashMap<Integer, List> blockToInsns = new HashMap<Integer, List>();
        for (AbstractInsnNode insn : method.instructions) {
            Integer blockId = cfg.blockMap.get(insn);
            if (blockId == null) {
                blockId = 0;
            }
            blockToInsns.computeIfAbsent(blockId, k -> new ArrayList()).add(insn);
        }
        block1: for (int blockId = 1; blockId <= caseLabels.length; ++blockId) {
            LabelNode caseLabel = caseLabels[blockId - 1];
            newInstructions.add(caseLabel);
            newInstructions.add(new FrameNode(3, 0, null, 0, null));
            List blockInsns = (List)blockToInsns.get(blockId);
            if (blockInsns == null) continue;
            for (AbstractInsnNode insn : blockInsns) {
                if (insn instanceof LabelNode) continue;
                if (insn instanceof JumpInsnNode) {
                    JumpInsnNode jump = (JumpInsnNode)insn;
                    int targetBlock = cfg.blockMap.get(jump.label);
                    newInstructions.add(new IntInsnNode(16, targetBlock));
                    newInstructions.add(new VarInsnNode(54, stateVarIndex));
                    newInstructions.add(new JumpInsnNode(167, loopLabel));
                    continue block1;
                }
                AbstractInsnNode cloned = insn.clone(labelMap);
                if (insn instanceof LineNumberNode) {
                    cloned = insn.clone(labelMap);
                }
                newInstructions.add(cloned);
            }
        }
        newInstructions.add(defaultLabel);
        newInstructions.add(new InsnNode(177));
        method.instructions = newInstructions;
    }

    private static LabelNode[] generateCaseLabels(ControlFlowGraph cfg, Map<LabelNode, LabelNode> labelMap) {
        int maxBlockId = Collections.max(cfg.blockMap.values());
        LabelNode[] labels = new LabelNode[maxBlockId];
        for (int i = 0; i < maxBlockId; ++i) {
            labels[i] = new LabelNode();
            labelMap.put(new LabelNode(), labels[i]);
        }
        return labels;
    }

    private static class ControlFlowGraph {
        Map<AbstractInsnNode, Integer> blockMap;

        private ControlFlowGraph() {
        }
    }
}

