/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;

public class LabelResorterObfVisitor {
    public static byte[] transform(byte[] classData) throws AnalyzerException {
        ClassNode classNode = new ClassNode();
        ClassReader cr = new ClassReader(classData);
        cr.accept(classNode, 0);
        ObfVisitor tester = new ObfVisitor(cr){};
        if (!tester.shouldObf() || (classNode.access & 0x4200) != 0) {
            return classData;
        }
        for (MethodNode methodNode : classNode.methods) {
            if ((methodNode.access & 0x500) != 0 || methodNode.name.contains("init>")) continue;
            LabelResorterObfVisitor.transformMethod(classNode, methodNode);
        }
        ClassWriter1 writer = new ClassWriter1(3);
        classNode.accept(writer);
        return writer.toByteArray();
    }

    private static void transformMethod(ClassNode classNode, MethodNode methodNode) throws AnalyzerException {
        Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicInterpreter());
        try {
            analyzer.analyze(methodNode.name, methodNode);
        }
        catch (AnalyzerException e) {
            throw new RuntimeException("Exception in " + classNode.name + " " + methodNode.name + " " + methodNode.desc, e);
        }
        InsnList insnList = new InsnList();
        LabelNode startLabel = new LabelNode();
        Package currentPackage = new Package();
        ArrayList<Package> packageList = new ArrayList<Package>();
        currentPackage.nodes.add(startLabel);
        int enterTryCatch = 0;
        for (AbstractInsnNode insnNode : methodNode.instructions) {
            if (enterTryCatch <= 0 && insnNode instanceof LabelNode) {
                currentPackage.nodes.add(new JumpInsnNode(167, (LabelNode)insnNode));
                packageList.add(currentPackage);
                currentPackage = new Package();
                currentPackage.nodes.add(insnNode);
            } else {
                if (enterTryCatch > 0 && insnNode instanceof LabelNode) {
                    System.out.println("In try catch " + enterTryCatch);
                }
                currentPackage.nodes.add(insnNode);
            }
            if (!(insnNode instanceof LabelNode)) continue;
            if (methodNode.tryCatchBlocks.stream().anyMatch(tc -> tc.start == insnNode)) {
                ++enterTryCatch;
                continue;
            }
            if (!methodNode.tryCatchBlocks.stream().anyMatch(tc -> tc.end == insnNode)) continue;
            --enterTryCatch;
        }
        packageList.add(currentPackage);
        insnList.add(new JumpInsnNode(167, startLabel));
        while (!packageList.isEmpty()) {
            Package p = (Package)packageList.remove(Main.r.nextInt(packageList.size()));
            p.nodes.forEach(insnList::add);
        }
        methodNode.localVariables.clear();
        methodNode.instructions = insnList;
    }
}

