#!/bin/bash
# Run crontab -e and then 0 3 * * * /var/www/chud.win/tools/backup.sh after
# configure ts
DB_NAME="db"
DB_USER="user"
DB_PASS="password"
WEB_DIR="/var/www/chud.win"
BACKUP_DIR="/var/www/backups"
DATE=$(date +"%Y-%m-%d_%H-%M-%S")
TMP_DIR="/tmp/site_backup_$DATE"

mkdir -p "$TMP_DIR"
mkdir -p "$BACKUP_DIR"

# dump that shit
mysqldump -u "$DB_USER" -p"$DB_PASS" "$DB_NAME" > "$TMP_DIR/db.sql"

# grab site files
rsync -a "$WEB_DIR" "$TMP_DIR/www"

# compress it into a fine goo
tar -czf "$BACKUP_DIR/backup_$DATE.tar.gz" -C "$TMP_DIR" .

# clean up tmp directory
rm -rf "$TMP_DIR"
