<?php
    require 'info.php';
    
    function news_build($action, $settings, $board) {
        // Possible values for $action:
        //	- all (rebuild everything, initialization)
        //	- news (news has been updated)
        
        News::build($action, $settings);
    }

    // Wrap functions in a class so they don't interfere with normal Tinyboard operations
    class News {
        public static function build($action, $settings) {
            global $config;
            
            if ($action == 'all' || $action == 'news')
                file_write($config['dir']['home'] . $settings['html'], News::homepage($settings));
        }
        
        // Build news page
        public static function homepage($settings) {
            global $config;
            
            $query = query("SELECT * FROM ``news`` ORDER BY `id` DESC") or error(db_error());
            $news = $query->fetchAll(PDO::FETCH_ASSOC);
            
            return Element('themes/news/news.html', Array(
                'settings' => $settings,
                'config' => $config,
                'boardlist' => createBoardlist(),
                'news' => $news
            ));
        }
    };
?>