/*! tegaki.js, MIT License */"use strict";var TegakiStrings={badDimensions:"Invalid dimensions.",promptWidth:"Canvas width in pixels",promptHeight:"Canvas height in pixels",confirmDelLayers:"Delete selected layers?",confirmMergeLayers:"Merge selected layers?",tooManyLayers:"Layer limit reached.",errorLoadImage:"Could not load the image.",noActiveLayer:"No active layer.",hiddenActiveLayer:"The active layer is not visible.",confirmCancel:"Are you sure? Your work will be lost.",confirmChangeCanvas:"Are you sure? Changing the canvas will clear all layers and history and disable replay recording.",color:"Color",size:"Size",alpha:"Opacity",flow:"Flow",zoom:"Zoom",layers:"Layers",switchPalette:"Switch color palette",paletteSlotReplace:"Right click to replace with the current color",layer:"Layer",addLayer:"Add layer",delLayers:"Delete layers",mergeLayers:"Merge layers",moveLayerUp:"Move up",moveLayerDown:"Move down",toggleVisibility:"Toggle visibility",newCanvas:"New",open:"Open",save:"Save",saveAs:"Save As","export":"Export",undo:"Undo",redo:"Redo",close:"Close",finish:"Finish",tip:"Tip",pressure:"Pressure",preserveAlpha:"Preserve Alpha",pen:"Pen",pencil:"Pencil",airbrush:"Airbrush",pipette:"Pipette",blur:"Blur",eraser:"Eraser",bucket:"Bucket",tone:"Tone",gapless:"Gapless",play:"Play",pause:"Pause",rewind:"Rewind",slower:"Slower",faster:"Faster",recordingEnabled:"Recording replay",errorLoadReplay:"Could not load the replay: ",loadingReplay:"Loading replay\u2026"};class TegakiTool{constructor(){this.id=0,this.name=null,this.keybind=null,this.useFlow=!1,this.useSizeDynamics=!1,this.useAlphaDynamics=!1,this.useFlowDynamics=!1,this.usePreserveAlpha=!1,this.step=0,this.size=1,this.alpha=1,this.flow=1,this.useSize=!0,this.useAlpha=!0,this.useFlow=!0,this.noCursor=!1,this.color="#000000",this.rgb=[0,0,0],this.brushSize=0,this.brushAlpha=0,this.brushFlow=0,this.stepSize=0,this.center=0,this.sizeDynamicsEnabled=!1,this.alphaDynamicsEnabled=!1,this.flowDynamicsEnabled=!1,this.preserveAlphaEnabled=!1,this.tip=-1,this.tipList=null,this.stepAcc=0,this.shapeCache=null,this.kernel=null}brushFn(e,t,a,i){}start(e,t){}commit(){}draw(e,t){}usesDynamics(){return this.useSizeDynamics||this.useAlphaDynamics||this.useFlowDynamics}enabledDynamics(){return this.sizeDynamicsEnabled||this.alphaDynamicsEnabled||this.flowDynamicsEnabled}setSize(e){this.size=e}setAlpha(e){this.alpha=e,this.brushAlpha=e}setFlow(e){this.flow=e,this.brushFlow=this.easeFlow(e)}easeFlow(e){return e}setColor(e){this.rgb=$T.hexToRgb(e)}setSizeDynamics(e){this.useSizeDynamics&&(e||this.setSize(this.size),this.sizeDynamicsEnabled=e)}setAlphaDynamics(e){this.useAlphaDynamics&&(e||this.setAlpha(this.alpha),this.alphaDynamicsEnabled=e)}setFlowDynamics(e){this.useFlowDynamics&&(e||this.setFlow(this.flow),this.flowDynamicsEnabled=e)}setPreserveAlpha(e){this.preserveAlphaEnabled=e}set(){this.setAlpha(this.alpha),this.setFlow(this.flow),this.setSize(this.size),this.setColor(Tegaki.toolColor),Tegaki.onToolChanged(this)}}class TegakiBrush extends TegakiTool{constructor(){super()}generateShape(e){}brushFn(e,t,a,i){var s,r,n,o,l,g,d,c,h,p,k,T,u,y,f,v,m,b,L,C,w,S,I,U,P,A,D,E,$;for($=this.preserveAlphaEnabled,g=this.kernel,D=this.brushAlpha,E=this.brushFlow,A=this.brushSize,s=Tegaki.activeLayer.imageData.data,r=Tegaki.ghostBuffer.data,n=Tegaki.blendBuffer.data,o=Tegaki.baseWidth,l=Tegaki.baseHeight,o,f=this.rgb[0],v=this.rgb[1],m=this.rgb[2],c=0;c<A;++c)if(!((p=t+c+i)<0||p>=l))for(d=0;d<A;++d)(h=e+d+a)<0||h>=o||(T=g[4*(c*A+d)+3]/255)<=0||(y=n[(U=4*(p*o+h))+3]/255,y+=T*E*(D-y),(P=Math.ceil(255*y))>n[U+3]&&(0===n[U]&&(r[U]=s[U],r[U+1]=s[U+1],r[U+2]=s[U+2],r[U+3]=s[U+3]),n[U]=1,n[U+3]=P,w=r[U],S=r[U+1],I=r[U+2],b=(f*y+w*(k=r[U+3]/255)*(1-y))/(u=k+y-k*y),L=(v*y+S*k*(1-y))/u,C=(m*y+I*k*(1-y))/u,s[U]=f>w?Math.ceil(b):Math.floor(b),s[U+1]=v>S?Math.ceil(L):Math.floor(L),s[U+2]=m>I?Math.ceil(C):Math.floor(C),$||(s[U+3]=Math.ceil(255*u))))}generateShapeCache(e){var t,a;if(this.shapeCache||(this.shapeCache=new Array(Tegaki.maxSize)),!this.shapeCache[0]||e)for(t=0;t<Tegaki.maxSize;++t)a=this.generateShape(t+1),this.shapeCache[t]=a,this.setShape(a)}updateDynamics(e){var t,a,i;if(t=TegakiPressure.lerp(e),this.sizeDynamicsEnabled){if(0===(i=Math.ceil(t*this.size)))return!1;a=this.shapeCache[i-1],this.setShape(a)}if(this.alphaDynamicsEnabled){if((i=this.alpha*t)<=0)return!1;this.brushAlpha=i}if(this.flowDynamicsEnabled){if((i=this.flow*t)<=0)return!1;this.brushFlow=this.easeFlow(i)}return!0}start(e,t){var a,i;this.stepAcc=0,this.posX=e,this.posY=t,this.enabledDynamics()&&!this.updateDynamics(1)||(a=e-this.center,i=t-this.center,this.readImageData(a,i,this.brushSize,this.brushSize),this.brushFn(0,0,a,i),this.writeImageData(a,i,this.brushSize,this.brushSize))}commit(){Tegaki.clearBuffers()}draw(e,t){var a,i,s,r,n,o,l,g,d,c,h,p,k,T,u,y,f,v,m,b,L;for(h=this.stepAcc,s=this.posX,r=this.posY,s<e?(l=e-s,n=s,a=1):(l=s-e,n=e,a=-1),r<t?(g=t-r,o=r,i=1):(g=r-t,o=t,i=-1),this.enabledDynamics()&&(T=Math.sqrt((e-s)*(e-s)+(t-r)*(t-r))),this.sizeDynamicsEnabled?(y=(u=this.shapeCache[this.size-1]).center,f=u.brushSize):(y=this.center,f=this.brushSize),n-=y,o-=y,b=l+f,L=g+f,this.readImageData(n,o,b,L),d=(l>g?l:0!==g?-g:0)/2,0!==l&&(l=-l),m=!1,p=s,k=r;h+=Math.max(Math.abs(p-s),Math.abs(k-r)),p=s,k=r,h>=this.stepSize&&(this.enabledDynamics()?(v=T>0?1-Math.sqrt((e-s)*(e-s)+(t-r)*(t-r))/T:0,this.updateDynamics(v)&&(this.brushFn(s-this.center-n,r-this.center-o,n,o),m=!0)):(this.brushFn(s-this.center-n,r-this.center-o,n,o),m=!0),h=0),s!==e||r!==t;)(c=d)>l&&(d-=g,s+=a),c<g&&(d-=l,r+=i);this.stepAcc=h,this.posX=e,this.posY=t,m&&this.writeImageData(n,o,b,L)}writeImageData(e,t,a,i){Tegaki.activeLayer.ctx.putImageData(Tegaki.activeLayer.imageData,0,0,e,t,a,i)}readImageData(e,t,a,i){}setShape(e){this.center=e.center,this.stepSize=e.stepSize,this.brushSize=e.brushSize,this.kernel=e.kernel}setSize(e){this.size=e,this.sizeDynamicsEnabled?this.generateShapeCache():this.setShape(this.generateShape(e))}setSizeDynamics(e){this.useSizeDynamics&&this.sizeDynamicsEnabled!==e&&(e?this.generateShapeCache():this.setShape(this.generateShape(this.size)),this.sizeDynamicsEnabled=e)}setTip(e){this.tipId=e,this.sizeDynamicsEnabled?this.generateShapeCache(!0):this.setShape(this.generateShape(this.size))}}class TegakiPencil extends TegakiBrush{constructor(){super(),this.id=1,this.name="pencil",this.keybind="b",this.step=.01,this.useFlow=!1,this.size=1,this.alpha=1,this.useSizeDynamics=!0,this.useAlphaDynamics=!0,this.usePreserveAlpha=!0}generateShape(e){var t,a,i,s,r,n,o,l,g;for(l=0|e/2,g=0|(e+1)%2,s=new ImageData(e,e),r=new Uint32Array(s.data.buffer),o=4278190080,a=l,i=0,t=1-l,n=l;a>=i;)r[n+a-g+(n+i-g)*e]=o,r[n+i-g+(n+a-g)*e]=o,r[n-i+(n+a-g)*e]=o,r[n-a+(n+i-g)*e]=o,r[n-i+(n-a)*e]=o,r[n-a+(n-i)*e]=o,r[n+i-g+(n-a)*e]=o,r[n+a-g+(n-i)*e]=o,++i,t+=t<=0?2*i+1:2*(i- --a)+1;return l>0&&Tegaki.tools.bucket.fill(s,l,l,this.rgb,1),{center:l,stepSize:Math.ceil(e*this.step),brushSize:e,kernel:s.data}}}class TegakiAirbrush extends TegakiBrush{constructor(){super(),this.id=3,this.name="airbrush",this.keybind="a",this.step=.1,this.size=32,this.alpha=1,this.useSizeDynamics=!0,this.useAlphaDynamics=!0,this.useFlowDynamics=!0,this.usePreserveAlpha=!0}easeFlow(e){return 1-Math.sqrt(1-e)}generateShape(e){var t,a,i,s,r,n,o,l,g,d,c,h;for(a=e,e*=2,i=new ImageData(e,e).data,s=e*e*4,n=Math.sqrt(a*a),l=g=-(o=Math.round(a)),t=0;t<s;)l>=o?(l=-o,++g):(c=g,(d=l)<0&&(d=-d),c<0&&(c=-c),(r=Math.sqrt(d*d+c*c))>=n?h=0:0===r?h=255:((h=r/n+.1)>1&&(h=1),h=255*(1-Math.exp(1-1/h)/h)),i[t+3]=h,t+=4,++l);return{center:a,stepSize:Math.ceil(e*this.step),brushSize:e,kernel:i}}}class TegakiPen extends TegakiBrush{constructor(){super(),this.id=2,this.name="pen",this.keybind="p",this.step=.05,this.size=8,this.alpha=1,this.flow=1,this.useSizeDynamics=!0,this.useAlphaDynamics=!0,this.useFlowDynamics=!0,this.usePreserveAlpha=!0}easeFlow(e){return 1-Math.sqrt(1-Math.pow(e,3))}generateShape(e){var t,a,i,s,r,n,o,l,g,d,c,h,p,k,T,u,y,f;for(y=Math.floor(e/2)+1,c=(d=4)*d,h=(f=e+2)*d,l=Math.floor(h/2),g=Math.floor((h+1)%2),s=new ImageData(h,h),p=new Uint32Array(s.data.buffer),o=1426063360,a=l,i=0,t=1-l,n=l;a>=i;)p[n+a-g+(n+i-g)*h]=o,p[n+i-g+(n+a-g)*h]=o,p[n-i+(n+a-g)*h]=o,p[n-a+(n+i-g)*h]=o,p[n-i+(n-a)*h]=o,p[n-a+(n-i)*h]=o,p[n+i-g+(n-a)*h]=o,p[n+a-g+(n-i)*h]=o,++i,t+=t<=0?2*i+1:2*(i- --a)+1;for(o=4278190080,a=l-3,i=0,t=1-l,n=l;a>=i;)p[n+a-g+(n+i-g)*h]=o,p[n+i-g+(n+a-g)*h]=o,p[n-i+(n+a-g)*h]=o,p[n-a+(n+i-g)*h]=o,p[n-i+(n-a)*h]=o,p[n-a+(n-i)*h]=o,p[n+i-g+(n-a)*h]=o,p[n+a-g+(n-i)*h]=o,++i,t+=t<=0?2*i+1:2*(i- --a)+1;for(l>0&&Tegaki.tools.bucket.fill(s,l,l,this.rgb,1),p=s.data,r=new ImageData(f,f).data,a=0;a<f;++a)for(i=0;i<f;++i){for(k=4*(i*f+a)+3,o=0,T=0;T<d;++T)for(u=0;u<d;++u)o+=p[4*((u+i*d)*h+(T+a*d))+3];r[k]=o/c}return{center:y,stepSize:Math.ceil(e*this.step),brushSize:f,kernel:r}}}class TegakiBucket extends TegakiTool{constructor(){super(),this.id=4,this.name="bucket",this.keybind="g",this.step=100,this.useSize=!1,this.useFlow=!1,this.noCursor=!0}fill(e,t,a,i,s){var r,n,o,l,g,d,c,h,p,k,T,u,y,f,v,m,b,L,C,w,S;for(w=e.width,S=e.height,r=i[0],n=i[1],o=i[2],l=4*(a*w+t),g=(C=e.data)[l],d=C[l+1],c=C[l+2],h=C[l+3],k=new Uint8Array(w*S*4),(p=[])[0]=t,p[1]=a;p.length;){for(T=p.pop(),u=p.pop(),v=T*w,m=(y=T-1)*w,b=(f=T+1)*w,L=u;L>=0&&(l=4*(v+L),this.testPixel(C,l,k,g,d,c,h));)this.blendPixel(C,l,r,n,o,s),k[l]=1,y>=0&&(l=4*(m+L),this.testPixel(C,l,k,g,d,c,h)&&(p.push(L),p.push(y))),f<S&&(l=4*(b+L),this.testPixel(C,l,k,g,d,c,h)&&(p.push(L),p.push(f))),L--;for(L=u+1;L<w&&(l=4*(v+L),this.testPixel(C,l,k,g,d,c,h));)this.blendPixel(C,l,r,n,o,s),k[l]=1,y>=0&&(l=4*(m+L),this.testPixel(C,l,k,g,d,c,h)&&(p.push(L),p.push(y))),f<S&&(l=4*(b+L),this.testPixel(C,l,k,g,d,c,h)&&(p.push(L),p.push(f))),++L}}brushFn(e,t){e<0||t<0||e>=Tegaki.baseWidth||t>=Tegaki.baseHeight||(this.fill(Tegaki.activeLayer.imageData,e,t,this.rgb,this.alpha),Tegaki.activeLayer.ctx.putImageData(Tegaki.activeLayer.imageData,0,0))}blendPixel(e,t,a,i,s,r){var n,o,l,g,d,c,h,p;n=e[t],o=e[t+1],l=e[t+2],d=(a*r+n*(g=e[t+3]/255)*(1-r))/(p=g+r-g*r),c=(i*r+o*g*(1-r))/p,h=(s*r+l*g*(1-r))/p,e[t]=a>n?Math.ceil(d):Math.floor(d),e[t+1]=i>o?Math.ceil(c):Math.floor(c),e[t+2]=s>l?Math.ceil(h):Math.floor(h),e[t+3]=Math.ceil(255*p)}testPixel(e,t,a,i,s,r,n){return!a[t]&&e[t]==i&&e[++t]==s&&e[++t]==r&&e[++t]==n}start(e,t){this.brushFn(e,t)}draw(e,t){this.brushFn(e,t)}setSize(e){}}class TegakiTone extends TegakiPencil{constructor(){super(),this.id=5,this.name="tone",this.keybind="t",this.step=.01,this.useFlow=!1,this.size=8,this.alpha=.5,this.useSizeDynamics=!0,this.useAlphaDynamics=!0,this.usePreserveAlpha=!0,this.matrix=[[0,8,2,10],[12,4,14,6],[3,11,1,9],[15,7,13,5]],this.mapCache=null,this.mapWidth=0,this.mapHeight=0}start(e,t){this.mapWidth===Tegaki.baseWidth&&this.mapHeight===Tegaki.baseHeight||this.generateMapCache(!0),super.start(e,t)}brushFn(e,t,a,i){var s,r,n,o,l,g,d,c,h,p,k,T,u,y;if(s=Tegaki.activeLayer.imageData.data,u=Tegaki.baseWidth,y=Tegaki.baseHeight,r=this.kernel,n=this.brushSize,this.mapWidth,g=this.preserveAlphaEnabled,!((l=Math.round(16*this.brushAlpha)-1)<0))for(o=this.mapCache[l],p=0;p<n;++p)if(!((T=t+p+i)<0||T>=y))for(h=0;h<n;++h)(k=e+h+a)<0||k>=u||0!==r[4*(p*n+h)+3]&&(d=4*(c=T*u+k),0===o[c]&&(s[d]=this.rgb[0],s[d+1]=this.rgb[1],s[d+2]=this.rgb[2],g||(s[d+3]=255)))}generateMap(e,t,a){var i,s,r;for(i=new Uint8Array(e*t),r=0;r<t;++r)for(s=0;s<e;++s)a<this.matrix[r%4][s%4]&&(i[e*r+s]=1);return i}generateMapCache(e){var t,a;if(a=this.matrix.length*this.matrix[0].length,this.mapCache||(this.mapCache=new Array(a)),e||!this.mapCache[0]||this.mapWidth!==Tegaki.baseWidth||this.mapHeight!==Tegaki.baseHeight)for(this.mapWidth=Tegaki.baseWidth,this.mapHeight=Tegaki.baseHeight,t=0;t<a;++t)this.mapCache[t]=this.generateMap(this.mapWidth,this.mapHeight,t)}setAlpha(e){super.setAlpha(e),this.generateMapCache()}}class TegakiPipette extends TegakiTool{constructor(){super(),this.id=6,this.name="pipette",this.keybind="i",this.step=100,this.useSize=!1,this.useAlpha=!1,this.useFlow=!1,this.noCursor=!0}start(e,t){this.draw(e,t)}draw(e,t){var a,i;i=Tegaki.flatten().getContext("2d"),a=$T.getColorAt(i,e,t),Tegaki.setToolColor(a)}set(){Tegaki.onToolChanged(this)}commit(){}setSize(){}setAlpha(){}}class TegakiBlur extends TegakiBrush{constructor(){super(),this.id=7,this.name="blur",this.step=.25,this.useFlow=!1,this.size=32,this.alpha=.5,this.useAlphaDynamics=!0,this.usePreserveAlpha=!1}writeImageData(e,t,a,i){var s,r,n,o,l,g,d;for(g=Tegaki.activeLayer.imageData.data,d=Tegaki.blendBuffer.data,l=Tegaki.baseWidth,s=0;s<a;++s)for(n=e+s,r=0;r<i;++r)g[o=4*((t+r)*l+n)]=d[o],g[o+1]=d[o+1],g[o+2]=d[o+2],g[o+3]=d[o+3];super.writeImageData(e,t,a,i)}readImageData(e,t,a,i){var s,r,n,o,l,g,d;for(g=Tegaki.activeLayer.imageData.data,d=Tegaki.blendBuffer.data,l=Tegaki.baseWidth,s=0;s<a;++s)for(n=e+s,r=0;r<i;++r)d[o=4*((t+r)*l+n)]=g[o],d[o+1]=g[o+1],d[o+2]=g[o+2],d[o+3]=g[o+3]}brushFn(e,t,a,i){var s,r,n,o,l,g,d,c,h,p,k,T,u,y,f,v,m,b,L,C,w,S,I,U,P;if(!((c=(h=this.brushAlpha)*h*h)<=0))for(r=this.brushSize,d=this.kernel,n=Tegaki.activeLayer.imageData.data,o=Tegaki.blendBuffer.data,l=(T=Tegaki.baseWidth)-1,g=(u=Tegaki.baseHeight)-1,y=0;y<r;++y)if(!((p=e+y+a)<0||p>=T))for(f=0;f<r;++f)if(!((k=t+f+i)<0||k>=u||(S=4*(k*T+p),0===d[4*(f*r+y)+3]||p<=0||k<=0||p>=l||k>=g))){for(v=m=b=L=U=0,C=-1;C<2;++C)for(w=-1;w<2;++w)I=n[(s=4*((k-w)*T+(p-C)))+3],0===C&&0===w?(P=I*h,U+=h):(P=I*c,U+=c),v+=n[s]*P,m+=n[++s]*P,b+=n[++s]*P,L+=P;(L/=U)<=0||(o[S]=Math.round(v/U/L),o[S+1]=Math.round(m/U/L),o[S+2]=Math.round(b/U/L),o[S+3]=Math.round(L))}}}TegakiBlur.prototype.generateShape=TegakiPencil.prototype.generateShape;class TegakiEraser extends TegakiBrush{constructor(){super(),this.id=8,this.name="eraser",this.keybind="e",this.step=.1,this.size=8,this.alpha=1,this.useFlow=!1,this.useSizeDynamics=!0,this.useAlphaDynamics=!0,this.usePreserveAlpha=!1,this.tipId=0,this.tipList=["pencil","pen","airbrush"]}brushFn(e,t,a,i){var s,r,n,o,l,g,d,c,h,p,k,T,u,y,f;for(f=this.brushAlpha,y=this.brushSize,o=this.kernel,s=Tegaki.activeLayer.imageData.data,n=Tegaki.ghostBuffer.data,r=Tegaki.blendBuffer.data,l=Tegaki.baseWidth,g=Tegaki.baseHeight,k=0;k<y;++k)if(!((u=t+k+i)<0||u>=g))for(p=0;p<y;++p)(T=e+p+a)<0||T>=l||(d=o[4*(k*y+p)+3]/255,0===n[h=4*(u*l+T)+3]&&(n[h]=s[h]),c=r[h]/255,c+=d*(f-c),r[h]=Math.floor(255*c),s[h]=Math.floor(n[h]*(1-c)))}generateShape(e){return 0===this.tipId?this.generateShapePencil(e):1===this.tipId?this.generateShapePen(e):this.generateShapeAirbrush(e)}}TegakiEraser.prototype.generateShapePencil=TegakiPencil.prototype.generateShape,TegakiEraser.prototype.generateShapePen=TegakiPen.prototype.generateShape,TegakiEraser.prototype.generateShapeAirbrush=TegakiAirbrush.prototype.generateShape;var $T={docEl:document.documentElement,id:function(e){return document.getElementById(e)},cls:function(e,t){return(t||document).getElementsByClassName(e)},on:function(e,t,a){e.addEventListener(t,a,!1)},off:function(e,t,a){e.removeEventListener(t,a,!1)},el:function(e){return document.createElement(e)},frag:function(){return document.createDocumentFragment()},copyImageData:e=>new ImageData(new Uint8ClampedArray(e.data),e.width),copyCanvas:function(e,t){var a;return t?a=e.cloneNode(!1):((a=$T.el("canvas")).width=e.width,a.height=e.height),a.getContext("2d").drawImage(e,0,0),a},clearCtx:function(e){e.clearRect(0,0,e.canvas.width,e.canvas.height)},hexToRgb:function(e){var t=e.match(/^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/i);return t?[parseInt(t[1],16),parseInt(t[2],16),parseInt(t[3],16)]:null},RgbToHex:function(e,t,a){return"#"+((1<<24)+(e<<16)+(t<<8)+a).toString(16).slice(1)},getColorAt:function(e,t,a){var i=e.getImageData(t,a,1,1).data;return"#"+("0"+i[0].toString(16)).slice(-2)+("0"+i[1].toString(16)).slice(-2)+("0"+i[2].toString(16)).slice(-2)},generateFilename:function(){return"tegaki_"+(new Date).toISOString().split(".")[0].replace(/[^0-9]/g,"_")},sortAscCb:function(e,t){return e>t?1:e<t?-1:0},sortDescCb:function(e,t){return e>t?-1:e<t?1:0},msToHms:function(e){var t,a,i,s;return i=(i=0|e/1e3)-3600*(t=0|i/3600)-60*(a=0|(i-3600*t)/60),s=[],t&&s.push(t<10?"0"+t:t),a?s.push(a<10?"0"+a:a):s.push("00"),i?s.push(i<10?"0"+i:i):s.push("00"),s.join(":")},calcThumbSize(e,t,a){var i;return e>a&&(i=a/e,e=a,t*=i),t>a&&(i=a/t,t=a,e*=i),[Math.ceil(e),Math.ceil(t)]}};class TegakiBinReader{constructor(e){this.pos=0,this.view=new DataView(e),this.buf=e}readInt8(){var e=this.view.getInt8(this.pos);return this.pos+=1,e}readUint8(){var e=this.view.getUint8(this.pos);return this.pos+=1,e}readInt16(){var e=this.view.getInt16(this.pos);return this.pos+=2,e}readUint16(){var e=this.view.getUint16(this.pos);return this.pos+=2,e}readUint32(){var e=this.view.getUint32(this.pos);return this.pos+=4,e}readFloat32(){var e=this.view.getFloat32(this.pos);return this.pos+=4,e}}class TegakiBinWriter{constructor(e){this.pos=0,this.view=new DataView(e),this.buf=e}writeInt8(e){this.view.setInt8(this.pos,e),this.pos+=1}writeUint8(e){this.view.setUint8(this.pos,e),this.pos+=1}writeInt16(e){this.view.setInt16(this.pos,e),this.pos+=2}writeUint16(e){this.view.setUint16(this.pos,e),this.pos+=2}writeUint32(e){this.view.setUint32(this.pos,e),this.pos+=4}writeFloat32(e){this.view.setFloat32(this.pos,e),this.pos+=4}}var TegakiCursor={size:0,radius:0,points:null,cursorCtx:null,offsetX:0,offsetY:0,lastX:0,lastY:0,lastSize:0,init:function(){var e;(e=$T.el("canvas")).id="tegaki-cursor-layer",[e.width,e.height]=TegakiCursor.getMaxCanvasSize(),Tegaki.canvasCnt.appendChild(e),this.offsetX=e.offsetLeft,this.offsetY=e.offsetTop,this.cursorCtx=e.getContext("2d")},getCanvas:function(){return this.cursorCtx?this.cursorCtx.canvas:null},getMaxCanvasSize:function(){let e=Tegaki.canvasCnt.offsetWidth,t=Tegaki.canvasCnt.offsetHeight,[a,i]=Tegaki.getScrollbarSizes();return[e-a,t-i]},updateCanvasSize:function(){let e=this.cursorCtx.canvas,[t,a]=this.getMaxCanvasSize();t===e.width&&a===e.height||(e.width=t,e.height=a,this.offsetX=e.offsetLeft,this.offsetY=e.offsetTop)},render:function(e,t){var a,i,s,r,n;for(a=e-this.offsetX-this.radius,i=t-this.offsetY-this.radius,this.clear(),this.lastX=a,this.lastY=i,this.lastSize=this.size,r=this.cursorCtx.createImageData(this.size,this.size),n=new Uint32Array(r.data.buffer),s=0;s<this.points.length;++s)n[this.points[s]]=4294967167;this.cursorCtx.putImageData(r,a,i)},clear:function(){this.cursorCtx.clearRect(this.lastX,this.lastY,this.lastSize,this.lastSize)},clearAll:function(){var e=this.cursorCtx.canvas;this.cursorCtx.clearRect(0,0,e.width,e.height)},destroy(){this.size=0,this.radius=0,this.offsetX=0,this.offsetY=0,this.lastX=0,this.lastY=0,this.lastSize=0,this.points=null,this.cursorCtx=null},generate:function(e){var t,a,i,s,r,n,o;if((e=0|e*Tegaki.zoomFactor)<2)return!1;for(n=0|(e+1)%2,o=[],a=r=0|e/2,i=0,t=1-r,s=r;a>=i;)o.push(s+a-n+(s+i-n)*e),o.push(s+i-n+(s+a-n)*e),o.push(s-i+(s+a-n)*e),o.push(s-a+(s+i-n)*e),o.push(s-i+(s-a)*e),o.push(s-a+(s-i)*e),o.push(s+i-n+(s-a)*e),o.push(s+a-n+(s-i)*e),++i,t+=t<=0?2*i+1:2*(i- --a)+1;return this.size=e,this.radius=r,this.points=o,!0}},TegakiHistory={maxSize:50,undoStack:[],redoStack:[],pendingAction:null,clear:function(){this.undoStack=[],this.redoStack=[],this.pendingAction=null,this.onChange(0)},push:function(e){e&&(e.coalesce&&this.undoStack[this.undoStack.length-1]instanceof e.constructor&&this.undoStack[this.undoStack.length-1].coalesce(e)||(this.undoStack.push(e),this.undoStack.length>this.maxSize&&this.undoStack.shift(),this.redoStack.length>0&&(this.redoStack=[]),this.onChange(0)))},undo:function(){var e;this.undoStack.length&&((e=this.undoStack.pop()).undo(),this.redoStack.push(e),this.onChange(-1))},redo:function(){var e;this.redoStack.length&&((e=this.redoStack.pop()).redo(),this.undoStack.push(e),this.onChange(1))},onChange:function(e){Tegaki.onHistoryChange(this.undoStack.length,this.redoStack.length,e)},sortPosLayerCallback:function(e,t){return e[0]>t[0]?1:e[0]<t[0]?-1:0}},TegakiHistoryActions={Dummy:function(){this.undo=function(){},this.redo=function(){}},Draw:function(e){this.coalesce=!1,this.imageDataBefore=null,this.imageDataAfter=null,this.layerId=e},DeleteLayers:function(e,t){var a;this.coalesce=!1,this.layerPosMap=[];for(a of e.sort(TegakiHistory.sortPosLayerCallback))a[1]=TegakiLayers.cloneLayer(a[1]),this.layerPosMap.push(a);if(this.tgtLayerId=null,this.aLayerIdBefore=null,this.aLayerIdAfter=null,this.imageDataBefore=null,this.imageDataAfter=null,this.mergeDown=!1,t)for(let e in t)this[e]=t[e]},AddLayer:function(e,t,a){this.coalesce=!1,this.layer=e,this.layerId=e.id,this.aLayerIdBefore=t,this.aLayerIdAfter=a},MoveLayers:function(e,t,a){this.coalesce=!1,this.layers=e,this.belowPos=t,this.aLayerId=a},SetLayersAlpha:function(e,t){this.layerAlphas=e,this.newAlpha=t},SetLayerName:function(e,t,a){this.layerId=e,this.oldName=t,this.newName=a}};TegakiHistoryActions.Draw.prototype.addCanvasState=function(e,t){t?this.imageDataAfter=$T.copyImageData(e):this.imageDataBefore=$T.copyImageData(e)},TegakiHistoryActions.Draw.prototype.exec=function(e){var t=TegakiLayers.getLayerById(this.layerId);e?(t.ctx.putImageData(this.imageDataAfter,0,0),TegakiLayers.syncLayerImageData(t,this.imageDataAfter)):(t.ctx.putImageData(this.imageDataBefore,0,0),TegakiLayers.syncLayerImageData(t,this.imageDataBefore)),TegakiUI.updateLayerPreview(t),TegakiLayers.setActiveLayer(this.layerId)},TegakiHistoryActions.Draw.prototype.undo=function(){this.exec(0)},TegakiHistoryActions.Draw.prototype.redo=function(){this.exec(1)},TegakiHistoryActions.DeleteLayers.prototype.undo=function(){var e,t,a,i,s,r;for(e=0,t=this.layerPosMap.length;e<t;++e)[s,i]=this.layerPosMap[e],i=TegakiLayers.cloneLayer(i),(a=Tegaki.layers[s])?((r=TegakiLayers.getLayerBelowId(a.id))&&(r=r.id),TegakiUI.updateLayersGridAdd(i,r),TegakiUI.updateLayerPreview(i),Tegaki.layersCnt.insertBefore(i.canvas,a.canvas),Tegaki.layers.splice(s,0,i)):(a=Tegaki.layers[0]?Tegaki.layers[Tegaki.layers.length-1].canvas:Tegaki.layersCnt.children[0],TegakiUI.updateLayersGridAdd(i,TegakiLayers.getTopLayerId()),TegakiUI.updateLayerPreview(i),Tegaki.layersCnt.insertBefore(i.canvas,a.nextElementSibling),Tegaki.layers.push(i));this.tgtLayerId&&((i=TegakiLayers.getLayerById(this.tgtLayerId)).ctx.putImageData(this.imageDataBefore,0,0),TegakiLayers.syncLayerImageData(i,this.imageDataBefore),TegakiLayers.setLayerAlpha(i,this.tgtLayerAlpha),TegakiUI.updateLayerPreview(i)),TegakiLayers.setActiveLayer(this.aLayerIdBefore)},TegakiHistoryActions.DeleteLayers.prototype.redo=function(){var e,t=[];for(e of this.layerPosMap)t.unshift(e[1].id);this.tgtLayerId?(this.mergeDown||t.unshift(this.tgtLayerId),TegakiLayers.mergeLayers(new Set(t))):TegakiLayers.deleteLayers(t),TegakiLayers.setActiveLayer(this.aLayerIdAfter)},TegakiHistoryActions.MoveLayers.prototype.undo=function(){var e,t,a,i,s;new Array(Tegaki.layers.length),i={};for(t of this.layers)i[t[1].id]=t[0];for(e=0,s=Tegaki.layers.length;e<s;++e)i[(t=Tegaki.layers[e]).id]!==undefined&&(Tegaki.layers.splice(e,1),Tegaki.layers.splice(i[t.id],0,t));for(TegakiUI.updayeLayersGridOrder(),a=Tegaki.layersCnt.children[0],e=Tegaki.layers.length-1;e>=0;e--)t=Tegaki.layers[e],Tegaki.layersCnt.insertBefore(t.canvas,a.nextElementSibling);TegakiLayers.setActiveLayer(this.aLayerId)},TegakiHistoryActions.MoveLayers.prototype.redo=function(){var e,t=new Set;for(e of this.layers.slice().reverse())t.add(e[1].id);TegakiLayers.setActiveLayer(this.aLayerId),TegakiLayers.moveLayers(t,this.belowPos)},TegakiHistoryActions.AddLayer.prototype.undo=function(){TegakiLayers.deleteLayers([this.layer.id]),TegakiLayers.setActiveLayer(this.aLayerIdBefore),Tegaki.layerCounter--},TegakiHistoryActions.AddLayer.prototype.redo=function(){TegakiLayers.setActiveLayer(this.aLayerIdBefore),TegakiLayers.addLayer(this.layer),TegakiLayers.setActiveLayer(this.aLayerIdAfter)},TegakiHistoryActions.SetLayersAlpha.prototype.undo=function(){var e,t,a;for(t of this.layerAlphas)[e,t]=t,(a=TegakiLayers.getLayerById(e))&&TegakiLayers.setLayerAlpha(a,t);TegakiUI.updateLayerAlphaOpt()},TegakiHistoryActions.SetLayersAlpha.prototype.redo=function(){var e,t,a;for(t of this.layerAlphas)[e,t]=t,(a=TegakiLayers.getLayerById(e))&&TegakiLayers.setLayerAlpha(a,this.newAlpha);TegakiUI.updateLayerAlphaOpt()},TegakiHistoryActions.SetLayersAlpha.prototype.coalesce=function(e){var t;if(this.layerAlphas.length!==e.layerAlphas.length)return!1;for(t=0;t<this.layerAlphas.length;++t)if(this.layerAlphas[t][0]!==e.layerAlphas[t][0])return!1;return this.newAlpha=e.newAlpha,!0},TegakiHistoryActions.SetLayerName.prototype.exec=function(e){var t=TegakiLayers.getLayerById(this.layerId);t&&(t.name=e?this.newName:this.oldName,TegakiUI.updateLayerName(t))},TegakiHistoryActions.SetLayerName.prototype.undo=function(){this.exec(0)},TegakiHistoryActions.SetLayerName.prototype.redo=function(){this.exec(1)};var TegakiKeybinds={keyMap:{},captionMap:{},clear:function(){this.keyMap={},this.captionMap={}},bind:function(e,t,a,i,s){this.keyMap[e]=[t,a],i&&(this.captionMap[i]=s)},getCaption(e){return this.captionMap[e]},resolve:function(e){var t,a,i,s;("INPUT"!=(s=e.target).nodeName||"text"!==s.type&&"number"!==s.type)&&(a=[],e.ctrlKey&&a.push("ctrl"),e.shiftKey&&a.push("shift"),i=e.key.toLowerCase(),a[0]&&(i=a.join("+")+"+"+i),!(t=TegakiKeybinds.keyMap[i])||e.altKey||e.metaKey||(e.preventDefault(),e.stopPropagation(),t[0][t[1]]()))}},TegakiLayers={cloneLayer:function(e){var t=Object.assign({},e);return t.canvas=$T.copyCanvas(e.canvas,!0),t.ctx=t.canvas.getContext("2d"),t.imageData=$T.copyImageData(e.imageData),t},getCanvasById:function(e){return $T.id("tegaki-canvas-"+e)},getActiveLayer:function(){return Tegaki.activeLayer},getLayerPosById:function(e){var t,a=Tegaki.layers;for(t=0;t<a.length;++t)if(a[t].id===e)return t;return-1},getTopFencedLayerId:function(){var e,t,a=Tegaki.layers;for(e=a.length-1;e>=0&&!TegakiLayers.selectedLayersHas(a[e].id);e--);for(e-=1;e>=0&&TegakiLayers.selectedLayersHas(a[e].id);e--);return(t=a[e])?t.id:0},getSelectedEdgeLayerPos:function(e){var t,a=Tegaki.layers;if(e)for(t=Tegaki.layers.length-1;t>=0&&!TegakiLayers.selectedLayersHas(a[t].id);t--);else{for(t=0;t<a.length&&!TegakiLayers.selectedLayersHas(a[t].id);++t);t>=a.length&&(t=-1)}return t},getTopLayer:function(){return Tegaki.layers[Tegaki.layers.length-1]},getTopLayerId:function(){var e=TegakiLayers.getTopLayer();return e?e.id:0},getLayerBelowId:function(e){var t;return(t=TegakiLayers.getLayerPosById(e))<1?null:Tegaki.layers[t-1]},getLayerById:function(e){return Tegaki.layers[TegakiLayers.getLayerPosById(e)]},isSameLayerOrder:function(e,t){var a,i;if(e.length!==t.length)return!1;for(a=0;i=e[a];++a)if(i.id!==t[a].id)return!1;return!0},addLayer:function(e={}){var t,a,i,s,r,n,o,l,g;Tegaki.activeLayer?(l=Tegaki.activeLayer.id,o=TegakiLayers.getLayerPosById(Tegaki.activeLayer.id),n=$T.cls("tegaki-layer",Tegaki.layersCnt)[o]):(o=-1,n=null),n||(n=Tegaki.layersCnt.firstElementChild),(a=$T.el("canvas")).className="tegaki-layer",a.width=Tegaki.baseWidth,a.height=Tegaki.baseHeight,t=++Tegaki.layerCounter,a.id="tegaki-canvas-"+t,a.setAttribute("data-id",t),s={name:TegakiStrings.layer+" "+t,visible:!0,alpha:1},r={id:t,canvas:a,ctx:g=a.getContext("2d"),imageData:g.getImageData(0,0,a.width,a.height)};for(i in s)e[i]!==undefined&&(s[i]=e[i]),r[i]=s[i];return Tegaki.layers.splice(o+1,0,r),TegakiUI.updateLayersGridAdd(r,l),Tegaki.layersCnt.insertBefore(a,n.nextElementSibling),Tegaki.onLayerStackChanged(),new TegakiHistoryActions.AddLayer(r,l,t)},deleteLayers:function(e,t){var a,i,s,r,n,o;o={aLayerIdBefore:Tegaki.activeLayer?Tegaki.activeLayer.id:-1,aLayerIdAfter:TegakiLayers.getTopFencedLayerId()},r=[],n=[];for(a of e)i=TegakiLayers.getLayerPosById(a),s=Tegaki.layers[i],r.push([i,s]),Tegaki.layersCnt.removeChild(s.canvas),n.push(i),TegakiUI.updateLayersGridRemove(a),TegakiUI.deleteLayerPreviewCtx(s);n=n.sort($T.sortDescCb);for(i of n)Tegaki.layers.splice(i,1);return t&&Object.assign(o,t),Tegaki.onLayerStackChanged(),new TegakiHistoryActions.DeleteLayers(r,o)},mergeLayers:function(e){var t,a,i,s,r,n,o,l,g,d;l=[];for(o of Tegaki.layers)e.has(o.id)&&l.push(o);if(!(l.length<1)){if(1===l.length){if(!(r=TegakiLayers.getLayerBelowId(l[0].id)))return;l.unshift(r),d=!0}else r=l[l.length-1],d=!1;(t=$T.el("canvas")).width=Tegaki.baseWidth,t.height=Tegaki.baseHeight,a=t.getContext("2d"),s=$T.copyImageData(r.imageData),g=[];for(o of l)o.id!==r.id&&g.push(o.id),a.globalAlpha=o.alpha,a.drawImage(o.canvas,0,0);return $T.clearCtx(r.ctx),r.ctx.drawImage(t,0,0),TegakiLayers.syncLayerImageData(r),i=$T.copyImageData(r.imageData),n=TegakiLayers.deleteLayers(g,{tgtLayerId:r.id,tgtLayerAlpha:r.alpha,aLayerIdAfter:r.id,imageDataBefore:s,imageDataAfter:i,mergeDown:d}),TegakiLayers.setLayerAlpha(r,1),TegakiUI.updateLayerAlphaOpt(),TegakiUI.updateLayerPreview(r),Tegaki.onLayerStackChanged(),n}},moveLayers:function(e,t){var a,i,s,r,n,o,l;if(e.size&&Tegaki.layers.length){o=t>=Tegaki.layers.length?TegakiLayers.getTopLayer().canvas.nextElementSibling:(i=Tegaki.layers[t]).canvas,s=[],r=[],n=[],l=t,a=0;for(i of Tegaki.layers)e.has(i.id)?(t>0&&a<=t&&l--,s.push([a,i]),n.push(i)):r.push(i),++a;if(r.splice(l,0,...n),!TegakiLayers.isSameLayerOrder(r,Tegaki.layers)){Tegaki.layers=r;for(i of s)Tegaki.layersCnt.insertBefore(i[1].canvas,o);return TegakiUI.updayeLayersGridOrder(),Tegaki.onLayerStackChanged(),new TegakiHistoryActions.MoveLayers(s,t,Tegaki.activeLayer?Tegaki.activeLayer.id:-1)}}},setLayerVisibility:function(e,t){e.visible=t,t?e.canvas.classList.remove("tegaki-hidden"):e.canvas.classList.add("tegaki-hidden"),Tegaki.onLayerStackChanged(),TegakiUI.updateLayersGridVisibility(e.id,t)},setLayerAlpha:function(e,t){e.alpha=t,e.canvas.style.opacity=t},setActiveLayer:function(e){var t,a;e||(e=TegakiLayers.getTopLayerId())?(t=TegakiLayers.getLayerPosById(e))<0||(a=Tegaki.layers[t],Tegaki.activeLayer&&Tegaki.copyContextState(Tegaki.activeLayer.ctx,a.ctx),Tegaki.activeLayer=a,TegakiLayers.selectedLayersClear(),TegakiLayers.selectedLayersAdd(e),TegakiUI.updateLayersGridActive(e),TegakiUI.updateLayerAlphaOpt(),Tegaki.onLayerStackChanged()):Tegaki.activeLayer=null},syncLayerImageData(e,t=null){e.imageData=t?$T.copyImageData(t):e.ctx.getImageData(0,0,Tegaki.baseWidth,Tegaki.baseHeight)},selectedLayersHas:function(e){return Tegaki.selectedLayers.has(+e)},selectedLayersClear:function(){Tegaki.selectedLayers.clear(),TegakiUI.updateLayerAlphaOpt(),TegakiUI.updateLayersGridSelectedClear()},selectedLayersAdd:function(e){Tegaki.selectedLayers.add(+e),TegakiUI.updateLayerAlphaOpt(),TegakiUI.updateLayersGridSelectedSet(e,!0)},selectedLayersRemove:function(e){Tegaki.selectedLayers["delete"](+e),TegakiUI.updateLayerAlphaOpt(),TegakiUI.updateLayersGridSelectedSet(e,!1)},selectedLayersToggle:function(e){TegakiLayers.selectedLayersHas(e)?TegakiLayers.selectedLayersRemove(e):TegakiLayers.selectedLayersAdd(e)}},Tegaki={VERSION:"0.9.3",startTimeStamp:0,bg:null,canvas:null,ctx:null,layers:[],layersCnt:null,canvasCnt:null,ghostBuffer:null,blendBuffer:null,ghostBuffer32:null,blendBuffer32:null,activeLayer:null,layerCounter:0,selectedLayers:new Set,activePointerId:0,activePointerIsPen:!1,isPainting:!1,offsetX:0,offsetY:0,zoomLevel:0,zoomFactor:1,zoomFactorList:[.5,1,2,4,8,16],zoomBaseLevel:1,hasCustomCanvas:!1,TWOPI:2*Math.PI,toolList:[TegakiPencil,TegakiPen,TegakiAirbrush,TegakiBucket,TegakiTone,TegakiPipette,TegakiBlur,TegakiEraser],tools:{},tool:null,colorPaletteId:0,toolColor:"#000000",defaultTool:"pencil",bgColor:"#ffffff",maxSize:64,maxLayers:25,baseWidth:0,baseHeight:0,replayRecorder:null,replayViewer:null,onDoneCb:null,onCancelCb:null,replayMode:!1,saveReplay:!1,open:function(e={}){var t=Tegaki;if(t.bg){if(t.replayMode===!!e.replayMode)return void t.resume();t.destroy()}t.startTimeStamp=Date.now(),e.bgColor&&(t.bgColor=e.bgColor),t.hasCustomCanvas=!1,t.saveReplay=!!e.saveReplay,t.replayMode=!!e.replayMode,t.onDoneCb=e.onDone,t.onCancelCb=e.onCancel,t.baseWidth=e.width||0,t.baseHeight=e.height||0,t.createTools(),t.initKeybinds(),[t.bg,t.canvasCnt,t.layersCnt]=TegakiUI.buildUI(),document.body.appendChild(t.bg),document.body.classList.add("tegaki-backdrop"),t.replayMode?(TegakiUI.setReplayMode(!0),t.replayViewer=new TegakiReplayViewer,e.replayURL&&t.loadReplayFromURL(e.replayURL)):(t.init(),t.setTool(t.defaultTool),t.saveReplay&&(t.replayRecorder=new TegakiReplayRecorder,t.replayRecorder.start()))},init:function(){var e=Tegaki;e.createCanvas(),e.updateLayersCntSize(),e.createBuffers(),e.updatePosOffset(),e.resetLayers(),TegakiCursor.init(e.baseWidth,e.baseHeight),e.bindGlobalEvents(),TegakiUI.updateUndoRedo(0,0),TegakiUI.updateZoomLevel()},initFromReplay:function(){var e,t;t=(e=Tegaki).replayViewer,e.initToolsFromReplay(),e.baseWidth=t.canvasWidth,e.baseHeight=t.canvasHeight,
e.bgColor=$T.RgbToHex(...t.bgColor),e.toolColor=$T.RgbToHex(...t.toolColor)},initToolsFromReplay:function(){var e,t,a,i,s,r,n;t=(e=Tegaki).replayViewer;for(a in e.tools){(i=e.tools[a]).id===t.toolId&&(e.defaultTool=a),s=t.toolMap[i.id],n=["step","size","alpha","flow","tipId"];for(r of n)s[r]!==undefined&&(i[r]=s[r]);n=["sizeDynamicsEnabled","alphaDynamicsEnabled","flowDynamicsEnabled","usePreserveAlpha"];for(r of n)s[r]!==undefined&&(i[r]=!!s[r])}},resetLayers:function(){var e,t;if(Tegaki.layers.length){for(e=0,t=Tegaki.layers.length;e<t;++e)Tegaki.layersCnt.removeChild(Tegaki.layers[e].canvas);Tegaki.layers=[],Tegaki.layerCounter=0,TegakiUI.updateLayersGridClear()}TegakiLayers.addLayer(),TegakiLayers.setActiveLayer(0)},createCanvas:function(){var e,t=Tegaki;(e=$T.el("canvas")).id="tegaki-canvas",e.width=t.baseWidth,e.height=t.baseHeight,t.canvas=e,t.ctx=e.getContext("2d"),t.ctx.fillStyle=t.bgColor,t.ctx.fillRect(0,0,t.baseWidth,t.baseHeight),t.layersCnt.appendChild(e)},createTools:function(){var e,t;for(e of Tegaki.toolList)t=new e,Tegaki.tools[t.name]=t},bindGlobalEvents:function(){var e=Tegaki;if(e.replayMode)$T.on(document,"visibilitychange",Tegaki.onVisibilityChange);else{let t=TegakiCursor.getCanvas();$T.on(t,"pointermove",e.onPointerMove),$T.on(t,"pointerdown",e.onPointerDown),$T.on(t,"pointerout",e.onPointerOut),$T.on(document,"pointerup",e.onPointerUp),$T.on(document,"pointercancel",e.onPointerUp),$T.on(document,"keydown",TegakiKeybinds.resolve),$T.on(window,"beforeunload",Tegaki.onTabClose)}$T.on(e.bg,"contextmenu",e.onDummy),$T.on(window,"resize",e.onWindowResized),$T.on(window,"scroll",e.updatePosOffset)},unBindGlobalEvents:function(){var e=Tegaki;if(e.replayMode)$T.off(document,"visibilitychange",Tegaki.onVisibilityChange);else{let t=TegakiCursor.getCanvas();$T.off(t,"pointermove",e.onPointerMove),$T.off(t,"pointerdown",e.onPointerDown),$T.off(t,"pointerout",e.onPointerOut),$T.off(document,"pointerup",e.onPointerUp),$T.off(document,"pointercancel",e.onPointerUp),$T.off(document,"keydown",TegakiKeybinds.resolve),$T.off(window,"beforeunload",Tegaki.onTabClose)}$T.off(e.bg,"contextmenu",e.onDummy),$T.off(window,"resize",e.onWindowResized),$T.off(window,"scroll",e.updatePosOffset)},createBuffers(){Tegaki.ghostBuffer=new ImageData(Tegaki.baseWidth,Tegaki.baseHeight),Tegaki.blendBuffer=new ImageData(Tegaki.baseWidth,Tegaki.baseHeight),Tegaki.ghostBuffer32=new Uint32Array(Tegaki.ghostBuffer.data.buffer),Tegaki.blendBuffer32=new Uint32Array(Tegaki.blendBuffer.data.buffer)},clearBuffers(){Tegaki.ghostBuffer32.fill(0),Tegaki.blendBuffer32.fill(0)},destroyBuffers(){Tegaki.ghostBuffer=null,Tegaki.blendBuffer=null,Tegaki.ghostBuffer32=null,Tegaki.blendBuffer32=null},disableSmoothing:function(e){e.mozImageSmoothingEnabled=!1,e.webkitImageSmoothingEnabled=!1,e.msImageSmoothingEnabled=!1,e.imageSmoothingEnabled=!1},updateLayersCntSize:function(){var e=Tegaki.layersCnt.style;e.width=Tegaki.baseWidth+"px",e.height=Tegaki.baseHeight+"px"},onTabClose:function(e){e.preventDefault(),e.returnValue=""},onVisibilityChange:function(){Tegaki.replayMode&&("visible"===document.visibilityState?Tegaki.replayViewer.autoPaused&&Tegaki.replayViewer.play():Tegaki.replayViewer.playing&&Tegaki.replayViewer.autoPause())},onWindowResized:function(){Tegaki.updatePosOffset(),TegakiCursor.updateCanvasSize()},initKeybinds:function(){var e,t;if(!Tegaki.replayMode){TegakiKeybinds.bind("ctrl+z",TegakiHistory,"undo","undo","Ctrl+Z"),TegakiKeybinds.bind("ctrl+y",TegakiHistory,"redo","redo","Ctrl+Y"),TegakiKeybinds.bind("+",Tegaki,"setToolSizeUp","toolSize","Numpad +/-"),TegakiKeybinds.bind("-",Tegaki,"setToolSizeDown");for(t in Tegaki.tools)(e=Tegaki.tools[t]).keybind&&TegakiKeybinds.bind(e.keybind,e,"set")}},getPointerPos:function(e,t){return 0===t?0|(e.clientX+window.pageXOffset+Tegaki.canvasCnt.scrollLeft-Tegaki.offsetX)/Tegaki.zoomFactor:0|(e.clientY+window.pageYOffset+Tegaki.canvasCnt.scrollTop-Tegaki.offsetY)/Tegaki.zoomFactor},resume:function(){Tegaki.saveReplay&&Tegaki.replayRecorder.start(),Tegaki.bg.classList.remove("tegaki-hidden"),document.body.classList.add("tegaki-backdrop"),Tegaki.setZoom(0),Tegaki.updateLayersCntSize(),Tegaki.updatePosOffset(),TegakiCursor.updateCanvasSize(),Tegaki.bindGlobalEvents()},hide:function(){Tegaki.saveReplay&&Tegaki.replayRecorder.stop(),Tegaki.bg.classList.add("tegaki-hidden"),document.body.classList.remove("tegaki-backdrop"),Tegaki.unBindGlobalEvents()},destroy:function(){Tegaki.unBindGlobalEvents(),TegakiKeybinds.clear(),TegakiHistory.clear(),Tegaki.bg.parentNode.removeChild(Tegaki.bg),document.body.classList.remove("tegaki-backdrop"),Tegaki.startTimeStamp=0,Tegaki.bg=null,Tegaki.canvasCnt=null,Tegaki.layersCnt=null,Tegaki.canvas=null,Tegaki.ctx=null,Tegaki.layers=[],Tegaki.layerCounter=0,Tegaki.zoomLevel=0,Tegaki.zoomFactor=1,Tegaki.activeLayer=null,Tegaki.tool=null,TegakiCursor.destroy(),Tegaki.replayRecorder=null,Tegaki.replayViewer=null,Tegaki.destroyBuffers()},flatten:function(e){var t,a,i,s;for(e?i=e.canvas:e=(i=$T.el("canvas")).getContext("2d"),i.width=Tegaki.canvas.width,i.height=Tegaki.canvas.height,e.drawImage(Tegaki.canvas,0,0),t=0,s=Tegaki.layers.length;t<s;++t)(a=Tegaki.layers[t]).visible&&(e.globalAlpha=a.alpha,e.drawImage(a.canvas,0,0));return i},onReplayLoaded:function(){TegakiUI.clearMsg(),Tegaki.initFromReplay(),Tegaki.init(),Tegaki.setTool(Tegaki.defaultTool),TegakiUI.updateReplayControls(),TegakiUI.updateReplayTime(!0),TegakiUI.enableReplayControls(!0),Tegaki.replayViewer.play()},onReplayGaplessClick:function(){Tegaki.replayViewer.toggleGapless(),TegakiUI.updateReplayGapless()},onReplayPlayPauseClick:function(){Tegaki.replayViewer.togglePlayPause()},onReplayRewindClick:function(){Tegaki.replayViewer.rewind()},onReplaySlowDownClick:function(){Tegaki.replayViewer.slowDown(),TegakiUI.updateReplaySpeed()},onReplaySpeedUpClick:function(){Tegaki.replayViewer.speedUp(),TegakiUI.updateReplaySpeed()},onReplayTimeChanged:function(){TegakiUI.updateReplayTime()},onReplayPlayPauseChanged:function(){TegakiUI.updateReplayPlayPause()},onReplayReset:function(){Tegaki.initFromReplay(),Tegaki.setTool(Tegaki.defaultTool),Tegaki.resizeCanvas(Tegaki.baseWidth,Tegaki.baseHeight),TegakiUI.updateReplayControls(),TegakiUI.updateReplayTime()},onMainColorClick:function(e){e.preventDefault(),$T.id("tegaki-colorpicker").click()},onPaletteColorClick:function(e){2===e.button?(this.style.backgroundColor=Tegaki.toolColor,this.setAttribute("data-color",Tegaki.toolColor)):0===e.button&&Tegaki.setToolColor(this.getAttribute("data-color"))},onColorPicked:function(){$T.id("tegaki-color").style.backgroundColor=this.value,Tegaki.setToolColor(this.value)},onSwitchPaletteClick:function(e){var t;t=e.target.hasAttribute("data-prev")?Tegaki.colorPaletteId-1:Tegaki.colorPaletteId+1,Tegaki.setColorPalette(t)},setColorPalette:function(e){e<0||e>=TegakiColorPalettes.length||(Tegaki.colorPaletteId=e,TegakiUI.updateColorPalette())},setToolSizeUp:function(){Tegaki.setToolSize(Tegaki.tool.size+1)},setToolSizeDown:function(){Tegaki.setToolSize(Tegaki.tool.size-1)},setToolSize:function(e){e>0&&e<=Tegaki.maxSize&&(Tegaki.tool.setSize(e),Tegaki.updateCursorStatus(),Tegaki.recordEvent(TegakiEventSetToolSize,performance.now(),e),TegakiUI.updateToolSize())},setToolAlpha:function(e){(e=Math.fround(e))>=0&&e<=1&&(Tegaki.tool.setAlpha(e),Tegaki.recordEvent(TegakiEventSetToolAlpha,performance.now(),e),TegakiUI.updateToolAlpha())},setToolFlow:function(e){(e=Math.fround(e))>=0&&e<=1&&(Tegaki.tool.setFlow(e),Tegaki.recordEvent(TegakiEventSetToolFlow,performance.now(),e),TegakiUI.updateToolFlow())},setToolColor:function(e){Tegaki.toolColor=e,$T.id("tegaki-color").style.backgroundColor=e,$T.id("tegaki-colorpicker").value=e,Tegaki.tool.setColor(e),Tegaki.recordEvent(TegakiEventSetColor,performance.now(),Tegaki.tool.rgb)},setToolColorRGB:function(e,t,a){Tegaki.setToolColor($T.RgbToHex(e,t,a))},setTool:function(e){Tegaki.tools[e].set()},setToolById:function(e){var t;for(t in Tegaki.tools)if(Tegaki.tools[t].id===e)return void Tegaki.setTool(t)},setZoom:function(e){var t;(t=e+Tegaki.zoomBaseLevel)>=Tegaki.zoomFactorList.length||t<0||!Tegaki.canvas||(Tegaki.zoomLevel=e,Tegaki.zoomFactor=Tegaki.zoomFactorList[t],TegakiUI.updateZoomLevel(),Tegaki.layersCnt.style.width=Math.ceil(Tegaki.baseWidth*Tegaki.zoomFactor)+"px",Tegaki.layersCnt.style.height=Math.ceil(Tegaki.baseHeight*Tegaki.zoomFactor)+"px",Tegaki.updateCursorStatus(),Tegaki.updatePosOffset())},onZoomChange:function(){this.hasAttribute("data-in")?Tegaki.setZoom(Tegaki.zoomLevel+1):Tegaki.setZoom(Tegaki.zoomLevel-1),TegakiCursor.updateCanvasSize()},onNewClick:function(){var e,t,a,i=Tegaki;(e=prompt(TegakiStrings.promptWidth,i.canvas.width))&&(t=prompt(TegakiStrings.promptHeight,i.canvas.height))&&(t=+t,(e=+e)<1||t<1?TegakiUI.printMsg(TegakiStrings.badDimensions):(a={},i.copyContextState(i.activeLayer.ctx,a),i.resizeCanvas(e,t),i.copyContextState(a,i.activeLayer.ctx),i.setZoom(0),TegakiHistory.clear(),TegakiUI.updateLayerPreviewSize(),i.startTimeStamp=Date.now(),i.saveReplay&&(i.createTools(),i.setTool(i.defaultTool),i.replayRecorder=new TegakiReplayRecorder,i.replayRecorder.start())))},onOpenClick:function(){(!(TegakiHistory.undoStack[0]||TegakiHistory.redoStack[0])&&!Tegaki.saveReplay||confirm(TegakiStrings.confirmChangeCanvas))&&$T.id("tegaki-filepicker").click()},loadReplayFromFile:function(){Tegaki.replayViewer.debugLoadLocal()},loadReplayFromURL:function(e){TegakiUI.printMsg(TegakiStrings.loadingReplay,0),Tegaki.replayViewer.loadFromURL(e)},onExportClick:function(){Tegaki.flatten().toBlob(function(e){var t=$T.el("a");t.className="tegaki-hidden",t.download=$T.generateFilename()+".png",t.href=URL.createObjectURL(e),Tegaki.bg.appendChild(t),t.click(),Tegaki.bg.removeChild(t)},"image/png")},onUndoClick:function(){TegakiHistory.undo()},onRedoClick:function(){TegakiHistory.redo()},onHistoryChange:function(e,t,a=0){TegakiUI.updateUndoRedo(e,t),-1===a?Tegaki.recordEvent(TegakiEventUndo,performance.now()):1===a&&Tegaki.recordEvent(TegakiEventRedo,performance.now())},onDoneClick:function(){Tegaki.hide(),Tegaki.onDoneCb()},onCancelClick:function(){confirm(TegakiStrings.confirmCancel)&&(Tegaki.destroy(),Tegaki.onCancelCb())},onCloseViewerClick:function(){Tegaki.replayViewer.destroy(),Tegaki.destroy()},onToolSizeChange:function(){var e=+this.value;e<1?e=1:e>Tegaki.maxSize&&(e=Tegaki.maxSize),Tegaki.setToolSize(e)},onToolAlphaChange:function(){var e=+this.value;(e/=100)<0?e=0:e>1&&(e=1),Tegaki.setToolAlpha(e)},onToolFlowChange:function(){var e=+this.value;(e/=100)<0?e=0:e>1&&(e=1),Tegaki.setToolFlow(e)},onToolPressureSizeClick:function(){Tegaki.tool.useSizeDynamics&&Tegaki.setToolSizeDynamics(!Tegaki.tool.sizeDynamicsEnabled)},setToolSizeDynamics:function(e){Tegaki.tool.setSizeDynamics(e),TegakiUI.updateToolDynamics(),Tegaki.recordEvent(TegakiEventSetToolSizeDynamics,performance.now(),+e)},onToolPressureAlphaClick:function(){Tegaki.tool.useAlphaDynamics&&Tegaki.setToolAlphaDynamics(!Tegaki.tool.alphaDynamicsEnabled)},setToolAlphaDynamics:function(e){Tegaki.tool.setAlphaDynamics(e),TegakiUI.updateToolDynamics(),Tegaki.recordEvent(TegakiEventSetToolAlphaDynamics,performance.now(),+e)},onToolPressureFlowClick:function(){Tegaki.tool.useFlowDynamics&&Tegaki.setToolFlowDynamics(!Tegaki.tool.flowDynamicsEnabled)},setToolFlowDynamics:function(e){Tegaki.tool.setFlowDynamics(e),TegakiUI.updateToolDynamics(),Tegaki.recordEvent(TegakiEventSetToolFlowDynamics,performance.now(),+e)},onToolPreserveAlphaClick:function(){Tegaki.tool.usePreserveAlpha&&Tegaki.setToolPreserveAlpha(!Tegaki.tool.preserveAlphaEnabled)},setToolPreserveAlpha:function(e){Tegaki.tool.setPreserveAlpha(e),TegakiUI.updateToolPreserveAlpha(),Tegaki.recordEvent(TegakiEventPreserveAlpha,performance.now(),+e)},onToolTipClick:function(e){var t=+e.target.getAttribute("data-id");t!==Tegaki.tool.tipId&&Tegaki.setToolTip(t)},setToolTip:function(e){Tegaki.tool.setTip(e),TegakiUI.updateToolShape(),Tegaki.recordEvent(TegakiEventSetToolTip,performance.now(),e)},onLayerSelectorClick:function(e){var t=+this.getAttribute("data-id");t&&!e.target.classList.contains("tegaki-ui-cb")&&(e.ctrlKey?Tegaki.toggleSelectedLayer(t):Tegaki.setActiveLayer(t))},toggleSelectedLayer:function(e){TegakiLayers.selectedLayersToggle(e),Tegaki.recordEvent(TegakiEventToggleLayerSelection,performance.now(),e)},setActiveLayer:function(e){TegakiLayers.setActiveLayer(e),Tegaki.recordEvent(TegakiEventSetActiveLayer,performance.now(),e)},onLayerAlphaDragStart:function(e){TegakiUI.setupDragLabel(e,Tegaki.onLayerAlphaDragMove)},onLayerAlphaDragMove:function(e){var t;e&&((t=Tegaki.activeLayer.alpha+e/100)<0?t=0:t>1&&(t=1),Tegaki.setSelectedLayersAlpha(t))},onLayerAlphaChange:function(){var e=+this.value;(e/=100)<0?e=0:e>1&&(e=1),Tegaki.setSelectedLayersAlpha(e)},setSelectedLayersAlpha:function(e){var t,a,i;if((e=Math.fround(e))>=0&&e<=1&&Tegaki.selectedLayers.size>0){i=[];for(a of Tegaki.selectedLayers)(t=TegakiLayers.getLayerById(a))&&(i.push([t.id,t.alpha]),TegakiLayers.setLayerAlpha(t,e));TegakiUI.updateLayerAlphaOpt(),TegakiHistory.push(new TegakiHistoryActions.SetLayersAlpha(i,e)),Tegaki.recordEvent(TegakiEventSetSelectedLayersAlpha,performance.now(),e)}},onLayerNameChangeClick:function(){var e,t,a;e=+this.getAttribute("data-id"),(a=TegakiLayers.getLayerById(e))&&(t=prompt(undefined,a.name))&&Tegaki.setLayerName(e,t)},setLayerName:function(e,t){var a,i;t=t.trim().slice(0,25),(i=TegakiLayers.getLayerById(e))&&t&&t!==i.name&&(a=i.name,i.name=t,TegakiUI.updateLayerName(i),TegakiHistory.push(new TegakiHistoryActions.SetLayerName(e,a,t)),Tegaki.recordEvent(TegakiEventHistoryDummy,performance.now()))},onLayerAddClick:function(){Tegaki.addLayer()},addLayer:function(){var e;Tegaki.layers.length>=Tegaki.maxLayers?TegakiUI.printMsg(TegakiStrings.tooManyLayers):(TegakiHistory.push(e=TegakiLayers.addLayer()),TegakiLayers.setActiveLayer(e.aLayerIdAfter),Tegaki.recordEvent(TegakiEventAddLayer,performance.now()))},onLayerDeleteClick:function(){Tegaki.deleteSelectedLayers()},deleteSelectedLayers:function(){var e,t;(t=Tegaki.selectedLayers).size!==Tegaki.layers.length&&(!t.size||Tegaki.layers.length<2||(TegakiHistory.push(e=TegakiLayers.deleteLayers(t)),TegakiLayers.selectedLayersClear(),TegakiLayers.setActiveLayer(e.aLayerIdAfter),Tegaki.recordEvent(TegakiEventDeleteLayers,performance.now())))},onLayerToggleVisibilityClick:function(){Tegaki.toggleLayerVisibility(+this.getAttribute("data-id"))},toggleLayerVisibility:function(e){var t=TegakiLayers.getLayerById(e);TegakiLayers.setLayerVisibility(t,!t.visible),Tegaki.recordEvent(TegakiEventToggleLayerVisibility,performance.now(),e)},onMergeLayersClick:function(){Tegaki.mergeSelectedLayers()},mergeSelectedLayers:function(){var e;Tegaki.selectedLayers.size&&(e=TegakiLayers.mergeLayers(Tegaki.selectedLayers))&&(TegakiHistory.push(e),TegakiLayers.setActiveLayer(e.aLayerIdAfter),Tegaki.recordEvent(TegakiEventMergeLayers,performance.now()))},onMoveLayerClick:function(e){var t,a;Tegaki.selectedLayers.size&&(a=e.target.hasAttribute("data-up"),(t=TegakiLayers.getSelectedEdgeLayerPos(a))<0||(a?t+=2:t>=1&&t--,Tegaki.moveSelectedLayers(t)))},moveSelectedLayers:function(e){TegakiHistory.push(TegakiLayers.moveLayers(Tegaki.selectedLayers,e)),Tegaki.recordEvent(TegakiEventMoveLayers,performance.now(),e)},onToolClick:function(){Tegaki.setTool(this.getAttribute("data-tool"))},onToolChanged:function(e){var t;Tegaki.tool=e,(t=$T.cls("tegaki-tool-active")[0])&&t.classList.remove("tegaki-tool-active"),$T.id("tegaki-tool-btn-"+e.name).classList.add("tegaki-tool-active"),Tegaki.recordEvent(TegakiEventSetTool,performance.now(),Tegaki.tool.id),TegakiUI.onToolChanged(),Tegaki.updateCursorStatus()},onLayerStackChanged:function(){},onOpenFileSelected:function(){var e;this.files&&this.files[0]&&((e=new Image).onload=Tegaki.onOpenImageLoaded,e.onerror=Tegaki.onOpenImageError,e.src=URL.createObjectURL(this.files[0]))},onOpenImageLoaded:function(){var e={},t=Tegaki;t.hasCustomCanvas=!0,t.copyContextState(t.activeLayer.ctx,e),t.resizeCanvas(this.naturalWidth,this.naturalHeight),t.activeLayer.ctx.drawImage(this,0,0),TegakiLayers.syncLayerImageData(t.activeLayer),t.copyContextState(e,t.activeLayer.ctx),t.setZoom(0),TegakiHistory.clear(),TegakiUI.updateLayerPreviewSize(!0),t.startTimeStamp=Date.now(),t.saveReplay&&(t.replayRecorder.stop(),t.replayRecorder=null,t.saveReplay=!1,TegakiUI.setRecordingStatus(!1))},onOpenImageError:function(){TegakiUI.printMsg(TegakiStrings.errorLoadImage)},resizeCanvas:function(e,t){Tegaki.baseWidth=e,Tegaki.baseHeight=t,Tegaki.createBuffers(),Tegaki.canvas.width=e,Tegaki.canvas.height=t,Tegaki.ctx.fillStyle=Tegaki.bgColor,Tegaki.ctx.fillRect(0,0,e,t),Tegaki.activeLayer=null,Tegaki.resetLayers(),Tegaki.updateLayersCntSize(),Tegaki.updatePosOffset(),TegakiCursor.updateCanvasSize()},copyContextState:function(e,t){var a,i,s=["lineCap","lineJoin","strokeStyle","fillStyle","globalAlpha","lineWidth","globalCompositeOperation"];for(a=0;i=s[a];++a)t[i]=e[i]},updateCursorStatus:function(){!Tegaki.tool.noCursor&&Tegaki.tool.size>1?Tegaki.cursor=TegakiCursor.generate(Tegaki.tool.size):(Tegaki.cursor=!1,TegakiCursor.clear())},updatePosOffset:function(){var e=Tegaki.canvas.getBoundingClientRect();Tegaki.offsetX=e.left+window.pageXOffset+Tegaki.canvasCnt.scrollLeft+Tegaki.layersCnt.scrollLeft,Tegaki.offsetY=e.top+window.pageYOffset+Tegaki.canvasCnt.scrollTop+Tegaki.layersCnt.scrollTop},getScrollbarSizes:function(){return[Tegaki.canvasCnt.offsetWidth-Tegaki.canvasCnt.clientWidth,Tegaki.canvasCnt.offsetHeight-Tegaki.canvasCnt.clientHeight]},isScrollbarClick:function(e){var[t,a]=Tegaki.getScrollbarSizes();return t>0&&e.clientX>=Tegaki.canvasCnt.offsetLeft+Tegaki.canvasCnt.clientWidth&&e.clientX<=Tegaki.canvasCnt.offsetLeft+Tegaki.canvasCnt.clientWidth+t||a>0&&e.clientY>=Tegaki.canvasCnt.offsetTop+Tegaki.canvasCnt.clientHeight&&e.clientY<=Tegaki.canvasCnt.offsetTop+Tegaki.canvasCnt.clientHeight+t},onPointerMove:function(e){var t,a,i,s,r,n;if(Tegaki.cursor&&TegakiCursor.render(e.clientX,e.clientY),e.mozInputSource!==undefined){if(Tegaki.activePointerIsPen&&"mouse"===e.pointerType)return}else if(Tegaki.activePointerId!==e.pointerId)return void(Tegaki.activePointerId=e.pointerId);if(Tegaki.isPainting)if(s=Tegaki.tool,Tegaki.activePointerIsPen&&e.getCoalescedEvents){t=e.getCoalescedEvents(),r=e.timeStamp;for(e of t)a=Tegaki.getPointerPos(e,0),i=Tegaki.getPointerPos(e,1),s.enabledDynamics()?(n=TegakiPressure.toShort(e.pressure),TegakiPressure.push(n),Tegaki.recordEvent(TegakiEventDraw,r,a,i,n)):Tegaki.recordEvent(TegakiEventDrawNoP,r,a,i),s.draw(a,i)}else a=Tegaki.getPointerPos(e,0),i=Tegaki.getPointerPos(e,1),n=TegakiPressure.toShort(e.pressure),Tegaki.recordEvent(TegakiEventDraw,e.timeStamp,a,i,n),TegakiPressure.push(n),s.draw(a,i);else a=Tegaki.getPointerPos(e,0),i=Tegaki.getPointerPos(e,1)},onPointerDown:function(e){var t,a,i,s;Tegaki.cursor&&TegakiCursor.render(e.clientX,e.clientY),Tegaki.isScrollbarClick(e)||(Tegaki.activePointerId=e.pointerId,Tegaki.activePointerIsPen="pen"===e.pointerType,null!==Tegaki.activeLayer?TegakiLayers.getActiveLayer().visible?(t=Tegaki.getPointerPos(e,0),a=Tegaki.getPointerPos(e,1),2===e.button||e.altKey?(e.preventDefault(),Tegaki.isPainting=!1,Tegaki.tools.pipette.draw(t,a)):0===e.button&&(e.preventDefault(),(i=Tegaki.tool).enabledDynamics()?(s=TegakiPressure.toShort(e.pressure),TegakiPressure.push(s),Tegaki.recordEvent(TegakiEventDrawStart,e.timeStamp,t,a,s)):Tegaki.recordEvent(TegakiEventDrawStartNoP,e.timeStamp,t,a),Tegaki.isPainting=!0,TegakiHistory.pendingAction=new TegakiHistoryActions.Draw(Tegaki.activeLayer.id),TegakiHistory.pendingAction.addCanvasState(Tegaki.activeLayer.imageData,0),i.start(t,a))):e.target.parentNode===Tegaki.layersCnt&&TegakiUI.printMsg(TegakiStrings.hiddenActiveLayer):e.target.parentNode===Tegaki.layersCnt&&TegakiUI.printMsg(TegakiStrings.noActiveLayer))},onPointerUp:function(e){Tegaki.activePointerId=e.pointerId,Tegaki.activePointerIsPen=!1,Tegaki.isPainting&&(Tegaki.recordEvent(TegakiEventDrawCommit,e.timeStamp),Tegaki.tool.commit(),TegakiUI.updateLayerPreview(Tegaki.activeLayer),TegakiHistory.pendingAction.addCanvasState(Tegaki.activeLayer.imageData,1),TegakiHistory.push(TegakiHistory.pendingAction),Tegaki.isPainting=!1)},onPointerOut:function(){TegakiCursor.clearAll()},onDummy:function(e){e.preventDefault(),e.stopPropagation()},recordEvent(e,...t){Tegaki.replayRecorder&&Tegaki.replayRecorder.push(new e(...t))}},TegakiColorPalettes=[["#ffffff","#000000","#888888","#b47575","#c096c0","#fa9696","#8080ff","#ffb6ff","#e7e58d","#25c7c9","#99cb7b","#e7962d","#f9ddcf","#fcece2"],["#000000","#ffffff","#7f7f7f","#c3c3c3","#880015","#b97a57","#ed1c24","#ffaec9","#ff7f27","#ffc90e","#fff200","#efe4b0","#22b14c","#b5e61d","#00a2e8","#99d9ea","#3f48cc","#7092be","#a349a4","#c8bfe7"],["#000000","#ffffff","#8a8a8a","#cacaca","#fcece2","#f9ddcf","#e0a899","#a05b53","#7a444a","#960018","#c41e3a","#de4537","#ff3300","#ff9800","#ffc107","#ffd700","#ffeb3b","#ffffcc","#f3e5ab","#cddc39","#8bc34a","#4caf50","#3e8948","#355e3b","#3eb489","#f0f8ff","#87ceeb","#6699cc","#007fff","#2d68c4","#364478","#352c4a","#9c27b0","#da70d6","#ff0090","#fa8072","#f19cbb","#c78b95"]],TegakiPressure={pressureNow:0,pressureThen:0,toShort:function(e){return 0|65535*e},get:function(){return this.pressureNow},lerp:function(e){return this.pressureThen*(1-e)+this.pressureNow*e},push:function(e){this.pressureThen=this.pressureNow,this.pressureNow=e/65535},set:function(e){this.pressureThen=this.pressureNow=e/65535}};class TegakiEvent_void{constructor(){this.size=5}pack(e){e.writeUint8(this.type),e.writeUint32(this.timeStamp)}static unpack(e){return new this(e.readUint32())}}class TegakiEvent_c{constructor(){this.size=6}pack(e){e.writeUint8(this.type),e.writeUint32(this.timeStamp),e.writeUint8(this.value)}static unpack(e){return new this(e.readUint32(),e.readUint8())}}class TegakiEventPrelude extends TegakiEvent_void{constructor(e){super(),this.timeStamp=e,this.type=TegakiEvents[this.constructor.name][0]}static unpack(e){return super.unpack(e)}dispatch(){}}class TegakiEventConclusion extends TegakiEvent_void{constructor(e){super(),this.timeStamp=e,this.type=TegakiEvents[this.constructor.name][0]}static unpack(e){return super.unpack(e)}dispatch(){}}class TegakiEventHistoryDummy extends TegakiEvent_void{constructor(e){super(),this.timeStamp=e,this.type=TegakiEvents[this.constructor.name][0]}static unpack(e){return super.unpack(e)}dispatch(){TegakiHistory.push(new TegakiHistoryActions.Dummy)}}class TegakiEventDrawStart{constructor(e,t,a,i){this.timeStamp=e,this.x=t,this.y=a,this.pressure=i,this.type=TegakiEvents[this.constructor.name][0],this.size=11}pack(e){e.writeUint8(this.type),e.writeUint32(this.timeStamp),e.writeInt16(this.x),e.writeInt16(this.y),e.writeUint16(this.pressure)}static unpack(e){var t,a,i,s;return t=e.readUint32(),a=e.readInt16(),i=e.readInt16(),s=e.readUint16(),new TegakiEventDrawStart(t,a,i,s)}dispatch(){TegakiPressure.set(this.pressure),TegakiHistory.pendingAction=new TegakiHistoryActions.Draw(Tegaki.activeLayer.id),TegakiHistory.pendingAction.addCanvasState(Tegaki.activeLayer.imageData,0),Tegaki.tool.start(this.x,this.y)}}class TegakiEventDrawStartNoP{constructor(e,t,a){this.timeStamp=e,this.x=t,this.y=a,this.type=TegakiEvents[this.constructor.name][0],this.size=9}pack(e){e.writeUint8(this.type),e.writeUint32(this.timeStamp),e.writeInt16(this.x),e.writeInt16(this.y)}static unpack(e){var t,a,i;return t=e.readUint32(),a=e.readInt16(),i=e.readInt16(),new TegakiEventDrawStartNoP(t,a,i)}dispatch(){TegakiPressure.set(.5),TegakiHistory.pendingAction=new TegakiHistoryActions.Draw(Tegaki.activeLayer.id),TegakiHistory.pendingAction.addCanvasState(Tegaki.activeLayer.imageData,0),Tegaki.tool.start(this.x,this.y)}}class TegakiEventDraw{constructor(e,t,a,i){this.timeStamp=e,this.x=t,this.y=a,this.pressure=i,this.type=TegakiEvents[this.constructor.name][0],this.size=11}pack(e){e.writeUint8(this.type),e.writeUint32(this.timeStamp),e.writeInt16(this.x),e.writeInt16(this.y),e.writeUint16(this.pressure)}static unpack(e){var t,a,i,s;return t=e.readUint32(),a=e.readInt16(),i=e.readInt16(),s=e.readUint16(),new TegakiEventDraw(t,a,i,s)}dispatch(){TegakiPressure.push(this.pressure),Tegaki.tool.draw(this.x,this.y)}}class TegakiEventDrawNoP{constructor(e,t,a){this.timeStamp=e,this.x=t,this.y=a,this.type=TegakiEvents[this.constructor.name][0],this.size=9}pack(e){e.writeUint8(this.type),e.writeUint32(this.timeStamp),e.writeInt16(this.x),e.writeInt16(this.y)}static unpack(e){var t,a,i;return t=e.readUint32(),a=e.readInt16(),i=e.readInt16(),new TegakiEventDrawNoP(t,a,i)}dispatch(){TegakiPressure.push(.5),Tegaki.tool.draw(this.x,this.y)}}class TegakiEventDrawCommit extends TegakiEvent_void{constructor(e){super(),this.timeStamp=e,this.type=TegakiEvents[this.constructor.name][0]}static unpack(e){return super.unpack(e)}dispatch(){Tegaki.tool.commit(),TegakiUI.updateLayerPreview(Tegaki.activeLayer),TegakiHistory.pendingAction.addCanvasState(Tegaki.activeLayer.imageData,1),TegakiHistory.push(TegakiHistory.pendingAction),Tegaki.isPainting=!1}}class TegakiEventUndo extends TegakiEvent_void{constructor(e){super(),this.timeStamp=e,this.type=TegakiEvents[this.constructor.name][0]}static unpack(e){return super.unpack(e)}dispatch(){TegakiHistory.undo()}}class TegakiEventRedo extends TegakiEvent_void{constructor(e){super(),this.timeStamp=e,this.type=TegakiEvents[this.constructor.name][0]}static unpack(e){return super.unpack(e)}dispatch(){TegakiHistory.redo()}}class TegakiEventSetColor{constructor(e,t){this.timeStamp=e,[this.r,this.g,this.b]=t,this.type=TegakiEvents[this.constructor.name][0],this.size=8,this.coalesce=!0}pack(e){e.writeUint8(this.type),e.writeUint32(this.timeStamp),e.writeUint8(this.r),e.writeUint8(this.g),e.writeUint8(this.b)}static unpack(e){var t,a;return t=e.readUint32(),a=[e.readUint8(),e.readUint8(),e.readUint8()],new TegakiEventSetColor(t,a)}dispatch(){Tegaki.setToolColorRGB(this.r,this.g,this.b)}}class TegakiEventSetTool extends TegakiEvent_c{constructor(e,t){super(),this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0],this.coalesce=!0}dispatch(){Tegaki.setToolById(this.value)}}class TegakiEventSetToolSize extends TegakiEvent_c{constructor(e,t){super(),this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0],this.coalesce=!0}dispatch(){Tegaki.setToolSize(this.value)}}class TegakiEventSetToolAlpha{constructor(e,t){this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0],this.coalesce=!0,this.size=9}pack(e){e.writeUint8(this.type),e.writeUint32(this.timeStamp),e.writeFloat32(this.value)}static unpack(e){return new this(e.readUint32(),e.readFloat32())}dispatch(){Tegaki.setToolAlpha(this.value)}}class TegakiEventSetToolFlow{constructor(e,t){this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0],this.coalesce=!0,this.size=9}pack(e){e.writeUint8(this.type),e.writeUint32(this.timeStamp),e.writeFloat32(this.value)}static unpack(e){return new this(e.readUint32(),e.readFloat32())}dispatch(){Tegaki.setToolFlow(this.value)}}class TegakiEventPreserveAlpha extends TegakiEvent_c{constructor(e,t){super(),this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0],this.coalesce=!0}dispatch(){Tegaki.setToolPreserveAlpha(!!this.value)}}class TegakiEventSetToolSizeDynamics extends TegakiEvent_c{constructor(e,t){super(),this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0],this.coalesce=!0}dispatch(){Tegaki.setToolSizeDynamics(!!this.value)}}class TegakiEventSetToolAlphaDynamics extends TegakiEvent_c{constructor(e,t){super(),this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0],this.coalesce=!0}dispatch(){Tegaki.setToolAlphaDynamics(!!this.value)}}class TegakiEventSetToolFlowDynamics extends TegakiEvent_c{constructor(e,t){super(),this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0],this.coalesce=!0}dispatch(){Tegaki.setToolFlowDynamics(!!this.value)}}class TegakiEventSetToolTip extends TegakiEvent_c{constructor(e,t){super(),this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0],this.coalesce=!0}dispatch(){Tegaki.setToolTip(this.value)}}class TegakiEventAddLayer extends TegakiEvent_void{constructor(e){super(),this.timeStamp=e,this.type=TegakiEvents[this.constructor.name][0]}static unpack(e){return super.unpack(e)}dispatch(){Tegaki.addLayer()}}class TegakiEventDeleteLayers extends TegakiEvent_void{constructor(e){super(),this.timeStamp=e,this.type=TegakiEvents[this.constructor.name][0]}static unpack(e){return super.unpack(e)}dispatch(){Tegaki.deleteSelectedLayers()}}class TegakiEventMoveLayers extends TegakiEvent_c{constructor(e,t){super(),this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0]}dispatch(){Tegaki.moveSelectedLayers(this.value)}}class TegakiEventMergeLayers extends TegakiEvent_void{constructor(e){super(),this.timeStamp=e,this.type=TegakiEvents[this.constructor.name][0]}static unpack(e){return super.unpack(e)}dispatch(){Tegaki.mergeSelectedLayers()}}class TegakiEventToggleLayerVisibility extends TegakiEvent_c{constructor(e,t){super(),this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0]}dispatch(){Tegaki.toggleLayerVisibility(this.value)}}class TegakiEventSetActiveLayer extends TegakiEvent_c{constructor(e,t){super(),this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0]}dispatch(){Tegaki.setActiveLayer(this.value)}}class TegakiEventToggleLayerSelection extends TegakiEvent_c{constructor(e,t){super(),this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0]}dispatch(){Tegaki.toggleSelectedLayer(this.value)}}class TegakiEventSetSelectedLayersAlpha{constructor(e,t){this.timeStamp=e,this.value=t,this.type=TegakiEvents[this.constructor.name][0],this.coalesce=!0,this.size=9}pack(e){e.writeUint8(this.type),e.writeUint32(this.timeStamp),e.writeFloat32(this.value)}static unpack(e){return new this(e.readUint32(),e.readFloat32())}dispatch(){Tegaki.setSelectedLayersAlpha(this.value)}}const TegakiEvents=Object.freeze({TegakiEventPrelude:[0,TegakiEventPrelude],TegakiEventDrawStart:[1,TegakiEventDrawStart],TegakiEventDraw:[2,TegakiEventDraw],TegakiEventDrawCommit:[3,TegakiEventDrawCommit],TegakiEventUndo:[4,TegakiEventUndo],TegakiEventRedo:[5,TegakiEventRedo],TegakiEventSetColor:[6,TegakiEventSetColor],TegakiEventDrawStartNoP:[7,TegakiEventDrawStartNoP],TegakiEventDrawNoP:[8,TegakiEventDrawNoP],TegakiEventSetTool:[10,TegakiEventSetTool],TegakiEventSetToolSize:[11,TegakiEventSetToolSize],TegakiEventSetToolAlpha:[12,TegakiEventSetToolAlpha],TegakiEventSetToolSizeDynamics:[13,TegakiEventSetToolSizeDynamics],TegakiEventSetToolAlphaDynamics:[14,TegakiEventSetToolAlphaDynamics],TegakiEventSetToolTip:[15,TegakiEventSetToolTip],TegakiEventPreserveAlpha:[16,TegakiEventPreserveAlpha],TegakiEventSetToolFlowDynamics:[17,TegakiEventSetToolFlowDynamics],TegakiEventSetToolFlow:[18,TegakiEventSetToolFlow],TegakiEventAddLayer:[20,TegakiEventAddLayer],TegakiEventDeleteLayers:[21,TegakiEventDeleteLayers],TegakiEventMoveLayers:[22,TegakiEventMoveLayers],TegakiEventMergeLayers:[23,TegakiEventMergeLayers],TegakiEventToggleLayerVisibility:[24,TegakiEventToggleLayerVisibility],TegakiEventSetActiveLayer:[25,TegakiEventSetActiveLayer],TegakiEventToggleLayerSelection:[26,TegakiEventToggleLayerSelection],TegakiEventSetSelectedLayersAlpha:[27,TegakiEventSetSelectedLayersAlpha],TegakiEventHistoryDummy:[254,TegakiEventHistoryDummy],TegakiEventConclusion:[255,TegakiEventConclusion]});class TegakiReplayRecorder{constructor(){this.formatVersion=1,this.compressed=!0,this.tegakiVersion=Tegaki.VERSION.split(".").map(e=>+e),this.canvasWidth=Tegaki.baseWidth,this.canvasHeight=Tegaki.baseHeight,this.bgColor=$T.hexToRgb(Tegaki.bgColor),this.toolColor=$T.hexToRgb(Tegaki.toolColor),this.toolId=Tegaki.tools[Tegaki.defaultTool].id,this.toolList=this.buildToolList(Tegaki.tools),this.startTimeStamp=0,this.endTimeStamp=0,this.recording=!1,this.events=[],this.mimeType="application/octet-stream"}buildToolList(e){var t,a,i;i=[];for(t in e)a=e[t],i.push({id:a.id,size:a.size,alpha:a.alpha,flow:a.flow,step:a.step,sizeDynamicsEnabled:+a.sizeDynamicsEnabled,alphaDynamicsEnabled:+a.alphaDynamicsEnabled,flowDynamicsEnabled:+a.flowDynamicsEnabled,usePreserveAlpha:+a.usePreserveAlpha,tipId:a.tipId});return i}start(){this.recording||(this.endTimeStamp>0&&(this.events.pop(),this.endTimeStamp=0),0===this.startTimeStamp&&(this.events.push(new TegakiEventPrelude(performance.now())),this.startTimeStamp=Date.now()),this.recording=!0)}stop(){
0!==this.startTimeStamp&&this.recording&&(this.events.push(new TegakiEventConclusion(performance.now())),this.endTimeStamp=Date.now(),this.recording=!1)}push(e){this.recording&&(e.coalesce&&this.events[this.events.length-1].type===e.type?this.events[this.events.length-1]=e:this.events.push(e))}getEventStackSize(){var e,t;t=4;for(e of this.events)t+=e.size;return t}getHeaderSize(){return 12}getMetaSize(){return 21}getToolSize(){return 19}getToolListSize(){return 2+this.toolList.length*this.getToolSize()}writeToolList(e){var t,a,i;i=[["id","Uint8"],["size","Uint8"],["alpha","Float32"],["step","Float32"],["sizeDynamicsEnabled","Uint8"],["alphaDynamicsEnabled","Uint8"],["usePreserveAlpha","Uint8"],["tipId","Int8"],["flow","Float32"],["flowDynamicsEnabled","Uint8"]],e.writeUint8(this.toolList.length),e.writeUint8(this.getToolSize());for(t of this.toolList)for(a of i)e["write"+a[1]](t[a[0]])}writeMeta(e){e.writeUint16(this.getMetaSize()),e.writeUint32(Math.ceil(this.startTimeStamp/1e3)),e.writeUint32(Math.ceil(this.endTimeStamp/1e3)),e.writeUint16(this.canvasWidth),e.writeUint16(this.canvasHeight),e.writeUint8(this.bgColor[0]),e.writeUint8(this.bgColor[1]),e.writeUint8(this.bgColor[2]),e.writeUint8(this.toolColor[0]),e.writeUint8(this.toolColor[1]),e.writeUint8(this.toolColor[2]),e.writeUint8(this.toolId)}writeEventStack(e){var t;e.writeUint32(this.events.length);for(t of this.events)t.pack(e)}writeHeader(e,t){e.writeUint8(84),e.writeUint8(71),e.writeUint8(75),e.writeUint8(+this.compressed),e.writeUint32(t),e.writeUint8(this.tegakiVersion[0]),e.writeUint8(this.tegakiVersion[1]),e.writeUint8(this.tegakiVersion[2]),e.writeUint8(this.formatVersion)}compressData(e){return UZIP.deflateRaw(new Uint8Array(e.buf),{level:9})}toUint8Array(){var e,t,a,i,s,r;return this.startTimeStamp&&this.endTimeStamp?(e=this.getHeaderSize(),t=this.getMetaSize()+this.getToolListSize()+this.getEventStackSize(),a=new ArrayBuffer(t),i=new TegakiBinWriter(a),this.writeMeta(i),this.writeToolList(i),this.writeEventStack(i),s=this.compressData(i),i=new TegakiBinWriter(new ArrayBuffer(e+s.length)),this.writeHeader(i,t),(r=new Uint8Array(i.buf)).set(s,e),r):null}toBlob(){var e=this.toUint8Array();return e?new Blob([e.buffer],{type:this.mimeType}):null}}class TegakiReplayViewer{constructor(){this.formatVersion=1,this.compressed=!0,this.tegakiVersion=[0,0,0],this.dataSize=0,this.canvasWidth=0,this.canvasHeight=0,this.bgColor=[0,0,0],this.toolColor=[0,0,0],this.toolId=1,this.toolMap={},this.startTimeStamp=0,this.endTimeStamp=0,this.loaded=!1,this.playing=!1,this.gapless=!0,this.autoPaused=!1,this.destroyed=!1,this.speedIndex=1,this.speedList=[.5,1,2,5,10,25],this.speed=this.speedList[this.speedIndex],this.maxEventsPerFrame=50,this.maxEventCount=864e4,this.events=[],this.preludePos=0,this.currentPos=0,this.conclusionPos=0,this.duration=0,this.playTimeStart=0,this.playTimeCurrent=0,this.eventIndex=0,this.maxCanvasWH=8192,this.maxGapTime=3e3,this.uiAccTime=0,this.onFrameThis=this.onFrame.bind(this)}destroy(){this.destroyed=!0,this.pause(),this.events=null}speedUp(){this.speedIndex+1<this.speedList.length&&(this.speed=this.speedList[++this.speedIndex])}slowDown(){this.speedIndex-1>=0&&(this.speed=this.speedList[--this.speedIndex])}toggleGapless(){this.gapless=!this.gapless}getCurrentPos(){return this.currentPos}getDuration(){return this.duration}loadFromURL(e){fetch(e).then(e=>this.onResponseReady(e))["catch"](e=>this.onLoadError(e))}onResponseReady(e){e.ok?e.arrayBuffer().then(e=>this.onResponseBodyReady(e))["catch"](e=>this.onLoadError(e)):this.onLoadError(e.statusText)}onResponseBodyReady(e){this.loadFromBuffer(e),Tegaki.onReplayLoaded()}onLoadError(e){TegakiUI.printMsg(TegakiStrings.errorLoadReplay+e,0)}autoPause(){this.autoPaused=!0,this.pause()}pause(e){window.cancelAnimationFrame(this.onFrameThis),this.playing=!1,e&&(this.currentPos=0,this.eventIndex=0),Tegaki.onReplayTimeChanged(),Tegaki.onReplayPlayPauseChanged()}rewind(){this.autoPaused=!1,this.pause(!0),Tegaki.onReplayReset()}play(){this.playTimeStart=performance.now(),this.playTimeCurrent=this.playTimeStart,this.playing=!0,this.autoPaused=!1,this.uiAccTime=0,Tegaki.onReplayPlayPauseChanged(),window.requestAnimationFrame(this.onFrameThis)}togglePlayPause(){this.playing?this.pause():this.play()}onFrame(e){var t=e-this.playTimeCurrent;this.playing&&(this.playTimeCurrent=e,this.step(t),this.uiAccTime+=t,this.uiAccTime>1e3&&(Tegaki.onReplayTimeChanged(),this.uiAccTime=0),this.currentPos<this.duration?window.requestAnimationFrame(this.onFrameThis):this.pause())}step(e){var t,a,i;for(this.currentPos+=e*this.speed,a=this.currentPos+this.preludePos,this.gapless&&this.eventIndex<this.events.length&&(t=this.events[this.eventIndex]).timeStamp-a>this.maxGapTime&&(this.currentPos=t.timeStamp-this.preludePos,a=t.timeStamp),i=0;this.eventIndex<this.events.length&&(t=this.events[this.eventIndex]).timeStamp<=a;){if(i>=this.maxEventsPerFrame){this.currentPos=t.timeStamp-this.preludePos;break}t.dispatch(),++this.eventIndex,++i}}getEventIdMap(){var e,t,a;e={};for(t in TegakiEvents)e[(a=TegakiEvents[t])[0]]=a[1];return e}readToolMap(e){var t,a,i,s,r,n,o;for(this.toolMap={},n=[["id","Uint8"],["size","Uint8"],["alpha","Float32"],["step","Float32"],["sizeDynamicsEnabled","Uint8"],["alphaDynamicsEnabled","Uint8"],["usePreserveAlpha","Uint8"],["tipId","Int8"],["flow","Float32"],["flowDynamicsEnabled","Uint8"]],a=e.readUint8(),i=e.readUint8(),t=0;t<a;++t){o=e.pos+i,s={};for(r of n){if(e.pos>=o)break;s[r[0]]=e["read"+r[1]]()}this.toolMap[s.id]=s,e.pos=o}}readHeader(e){if("TGK"!==String.fromCharCode(e.readUint8(),e.readUint8(),e.readUint8()))throw"invalid header";this.compressed=1===e.readUint8(),this.dataSize=e.readUint32(),this.tegakiVersion[0]=e.readUint8(),this.tegakiVersion[1]=e.readUint8(),this.tegakiVersion[2]=e.readUint8(),this.formatVersion=e.readUint8()}decompressData(e){return UZIP.inflateRaw(new Uint8Array(e.buf,e.pos),new Uint8Array(this.dataSize))}readMeta(e){var t,a;if(a=e.readUint16(),t=e.pos+a-2,this.startTimeStamp=1e3*e.readUint32(),this.endTimeStamp=1e3*e.readUint32(),this.canvasWidth=e.readUint16(),this.canvasHeight=e.readUint16(),this.canvasWidth>this.maxCanvasWH||this.canvasHeight>this.maxCanvasWH)throw"canvas too large";this.bgColor[0]=e.readUint8(),this.bgColor[1]=e.readUint8(),this.bgColor[2]=e.readUint8(),this.toolColor[0]=e.readUint8(),this.toolColor[1]=e.readUint8(),this.toolColor[2]=e.readUint8(),this.toolId=e.readUint8(),e.pos=t}readEventStack(e){var t,a,i,s,r;if(r=this.getEventIdMap(),(a=e.readUint32())<1||a>this.maxEventCount)throw"invalid event count";for(t=0;t<a;++t){if(!(i=r[e.readUint8()]))throw"invalid event id";s=i.unpack(e),this.events.push(s)}if(this.events[0].type!==TegakiEvents.TegakiEventPrelude[0])throw"invalid prelude";if(this.events[a-1].type!==TegakiEvents.TegakiEventConclusion[0])throw"invalid conclusion";if(this.preludePos=this.events[0].timeStamp,this.conclusionPos=this.events[a-1].timeStamp,this.duration=this.conclusionPos-this.preludePos,this.duration<=0)throw"invalid duration"}loadFromBuffer(e){var t,a;return!this.destroyed&&!this.loaded&&(t=new TegakiBinReader(e),this.readHeader(t),a=this.decompressData(t),t=new TegakiBinReader(a.buffer),this.readMeta(t),this.readToolMap(t),this.readEventStack(t),this.loaded=!0,!0)}}var TegakiUI={draggedNode:null,draggedLabelLastX:0,draggedLabelFn:null,statusTimeout:0,layerPreviewCtxCache:new WeakMap,getLayerPreviewSize:function(){return $T.calcThumbSize(Tegaki.baseWidth,Tegaki.baseHeight,24)},setupDragLabel:function(e,t){TegakiUI.draggedLabelFn=t,TegakiUI.draggedLabelLastX=e.clientX,$T.on(document,"pointermove",TegakiUI.processDragLabel),$T.on(document,"pointerup",TegakiUI.clearDragLabel)},processDragLabel:function(e){TegakiUI.draggedLabelFn.call(Tegaki,e.clientX-TegakiUI.draggedLabelLastX),TegakiUI.draggedLabelLastX=e.clientX},clearDragLabel:function(){$T.off(document,"pointermove",TegakiUI.processDragLabel),$T.off(document,"pointerup",TegakiUI.clearDragLabel)},printMsg:function(e,t=5e3){TegakiUI.clearMsg(),$T.id("tegaki-status-output").textContent=e,t>0&&(TegakiUI.statusTimeout=setTimeout(TegakiUI.clearMsg,5e3))},clearMsg:function(){TegakiUI.statusTimeout&&(clearTimeout(TegakiUI.statusTimeout),TegakiUI.statusTimeout=0),$T.id("tegaki-status-output").textContent=""},buildUI:function(){var e,t,a,i,s,r;return(e=$T.el("div")).id="tegaki",(a=$T.el("div")).id="tegaki-menu-cnt",Tegaki.replayMode?(a.appendChild(TegakiUI.buildViewerMenuBar()),a.appendChild(TegakiUI.buildReplayControls())):a.appendChild(TegakiUI.buildMenuBar()),a.appendChild(TegakiUI.buildToolModeBar()),e.appendChild(a),e.appendChild(TegakiUI.buildDummyFilePicker()),(t=$T.el("div")).id="tegaki-tools-cnt",t.appendChild(TegakiUI.buildToolsMenu()),e.appendChild(t),[r,s]=TegakiUI.buildCanvasCnt(),e.appendChild(r),(i=$T.el("div")).id="tegaki-ctrl-cnt",i.appendChild(TegakiUI.buildZoomCtrlGroup()),i.appendChild(TegakiUI.buildColorCtrlGroup(Tegaki.toolColor)),i.appendChild(TegakiUI.buildSizeCtrlGroup()),i.appendChild(TegakiUI.buildAlphaCtrlGroup()),i.appendChild(TegakiUI.buildFlowCtrlGroup()),i.appendChild(TegakiUI.buildLayersCtrlGroup()),e.appendChild(i),e.appendChild(TegakiUI.buildStatusCnt()),[e,r,s]},buildDummyFilePicker:function(){var e=$T.el("input");return e.type="file",e.id="tegaki-filepicker",e.className="tegaki-hidden",e.accept="image/png, image/jpeg",$T.on(e,"change",Tegaki.onOpenFileSelected),e},buildMenuBar:function(){var e,t;return(e=$T.el("div")).id="tegaki-menu-bar",(t=$T.el("span")).className="tegaki-mb-btn",t.textContent=TegakiStrings.newCanvas,$T.on(t,"click",Tegaki.onNewClick),e.appendChild(t),(t=$T.el("span")).className="tegaki-mb-btn",t.textContent=TegakiStrings.open,$T.on(t,"click",Tegaki.onOpenClick),e.appendChild(t),(t=$T.el("span")).className="tegaki-mb-btn",t.textContent=TegakiStrings["export"],$T.on(t,"click",Tegaki.onExportClick),e.appendChild(t),(t=$T.el("span")).id="tegaki-undo-btn",t.className="tegaki-mb-btn",t.textContent=TegakiStrings.undo,t.title=TegakiKeybinds.getCaption("undo"),$T.on(t,"click",Tegaki.onUndoClick),e.appendChild(t),(t=$T.el("span")).id="tegaki-redo-btn",t.className="tegaki-mb-btn",t.textContent=TegakiStrings.redo,t.title=TegakiKeybinds.getCaption("redo"),$T.on(t,"click",Tegaki.onRedoClick),e.appendChild(t),(t=$T.el("span")).className="tegaki-mb-btn",t.textContent=TegakiStrings.close,$T.on(t,"click",Tegaki.onCancelClick),e.appendChild(t),(t=$T.el("span")).id="tegaki-finish-btn",t.className="tegaki-mb-btn",t.textContent=TegakiStrings.finish,$T.on(t,"click",Tegaki.onDoneClick),e.appendChild(t),e},buildViewerMenuBar:function(){var e,t;return(e=$T.el("div")).id="tegaki-menu-bar",(t=$T.el("span")).id="tegaki-finish-btn",t.className="tegaki-mb-btn",t.textContent=TegakiStrings.close,$T.on(t,"click",Tegaki.onCloseViewerClick),e.appendChild(t),e},buildToolModeBar:function(){var e,t,a,i;return(e=$T.el("div")).id="tegaki-toolmode-bar",Tegaki.tool||e.classList.add("tegaki-hidden"),(t=$T.el("span")).id="tegaki-tool-mode-dynamics",t.className="tegaki-toolmode-grp",(a=$T.el("span")).className="tegaki-toolmode-lbl",a.textContent=TegakiStrings.pressure,t.appendChild(a),(a=$T.el("span")).id="tegaki-tool-mode-dynamics-ctrl",a.className="tegaki-toolmode-ctrl",(i=$T.el("span")).id="tegaki-tool-mode-dynamics-size",i.className="tegaki-sw-btn",i.textContent=TegakiStrings.size,$T.on(i,"mousedown",Tegaki.onToolPressureSizeClick),a.appendChild(i),(i=$T.el("span")).id="tegaki-tool-mode-dynamics-alpha",i.className="tegaki-sw-btn",i.textContent=TegakiStrings.alpha,$T.on(i,"mousedown",Tegaki.onToolPressureAlphaClick),a.appendChild(i),(i=$T.el("span")).id="tegaki-tool-mode-dynamics-flow",i.className="tegaki-sw-btn",i.textContent=TegakiStrings.flow,$T.on(i,"mousedown",Tegaki.onToolPressureFlowClick),a.appendChild(i),t.appendChild(a),e.appendChild(t),(t=$T.el("span")).id="tegaki-tool-mode-mask",t.className="tegaki-toolmode-grp",(a=$T.el("span")).id="tegaki-toolmode-ctrl-tip",a.className="tegaki-toolmode-ctrl",(i=$T.el("span")).id="tegaki-tool-mode-mask-alpha",i.className="tegaki-sw-btn",i.textContent=TegakiStrings.preserveAlpha,$T.on(i,"mousedown",Tegaki.onToolPreserveAlphaClick),a.appendChild(i),t.appendChild(a),e.appendChild(t),(t=$T.el("span")).id="tegaki-tool-mode-tip",t.className="tegaki-toolmode-grp",(a=$T.el("span")).className="tegaki-toolmode-lbl",a.textContent=TegakiStrings.tip,t.appendChild(a),(a=$T.el("span")).id="tegaki-tool-mode-tip-ctrl",a.className="tegaki-toolmode-ctrl",t.appendChild(a),e.appendChild(t),e},buildToolsMenu:function(){var e,t,a,i;(e=$T.el("div")).id="tegaki-tools-grid";for(i in Tegaki.tools)(t=$T.el("span")).setAttribute("data-tool",i),a=TegakiStrings[i],Tegaki.tools[i].keybind&&(a+=" ("+Tegaki.tools[i].keybind.toUpperCase()+")"),t.setAttribute("title",a),t.id="tegaki-tool-btn-"+i,t.className="tegaki-tool-btn tegaki-icon tegaki-"+i,$T.on(t,"click",Tegaki.onToolClick),e.appendChild(t);return e},buildCanvasCnt:function(){var e,t,a;return(e=$T.el("div")).id="tegaki-canvas-cnt",(t=$T.el("div")).id="tegaki-layers-wrap",(a=$T.el("div")).id="tegaki-layers",t.appendChild(a),e.appendChild(t),[e,a]},buildCtrlGroup:function(e,t){var a,i;return(a=$T.el("div")).className="tegaki-ctrlgrp",e&&(a.id="tegaki-ctrlgrp-"+e),t!==undefined&&((i=$T.el("div")).className="tegaki-ctrlgrp-title",i.textContent=t,a.appendChild(i)),a},buildLayersCtrlGroup:function(){var e,t,a,i;return t=this.buildCtrlGroup("layers",TegakiStrings.layers),(a=$T.el("div")).id="tegaki-layers-opts",(i=$T.el("div")).id="tegaki-layer-alpha-cell",(e=$T.el("span")).className="tegaki-label-xs tegaki-lbl-c tegaki-drag-lbl",e.textContent=TegakiStrings.alpha,$T.on(e,"pointerdown",Tegaki.onLayerAlphaDragStart),i.appendChild(e),(e=$T.el("input")).id="tegaki-layer-alpha-opt",e.className="tegaki-stealth-input tegaki-range-lbl-xs",e.setAttribute("maxlength",3),$T.on(e,"input",Tegaki.onLayerAlphaChange),i.appendChild(e),a.appendChild(i),t.appendChild(a),(e=$T.el("div")).id="tegaki-layers-grid",t.appendChild(e),(a=$T.el("div")).id="tegaki-layers-ctrl",(e=$T.el("span")).title=TegakiStrings.addLayer,e.className="tegaki-ui-btn tegaki-icon tegaki-plus",$T.on(e,"click",Tegaki.onLayerAddClick),a.appendChild(e),(e=$T.el("span")).title=TegakiStrings.delLayers,e.className="tegaki-ui-btn tegaki-icon tegaki-minus",$T.on(e,"click",Tegaki.onLayerDeleteClick),a.appendChild(e),(e=$T.el("span")).id="tegaki-layer-merge",e.title=TegakiStrings.mergeLayers,e.className="tegaki-ui-btn tegaki-icon tegaki-level-down",$T.on(e,"click",Tegaki.onMergeLayersClick),a.appendChild(e),(e=$T.el("span")).id="tegaki-layer-up",e.title=TegakiStrings.moveLayerUp,e.setAttribute("data-up","1"),e.className="tegaki-ui-btn tegaki-icon tegaki-up-open",$T.on(e,"click",Tegaki.onMoveLayerClick),a.appendChild(e),(e=$T.el("span")).id="tegaki-layer-down",e.title=TegakiStrings.moveLayerDown,e.className="tegaki-ui-btn tegaki-icon tegaki-down-open",$T.on(e,"click",Tegaki.onMoveLayerClick),a.appendChild(e),t.appendChild(a),t},buildSizeCtrlGroup:function(){var e,t,a;return t=this.buildCtrlGroup("size",TegakiStrings.size),(a=$T.el("div")).className="tegaki-ctrlrow",(e=$T.el("input")).id="tegaki-size",e.className="tegaki-ctrl-range",e.min=1,e.max=Tegaki.maxSize,e.type="range",e.title=TegakiKeybinds.getCaption("toolSize"),$T.on(e,"input",Tegaki.onToolSizeChange),a.appendChild(e),(e=$T.el("input")).id="tegaki-size-lbl",e.setAttribute("maxlength",3),e.className="tegaki-stealth-input tegaki-range-lbl",$T.on(e,"input",Tegaki.onToolSizeChange),a.appendChild(e),t.appendChild(a),t},buildAlphaCtrlGroup:function(){var e,t,a;return t=this.buildCtrlGroup("alpha",TegakiStrings.alpha),(a=$T.el("div")).className="tegaki-ctrlrow",(e=$T.el("input")).id="tegaki-alpha",e.className="tegaki-ctrl-range",e.min=0,e.max=100,e.step=1,e.type="range",$T.on(e,"input",Tegaki.onToolAlphaChange),a.appendChild(e),(e=$T.el("input")).id="tegaki-alpha-lbl",e.setAttribute("maxlength",3),e.className="tegaki-stealth-input tegaki-range-lbl",$T.on(e,"input",Tegaki.onToolAlphaChange),a.appendChild(e),t.appendChild(a),t},buildFlowCtrlGroup:function(){var e,t,a;return t=this.buildCtrlGroup("flow",TegakiStrings.flow),(a=$T.el("div")).className="tegaki-ctrlrow",(e=$T.el("input")).id="tegaki-flow",e.className="tegaki-ctrl-range",e.min=0,e.max=100,e.step=1,e.type="range",$T.on(e,"input",Tegaki.onToolFlowChange),a.appendChild(e),(e=$T.el("input")).id="tegaki-flow-lbl",e.setAttribute("maxlength",3),e.className="tegaki-stealth-input tegaki-range-lbl",$T.on(e,"input",Tegaki.onToolFlowChange),a.appendChild(e),t.appendChild(a),t},buildZoomCtrlGroup:function(){var e,t,a;return a=this.buildCtrlGroup("zoom",TegakiStrings.zoom),(t=$T.el("div")).className="tegaki-ui-btn tegaki-icon tegaki-plus",t.id="tegaki-zoomin-btn",t.setAttribute("data-in",1),$T.on(t,"click",Tegaki.onZoomChange),a.appendChild(t),(t=$T.el("div")).className="tegaki-ui-btn tegaki-icon tegaki-minus",t.id="tegaki-zoomout-btn",t.setAttribute("data-out",1),$T.on(t,"click",Tegaki.onZoomChange),a.appendChild(t),(e=$T.el("div")).id="tegaki-zoom-lbl",a.appendChild(e),a},buildColorCtrlGroup:function(e){var t,a,i,s,r,n,o,l,g;for(n=/ Edge\//i.test(window.navigator.userAgent),s=this.buildCtrlGroup("color",TegakiStrings.color),(a=$T.el("div")).id="tegaki-color-ctrl",(t=$T.el("div")).id="tegaki-color",n&&t.classList.add("tegaki-hidden"),t.style.backgroundColor=e,$T.on(t,"mousedown",Tegaki.onMainColorClick),a.appendChild(t),(t=$T.el("div")).id="tegaki-palette-switcher",(i=$T.el("span")).id="tegaki-palette-prev-btn",i.title=TegakiStrings.switchPalette,i.setAttribute("data-prev","1"),i.className="tegaki-ui-btn tegaki-icon tegaki-left-open tegaki-disabled",$T.on(i,"click",Tegaki.onSwitchPaletteClick),t.appendChild(i),(i=$T.el("span")).id="tegaki-palette-next-btn",i.title=TegakiStrings.switchPalette,i.className="tegaki-ui-btn tegaki-icon tegaki-right-open",$T.on(i,"click",Tegaki.onSwitchPaletteClick),t.appendChild(i),a.appendChild(t),s.appendChild(a),(a=$T.el("div")).id="tegaki-color-grids",o=0;o<TegakiColorPalettes.length;++o){(t=$T.el("div")).setAttribute("data-id",o),g="tegaki-color-grid",(l=TegakiColorPalettes[o]).length<=18?g+=" tegaki-color-grid-20":g+=" tegaki-color-grid-15",o>0&&(g+=" tegaki-hidden"),t.className=g;for(r of l)(i=$T.el("div")).title=TegakiStrings.paletteSlotReplace,i.className="tegaki-color-btn",i.setAttribute("data-color",r),i.style.backgroundColor=r,$T.on(i,"mousedown",Tegaki.onPaletteColorClick),t.appendChild(i);a.appendChild(t)}return s.appendChild(a),(t=$T.el("input")).id="tegaki-colorpicker",!n&&t.classList.add("tegaki-invis"),t.value=r,t.type="color",$T.on(t,"change",Tegaki.onColorPicked),s.appendChild(t),s},buildStatusCnt:function(){var e,t;return(e=$T.el("div")).id="tegaki-status-cnt",Tegaki.saveReplay&&((t=$T.el("div")).id="tegaki-status-replay",t.textContent="\u2b24",t.setAttribute("title",TegakiStrings.recordingEnabled),e.appendChild(t)),(t=$T.el("div")).id="tegaki-status-output",e.appendChild(t),(t=$T.el("div")).id="tegaki-status-version",t.textContent="tegaki.js v"+Tegaki.VERSION,e.appendChild(t),e},buildReplayControls:function(){var e,t,a;return(e=$T.el("div")).id="tegaki-replay-controls",e.className="tegaki-hidden",(t=$T.el("span")).id="tegaki-replay-gapless-btn",t.className="tegaki-ui-cb-w",$T.on(t,"click",Tegaki.onReplayGaplessClick),(a=$T.el("span")).id="tegaki-replay-gapless-cb",a.className="tegaki-ui-cb",t.appendChild(a),(a=$T.el("span")).className="tegaki-menu-lbl",a.textContent=TegakiStrings.gapless,t.appendChild(a),e.appendChild(t),(t=$T.el("span")).id="tegaki-replay-play-btn",t.className="tegaki-ui-btn tegaki-icon tegaki-play",t.setAttribute("title",TegakiStrings.play),$T.on(t,"click",Tegaki.onReplayPlayPauseClick),e.appendChild(t),(t=$T.el("span")).className="tegaki-ui-btn tegaki-icon tegaki-to-start",t.setAttribute("title",TegakiStrings.rewind),$T.on(t,"click",Tegaki.onReplayRewindClick),e.appendChild(t),(t=$T.el("span")).id="tegaki-replay-slower-btn",t.className="tegaki-ui-btn tegaki-icon tegaki-fast-bw",t.setAttribute("title",TegakiStrings.slower),$T.on(t,"click",Tegaki.onReplaySlowDownClick),e.appendChild(t),(a=$T.el("span")).id="tegaki-replay-speed-lbl",a.className="tegaki-menu-lbl",a.textContent="1.0",e.appendChild(a),(t=$T.el("span")).id="tegaki-replay-faster-btn",t.className="tegaki-ui-btn tegaki-icon tegaki-fast-fw",t.setAttribute("title",TegakiStrings.faster),$T.on(t,"click",Tegaki.onReplaySpeedUpClick),e.appendChild(t),(a=$T.el("span")).id="tegaki-replay-now-lbl",a.className="tegaki-menu-lbl",a.textContent="00:00",e.appendChild(a),(a=$T.el("span")).id="tegaki-replay-end-lbl",a.className="tegaki-menu-lbl",a.textContent="00:00",e.appendChild(a),e},buildLayerGridCell:function(e){var t,a,i;return(t=$T.el("div")).id="tegaki-layers-cell-"+e.id,t.className="tegaki-layers-cell",t.setAttribute("data-id",e.id),t.draggable=!0,t.setAttribute("data-id",e.id),$T.on(t,"pointerdown",TegakiUI.onLayerSelectorPtrDown),$T.on(t,"pointerup",Tegaki.onLayerSelectorClick),$T.on(t,"dragstart",TegakiUI.onLayerDragStart),$T.on(t,"dragover",TegakiUI.onLayerDragOver),$T.on(t,"drop",TegakiUI.onLayerDragDrop),$T.on(t,"dragend",TegakiUI.onLayerDragEnd),$T.on(t,"dragleave",TegakiUI.onLayerDragLeave),$T.on(t,"dragexit",TegakiUI.onLayerDragLeave),(i=$T.el("div")).className="tegaki-layers-cell-v",(a=$T.el("span")).id="tegaki-layers-cb-v-"+e.id,a.className="tegaki-ui-cb",a.setAttribute("data-id",e.id),a.title=TegakiStrings.toggleVisibility,$T.on(a,"click",Tegaki.onLayerToggleVisibilityClick),e.visible&&(a.className+=" tegaki-ui-cb-a"),i.appendChild(a),t.appendChild(i),(i=$T.el("div")).className="tegaki-layers-cell-p",(a=$T.el("canvas")).id="tegaki-layers-p-canvas-"+e.id,a.className="tegaki-alpha-bg-xs",[a.width,a.height]=TegakiUI.getLayerPreviewSize(),i.appendChild(a),t.appendChild(i),(i=$T.el("div")).className="tegaki-layers-cell-n",(a=$T.el("div")).id="tegaki-layer-name-"+e.id,a.className="tegaki-ellipsis",a.setAttribute("data-id",e.id),a.textContent=e.name,$T.on(a,"dblclick",Tegaki.onLayerNameChangeClick),i.appendChild(a),t.appendChild(i),t},onLayerSelectorPtrDown:function(e){"mouse"===e.pointerType?this.hasAttribute("data-nodrag")&&(this.removeAttribute("data-nodrag"),$T.on(this,"dragstart",TegakiUI.onLayerDragStart)):this.hasAttribute("data-nodrag")||(this.setAttribute("data-nodrag",1),$T.off(this,"dragstart",TegakiUI.onLayerDragStart))},onLayerDragStart:function(e){var t,a;e.ctrlKey||(TegakiUI.draggedNode=null,$T.id("tegaki-layers-grid").children[1]?(a=+e.target.getAttribute("data-id"),(t=$T.el("div")).className="tegaki-invis",e.dataTransfer.setDragImage(t,0,0),e.dataTransfer.setData("text/plain",a),e.dataTransfer.effectAllowed="move",TegakiUI.draggedNode=e.target,TegakiUI.updateLayersGridDragExt(!0)):e.preventDefault())},onLayerDragOver:function(e){e.preventDefault(),e.dataTransfer.dropEffect="move",TegakiUI.updateLayersGridDragEffect(e.target,+TegakiUI.draggedNode.getAttribute("data-id"))},onLayerDragLeave:function(){TegakiUI.updateLayersGridDragEffect()},onLayerDragEnd:function(){TegakiUI.draggedNode=null,TegakiUI.updateLayersGridDragExt(!1),TegakiUI.updateLayersGridDragEffect()},onLayerDragDrop:function(e){var t,a,i;e.preventDefault(),TegakiUI.draggedNode=null,[t]=TegakiUI.layersGridFindDropTgt(e.target),a=+e.dataTransfer.getData("text/plain"),TegakiUI.updateLayersGridDragEffect(e.target.parentNode),TegakiUI.updateLayersGridDragExt(!1),TegakiUI.layersGridCanDrop(t,a)&&(i=t?TegakiLayers.getLayerPosById(t):Tegaki.layers.length,TegakiLayers.selectedLayersHas(a)||Tegaki.setActiveLayer(a),Tegaki.moveSelectedLayers(i))},updateLayersGridDragExt:function(e){var t,a;(t=$T.id("tegaki-layers-grid")).children[1]&&(e?((a=$T.el("div")).id="tegaki-layers-cell-dx",a.draggable=!0,$T.on(a,"dragover",TegakiUI.onLayerDragOver),$T.on(a,"drop",TegakiUI.onLayerDragDrop),t.parentNode.insertBefore(a,t)):(a=$T.id("tegaki-layers-cell-dx"))&&a.parentNode.removeChild(a))},updateLayersGridDragEffect:function(e,t){var a,i,s;i=$T.cls("tegaki-layers-cell-d",$T.id("tegaki-ctrlgrp-layers"));for(a of i)a.classList.remove("tegaki-layers-cell-d");e&&t&&([s,e]=TegakiUI.layersGridFindDropTgt(e),TegakiUI.layersGridCanDrop(s,t)&&(e||(e=$T.id("tegaki-layers-grid")),e.classList.add("tegaki-layers-cell-d")))},layersGridFindDropTgt:function(e){var t,a;for(t=+e.getAttribute("data-id"),a=$T.id("tegaki-ctrlgrp-layers");!e.draggable&&e!==a;)t=+(e=e.parentNode).getAttribute("data-id");return e!==a&&e.draggable?[t,e]:[0,null]},layersGridCanDrop:function(e,t){var a;if(e===t)return!1;if((a=$T.id("tegaki-layers-cell-"+t)).previousElementSibling){if(+a.previousElementSibling.getAttribute("data-id")===e)return!1}else if(!e)return!1;return!0},setReplayMode:function(e){Tegaki.bg.classList[e?"add":"remove"]("tegaki-replay-mode")},onToolChanged:function(){$T.id("tegaki-toolmode-bar").classList.remove("tegaki-hidden"),TegakiUI.updateToolSize(),TegakiUI.updateToolAlpha(),TegakiUI.updateToolFlow(),TegakiUI.updateToolModes()},updateLayerAlphaOpt:function(){$T.id("tegaki-layer-alpha-opt").value=Math.round(100*Tegaki.activeLayer.alpha)},updateLayerName:function(e){var t;(t=$T.id("tegaki-layer-name-"+e.id))&&(t.textContent=e.name)},updateLayerPreview:function(e){var t,a;(t=$T.id("tegaki-layers-p-canvas-"+e.id))&&((a=TegakiUI.getLayerPreviewCtx(e))||((a=t.getContext("2d")).imageSmoothingEnabled=!1,TegakiUI.setLayerPreviewCtx(e,a)),$T.clearCtx(a),a.drawImage(e.canvas,0,0,t.width,t.height))},updateLayerPreviewSize:function(e){var t,a,i;i=TegakiUI.getLayerPreviewSize();for(a of Tegaki.layers)(t=$T.id("tegaki-layers-p-canvas-"+a.id))&&([t.width,t.height]=i,e&&TegakiUI.updateLayerPreview(a))},getLayerPreviewCtx:function(e){TegakiUI.layerPreviewCtxCache.get(e)},setLayerPreviewCtx:function(e,t){TegakiUI.layerPreviewCtxCache.set(e,t)},deleteLayerPreviewCtx:function(e){TegakiUI.layerPreviewCtxCache["delete"](e)},updateLayersGridClear:function(){$T.id("tegaki-layers-grid").innerHTML=""},updateLayersGrid:function(){var e,t,a,i;a=$T.frag();for(e of Tegaki.layers)t=TegakiUI.buildLayerGridCell(e),a.insertBefore(t,a.firstElementChild);TegakiUI.updateLayersGridClear(),i.appendChild(a)},updateLayersGridActive:function(e){var t;(t=$T.cls("tegaki-layers-cell-a",$T.id("tegaki-layers-grid"))[0])&&t.classList.remove("tegaki-layers-cell-a"),(t=$T.id("tegaki-layers-cell-"+e))&&t.classList.add("tegaki-layers-cell-a"),TegakiUI.updateLayerAlphaOpt()},updateLayersGridAdd:function(e,t){var a,i,s;a=TegakiUI.buildLayerGridCell(e),i=$T.id("tegaki-layers-grid"),s=t?$T.id("tegaki-layers-cell-"+t):null,i.insertBefore(a,s)},updateLayersGridRemove:function(e){var t;(t=$T.id("tegaki-layers-cell-"+e))&&t.parentNode.removeChild(t)},updayeLayersGridOrder:function(){var e,t,a;t=$T.id("tegaki-layers-grid");for(e of Tegaki.layers)a=$T.id("tegaki-layers-cell-"+e.id),t.insertBefore(a,t.firstElementChild)},updateLayersGridVisibility:function(e,t){var a;(a=$T.id("tegaki-layers-cb-v-"+e))&&(t?a.classList.add("tegaki-ui-cb-a"):a.classList.remove("tegaki-ui-cb-a"))},updateLayersGridSelectedClear:function(){var e,t;for(e of Tegaki.layers)(t=$T.id("tegaki-layers-cell-"+e.id))&&t.classList.remove("tegaki-layers-cell-s")},updateLayersGridSelectedSet:function(e,t){var a;(a=$T.id("tegaki-layers-cell-"+e))&&(t?a.classList.add("tegaki-layers-cell-s"):a.classList.remove("tegaki-layers-cell-s"))},updateToolSize:function(){var e=$T.id("tegaki-ctrlgrp-size");Tegaki.tool.useSize?(e.classList.remove("tegaki-hidden"),$T.id("tegaki-size-lbl").value=Tegaki.tool.size,$T.id("tegaki-size").value=Tegaki.tool.size):e.classList.add("tegaki-hidden")},updateToolAlpha:function(){var e,t=$T.id("tegaki-ctrlgrp-alpha");Tegaki.tool.useAlpha?(t.classList.remove("tegaki-hidden"),e=Math.round(100*Tegaki.tool.alpha),$T.id("tegaki-alpha-lbl").value=e,$T.id("tegaki-alpha").value=e):t.classList.add("tegaki-hidden")},updateToolFlow:function(){var e,t=$T.id("tegaki-ctrlgrp-flow");Tegaki.tool.useFlow?(t.classList.remove("tegaki-hidden"),e=Math.round(100*Tegaki.tool.flow),$T.id("tegaki-flow-lbl").value=e,$T.id("tegaki-flow").value=e):t.classList.add("tegaki-hidden")},updateToolDynamics:function(){var e,t;e=$T.id("tegaki-tool-mode-dynamics"),Tegaki.tool.usesDynamics()?(t=$T.id("tegaki-tool-mode-dynamics-size"),Tegaki.tool.useSizeDynamics?(Tegaki.tool.sizeDynamicsEnabled?t.classList.add("tegaki-sw-btn-a"):t.classList.remove("tegaki-sw-btn-a"),t.classList.remove("tegaki-hidden")):t.classList.add("tegaki-hidden"),t=$T.id("tegaki-tool-mode-dynamics-alpha"),Tegaki.tool.useAlphaDynamics?(Tegaki.tool.alphaDynamicsEnabled?t.classList.add("tegaki-sw-btn-a"):t.classList.remove("tegaki-sw-btn-a"),t.classList.remove("tegaki-hidden")):t.classList.add("tegaki-hidden"),t=$T.id("tegaki-tool-mode-dynamics-flow"),Tegaki.tool.useFlowDynamics?(Tegaki.tool.flowDynamicsEnabled?t.classList.add("tegaki-sw-btn-a"):t.classList.remove("tegaki-sw-btn-a"),t.classList.remove("tegaki-hidden")):t.classList.add("tegaki-hidden"),e.classList.remove("tegaki-hidden")):e.classList.add("tegaki-hidden")},updateToolShape:function(){var e,t,a,i,s;if(t=$T.id("tegaki-tool-mode-tip"),Tegaki.tool.tipList){for(s=Tegaki.tool.tipList,(a=$T.id("tegaki-tool-mode-tip-ctrl")).innerHTML="",e=0;e<s.length;++e)(i=$T.el("span")).id="tegaki-tool-mode-tip-"+e,i.className="tegaki-sw-btn",i.setAttribute("data-id",e),i.textContent=TegakiStrings[s[e]],$T.on(i,"mousedown",Tegaki.onToolTipClick),a.appendChild(i),Tegaki.tool.tipId===e&&i.classList.add("tegaki-sw-btn-a");t.classList.remove("tegaki-hidden")}else t.classList.add("tegaki-hidden")},updateToolPreserveAlpha:function(){var e,t;t=$T.id("tegaki-tool-mode-mask"),Tegaki.tool.usePreserveAlpha?(e=$T.id("tegaki-tool-mode-mask-alpha"),Tegaki.tool.preserveAlphaEnabled?e.classList.add("tegaki-sw-btn-a"):e.classList.remove("tegaki-sw-btn-a"),t.classList.remove("tegaki-hidden")):t.classList.add("tegaki-hidden")},updateToolModes:function(){var e,t;TegakiUI.updateToolShape(),TegakiUI.updateToolDynamics(),TegakiUI.updateToolPreserveAlpha(),t=!1;for(e of $T.id("tegaki-toolmode-bar").children)t||e.classList.contains("tegaki-hidden")?e.classList.remove("tegaki-ui-borderless"):(e.classList.add("tegaki-ui-borderless"),t=!0)},updateUndoRedo:function(e,t){var a,i;Tegaki.replayMode||(a=$T.id("tegaki-undo-btn").classList,i=$T.id("tegaki-redo-btn").classList,e?a.contains("tegaki-disabled")&&a.remove("tegaki-disabled"):a.contains("tegaki-disabled")||a.add("tegaki-disabled"),t?i.contains("tegaki-disabled")&&i.remove("tegaki-disabled"):i.contains("tegaki-disabled")||i.add("tegaki-disabled"))},updateZoomLevel:function(){$T.id("tegaki-zoom-lbl").textContent=100*Tegaki.zoomFactor+"%",Tegaki.zoomLevel+Tegaki.zoomBaseLevel>=Tegaki.zoomFactorList.length?$T.id("tegaki-zoomin-btn").classList.add("tegaki-disabled"):$T.id("tegaki-zoomin-btn").classList.remove("tegaki-disabled"),Tegaki.zoomLevel+Tegaki.zoomBaseLevel<=0?$T.id("tegaki-zoomout-btn").classList.add("tegaki-disabled"):$T.id("tegaki-zoomout-btn").classList.remove("tegaki-disabled")},updateColorPalette:function(){var e,t,a;a=Tegaki.colorPaletteId,t=$T.cls("tegaki-color-grid",$T.id("tegaki-color-grids"));for(e of t)+e.getAttribute("data-id")===a?e.classList.remove("tegaki-hidden"):e.classList.add("tegaki-hidden");e=$T.id("tegaki-palette-prev-btn"),0===a?e.classList.add("tegaki-disabled"):e.classList.remove("tegaki-disabled"),e=$T.id("tegaki-palette-next-btn"),a===TegakiColorPalettes.length-1?e.classList.add("tegaki-disabled"):e.classList.remove("tegaki-disabled")},updateReplayTime:function(e){var t,a,i=Tegaki.replayViewer;(t=i.getCurrentPos())>(a=i.getDuration())&&(t=a),$T.id("tegaki-replay-now-lbl").textContent=$T.msToHms(t),e&&($T.id("tegaki-replay-end-lbl").textContent=$T.msToHms(a))},updateReplayControls:function(){TegakiUI.updateReplayGapless(),TegakiUI.updateReplayPlayPause(),TegakiUI.updateReplaySpeed()},updateReplayGapless:function(){var e,t=Tegaki.replayViewer;e=$T.id("tegaki-replay-gapless-cb"),t.gapless?e.classList.add("tegaki-ui-cb-a"):e.classList.remove("tegaki-ui-cb-a")},updateReplayPlayPause:function(){var e,t=Tegaki.replayViewer;e=$T.id("tegaki-replay-play-btn"),t.playing?(e.classList.remove("tegaki-play"),e.classList.add("tegaki-pause"),e.setAttribute("title",TegakiStrings.pause)):(e.classList.add("tegaki-play"),e.classList.remove("tegaki-pause"),e.setAttribute("title",TegakiStrings.play),t.getCurrentPos()<t.getDuration()?e.classList.remove("tegaki-disabled"):e.classList.add("tegaki-disabled"))},updateReplaySpeed:function(){var e,t=Tegaki.replayViewer;$T.id("tegaki-replay-speed-lbl").textContent=t.speed.toFixed(1),e=$T.id("tegaki-replay-slower-btn"),0===t.speedIndex?e.classList.add("tegaki-disabled"):e.classList.remove("tegaki-disabled"),e=$T.id("tegaki-replay-faster-btn"),t.speedIndex===t.speedList.length-1?e.classList.add("tegaki-disabled"):e.classList.remove("tegaki-disabled")},
enableReplayControls:function(e){e?$T.id("tegaki-replay-controls").classList.remove("tegaki-hidden"):$T.id("tegaki-replay-controls").classList.add("tegaki-hidden")},setRecordingStatus:function(e){var t=$T.id("tegaki-status-replay");e?t.classList.remove("tegaki-hidden"):t.classList.add("tegaki-hidden")}},UZIP={};
/*! UZIP.js, © 2018 Photopea, MIT License */"object"==typeof module&&(module.exports=UZIP),UZIP.inflateRaw=function(e,t){return UZIP.F.inflate(e,t)},UZIP.deflateRaw=function(e,t){null==t&&(t={level:6});var a=new Uint8Array(50+Math.floor(1.1*e.length)),i=UZIP.F.deflateRaw(e,a,i,t.level);return new Uint8Array(a.buffer,0,i)},UZIP.bin={readUshort:function(e,t){return e[t]|e[t+1]<<8},writeUshort:function(e,t,a){e[t]=255&a,e[t+1]=a>>8&255},readUint:function(e,t){return 16777216*e[t+3]+(e[t+2]<<16|e[t+1]<<8|e[t])},writeUint:function(e,t,a){e[t]=255&a,e[t+1]=a>>8&255,e[t+2]=a>>16&255,e[t+3]=a>>24&255},readASCII:function(e,t,a){for(var i="",s=0;s<a;s++)i+=String.fromCharCode(e[t+s]);return i},writeASCII:function(e,t,a){for(var i=0;i<a.length;i++)e[t+i]=a.charCodeAt(i)},pad:function(e){return e.length<2?"0"+e:e},readUTF8:function(e,t,a){for(var i,s="",r=0;r<a;r++)s+="%"+UZIP.bin.pad(e[t+r].toString(16));try{i=decodeURIComponent(s)}catch(n){return UZIP.bin.readASCII(e,t,a)}return i},writeUTF8:function(e,t,a){for(var i=a.length,s=0,r=0;r<i;r++){var n=a.charCodeAt(r);if(0==(4294967168&n))e[t+s]=n,s++;else if(0==(4294965248&n))e[t+s]=192|n>>6,e[t+s+1]=128|n>>0&63,s+=2;else if(0==(4294901760&n))e[t+s]=224|n>>12,e[t+s+1]=128|n>>6&63,e[t+s+2]=128|n>>0&63,s+=3;else{if(0!=(4292870144&n))throw"e";e[t+s]=240|n>>18,e[t+s+1]=128|n>>12&63,e[t+s+2]=128|n>>6&63,e[t+s+3]=128|n>>0&63,s+=4}}return s},sizeUTF8:function(e){for(var t=e.length,a=0,i=0;i<t;i++){var s=e.charCodeAt(i);if(0==(4294967168&s))a++;else if(0==(4294965248&s))a+=2;else if(0==(4294901760&s))a+=3;else{if(0!=(4292870144&s))throw"e";a+=4}}return a}},UZIP.F={},UZIP.F.deflateRaw=function(e,t,a,i){var s=[[0,0,0,0,0],[4,4,8,4,0],[4,5,16,8,0],[4,6,16,16,0],[4,10,16,32,0],[8,16,32,32,0],[8,16,128,128,0],[8,32,128,256,0],[32,128,258,1024,1],[32,258,258,4096,1]][i],r=UZIP.F.U,n=UZIP.F._goodIndex,o=(UZIP.F._hash,UZIP.F._putsE),l=0,g=a<<3,d=0,c=e.length;if(0==i){for(;l<c;){o(t,g,l+(C=Math.min(65535,c-l))==c?1:0),g=UZIP.F._copyExact(e,l,C,t,g+8),l+=C}return g>>>3}var h=r.lits,p=r.strt,k=r.prev,T=0,u=0,y=0,f=0,v=0,m=0;c>2&&(p[m=UZIP.F._hash(e,0)]=0);for(l=0;l<c;l++){if(v=m,l+1<c-2){m=UZIP.F._hash(e,l+1);var b=l+1&32767;k[b]=p[m],p[m]=b}if(d<=l){(T>14e3||u>26697)&&c-l>100&&(d<l&&(h[T]=l-d,T+=2,d=l),g=UZIP.F._writeBlock(l==c-1||d==c?1:0,h,T,f,e,y,l-y,t,g),T=u=f=0,y=l);var L=0;l<c-2&&(L=UZIP.F._bestMatch(e,l,k,v,Math.min(s[2],c-l),s[3]));var C=L>>>16,w=65535&L;if(0!=L){w=65535&L;var S=n(C=L>>>16,r.of0);r.lhst[257+S]++;var I=n(w,r.df0);r.dhst[I]++,f+=r.exb[S]+r.dxb[I],h[T]=C<<23|l-d,h[T+1]=w<<16|S<<8|I,T+=2,d=l+C}else r.lhst[e[l]]++;u++}}for(y==l&&0!=e.length||(d<l&&(h[T]=l-d,T+=2,d=l),g=UZIP.F._writeBlock(1,h,T,f,e,y,l-y,t,g),T=0,u=0,T=u=f=0,y=l);0!=(7&g);)g++;return g>>>3},UZIP.F._bestMatch=function(e,t,a,i,s,r){var n=32767&t,o=a[n],l=n-o+32768&32767;if(o==n||i!=UZIP.F._hash(e,t-l))return 0;for(var g=0,d=0,c=Math.min(32767,t);l<=c&&0!=--r&&o!=n;){if(0==g||e[t+g]==e[t+g-l]){var h=UZIP.F._howLong(e,t,l);if(h>g){if(d=l,(g=h)>=s)break;l+2<h&&(h=l+2);for(var p=0,k=0;k<h-2;k++){var T=t-l+k+32768&32767,u=T-a[T]+32768&32767;u>p&&(p=u,o=T)}}}l+=(n=o)-(o=a[n])+32768&32767}return g<<16|d},UZIP.F._howLong=function(e,t,a){if(e[t]!=e[t-a]||e[t+1]!=e[t+1-a]||e[t+2]!=e[t+2-a])return 0;var i=t,s=Math.min(e.length,t+258);for(t+=3;t<s&&e[t]==e[t-a];)t++;return t-i},UZIP.F._hash=function(e,t){return(e[t]<<8|e[t+1])+(e[t+2]<<4)&65535},UZIP.saved=0,UZIP.F._writeBlock=function(e,t,a,i,s,r,n,o,l){var g,d,c,h,p,k,T,u,y,f=UZIP.F.U,v=UZIP.F._putsF,m=UZIP.F._putsE;f.lhst[256]++,d=(g=UZIP.F.getTrees())[0],c=g[1],h=g[2],p=g[3],k=g[4],T=g[5],u=g[6],y=g[7];var b=32+(0==(l+3&7)?0:8-(l+3&7))+(n<<3),L=i+UZIP.F.contSize(f.fltree,f.lhst)+UZIP.F.contSize(f.fdtree,f.dhst),C=i+UZIP.F.contSize(f.ltree,f.lhst)+UZIP.F.contSize(f.dtree,f.dhst);C+=14+3*T+UZIP.F.contSize(f.itree,f.ihst)+(2*f.ihst[16]+3*f.ihst[17]+7*f.ihst[18]);for(var w=0;w<286;w++)f.lhst[w]=0;for(w=0;w<30;w++)f.dhst[w]=0;for(w=0;w<19;w++)f.ihst[w]=0;var S=b<L&&b<C?0:L<C?1:2;v(o,l,e),v(o,l+1,S);l+=3;if(0==S){for(;0!=(7&l);)l++;l=UZIP.F._copyExact(s,r,n,o,l)}else{var I,U;if(1==S&&(I=f.fltree,U=f.fdtree),2==S){UZIP.F.makeCodes(f.ltree,d),UZIP.F.revCodes(f.ltree,d),UZIP.F.makeCodes(f.dtree,c),UZIP.F.revCodes(f.dtree,c),UZIP.F.makeCodes(f.itree,h),UZIP.F.revCodes(f.itree,h),I=f.ltree,U=f.dtree,m(o,l,p-257),m(o,l+=5,k-1),m(o,l+=5,T-4),l+=4;for(var P=0;P<T;P++)m(o,l+3*P,f.itree[1+(f.ordr[P]<<1)]);l+=3*T,l=UZIP.F._codeTiny(u,f.itree,o,l),l=UZIP.F._codeTiny(y,f.itree,o,l)}for(var A=r,D=0;D<a;D+=2){for(var E=t[D],$=E>>>23,z=A+(8388607&E);A<z;)l=UZIP.F._writeLit(s[A++],I,o,l);if(0!=$){var x=t[D+1],F=x>>16,M=x>>8&255,R=255&x;m(o,l=UZIP.F._writeLit(257+M,I,o,l),$-f.of0[M]),l+=f.exb[M],v(o,l=UZIP.F._writeLit(R,U,o,l),F-f.df0[R]),l+=f.dxb[R],A+=$}}l=UZIP.F._writeLit(256,I,o,l)}return l},UZIP.F._copyExact=function(e,t,a,i,s){var r=s>>>3;return i[r]=a,i[r+1]=a>>>8,i[r+2]=255-i[r],i[r+3]=255-i[r+1],r+=4,i.set(new Uint8Array(e.buffer,t,a),r),s+(a+4<<3)},UZIP.F.getTrees=function(){for(var e=UZIP.F.U,t=UZIP.F._hufTree(e.lhst,e.ltree,15),a=UZIP.F._hufTree(e.dhst,e.dtree,15),i=[],s=UZIP.F._lenCodes(e.ltree,i),r=[],n=UZIP.F._lenCodes(e.dtree,r),o=0;o<i.length;o+=2)e.ihst[i[o]]++;for(o=0;o<r.length;o+=2)e.ihst[r[o]]++;for(var l=UZIP.F._hufTree(e.ihst,e.itree,7),g=19;g>4&&0==e.itree[1+(e.ordr[g-1]<<1)];)g--;return[t,a,l,s,n,g,i,r]},UZIP.F.getSecond=function(e){for(var t=[],a=0;a<e.length;a+=2)t.push(e[a+1]);return t},UZIP.F.nonZero=function(e){for(var t="",a=0;a<e.length;a+=2)0!=e[a+1]&&(t+=(a>>1)+",");return t},UZIP.F.contSize=function(e,t){for(var a=0,i=0;i<t.length;i++)a+=t[i]*e[1+(i<<1)];return a},UZIP.F._codeTiny=function(e,t,a,i){for(var s=0;s<e.length;s+=2){var r=e[s],n=e[s+1];i=UZIP.F._writeLit(r,t,a,i);var o=16==r?2:17==r?3:7;r>15&&(UZIP.F._putsE(a,i,n,o),i+=o)}return i},UZIP.F._lenCodes=function(e,t){for(var a=e.length;2!=a&&0==e[a-1];)a-=2;for(var i=0;i<a;i+=2){var s=e[i+1],r=i+3<a?e[i+3]:-1,n=i+5<a?e[i+5]:-1,o=0==i?-1:e[i-1];if(0==s&&r==s&&n==s){for(var l=i+5;l+2<a&&e[l+2]==s;)l+=2;(g=Math.min(l+1-i>>>1,138))<11?t.push(17,g-3):t.push(18,g-11),i+=2*g-2}else if(s==o&&r==s&&n==s){for(l=i+5;l+2<a&&e[l+2]==s;)l+=2;var g=Math.min(l+1-i>>>1,6);t.push(16,g-3),i+=2*g-2}else t.push(s,0)}return a>>>1},UZIP.F._hufTree=function(e,t,a){var i=[],s=e.length,r=t.length,n=0;for(n=0;n<r;n+=2)t[n]=0,t[n+1]=0;for(n=0;n<s;n++)0!=e[n]&&i.push({lit:n,f:e[n]});var o=i.length,l=i.slice(0);if(0==o)return 0;if(1==o){var g=i[0].lit;l=0==g?1:0;return t[1+(g<<1)]=1,t[1+(l<<1)]=1,1}i.sort(function(e,t){return e.f-t.f});var d=i[0],c=i[1],h=0,p=1,k=2;for(i[0]={lit:-1,f:d.f+c.f,l:d,r:c,d:0};p!=o-1;)d=h!=p&&(k==o||i[h].f<i[k].f)?i[h++]:i[k++],c=h!=p&&(k==o||i[h].f<i[k].f)?i[h++]:i[k++],i[p++]={lit:-1,f:d.f+c.f,l:d,r:c};var T=UZIP.F.setDepth(i[p-1],0);for(T>a&&(UZIP.F.restrictDepth(l,a,T),T=a),n=0;n<o;n++)t[1+(l[n].lit<<1)]=l[n].d;return T},UZIP.F.setDepth=function(e,t){return-1!=e.lit?(e.d=t,t):Math.max(UZIP.F.setDepth(e.l,t+1),UZIP.F.setDepth(e.r,t+1))},UZIP.F.restrictDepth=function(e,t,a){var i=0,s=1<<a-t,r=0;for(e.sort(function(e,t){return t.d==e.d?e.f-t.f:t.d-e.d}),i=0;i<e.length&&e[i].d>t;i++){var n=e[i].d;e[i].d=t,r+=s-(1<<a-n)}for(r>>>=a-t;r>0;){(n=e[i].d)<t?(e[i].d++,r-=1<<t-n-1):i++}for(;i>=0;i--)e[i].d==t&&r<0&&(e[i].d--,r++)},UZIP.F._goodIndex=function(e,t){var a=0;return t[16|a]<=e&&(a|=16),t[8|a]<=e&&(a|=8),t[4|a]<=e&&(a|=4),t[2|a]<=e&&(a|=2),t[1|a]<=e&&(a|=1),a},UZIP.F._writeLit=function(e,t,a,i){return UZIP.F._putsF(a,i,t[e<<1]),i+t[1+(e<<1)]},UZIP.F.inflate=function(e,t){var a=Uint8Array;if(3==e[0]&&0==e[1])return t||new a(0);var i=UZIP.F,s=i._bitsF,r=i._bitsE,n=i._decodeTiny,o=i.makeCodes,l=i.codes2map,g=i._get17,d=i.U,c=null==t;c&&(t=new a(e.length>>>2<<3));for(var h,p,k=0,T=0,u=0,y=0,f=0,v=0,m=0,b=0,L=0;0==k;)if(k=s(e,L,1),T=s(e,L+1,2),L+=3,0!=T){if(c&&(t=UZIP.F._check(t,b+(1<<17))),1==T&&(h=d.flmap,p=d.fdmap,v=511,m=31),2==T){u=r(e,L,5)+257,y=r(e,L+5,5)+1,f=r(e,L+10,4)+4;L+=14;for(var C=0;C<38;C+=2)d.itree[C]=0,d.itree[C+1]=0;var w=1;for(C=0;C<f;C++){var S=r(e,L+3*C,3);d.itree[1+(d.ordr[C]<<1)]=S,S>w&&(w=S)}L+=3*f,o(d.itree,w),l(d.itree,w,d.imap),h=d.lmap,p=d.dmap,L=n(d.imap,(1<<w)-1,u+y,e,L,d.ttree);var I=i._copyOut(d.ttree,0,u,d.ltree);v=(1<<I)-1;var U=i._copyOut(d.ttree,u,y,d.dtree);m=(1<<U)-1,o(d.ltree,I),l(d.ltree,I,h),o(d.dtree,U),l(d.dtree,U,p)}for(;;){var P=h[g(e,L)&v];L+=15&P;var A=P>>>4;if(A>>>8==0)t[b++]=A;else{if(256==A)break;var D=b+A-254;if(A>264){var E=d.ldef[A-257];D=b+(E>>>3)+r(e,L,7&E),L+=7&E}var $=p[g(e,L)&m];L+=15&$;var z=$>>>4,x=d.ddef[z],F=(x>>>4)+s(e,L,15&x);for(L+=15&x,c&&(t=UZIP.F._check(t,b+(1<<17)));b<D;)t[b]=t[b++-F],t[b]=t[b++-F],t[b]=t[b++-F],t[b]=t[b++-F];b=D}}}else{0!=(7&L)&&(L+=8-(7&L));var M=4+(L>>>3),R=e[M-4]|e[M-3]<<8;c&&(t=UZIP.F._check(t,b+R)),t.set(new a(e.buffer,e.byteOffset+M,R),b),L=M+R<<3,b+=R}return t.length==b?t:t.slice(0,b)},UZIP.F._check=function(e,t){var a=e.length;if(t<=a)return e;var i=new Uint8Array(Math.max(a<<1,t));return i.set(e,0),i},UZIP.F._decodeTiny=function(e,t,a,i,s,r){for(var n=UZIP.F._bitsE,o=UZIP.F._get17,l=0;l<a;){var g=e[o(i,s)&t];s+=15&g;var d=g>>>4;if(d<=15)r[l]=d,l++;else{var c=0,h=0;16==d?(h=3+n(i,s,2),s+=2,c=r[l-1]):17==d?(h=3+n(i,s,3),s+=3):18==d&&(h=11+n(i,s,7),s+=7);for(var p=l+h;l<p;)r[l]=c,l++}}return s},UZIP.F._copyOut=function(e,t,a,i){for(var s=0,r=0,n=i.length>>>1;r<a;){var o=e[r+t];i[r<<1]=0,i[1+(r<<1)]=o,o>s&&(s=o),r++}for(;r<n;)i[r<<1]=0,i[1+(r<<1)]=0,r++;return s},UZIP.F.makeCodes=function(e,t){for(var a,i,s,r,n=UZIP.F.U,o=e.length,l=n.bl_count,g=0;g<=t;g++)l[g]=0;for(g=1;g<o;g+=2)l[e[g]]++;var d=n.next_code;for(a=0,l[0]=0,i=1;i<=t;i++)a=a+l[i-1]<<1,d[i]=a;for(s=0;s<o;s+=2)0!=(r=e[s+1])&&(e[s]=d[r],d[r]++)},UZIP.F.codes2map=function(e,t,a){for(var i=e.length,s=UZIP.F.U.rev15,r=0;r<i;r+=2)if(0!=e[r+1])for(var n=r>>1,o=e[r+1],l=n<<4|o,g=t-o,d=e[r]<<g,c=d+(1<<g);d!=c;){a[s[d]>>>15-t]=l,d++}},UZIP.F.revCodes=function(e,t){for(var a=UZIP.F.U.rev15,i=15-t,s=0;s<e.length;s+=2){var r=e[s]<<t-e[s+1];e[s]=a[r]>>>i}},UZIP.F._putsE=function(e,t,a){a<<=7&t;var i=t>>>3;e[i]|=a,e[i+1]|=a>>>8},UZIP.F._putsF=function(e,t,a){a<<=7&t;var i=t>>>3;e[i]|=a,e[i+1]|=a>>>8,e[i+2]|=a>>>16},UZIP.F._bitsE=function(e,t,a){return(e[t>>>3]|e[1+(t>>>3)]<<8)>>>(7&t)&(1<<a)-1},UZIP.F._bitsF=function(e,t,a){return(e[t>>>3]|e[1+(t>>>3)]<<8|e[2+(t>>>3)]<<16)>>>(7&t)&(1<<a)-1},UZIP.F._get17=function(e,t){return(e[t>>>3]|e[1+(t>>>3)]<<8|e[2+(t>>>3)]<<16)>>>(7&t)},UZIP.F._get25=function(e,t){return(e[t>>>3]|e[1+(t>>>3)]<<8|e[2+(t>>>3)]<<16|e[3+(t>>>3)]<<24)>>>(7&t)},UZIP.F.U=function(){var e=Uint16Array,t=Uint32Array;return{next_code:new e(16),bl_count:new e(16),ordr:[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],of0:[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,999,999,999],exb:[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0],ldef:new e(32),df0:[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,65535,65535],dxb:[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,0,0],ddef:new t(32),flmap:new e(512),fltree:[],fdmap:new e(32),fdtree:[],lmap:new e(32768),ltree:[],ttree:[],dmap:new e(32768),dtree:[],imap:new e(512),itree:[],rev15:new e(32768),lhst:new t(286),dhst:new t(30),ihst:new t(19),lits:new t(15e3),strt:new e(65536),prev:new e(32768)}}(),function(){function e(e,t,a){for(;0!=t--;)e.push(0,a)}for(var t=UZIP.F.U,a=32768,i=0;i<a;i++){var s=i;s=(4278255360&(s=(4042322160&(s=(3435973836&(s=(2863311530&s)>>>1|(1431655765&s)<<1))>>>2|(858993459&s)<<2))>>>4|(252645135&s)<<4))>>>8|(16711935&s)<<8,t.rev15[i]=(s>>>16|s<<16)>>>17}for(i=0;i<32;i++)t.ldef[i]=t.of0[i]<<3|t.exb[i],t.ddef[i]=t.df0[i]<<4|t.dxb[i];e(t.fltree,144,8),e(t.fltree,112,9),e(t.fltree,24,7),e(t.fltree,8,8),UZIP.F.makeCodes(t.fltree,9),UZIP.F.codes2map(t.fltree,9,t.flmap),UZIP.F.revCodes(t.fltree,9),e(t.fdtree,32,5),UZIP.F.makeCodes(t.fdtree,5),UZIP.F.codes2map(t.fdtree,5,t.fdmap),UZIP.F.revCodes(t.fdtree,5),e(t.itree,19,0),e(t.ltree,286,0),e(t.dtree,30,0),e(t.ttree,320,0)}();