$(document).ready(function() {
    var App = {
      options: {
        add: function(key, description, tab) {
          tab || (tab = 'general');
  
          var checked = App.options.get(key);
          var $el = $(`
            <div>
              <label>
                <input type="checkbox">${description}
              </label>
            </div>`);
  
          $el
            .find('input')
            .prop('checked', checked)
            .on('change', App.options.check(key));
  
          window.Options.extend_tab(tab, $el);
        },
        get: function(key) {
          if (localStorage[key])
            return JSON.parse(localStorage[key]);
          return false;
        },
        check: function(key) {
          return function(e) {
            var val = this.checked;
            localStorage[key] = JSON.stringify(val);
  
            if (key === 'useFileStrip') {
              if (val) {
                if (!App.fileStripLoaded) {
                  App.initializeFileStrip(); 
                  App.fileStripLoaded = true; 
                }
              } else {
                App.fileStripLoaded = false;
                $('.file-thumbs').empty(); 
                $(document).off('drop click keypress paste'); 
                location.reload(); 
              }
            }
          };
        }
      },
      fileStripLoaded: false, 
  
      initializeFileStrip: function() {
        $(document).off("drop click keypress paste");
        const max_images = 4;
  
        var files = [];
        
        function addFile(file) {
          if (files.length == max_images) return;
          
          
          let timestamp = Date.now(); 
          
          // set the filename with the original file extension
          var fileName = timestamp + "." + file.name.split('.').pop();
          var newFile = new File([file.slice(0, file.size, file.type)], fileName, {type: file.type});
          
          files.push(newFile);
          addThumb(newFile);
        }
  
        function removeFile(file) {
          files.splice(files.indexOf(file), 1);
        }
  
        function getThumbElement(file) {
          return $('.tmb-container').filter(function(){ return($(this).data('file-ref') == file); });
        }
  
        function addThumb(file) {
          var fileName = (file.name.length < 24) ? file.name : file.name.substr(0, 22) + '…';
          var fileType = file.type.split('/')[0];
          var fileExt = file.type.split('/')[1];
          var $container = $('<div>')
            .addClass('tmb-container')
            .data('file-ref', file)
            .append(
              $('<div>').addClass('remove-btn').html('X'),
              $('<div>').addClass('file-tmb'),
              $('<div>').addClass('tmb-filename').html(fileName)
            )
            .appendTo('.file-thumbs');
  
          var $fileThumb = $container.find('.file-tmb');
          if (fileType == 'image') {
            var objURL = window.URL.createObjectURL(file);
            $fileThumb.css('background-image', 'url(' + objURL + ')');
          } else {
            $fileThumb.html('<span>' + fileExt.toUpperCase() + '</span>');
          }
        }
  
        $(document).on('ajax_before_post', function (e, formData) {
          for (var i = 0; i < max_images; i++) {
            var key = 'file';
            if (i > 0) key += i + 1;
            if (typeof files[i] === 'undefined') break;
  
            formData.append(key, files[i]);
          }
        });
  
        
        $(document).on('ajax_after_post', function () {
          files = [];
          $('.file-thumbs').empty();
        });
  
        var dragCounter = 0;
        var dropHandler = {
          drop: function (e) {
            e.stopPropagation();
            e.preventDefault();
  
            $('.dropzone').removeClass('dragover');
            dragCounter = 0;
  
            var fileList = e.originalEvent.dataTransfer.files;
            for (var i = 0; i < fileList.length; i++) {
              addFile(fileList[i]);
            }
          }
        };
  
        $(document).on(dropHandler);
  
        $(document).on('click', '.dropzone .remove-btn', function (e) {
          e.stopPropagation();
  
          var file = $(e.target).parent().data('file-ref');
  
          getThumbElement(file).remove();
          removeFile(file);
        });
  
        $(document).on('keypress click', '.dropzone', function (e) {
          e.stopPropagation();
  
          
          if ((e.which != 1 || e.target.className != 'file-hint') &&
            e.which != 13)
            return;
  
          var $fileSelector = $('<input type="file" multiple>');
  
          $fileSelector.on('change', function (e) {
            if (this.files.length > 0) {
              for (var i = 0; i < this.files.length; i++) {
                addFile(this.files[i]);
              }
            }
            $(this).remove();
          });
  
          $fileSelector.click();
        });
  
        $(document).on('paste', function (e) {
          var clipboard = e.originalEvent.clipboardData;
          if (typeof clipboard.items != 'undefined' && clipboard.items.length != 0) {
  
            
            for (var i = 0; i < clipboard.items.length; i++) {
              if (clipboard.items[i].kind != 'file') continue;
  
              
              var file = new File([clipboard.items[i].getAsFile()], 'ClipboardImage.png', {type: 'image/png'});
              addFile(file);
            }
          }
        });
      }
    };
  
    App.options.add('useFileStrip', ('Strip filenames'));
  
    if (App.options.get('useFileStrip') && !App.fileStripLoaded) {
      App.initializeFileStrip(); 
      App.fileStripLoaded = true; 
    }
  });
