# Update Culture

Update culture is a highly [harmful](harmful.md), generally established mindset and a set of societal mechanisms emerging in a [capitalist](capitalism.md) society which demand and rely on constant UPDATES in all aspects of life -- importantly to [us](lrs.md) this means updates of [software](sw.md), [hardware](hw.md) and electronic devices, but also other things such as keeping up with the latest news, politics, trends, [memes](meme.md), fashion and so on. In [technology](tech.md) this manifests by developers of a (typically [bloated](bloat.md)) program creating frequent modifications called "updates" (sometimes also more sneakily masked under terms such as [progress](leading_the_pig_to_the_slaughterhouse.md) or [modernization](modern.md)) and forcing users to keep [consuming](consumerism.md) them, e.g. by deprecating or neglecting old versions, dropping [backwards compatibility](backwards_compatibility.md) (e.g. [Python](python.md)) or by downright forcing updates in code. This often manifests by a familiar pop-up message:

*"Your software is too old, please update to the latest version."*

In software this process is a lot of times automated and known as [autoupdates](autoupdate.md), but update culture encompasses more than this, it's the whole mentality of having to constantly keep up, update one's software, hardware and other products, it is part of [fear culture](fear_culture.md), [bullshit](bullshit.md) and [consumerism](consumerism.md). Normies get all neurotic when they haven't received their weekly updates that give them new content or fake sense of "[security](security.md)". The truth is updates break more things that they fix and make software progressively [shittier](modern.md). STOP FUCKING UPDATING EVERYTHING EVERY 3 SECONDS YOU IDIOTS. [Good software](lrs.md) is written once and works for hundreds of years without [maintenance](maintenance.md).

A typical example falling under update culture are [web browsers](browser.md) or proprietary [operating systems](operating_system.md) that strive for [bloat monopoly](bloat_monopoly.md). Normalizing the practice of having to consume updates leads to the convenient opportunity for abuse of users: with the stuff you need you may be fed stuff you don't want.

Do you hate **[software as a service](saas.md)**? Do you miss the times when you bought a video game and then owned it forever, without subscriptions and a guarantee of slow enshitification? Thank update culture, this is its fruit. Even "[FOSS](foss.md)" programs must become services in the update culture climate because no software can even be finished, it has to be continuously maintained and maintenance is a service.

Update culture embraces and forces artificial obsolescence as a part of increasing [consumerism](consumerism.md), the issue became known as **[planned obsolescence](planned_obsolescence.md)**: not only we stopped investing energy into making technology last, even if the investment would be small and well worth it, we now even invest ADDITIONAL energy into programming technology to break on purpose if it would naturally last "too long" -- that would be an obstacle to consumerism. Whereas planned obsolescence is usually seen narrowly as a specific phenomenon manifested in electronic devices, update culture encompasses the same ideas taken to wider scales and contexts and normalizing them in our culture -- for example new communication protocols will be created despite diminishing returns or even their complete uselessness, for no other reason than that we've been using our current protocols for too long. Update culture sees it as inherently stupid and shameful to keep using old things, without asking why. Under this culture if you ask "Why should I start using the new thing?" you'll simply get an answer "Because you don't want to be using a technology from 1990s you retard" -- there has been a [thinking shortcut](shortcut_thinking.md) established for "old = bad", and so maybe we'll soon start making cars with square wheels only because the wheel is such an old invention. Under update culture you will also often hear completely irrational questions such as **"Is this old video game still fun in [CURRENT YEAR]?"** -- of course if the game was fun back when it was new, it is still fun today, only a retard could think fun can somehow evaporate from an unchanging piece of art -- yes, of course the game may seize to be fun to us because WE changed, but the point here is that there is now an established culture by which we perceive even values in art as temporary and evaporating, which is shown by how the question is formulated.

Let's stress again that update culture is NOT limited to computer world or even the area of technology alone, hell no. It is the mood of the whole society and applies to things like fashion, business, gossip, watching TV news every day, browsing social media or constantly updating laws, it is the acceptance and approval of living in a constant stress of having to extort extreme amounts of energy just to keep up with artificially made up [bullshit](bullshit.md), to race against oneself and others in a never ending senseless marathon with no winners, just with extremely exhausted participants. Our current system of [law](law.md) demands constant daily maintenance that's extremely costly, law needs to be rewritten on the go and 24/7 updated to reflect any emerging trend in society because it is so unbelievably complex and attempts to cover every single aspect of our society. Of course we, the [LRS](lrs.md), eventually oppose any kind of formal law, however law with added update culture takes us yet orders of magnitude further into the dark abyss of insanity -- if we see law as a tool to serve society, this kind of law is an utterly shitty tool similar to an overpriced hammer that has to be repaired every second just to keep functioning (poorly). Take a second to observe common language to reveal how deeply ingrained in our [culture](culture.md) the update craziness has become: the word **"outdated"** is a pejorative almost synonymous with "dangerous", "wrong", "bad", "broken" or "unusable", neither of which is deductible from simply being old -- on the contrary, being old can often mean the exact opposite: wise, stable, tested, verified, ...

Software updates are usually justified by "muh [security](security.md)" and "muh [modern](modern.md) [features](feature.md)". Users who want to avoid these updates or simply can't install them, e.g. due to using old incompatible hardware or missing dependency packages, are ridiculed as *poorfags*, idiots and their suffering is ignored. In fact, update culture is [cancer](cancer.md) because:

- **It is a form of software [consumerism](consumerism.md)**, even if the updates themselves are gratis, they always come at a cost such as potential unstability, requiring new hardware, forcing installing more dependencies, required learning to use the new version, or even dropping of old features and malicious code in the updates.
- **It is dangerous**, updates regularly break things, and there are cases where a lot depends on software running smoothly.
- It is [bullshit](bullshit.md) effort, **wasting human work and creating an intentionally high [maintenance](maintenance.md) cost**. Humans, both users and programmers, become slaves to the software.
- **The [security](security.md) justifications are just pure lies**: a true concern for security would lead to unbloating and creating a minimal, stable and well tested software. Update culture is the exact opposite, it in fact constantly pushes newly created vulnerabilities with the updates which are only better in not having been discovered yet, i.e. relying on **security by obscurity**. This creates an intentionally **endless cycle of creating something that will never be finished** (even if it well could be).
- **It kills [freedom](freedom.md)**. E.g. with the example of web the constant meaningless updates of JavaScript and addition of "features" eliminates any small competition that can't afford to keep up with the constantly changing environment. **This is why we have no good web browsers**.
- **It is painful for the user** while at the same time being unnecessary, i.e. it's plainly artificial discomfort forced on users. The user has to keep caring about his software like some kind of [tamagotchi](tamagotchi.md), becoming a slave to it.
- **It creates a mindset of not aiming to [finish](finished.md) anything** and [normalizes](normalization.md) this -- developers accept they release unfinished software, users accept they use unfinished software, society depends on technology that's not been finished, is buggy, unstable, randomly changing from one day to another etcetc. Update culture has a similar effect to the cancerous economic effect of [inflation](inflation.md) that prevents you from saving up money: it destroys anything that becomes static, not allowing to establish any stability.
- **It is actually a huge security risk** (yes, we don't really buy intro security but this still holds). The developer, whoever it is, has the power to remotely push and execute any code at any time to the devices of many users. In fact this can be seen as the definition of [backdoor](backdoor.md). This is not just an issue of [proprietary](proprietary.md) software, there have been many [FOSS](foss.md) projects pushing [malware](malware.md) this way (look up e.g. the projects that targeted malware at Russians during the Russia-Ukraine war).
- ...

[Debian](debian.md) even goes as far as to give different versions of their distro unique names such as *Jessie* or *Trixie*, possibly to make users form emotional relationships with their beloved distros, as if distros were characters in an endless update telenovela -- this must most definitely have been a [woman](woman.md)'s idea. Never mind that this makes version tracking a nightmare by making it impossible to tell from the name which version is newer.

Inb4 IPv7.

## See Also

- [software as a service](saas.md)