# Trash Magic

Trash Magic is a term present at the basis of a philosophy/ideology/movement created by Lfae Spietz (known as *Dirt Wizard*, formerly as *Trash Robot*), in short it stands for harnessing the potential of capitalist waste to create technology for a new, better society. The term "[magic](magic.md)" was deliberately chosen to be provocative, it tries to completely rethink all basic assumptions about [technology](tech.md) and society, it creates a whole new mindset that shatters the borders erected by capitalism, e.g. those between technology and [art](art.md), users and creators, students and teachers and so on. The "movement" itself is in many ways similar to and aligned with our [LRS](lrs.md), mainly by opposing [capitalism](capitalism.md), being largely non-violent and aiming for creating a world full of abundance and true freedom with good technology for all living beings; but of course like with any other "movement" even here we will find disagreements.

## Details

The author's books can be downloaded at https://colfax.site/books/trashrobot/ (sadly needs [JS](javascript.md)), they are all free (both gratis and, if the waiver is valid, also [free culture](free_culture.md)). The main work seems to be **Trash Magic Manifesto** written in 2016, other important works include *Geometron Magic* and *First Book of Geometron*.

The author is Lfae Spietz, an [American](usa.md) male [PhD](phd.md) physicist who sadly seems to be a [type A fail](fail_ab.md), i.e. leaning toward [pseudoleftist](pseudoleft.md) fascism, erecting [gay fascist](lgbt.md) flags, using "personal pronouns" on his social media, using GitHub and even tiktok. But the books themselves seem to be quite free of all this, they are pretty readable. Spietz seems to be loving [analog](analog.md) computers and [sci-fi](sci_fi.md), his websites have great schizo vibes.

{ The following is a summary based on my quick reading of the *Trash Magic Manifesto* -- I didn't read it super carefully, I skipped some parts, but think I got a gist of it. It's at times hard to understand and everything here is just my poor interpretation, so to get the clearest picture read the books yourself. ~drummyfish }

Here is a small **summary of the manifesto**. The text has over 200 pages, the start is very good, the work identifies very well issues of current society and mainly [capitalism](capitalism.md) in a way very similar to us, also like us it for example defines morality as a set of axioms which shouldn't be discussed further (arguing with capitalists is explicitly discouraged as a futile task, also agreeing with us) -- this is the same thing we do with [less retarded society](less_retarded_society.md). [Anarchist](anarchism.md) views are embraced, all life (not just human) is seen as precious (in agreement with us) and the text goes into nice details (e.g. lack of freedom, doctors can't work without technicians, technicians can't work without factory workers, capitalism enslaves us through health care by refusing it to the nonconformant, criticizes Universities, mainstream "science", shits on Bitcoin, the whole concept of intellectual property, refuses money etc.), it states that capitalism is a religion and [cancer](cancer.md) by which our society is dying: we are [consumerist](consumerism.md) society that digs up resources, makes them into product that are consumed and thrown away, creating scarcity and heading towards consuming up all resources -- it is stated our society has to switch to a replication society instead and proposes to utilize what capitalism calls waste or "trash" -- things that have no value to a capitalist, things thrown away or found in nature. From this we should build a new technology from the ground up, using so called "Trash Magic", a kind of art of making this new technology -- this would be practiced by *Trash [Wizards](wizard.md)* who for now will dwell in "cracks" of current system, e.g. in places that may be technically someone's private property but which can be secretly utilized anyway, temporarily making use even of what according to the text is non-free but at  lest quite cheap and independent hardware like [Raspberry pi](rpi.md) or [Arduino](arduino.md). Definition of free technology is provided which is very aligned with our own: it is stated such technology mustn't be just legally free (i.e. without [copyright](copyright.md), [patents](patent.md) etc.) but also mustn't e.g. require high expertise and most people must be able to create it (i.e. it must be [de facto](de_facto.md) free, with which we agree greatly). Principles of the "movement" state that, besides others, all technology must be free, all country borders must be abolished as well as the wage system and that capitalism can't be reformed, it has to be destroyed (by starting to give away free things that help those oppressed by capitalism, slowly creating a parallel world that will displace capitalism). The Trash Magic technology wouldn't be the same as it is today, it wants to erase all borders -- not only e.g. those between engineers and users but also for example between technology and [art](art.md); the aim is to automate as much as possible with the use of [robots](robot.md), but the robots wouldn't be "cold machines", they would be "slimy" and "dirty", more similar to biological life, roaming the land and helping people. To be honest, the later part of the manifesto gets a bit weird, it's hard to tell if the author goes [schizophrenic](schizo.md) (most people would 100% call it autistic here) or really has some grand vision, but he goes on to stating thing such as that the kind of orderly, cold computer design of today is a product of white supremacists, that we have to get rid of hard numbers and incorporate more things such as "alchemy" and "potion making" to make liquids for the "slimy" robots, using things like "magic wands" and "[slimezistor](slimezistor.md)". It is advised to start by creating things from tree sticks, but the sticks must be picked from the ground to not harm the trees (this cute advice we appreciate). The book does have some clear, logical arguments, but is also a bit esoteric and spiritual (aside from being a manifesto it's also a coloring book) -- we understand this and also want to combine spirituality, art and technology, but here the author sometimes seems to go a bit over the line as if under an influence of some drug; while to [us](lrs.md) an elegant mathematical formula is art, it seems (but maybe we're wrong) that the author rather imagines infantile colorful drawings (like [xxiivv](xxiivv.md) for example) in a math paper to be "art" (to us this is a very shallow view of what art is). The manifesto states each piece of technology should come with a "tale" and "lore" to have some kind of sentimental value (that's supposed to oppose its price, the capitalist quantitative value), it's almost as if this was written by a [woman](woman.md). Further on great speculation follows, very detailed descriptions and propsitions of various robots are given, new terms are defined, there is even a small section of fiction. The other works go even much deeper, defining thing like the *Geometron* ("thinking about technology in geometric terms") etcetc., but that's already all too complex to all summarize here.

All in all Trash Magic seem net good so far, some parts are very good, some are at least entertaining, many ideas are very close to [LRS](lrs.md) but we have to be aware of the lurking [SJW](sjw.md) danger.

## See Also

- [less retarded technology](lrs.md)
- [less retarded society](less_retarded_society.md)
- [salvage computing](salvage_computing.md)
- [garbage](garbage.md)