# Technology

Technology (from Greek tekhnologia, "systematic treatment of [art](art.md)", also just "tech") encompasses tools and knowledge of making such tools invented and achieved mainly through [science](science.md) and by long systematic effort. This includes everything from [stone tools](rock.md) to space rockets and [artificial intelligence](ai.md). On the [Internet](internet.md), as well as on [this Wiki](lrs_wiki.md), this term is commonly used with an increased focus on [computer](computer.md) technology, i.e. [hardware](hardware.md) and [software](software.md), for this is the kind of technology that is being discussed and developed the most these days. Let it be said that technology, like [fire](fire.md), should serve us, but can also be dangerous and often gets misused and abused.

**The primary purpose of technology is to make people not have to [work](work.md)** -- see also [progress](progress.md). Proponents of dystopian societies, such as [capitalists](capitalism.md), fear that technology will "take work away from the people" -- those making such ridiculous claims have most definitely abnormally small dicks and are mental asylum grade idiots that commonly end up abusing technology in the completely opposite manner: for enslaving and oppressing people. Proponents of [good technology](lrs.md) on the other hand strive to make technology do work for humans so that people can actually live happy lives and do what they want. With this said we additionally have to establish that **one of the most important concepts in technology is [minimalism](minimalism.md)**, as that is a necessary prerequisite for technological [freedom](freedom.md).

**Good technology absolutely and unconditionally serves its user in whatever it is he does**, it must never refuse to do what the user asks, it must never abuse the user, it must never hide anything from him. Even if what the user does would be considered dangerous and unethical, the technology may warn the user but if he wishes so, the tool must obey. This is a very basic principle of technology that simply states that a machine is another extension of human, like an extra limb, it should only do work, ethics is left completely to the human brain (the user of the machine, NOT the machine's manufacturer). For this reason technology must never contain any [proprietary](proprietary.md) parts, [censorship](censorship.md), [ads](marketing.md), [DRM](drm.md), [planned obsolescence](planned_obsolescence.md) and so on -- and for this reason good technology is incompatible with [capitalism](capitalism.md) (where technology serves its manufacturer).

**Knowledge of [older](old.md) technology gets lost extremely quickly in society** -- this is a crucial realization that follows a naive idea of the young man who by his inexperience believes that we somehow pertain knowledge of all technology that's been invented from dawn of man until today. In [history](history.md) our society has always only held knowledge of technology it was CURRENTLY ACTIVELY USING; knowledge of decades old technology no longer in use only stays in hands and heads of extremely few individuals and perhaps in some obscure [books](book.md) that ARE UNREADABLE to most, sometimes to none; yet older technology oftentimes gets forgotten for good. For instance renaissance had to largely reinvent many arts and sciences of making building and statues of antiquity because middle ages have simply forgotten them. A more recent, very absurd example is provided by [NASA](nasa.md)'s efforts to recreate THEIR OWN old rocket engines: you would think that since they literally have detailed documentation of those engines, they'd be able to simple make them again, but that's not the case because the small undocumented (yet crucial) [know-how](know_how.md) of the people who built the engines decades ago was lost with those individuals who in the meantime died or retired; NASA had to start a ginormous project to reinvent its own relatively recent technology. The same is happening in the field of [programming](programming.md): [modern](modern.md) [soydevs](soydev.md) just CANNOT create as efficient software as hackers back then as due to normalization of wasting computing resources they threw away the knowledge of [optimization](optimization.md) technique and [wisdom](unix_philosophy.md) in favor of bullshit such as "soft skills" and memorizing one billion genders and personal pronouns. One might naively think that e.g. since our agriculture is highly efficient and advanced due to all the immense complexity of our current machines, simple farming without machines would be a child's play for us, however the opposite is true: we no longer know how to farm without machines. If a [collapse](collpase.md) comes, we are quite simply fucked.

*Amara's law* states that people tend to overestimate short-term effects of new technology while underestimating its long-term effects. Any new, emerging groundbreaking technology is followed by hype and we universally like to predict we're about to see the world turned on its head in the span of one to two years, to witness immediate solutions to our most pressing problems and/or a [swift doom](collapse.md) to the entire civilization. Quick changes on global scale, however, occur rarely, if ever -- the initial excitement over a breakthrough in laboratories falls off and then bringing new technology from laboratories to practice (and subsequently spreading it over the whole world) takes decades to centuries. It is said the [future](future.md) is already here, just not distributed uniformly: we already have autonomously driving electric cars with human-like [artificial intelligence](ai.md), but the most common means of personal transport in most of the world is probably still a bicycle. With the discovery of nuclear energy we thought all the world's energy problems would soon be gone, or that a swift nuclear war would take us back to the stone age, and with moonlanding we predicted establishment of Moon cities in a few years and holidays on Mars soon after. Indeed that did not happen, but space technology, such as satellites, now power instantaneous world communication and the one essential part of our everyday lives that not even the sci-fi authors back then predicted: the [Internet](internet.md), that which now affects our mental health, politics and world wide [culture](culture.md) ([memes](meme.md), social networks, ...). We must remember this pattern as it will most likely repeat with currently emerging technology too, such as the general [AI](ai.md), nuclear fusion or [quantum](quantum.md) computing.

## See Also

- [science](science.md)