# Tangram

{ I made a simple tangram game in [SAF](saf.md), look it up if you want to play some tangram. ~drummyfish }

Tangram is an old, simple, yet highly amusing puzzle [game](game.md) wherein the player tries to compose a given shape (presented only by its silhouette) out of elementary geometric shapes such as [triangles](triangle.md) and [squares](square.md). It is a rearrangement puzzle, a 2D game that's in principle similar e.g. to [Soma cube](soma_cube.md), a game in which, similarly, one makes shapes out of basic parts that are however [three dimensional](3d.md). Tangram exploits the fact that from just a handful of building blocks it is possible to construct many thousands of shapes, some resembling animals, people and man made objects. This type of puzzle has been known for many centuries -- the oldest recorded tangram is Archimedes' box (square divided into 14 pieces), over 2000 years old. In general any such puzzle is called tangram, i.e. it is seen as a family of puzzle games, however tangram may also stand for **modern tangram**: one with 7 polygons, originating from 18th century China from where its popularity spread to the west and even briefly sparked a so called "tangram craze" around the year 1818. Unless mentioned otherwise, we'll be talking about this modern version from now on.

```
 _________________
|\_     big     _/|
|  \_   tri   _/  |
|tri_\_     _/    |
| _/   \_ _/  big |
|<_ sqr _X_   tri |
|  \_ _/tri\_     |
|mid \_______\_   |
| tri  \_ para \_ |
|________\_______\|
```

*Divide square like this to get the 7 tangram pieces. Note that the parallelogram is allowed to be flipped when creating shapes as it has no mirror symmetry (while all other shapes do).*

Tangram is a cute, appealing game and [LRS](lrs.md) considers it **one of the best games** as it is beautifully [simple](kiss.md) to make and [learn](easy_to_learn_hard_to_master.md), it has practically no [dependencies](dependency.md) ([computers](computer.md), [electricity](electricity.md), ... not even the sense of sight is strictly required), yet it offers countless hours of [fun](fun.md) and holds potential for gaining deep insight, there is [art](art.md) in shape composition, [math](math.md) in counting possibilities, good exercise for [programmers](programming.md) and much more.

Tangram ordinarily comes as a box with 7 pieces and a number of cards depicting shapes for the player to solve. On its back side each card shows a solution. Some of the shapes are easy to solve and some are very difficult.

```
          _/|
         /  |                           _/|\_
        |\_ |                          /  |  \_
        |  \|                         |   |    \_
        | _/                      _   |   |______\
        |/ \_  ________         _/ \_ | _/ \_
       /     \/       /       _/     \|/     \
       \_   _/_______/      _/         \_   _/
         \_/|              /_____________\_/
        _/  |                  |         _/
      _/    |                  |       _/
    _/      |                  |     _/
  _/        |                  |   _/
 /__________|                  | _/
 \_         |                  |/|
   \_       |                 /  |
     \_     |                 \_ | 
     _/\_   |                  |\|
   _/    \_ |                  |  \_
  /________\|                  |____\
```

*Two tangram shapes: bunny and stork (from 1917 book Amusements in Mathematics).*

{ I found tangram to be a nice practice for **letting go of ideas** -- sometimes you've got a nearly complete solution that looks just beautiful, it looks like THE only one that just has to be it, but you can't quite fit the last pieces. I learned that many times I just have to let go of it, destroy it and start over, usually there is a different, even more beautiful solution. This experience may carry over to practical life, e.g. [programming](programming.md). ~drummyfish }

**Can tangram shapes be [copyrighted](copyright.md)?** As always nothing is 100% clear in [law](law.md), but it seems many tangram shapes are so simple to not pass the threshold of originality that's a prerequisite for copyright. Furthermore tangram is old and many shapes have been published centuries ago, making them public domain, i.e. if you find some very dated, [public domain](public_domain.md) book (e.g. the book *The Fashionable Chinese Puzzle*, *Amusement in Mathematics* or *Ch'i ch'iao hsin p'u: ch'i chiao t'u chieh*) with the shape you want to use, you're most definitely safe to use it. HOWEVER watch out, a collection of shapes, their ordering and/or shapes including combinations of colors etc. may be considered non-trivial enough to spawn copyright (just as collections of colors may be copyrightable despite individual colors not being copyrightable), so do NOT copy whole shape collections.

**Tangram [paradoxes](paradox.md)** are an [interesting](interesting.md) discovery of this game -- a paradox is a shape that looks like another shape with added or substracted piece(s), despite both being composed of the same pieces. Of course geometrically this isn't possible, the missing/extra area is always compensated somewhere, but to a human eye this may be hard to spot (see also [infinite chocolate](infinite_chocolate.md)). New players get confused when they encounter a paradox for the first time, they think they solved the problem but are missing a piece, or have an extra one, while in fact they just made a wrong shape. TODO: example

**Tips for solving**:

- Start by placing pieces you know for certain where they belong (small details that can only be made with the smallest pieces, pieces you deduce that HAVE to be somewhere etc.). This reduces the problem to making a smaller shape from fewer pieces, making it much easier to solve. But BEWARE: sometimes you wrongfully assume some piece in some place because the silhouette "suggests" it, do not fall to this trap.
- At the beginning try to get a sense of scale, sometimes what in the silhouette looks like the big triangle may actually be the middle sized one etc.
- Learn some common patterns, e.g. you can make a rectangle out of the two small triangles and parallelogram. This comes with just solving more puzzles.
- If you have an "almost solution" and can't fit the last few pieces for some time, just destroy it and start over. There are many nicely looking blind paths.
- If in your partial solution you can replace some subshape composed of smaller pieces with the same subshape composed of one larger piece, do it. Having smaller pieces is preferable because you have more flexibility.
- Be careful to make the exact shape you see, sometimes it is possible to make a very similar looking shape that has just a tiny bit different proportions e.g. by rotating the parallelogram.
- ...

TODO: some PD shapes, math, stats, ...

## See Also

- [nonogram](nonogram.md)
- [Soma cube](soma_cube.md)
