# Shader

In [computer graphics](graphics.md) shader is a [program](program.md) running on the [graphics processing unit](gpu.md) (GPU), typically in many parallel instances so as to utilize the GPU's highly parallel nature and so achieve very high processing speed. As such shaders are simple to mid complexity programs. There are different types of shaders based on what kind of [data](data.md) they process -- most worthy of mention are probably fragment (also pixel) shaders that process [pixels](pixel.md) which then end up on the screen -- without explicitly mentioning what kind of shader we are talking about it is usually assumed we mean fragment shaders. The word *shader* is also used more loosely as a synonym for a special visual effect or material look in [3D graphics](3d_rendering.md) (e.g. [games](games.md)), because shaders are usually the means of achieving such effects.

Why is it called a *shader*? Well, probably because these programs were initially very limited and only intended for implementation of shading (i.e. slight brightening/darkening of the surface color to simulate the effects of light), so the name was logical. It stuck and remained even as the power and flexibility of shaders increased to allow doing much more, and this even affected the word *shading* whose meaning is now sometimes extended to include practically any effect applied on the object surface.

Shaders are normally written in a special **shading language** such as [GLSL](glsl.md) in the [OpenGL](opengl.md) [API](api.md), [HLSL](hlsl.md) ([proprietary](proprietary.md)) in [Direct3D](d3d.md) API or the Metal shading language ([proprietary](proprietary.md)) in [Metal](metal.md) API. These languages are often similar to [C](c.md) with some additions (e.g. vector and matrix data types) and simplifications (e.g. no function [recursion](recursion.md) or dynamic memory allocation). High level [frameworks](framework.md) like [Blender](blender.md) many times offer [visual programming](visual_programming.md) (point-n-click) of shaders with graph/node editors.

Initially (basically early [2000s](2000s.md)) shaders were used only for graphics, i.e. to transform 3D vertices, draw triangles and compute pixel colors. Later on as GPUs became more general purpose ([GPGPU](gpgpu.md)), flexibility was added to shaders that allowed to solve more problems with the GPU and eventually general *compute* shaders appeared (OpenGL added them in version  3.3 in 2010).

To put shaders in a bit more context, the flow of data is this: a [CPU](cpu.md) uploads some data (3D models, textures, ...) to the GPU and then issues a draw command -- this makes the GPU start its **[pipeline](pipeline.md)** consisting of different **stages**, e.g. the vertices of 3D models are transformed to screens space (the vertex stage), then triangles are generated and rasterized (the shading stage) and the data is output (on screen, to a buffer etc.). Some of these stages are programmable and so they have their own type of a shader. The details of the pipeline differ from API to API, but in general, depending on the type of data the shader processes (the stage), we talk about:

- **vertex shaders**: Perform per-vertex computations on 3D models, typically their transformation from their world position to the position in the camera and screen space.
- **fragment/pixel shaders**: Compute the final color of each pixel (sometimes called more generally *fragments*), i.e. work per-pixel. A typical use is to perform [texturing](texture.md) and amount/color of reflected light (lighting model).
- **geometry shaders**: Advanced stage, serves to modify the geometry of 3D models (these shaders can, unlike vertex shaders, generate of discard vertices).
- **tesselation shaders**: Advanced stage, serves for subdividing primitives to create smoother geometry.
- **compute shaders**: Perform general computations, used e.g. for computing physics simulations, [AI](ai.md) etc.
- **[ray tracing](ray_tracing.md) shaders** and other specific types
- ...

## See Also

- [GPU](gpu.md)
- [3D rendering](3d_rendering.md)