# Rule 110

*Not to be [confused](often_confused.md) with [rule 34](rule43.md) xD*

Rule 110 is a specific [cellular automaton](cellular_automaton.md) (similar e.g. to [Game of Life](game_of_life.md)) showing a very [interesting](interesting.md) behavior -- it is one of the simplest [Turing complete](turing_completeness.md) (computationally most powerful) systems with a balance of stable and [chaotic](chaos.md) behavior. In other words it is a system of interacting cells wherein a very complex and curious properties emerge from amazingly simple rules. The name *rule 110* comes from [truth table](truth_table.md) that defines the automaton's behavior. Its **extreme simplicity** combined with full computational power is what makes rule 110 of great interest -- for example it can relatively easily be implemented as a [mechanical computer](mechanical.md) using only marbles and a very simple maze (there's a video somewhere on the Internet).

Rule 110 is one of 256 so called elementary [cellular automata](cellular_automaton.md) which are special kinds of cellular automata that are one dimensional (unlike the mentioned [Game Of Life](game_of_life.md) that is two dimensional), in which cells have 1 bit state (1 or 0) and each cell's next state is determined by its current state and the state of its two immediate neighboring cells (left and right). Most of the 256 possible elementary cellular automata are "boring" but rule 110 is special and interesting. Probably the most interesting thing is that rule 110 is [Turing complete](turing_completeness.md), i.e. it can in theory compute anything any other computer can, while basically having just 8 rules. 110 (along with its equivalents) is the only elementary automaton for which Turing completeness has been [proven](proof.md).

For rule 110 the following is a table that dictates the next value of a cell given its current value (center) and the values of its left and right neighbor.

|left|center|right|center next|
|----|------|-----|-----------|
| 0  | 0    | 0   | 0         |
| 0  | 0    | 1   | 1         |
| 0  | 1    | 0   | 1         |
| 0  | 1    | 1   | 0         |
| 1  | 0    | 0   | 1         |
| 1  | 0    | 1   | 1         |
| 1  | 1    | 0   | 1         |
| 1  | 1    | 1   | 0         |

The rightmost column is where elementary cellular automata differ from each other -- here reading the column from top to bottom we get the [binary](binary.md) number 01101110 which is 110 in [decimal](decimal.md), hence we call the automaton rule 110. Some automata behave as "flipped" versions of rule 110, e.g. rule 137 (bit inversion of rule 110) and rule 124 (horizontal reflection of rule 110) -- these are in terms of properties equivalent to rule 110.

Printed below is an output of 32 steps of rule 110 from an initial tape with one cell set to 1. Horizontal dimension represents the tape, vertical dimension represents steps/time (from top to bottom).

```
#
##
###
# ##
#####
#   ##
##  ###
### # ##
# #######
###     ##
# ##    ###
#####   # ##
#   ##  #####
##  ### #   ##
### # ####  ###
# #####  ## # ##
###   ## ########
# ##  ####      ##
##### #  ##     ###
#   #### ###    # ##
##  #  ### ##   #####
### ## # #####  #   ##
# ########   ## ##  ###
###      ##  ###### # ##
# ##     ### #    #######
#####    # ####   #     ##
#   ##   ###  ##  ##    ###
##  ###  # ## ### ###   # ##
### # ## ###### ### ##  #####
# ########    ### ##### #   ##
###      ##   # ###   ####  ###
# ##     ###  ### ##  #  ## # ##
```

The output was generated by the following [C](c.md) code.

```
#include <stdio.h>

#define RULE 110 // 01100111 in binary
#define TAPE_SIZE 64
#define STEPS 32

unsigned char tape[TAPE_SIZE];

int main(void)
{
  // init the tape:
  for (int i = 0; i < TAPE_SIZE; ++i)
    tape[i] = i == 0;

  // simulate:
  for (int i = 0; i < STEPS; ++i)
  {
    for (int j = 0; j < TAPE_SIZE; ++j)
      putchar(tape[j] ? '#' : ' ');

    putchar('\n');

    unsigned char state = // three cell state
      (tape[1] << 2) | 
      (tape[0] << 1) |
      tape[TAPE_SIZE - 1];

    for (int j = 0; j < TAPE_SIZE; ++j)
    {
      tape[j] = (RULE >> state) & 0x01;
      state = (tape[(j + 2) % TAPE_SIZE] << 2) | (state >> 1);
    }
  }

  return 0;
}
```

Discovery of rule 110 is attributed to [Stephen Wolfram](wolfram.md) who introduced elementary cellular automata in 1983 and conjectured Turing completeness of rule 110 in 1986 which was proven by Matthew Cook in 2004.

## See Also

- [Game Of Life](game_of_life.md)
- [Langton's Ant](langtons_ant.md)
- [interaction net](interaction_net.md)
