# Richard Stallman

{ RMS is a legend and overall a great human, but let's be reminded we shouldn't be creating any [heroes](hero_culture.md) or celebrities. ~drummyfish }

The great doctor Richard Matthew Stallman (RMS, also [GNU](gnu.md)/Stallman, chief GNUisance and saint IGNUcius, born 1953 in New York) is one of the biggest figures in [software](sw.md) [history](history.md), inventor of [free (as in freedom) software](free_software.md), its lifelong advocate, founder of the [GNU project](gnu.md), [Free Software Foundation](fsf.md), a great [hacker](hacking.md) and the author of a famous text editor [Emacs](emacs.md) besides others. He is a non-religious [Jew](jew.md) and an [atheist](atheism.md) (though he is the highest saint of [Church Of Emacs](church_of_emacs.md)), a man who firmly stands behind his beliefs, who always acts in conformance with them and who's been advocating for [ethics](ethics.md) and user [freedom](freedom.md) in the computing world. He has also been called the *king of software [cloning](clone.md)* for having started the wave of making free, ethical clones of [proprietary](proprietary.md) programs. He's also notable for a plethora of smaller things such as coming up with the name [POSIX](posix.md) and creating lyrics for the Free Software Song. Stallman doesn't wear a [suit](suit.md), he never shaves and doesn't use a cellphone, he talks even if what he says is unpopular -- if he didn't make history, these things alone would make him one of the most [based](based.md) men of our time. However, on a completely serious note, let's not make [gods out of people](hero_culture.md) -- Richard Stallman also does some very retarded things too, for example he plays along with the [fight culture](fight_culture.md) and started conforming to the [SJW](sjw.md) [newspeak](newspeak.md), thumbs down on that.

```
   _..._
  /   \ \
 (= =  )))
 (.-._ ) ))
 /    \\  \
 ".,,,;,''' 
```

*[ASCII art](ascii_art.md) of Richard Stallman*

Stallman's life along with free software's history is documented by a free-licensed book named *Free as in Freedom: Richard Stallman's Crusade for Free Software* on which he collaborated. You can get it gratis e.g. at [Project Gutenberg](https://www.gutenberg.org/ebooks/5768). You should read this!

Richard Stallman is also famous for having foreseen and foretold virtually all the atrocities that [corporations](corporation.md) were up to with computer technology, such as all the cell phone surveillance, business with personal data and abuse of secrecy and "[intellectual ownership](intellectual_property.md)" of source code for bullying others, though to be honest it doesn't take a genius to [foresee](future.md) that [corporations](corporation.md) will want to rape people as much as possible, it is frankly more surprising he was one of very few who did so. The important thing is he acted promptly as soon as he spotted this -- though corporations indeed did go on to rape people anyway, Richard Stallman made some very important steps early on to make the impact much less catastrophic nowadays, which was thankfully noticed and resulted in a consolidation of his notoriety as a techno prophet. We should be all grateful.

It seems that **Stallman had at least one girlfriend**; in the 1999 book called *Open Sources* he says that he originally wanted to name the [HURD](hurd.md) kernel Alix after a [girl](woman.md) that was at the time his "sweetheart". On his website he further wrote about a girl named Melynda he met in 1995, however noting their love was only platonic.

[tl;dr](tldr.md): At 27 as an employee at [MIT](mit.md) [AI](ai.md) labs Stallman got stuck on trying to fix a Xerox printer whose [proprietary](proprietary.md) software source code was made inaccessible; he quickly recognized this as a sign of evil entering his beloved world of computers. Soon he would also notice the betrayal of [hacker](hacking.md) principles by his fellow programmers who, unlike him, adapted to this new era of proprietary software and who even began writing it themselves -- he realized proprietary software was wrong and presented dangers to [freedom](freedom.md) by forbidding study, improvements and sharing of software, something that easily enabled abuse of software users by tying hands of independent hackers, rendering them unable to fix malicious software. From 1982 onward he was involved in a "[fight](fight_culture.md)" against the Symbolics company that aggressively pushed proprietary software; he was swiftly rewriting their software from scratch (which now we call [cloning](clone.md)) to allow Lisp Machine users more freedom -- by the herculean feat of alone keeping up with the whole team of Symbolics programmers he proved his superior programming skills. By 1983 Stallman's frustration reached its peak and he announced the [GNU](gnu.md) [project](project.md) on [Usenet](usenet.md) -- one to create a completely [free as in freedom](free_software.md) [operating system](os.md), an alternative to the proprietary [Unix](unix.md) system that would offer its users freedom to use, study, modify and share the whole software, in the hacker spirit. He followed by publishing a manifesto and establishing the [Free Software Foundation](fsf.md). GNU and FSF popularized and standardized the term [free (as in freedom) software](free_software.md), [copyleft](copyleft.md) and free licensing, mainly with the [GPL](gpl.md) license. In the [90s](90s.md) GNU adopted the [Linux](linux.md) operating system kernel and released a complete version of the GNU operating system -- these are nowadays known mostly as "Linux" [distros](distro.md). As a head of FSF and GNU Stallman more or less stopped [programming](programming.md) and started traveling around the world to give talks about free software and has earned his status of one of the most important people in software history.

Regarding [software](software.md) Stallman has for his entire life vehemently and tirelessly promoted free software and [copyleft](copyleft.md) and has himself only used free software; he has always practiced his preaching and led the best example of how to live a life without [proprietary](proprietary.md) software. This in itself is an admirable merit and something rare to witness, regardless of whether he ever slipped (which we aren't aware of) or to what degree we agree with all he ever said; his moral strength and integrity is really what makes him special among basically all the other giants of recent decades, it's really as if he comes from a different time when people TRULY internally believed something so much they would die for it, that they wouldn't sell even a small part of that belief for any kind of personal benefit; this is something that really puts him alongside the greatest philosophers such as [Plato](plato.md) or [Socrates](socrates.md) (who followed his own principles so much that he voluntarily died for them).

Stallman stands out also by another characteristic feature -- his way of communication. Someone could blame it on his "[autism](autism.md)", but the truth still stands that he's very rational, consistent, direct and honest about his opinions, he talks calmly, in a quite monotonous voice, without exaggerated gestures, in plain terms and always quickly distills the essence of any subject. And yet his talking isn't boring. He calls things their right names and doesn't resort to populism. What he says is simply intelligible and intelligent, and so he has consolidated his reputation as a good speaker. Now that's not to say he isn't a mere mortal spared of experiencing worse days and weaker moments (the infamous meltdown on stage), but his nature is calmness, logic and honesty, and fear of personal consequences never stands in his way to speak the truth, however uncomfortable (chief example being his comments on [pedophilia](pedophilia.md) that got him [canceled](cancel_culture.md)). This is in stark contrast with other forefront "speakers" who as a matter of rule rely on the form of delivery at least as much (and often more) than the delivered content. Indeed it is very odd that Stallman was able to stand his ground and keep his place among these people despite such "handicap", it goes to prove the ideas he communicates carry value of their own.

[Fun](fun.md) fact: there is a [package](package.md) called *[vrms](vrms.md)*, for virtual RMS, that checks whether you have any non-free packages installed. Ironically it seems to not even tolerate non-free documentation under [GFDL](gfdl.md) with invariant sections, which is very correct but probably not something Stallman himself would do since GFDL is basically his own invention :)

This said, we should still make it clear that indeed we do not nearly agree with all that Richard Stallman says and promotes. For example he isn't too concerned about [bloat](bloat.md) (judging by the GNU software and his own creation, [Emacs](emacs.md)) and he also doesn't care that much about [free culture](free_culture.md) (some of his written works prohibit modification, see [GFDL](gfdl.md)'s "invariant seciotns", and his GNU project allows proprietary non-functional data as long as they are not "software"). Sadly he has also shown signs of being a [type A fail](fail_ab.md) personality by writing about some kind of [newspeak](newspeak.md) "*gender neutral language*" and by seeming to be caught in a [fight culture](fight_culture.md). On his website he also has an [American](usa.md) flag and claims to be a patriot, i.e. leaning to nationalism and therefore [fascism](fascism.md). Nevertheless he definitely can't be accused of populism or hypocrisy as he basically tells what he considers to be the truth no matter what, and he is very consistent in this. Some of his unpopular opinions (mostly those opposing [pedophile](pedophilia.md) witch hunt, with which we DO agree) brought him a lot of trouble and an endless wrath of [SJW](sjw.md)s. For this **he was [cancelled](cancel_culture.md)** and in 2019 was forced to resigned from the position of president of the FSF but continues to support it.

He is a weird guy, looks a bit like PS1 Hagrid, and has been recorded on video eating dirt from his feet before giving a lecture besides others -- another time he was even recorded raging on stage after being stressed out but that's actually odd -- he practically always keeps a calm, monotone, very rational speech (much different from any politician or revolutionary). In the book *Free as in Freedom* he admits he might be slightly [autistic](autism.md). Nevertheless he's extremely smart, has magna [cum](cum.md) laude degree in [physics](physics.md) from Harvard, 10+ honorary doctorates, fluently speaks English, Spanish, French and a little bit of Indonesian and has many times proven his superior programming skills (even though he later stopped programming to fully work on promoting the FSF). He is really good at public speaking, and that despite the mentioned calmness of his speech -- here possibly his inner autism shines because he just speaks in very simple but cold rational and logical ways that everyone from an expert to a complete layman understands, he rarely stops to say something like "ummm... wait", he's just letting out carefully crafted sentences as if you were reading them from a book, showing ways from facts to logical conclusions without cheap rhetoric tricks like wild gesticulation, rising voice or using buzzwords and strong terms. His interviews are however often awkward for the same reasons: it's usually the interviewer asking a question and then waiting 15 minutes for Stallman to print out the whole answer without giving a chance to be interrupted.

Worthy of note is also Stallman's [beautifully](beauty.md) [minimalist](minimalism.md) website at http://www.stallman.org where he actively comments on current news and issues. He also made the famous Free Software Song (well, only the lyrics, the melody is taken from a Bulgarian folk song Sadi Moma) -- he often performs it in public himself (he is pretty good at keeping the weird rhythm of the song while at the same time also singing, that's impressive).

Stallman has been critical of [capitalism](capitalism.md) though he probably isn't a hardcore anticapitalist (he's an [American](usa.md) after all). [Wikidata](wikidate.md) states he's a proponent of [alter-globalization](alter_globalization.md) (not completely against globalization in certain areas but not supporting the current form of it).

In the book *Free As In Freedom* it is also mentioned that **Stallman had aversion to passwords and secrecy in general** -- at MIT he used the username RMS with the same password so that other people could easily log in through his account and access [ARPANET](arpanet.md) (the predecessor of [Internet](internet.md)). Indeed, we applaud this, the "[security](security.md)" hysteria is killing the computing world.

As [anarchists](anarchism.md) we of course resent any worship of people, making [heroes](hero_culture.md) and cults of personalities, but the enormous [historical](history.md) significance of Stallman cannot be overstated, it's a plain and simple fact and though we may frown upon some of his methods and views, it's as clear as it can be that his most crucial actions were [selfless](selflessness.md), in favor of all people -- something that can ever be said about very few, let alone about [Americans](usa.md). A multitude of old time hackers, such as [Eric S. Ramyond](esr.md) and [Rob Pike](rob_pike.md), greedily distanced themselves from talk about ethics and jumped the capitalist train with the first smell of [money](money.md), Stallman stayed opposed to it all, and for this he holds our utmost admiration. Even though in [our days](21st_century.md) his name is overshadowed by rich [businessman](entrepreneurs.md) and creators of commercially successful technology and even though we ourselves disagree with Stallman on some points, in the future [history](history.md) may well see Stallman as perhaps the greatest man of the software era, and rightfully so. Stallman isn't a mere creator of a commercially successful software product or a successful politician, he is an extremely morally strong philosopher, a great example to others, a prophet, someone who sees the truth and hands it to the people -- he brilliantly foresaw the course of events and quickly defined ethics needed for the new era of cheap programmable computers at the right time, before the hammer hit. And not only that, he also managed to coordinate efforts so as to establish this ethics as a standard IN SPITE of all the world's [corporations](corporation.md) [fighting](fight_culture.md) back, in a field that back then was relatively obscure, unpopular in the mainstream and hence not much supported by any mass media. He is also extremely unique in not pursuing personal self interest, in not succumbing to luxury, in TRULY living his own philosophy, dedicating his whole life to his cause and refusing to give in even partially. All of this is at much higher level than simply becoming successful and famous within the contemporary capitalist system, his life effort is pure, true and timeless, unlike things achieved by pieces of shit such as [Steve Jobs](steve_jobs.md).

**Is Richard Stallman a celebrity?** To [us](lrs.md) the question is of importance because we oppose the existence of celebrity status in itself. The answer is likely this: to a certain degree he indeed is a small celebrity (though not nearly a Hollywood scale one, 99% of normal people never heard of him), but at least to a similar level he is just a well known expert in a very important, though obscure area of software ethics. So yes, we ought to dislike the celebrity part -- any worship of a man as god is acceptable only as subject of a [meme](meme.md), we must never see him as a [hero](hero_culture.md) or "leader". He seems to be a very rare case of a mini celebrity that managed to keep a sense of morality despite his fame, perhaps because he never aimed to become famous and his celebrity status, quite uncommonly, came to him rather accidentally, more because he wasn't careful enough to avoid it rather than because he would actively pursue it (which even in his time was rare, and [nowadays](21st_century.md) is probably impossible). This is not an excuse -- if someone resists hard enough, he can never become a celebrity -- but it may be an extenuating circumstance. This is to say: yes, it sucks he's partially a celebrity, but at least one of the least harmful ones.

**Stallman also sucks** just like any other [human](people.md). Some of his sins include: being a [nationalist](nationalism.md) (puts a flag of his country on his website), having totalitarian tendencies (aiming for [GNU](gnu.md) to be the overseer of ethics, a "big brother") and supporting some kind of hierarchy in society, supporting [copyleft](copyleft.md) (perpetuating [copyright](copyright.md) and the "lawyer's game"), supporting [privacy](privacy.md) and other [censorship](censorship.md) as a [means to an end](ends_justify_the_means.md) (e.g. censoring software in repositories for merely not conforming to approved terminology), violating [free culture](free_culture.md) (adding sneaky "invariant sections" to otherwise free documents, making them unfree, also being sensitive/hostile to others incorporating his GNU "brand" without permission), partially being an [SJW](sjw.md) (inventing "gender neutral" pronouns etc.), supporting [hero](hero.md) culture (e.g. calling [Snowden](snowden.md) a "hero"), accepting [bloat](bloat.md), supporting [fight culture](fight_culture.md), practicing [egoism](egoism.md) (putting himself in center of attention by accepting the role of chief GNUisance, ruining [anarchist](anarchism.md) culture by sustaining the politician's game ("go vote for X!", "I support this candidate!", ...), demonstrating evil through [humorwashing](humorwashing.md), also seeming to overestimate the quality of his [jokes](jokes.md) sometimes), [being fat](body_shaming.md) (oh sorry, "horizontally challenged") and more.

## See Also

- [John Gilmore](john_gilmore.md)
- [Alexandre Oliva](alexandre_oliva.md)
- [Jesus](jesus.md)
- [Hagrid](hagrid.md)
- [Einstein](einstein.md)
- [vrms](vrms.md)
- [gentoo](gentoo.md)
- [Linus Torvalds](torvalds.md)
- [Alan Cox](alan_cox.md)
- [Larry Wall](larry_wall.md)
- [people](people.md)