# Quake

Quake, released in [1996](90s.md) (as [shareware](shareware.md), originally for [DOS](dos.md) and [Winshit](windows.md)), is one of the best and most influential first man video [games](game.md) ever produced, released as the next big game by the creators of [Doom](doom.md) (Id Software), notable not only for once again pushing [3D graphics](3d_rendering.md) yet to another level, but equally so for introducing gameplay, mechanics and even "accidental features" ([bugs](bug.md)) that practically started a new genre. The original game has since been spawning sequels: Quake II (1997), [Quake III](quake3.md) Arena (1999, purely multiplayer), Quake IV (2005), Quake Live (2014, basically Quake III HD) and Quake Champions (2022, [shit](shit.md) that practically killed the series). This article will mostly focus on the original game as it's most notable and very technologically [interesting](interesting.md).

{ Some online resources on Quake: https://quakewiki.org/wiki/, https://www.gamers.org/dEngine/quake/. ~drummyfish }

Of course the game is [proprietary](proprietary.md), but the [engine](game_engine.md) was later released as [free software](free_software.md) under [GPL](gpl.md), which gave birth to a plethora of source ports and even completely [libre](libre.md) games such as [Xonotic](xonotic.md). This is one reason for why there are still big fan communities around Quake to this day, mainly centered around competitive multiplayer and [speedrunning](speedrun.md).

Upon its release Quake was a hit -- maybe not as huge as [Doom](doom.md), but that's perhaps only because Doom came first, struck like lightning and had little competition. Unlike Doom, Quake also wasn't universally revolutionary, its single player, enemies and [music](music.md) weren't as memorable, but the more innovation it brought in the area of [graphics](graphics.md) and competitive multiplayer where fast, skillful movement was as key to success as accurate aim. While Doom utilized a "[primitive/pseudo 3D](primitive_3d.md)" graphics with 2D enemy [sprites](sprite.md) and limitations imposed on level geometry, Quake engine implemented what we now call a "full/true 3D", i.e. it allowed unrestrained camera rotation and levels featuring all kinds of shapes, including sloped floor and ceiling, rooms above other rooms, walls moving in any direction etc. Still by [historical](history.md) significance this has now been overshadowed by an incredibly addictive player movement mechanisms that Quake invented (partially through [bugs](bug.md) that turned out to add to the gameplay), a formula that's still being replicated today. In Quake movement is [art](art.md) and [science](science.md) in itself and this went as far as to spawning entire communities that essentially modded the game to become a racing game without any shooting, purely focusing on movement (see the *defrag* mods). Most notable are such techniques as *bunny hopping* (jumping during movement, increasing speed), *strafe jumping* (turning diagonally when bunny hopping, adding velocity, which actually wasn't intended by developers), *rocket jumping* (shooting rockets under own feet to jump higher), *circle jumping*, *air control*, landing on slopes to gain speed, and there are many more.

Just like with Doom, the game's plot is simple and gives way to gameplay, it revolves around some kind of badass soldier (the player) stopping an invasion led by an extraterrestrial oppressor codenamed *Quake*. The game's atmosphere is dark, medieval, violent and scary, emphasizing brutality and gore, visibly influenced by H. P. Lovecraft. Iconic were also the weapons of which there weren't many (8 in total), but which were very diverse. Each weapon had a specific use and most of them became a standard arsenal of [arena shooter games](afps.md), notably the shotgun, rocket launcher, grenade launcher and lightning gun.

## Code And Technical Details

In general the game is no longer as nice in its internals as Doom was, creeping of mainstream [capitalist](capitalism.md) [bullshit](bullshit.md) already started to show here.

The original system requirements were 8 MB of [RAM](ram.md), 80 MB of hard drive space and a 75 MHz [CPU](cpu.md).

The engine, also known as *Id Tech 2*, is written in [C89](c.md). The original source code release has just short of 100 [KLOC](loc.md). That's no longer really [suckless](suckless.md). The code itself looks alright, has consistent formatting and [comments](comment.md). The game was developed on [NeXTSTEP](nextstep.md). The engine is built around client-server architecture and allows a multiplayer of up to 32 players.

Quake engine features one highly embarrassing feature: a kind of [scripting](script.md) language called [QuakeC](quakec.md) (see also [HolyC](holyc.md)). This language compiled to [bytecode](bytecode.md) and allowed to mod the game without recompiling the engine (a feature that Doom engine lacked), which sounds cool and all, but it's [shit](shit.md): it's a new language, new compiler and huge [bloat](bloat.md).

Sadly the game also uses [float](float.md), another thumbs down.

The engine is also **fucking [nondeterministic](determinism.md)**, mainly because its physics is FPS dependent (huge brain fart), but even if that was fixed it might not suffice e.g. because of the use of floating point (as C specification leaves room for floating point nondeterminism).

And as if that wasn't enough, the [demo](demo.md) format sucks ass too. Whereas demos in Doom only recorded the player's inputs -- the way it should always be done -- Quake demos literally store the player states such as his positions etc. It's practically a recording of packets sent from the [server](server.md) to the client. This means the demos are larger, [information](information.md) about input is lost (causing trouble in verifying speedruns for example) and the demo is only playable from point of view it was recorded from. This desperate and disastrous design choice had to be made because the engine is nondeterministic. Here we can see how a bad programming choice quickly snowballs into a gigantic pile of shit.

As for the **3D rendering**: this is probably the nicest part. The engine features a beautifully looking [software renderer](sw_rendering.md) that was very fast ([optimized](optimization.md) in [assembly](assembly.md)). It supported [256](256.md) [colors](color.md) and by default ran in 320x200 resolution that computers back then could handle at 30 FPS. Shortly after the game's release new versions added a support for [GPU](gpu.md) acceleration with [OpenGL](opengl.md), which was of course faster, additionally supported 16 and 32 bit color, higher resolution and pimped up look (transparent water, [bilinear](bilinear.md) texture filtering that actually looks inferior and soulless, ...). We'll be however focusing on the software renderer. It used [Gouraud](gouraud.md) [shading](shading.md) for moving objects (enemies, doors, ...) and precomputed [lightmaps](lightmap.md) for static environment. Just like Doom, [BSP](bsp.md) trees were still used to represent levels, however in Quake they were 3D (while in Doom only 2D). The renderer worked as follows. First [frustum culling](frustum_culling.md) was performed on the BSP tree, removing anything not in the direction of the camera. Secondly there were precalculated potentially visible sets ([PVS](pvs.md)) -- a [data structure](data_structure.md) storing information about which BSP leaves are visible from other leaves, allowing for saving time by disregarding most parts of the level that can't be seen -- this was applied after frustum culling. Backface culling followed and then rasterization itself in front-to-back order. Rasterization was made so as to eliminate overdraw, it was quite complex, based on scanlines formed by projected geometry edges. As another improvements against the Doom engine there were simple [particle systems](particle_system.md) (well, literally just tiny squares), real-time lighting, warping screen effects and fully 3D animated enemy models. Animated models used a MDL format which stored simple vertex animation (no skeletal bullshit) -- the frames were just played one after another without [interpolation](interpolation.md), resulting in a "jerky" animation. Needless to say the models were quite [low poly](low_poly.md) (monsters usually around 300 [triangles](triangle.md)) and had quite low-res textures (around 300x200 pixels).

## See Also

- [Doom](doom.md)
- [Duke 3D](duke3d.md)
- [Chasm the Rift](chasm_the_rift.md) (contemporary, less well known competitor)