# Pseudominimalism

Pseudominimalism is a kind of [technology](tech.md) design (of which most guilty is probably [computer](computer.md) technology, i.e. [hardware](hw.md) and [software](sw.md)) which aims to appear [minimalist](minimalism.md) but in fact isn't, typically by putting on a minimalist appearance while concealing highly [bloated](bloat.md) internals; but different types of pseudominimalism exist too, all revolving around undeservedly associating themselves with minimalism. Rather than trying to achieve a [truly good](lrs.md), minimalist design from the ground up, with all its advantages, pseudominimalism merely attempts to hide the ugliness of its internals and appeal purely by the looks: it's an attempt at deception, [marketing](marketing.md) and exploitation of trends (a kind of "minimalismwashing"), not an aim at creating good technology. A typical example might be a website with minimalist graphic design -- a blank background with sans-serif [font](font.md) and a couple of "clean", simple, razor sharp [vector](vector.md) icons -- which in the background sneakily uses dozens of [JavaScript](js.md) frameworks and libraries and requires a high end [CPU](cpu.md) in order to even appear responsive. Essentially all [modern](modern.md) "retro" video [games](game.md) are pseudominimalist in design, they use pixelated graphics but are created in enormous frameworks such as [Unity](unity.md) or [Godot](godot.md); even projects calling themselves "minimalist", such as many [fantasy consoles](fantasy_console.md), are in truth only pseudominimalist, written in extremely high level languages such as [JavaScript](javascript.md). [Apple](apple.md) is heavily practicing pseudominimalism. Many [SJWs](sjw.md) also.

While true minimalists do appreciate minimalist look as well (because in their world it's a natural consequence of good design and as a result a sign of minimalism they over time learn to look for and appreciate), pseudominimalists are obsessed with visuals, the casing, the shell and that is their true goal to which they sacrifice the internal beauty, so after a while you learn to spot pseudominimalists just by their attempts at what they call a "clean design" or "user experience" -- a true minimalist uses minimalism so that bullshit doesn't stands in his way, a **pseudominimalist is just a snob** using visuals to pretend he's an intellectual or, as he loves to say, an "artist". Over time you learn to smell the sweat poured into font choice, spacing of paragraphs and choice of color palettes, eventually leaking even to [natural language](human_language.md) he uses to communicate (usually on the detriment of communication) in which he tries to use minimum of words which just makes it hard to understand what he wants to say. A typical example is the [shitty 100r wiki](xxiivv.md). Pseudominimalist thinks calling a link to the main page "main page" is too mainstream, so he calls it just "m" or something like that.

A different example of pseudominimalism is demonstrated by great many "[modern](modern.md)" [CLI](cli.md) programs which [code monkeys](coder.md) use to impress their [YouTube](youtube.md) audience or to feel like matrix haxors. Some people believe that anything running in the command line has to be minimalist by a law of nature -- this is less and less true as we progress into the [future](future.md). A lot of [capitalist software](capitalist_software.md) adds a CLI interface ex post **on top** of an already bloated program (they even invented a term for this: "[headless](headless.md)"), often by simply disabling [GUI](gui.md) (but leaving all its [dependencies](dependency.md) in). An example may be the [gomux](gomux.md) chat client. Similarly many window managers demonstrate pseudominimalism by "looking minimalist", as in having thin 1 pixel borders for windows, flat colors, pixel art fonts etc., while in fact being bloated as hell under the hood. A very cheap trick used to impress retards is [rendering 3D graphics](3d_rendering.md) in terminal with [ASCII graphics](ascii_graphics.md), which is the easiest thing in the world to do, but for some reason people around 110 IQ wet themselves seeing anything rendered with ASCII.

Another form of pseudominimalism is **making a minimalist tool for something that in itself is a non-minimalist [bullshit](bullshit.md)** -- for example minimalist frontend for Facebook, minimalist Steam client, minimalist password manager, minimalist [Bitcoin](bitcoin.md) wallet etc.

Yet another type of pseudominimalist software is that which **objectively isn't too complex, but is still too complex for the task it's solving**. Typical example are static website generators. Too many people fall for them when in fact you either do NOT need a website generator at all (you can just manually write a website, design it so that everything is on a single page, linked together by anchors for example), OR, if there really is a truly justified need for a whole multipage website with navigation etc., one can easily write a shell script using only absolutely basic [Unix](unix.md) utilities, generating websites is only about appending text to another text (which is done with [cat](cat.md)), HTML parsers are NOT needed at all, and one can even easily generate [RSS](rss.md) and other fancy stuff. { As an exercise I made such a generator, turned out to be about 40 lines of shell code, written in under an hour. ~drummyfish } Another example are various note taking "apps" (text editor is literally enough for taking notes), password managers etc.

And that's not all -- another kind of pseudominimalism appearing among the new generation of crippled pseudoprogrammers is all about **writing very few [lines of code](loc.md) in an incredibly bloated language** and calling that "minimalism". Something like a *Minecraft clone in 100 LOC of Python using only Python standard library*, the catch of course being that [Python](python.md) itself is hugely bloated and its standard library is enormous, therefore they just hide all the complexity out of view. Effort like that is indeed completely useless and only serves for flexing in front of beginners who can't spot the obvious trick. Even if obvious, it has to be noted that **minimalist software cannot be written in a bloated language** (or using a bloated library, framework etc.).