# Open $ource

*"[Micro$oft](microsoft.md) <3 open $ource"*

Open source (OS, also *Open $ource*) is a [capitalist](capitalism.md) movement, in recent years degraded to a mere brand, [forked](fork.md) from the [free software movement](free_software.md); it is advocating at least partial "openness", i.e. strategic sharing of design parts with the public and allowing unpaid volunteer contributors from the public to take part in [software](sw.md) and [hardware](hw.md) development; though technically and legally the definition of *open source* is mostly identical to [free (as in freedom) software](free_software.md), in practice and in spirit it couldn't be more different as for **abandoning the goal of [freedom](freedom.md) and [ethics](ethics.md) in favor of business** (to which ethics is an obstacle), due to which [we](lrs.md) see open source as inherently [evil](evil.md) and recommend following the free software way instead. [Richard Stallman](rms.md), the founder of free software, distances himself from the open source movement. Fascist organizations such as [Microsoft](microsoft.md) and [Google](google.md), on the other hand, embrace open source (while restraining from using the term *free software*) and slowly shape it towards their goals. Open source is a short for "yes, it will abuse you, but at least you can read its source code." The term [FOSS](foss.md) is sometimes used to refer to both free software and open source without expressing any preference.

Open source unfortunately (but unsurprisingly) became absolutely prevalent over free software as it better serves [capitalism](capitalism.md) and abuse of people, and its followers are more and more hostile towards the free software movement. This is very dangerous, [ethics](ethics.md) and focus on actual user freedom is replaced by shallow legal definitions that can be bypassed, e.g. by [capitalist software](capitalist_software.md) and [bloat monopoly](bloat_monopoly.md). In a way open source is capitalism reshaping free software so as to weaken it and eventually make its principles of freedom ineffective. Open source tries to shift the goal posts: more and more it offers only an illusion of some kind of ethics and/or freedom, it pushes towards mere partial openness ("open source" for proprietary platforms), towards high complexity, inclusion of unethical business-centered features ([autoupdates](autoupdate.md), [DRM](drm.md), ...), high interdependency, difficulty of utilizing the rights granted by the license, exclusion of developers with "incorrect" political opinions or bad brand image etc. In practice open source has become something akin to a mere **brand** which is stick to a piece of software to give users with little insight a feeling they're buying into something good -- this is called **[openwashing](openwashing.md)**. This claim is greatly supported by the fact that corporations such as [Microsoft](microsoft.md) and [Google](google.md) widely embrace open source ("Microsoft <3 open source", the infamous [GitHub](github.md) acquisition etc.).

"Open source" as a term and brand arose by the group of capitalists, such as [Linus Torvalds](linus_torvalds.md) and [Eric. S. Raymond](esr.md) (author of [The Cathedral And Bazaar](bazaar.md), a guide of how to exploit programmers to maximize profit), who were at the time part of the [free software movement](free_software.md) but at the same time felt great sadness that they couldn't make enough money on something that's focused on ethical goals. At the beginning of 1998 some of these businessmen held a meeting in Palo Alto with the goal of shifting the goal posts where one of them -- allegedly Christine Peterson (a [woman](woman.md)) -- suggested the term "open source" (other alternatives were e.g. "sourceware") which then passed by vote. Consequently the next month the *Open Source Initiative* ([OSI](osi.md)), a new propaganda organization, was formed, with Raymond as its president. Sadly most of the self proclaimed "anticapitalist rebels" among [zoomers](zoomer.md) aren't even aware of this recent history and happily follow this purely capitalist movement, use the terms *open source*, embrace and use anything with the *open source* sticker on it, use [GitHub](github.md) etc., thinking they're "opposing something". This is exactly what Open Source wanted to achieve, a false sense of rebellion that will actually make most programmers do their bidding.

*"**Free and Open Source**: it is completely **FREE OF COST** and **ALMOST ALL** of its components are open source."* --GNU/Linux [Mint](mint.md)'s website already marketing partially proprietary system as "open source" and purposefully misusing the word "free" to mean "gratis" (February 2024)

{ Mint also hilariously markets itself as [KISS](kiss.md) lol. My friend suggested they only implemented the "stupid" part of it :-) ~drummyfish }

One great difference of open source with respect to free software is that **open source doesn't mind proprietary dependencies and only "partially open" projects** (see also [open core](open_core.md)): [Windows](windows.md) only programs or [games](game.md) in [proprietary](proprietary.md) engines such as [Unity](unity.md) are happily called open source -- this would be impossible in the context of free software because as [Richard Stallman](rms.md) says software can only be free if it is free as a whole, it takes a single proprietary line of code to allow abuse of the user. The "open source" communities nowadays absolutely **don't care a bit about [freedom](freedom.md) or [ethics](ethics.md)** (the majority of open source supporting zoomers most likely don't even know there was ever any connection), many "open source" proponents even react aggressively to bringing the idea of [ethics](ethics.md) up. "Open source" communities use locked, abusive proprietary platforms such as [Discord](discord.md), Google cloud documents and [Micro$oft's](microsoft.md) [GitHub](github.md) to create software and collaborate -- users without Discord and/or GitHub account often aren't even offered a way to contribute, report bugs or ask for support. There are plenty of "open source" [projects](project.md) that are just meant to be part of a mostly proprietary environment, for example the [Mangos](mangod.md) implementation of [World of Warcraft](wow.md) server, which of course has to be used with the proprietary WoW client and with proprietary server assets, which gives Blizzard (the owner of WoW) complete legal control over any server running on such an "open source" server (such servers always only rely on Blizzard temporarily TOLERATING their small noncommercial communities, despite Blizzard having taken some of them down with legal action) -- calling such a project "free software" in this context would just sound laughable, so they rather call it "open source", i.e. "no, there is no freedom, but the source is technically open". Lately you will even see more and more people just calling any software/project "open" as long as some part of its source code is [available](source_available.md) for viewing on GitHub, no matter the license or any other considerations (see e.g. "open"geofiction etc.).

The open source definition is maintained by the [Open Source Initiative](osi.md) (OSI) -- they define what exactly classifies as open source and which [licenses](license.md) are compatible with it. These licenses are mostly the same as those approved by the [FSF](fsf.md) (even though not 100%). The open source definition is a bit more complex than that of free software, in a nutshell it goes along the lines:

1. The license has to allow **free redistribution** of the software without any fees.
2. **Source code must be freely available**, without any [obfuscation](obfuscation.md).
3. **Modification of the software must be allowed** as well as redistribution of these modified versions under the same terms as the original.
4. **Direct modification may be forbidden only if [patches](patch.md) are allowed**.
5. **The license must not discriminate against people**, everyone has to be given the same rights.
6. **The license must not discriminate against specific uses**, i.e. use for any purpose must be allowed.
7. **The license applies automatically** to everyone who receives the software with the license.
8. **The license must apply generally**, it cannot be e.g. limited to the case when the software is part of some larger package.
9. **The license must not restrict other software**, i.e. it cannot for example be forbidden to run the software alongside some other piece of software.
10. **The license must be technology neutral**, i.e. it cannot for example limit the software to certain platform or API.

Besides this main legal definition open source is also a cult that comes with its own rituals and ways of thinking, again, mostly harmful ones like embracing [update culture](update_culture.md) which allows the overlords to push something to people and then keep [reshaping it silently](slowly_boiling_the_frog.md) with "updates" as they're using it (see e.g. the infamous [xz](xz.md) incident in [Linux](linux.md)).

Open source also colossally fails on other fronts, e.g. for example by not accepting [CC0](cc0.md) as a valid license and not accepting [esoteric programming languages](esolang.md) (because they're "obfuscated"). All in all, avoid open source, support [free software](free_software.md).

## See Also

- [openwashing](openwashing.md)
- [shitword](shitword.md)
- [free software](free_software.md)
- [open core](open_core.md)
- [source available](source_available.md)
- [license](license.md)