# Often Confused Terms

There exist many terms that are highly similar and can legitimately be used interchangeably in various contexts. This isn't wrong, a slight difference may be insignificant in ordinary conversation and so the list here may also serve as a list of synonyms, considering a synonym is defined as a word of SIMILAR meaning (it is very rare for two distinct words to have exactly the same meaning). However it's crucial to stress that we must at least be aware of the fact that the slight differences do exist, for the sake of the cases where they matter (such as technical specifications etc.). The list below attempts to document some of the often confused/similar terms. This is NOT a nitpicking list for people to go "ACKCHUALY" every time someone uses a slightly incorrect word, it's here to make us aware that in some special cases we should take a little extra time to think through which word to use to prevent misunderstanding.

- **[0](zero.md)** vs **O** vs **o**
- **[1](one.md)** vs **[I](i.md)** vs **l** vs **[|](pipe.md)**
- **1bit** vs **black and white** vs **grayscale** vs  **monochromatic**
- **[1D](1d.md)** vs **[2D](2d.md)** vs **[2.5D](pseudo3d.md)** vs **[3D](3d.md)** (e.g. 2D function vs 3D function, 1D raycasting vs 2D raycasting, ...)
- **[abstract](abstraction.md)** vs **[virtual](virtual.md)** vs **non-existent**
- **academia** vs **[science](science.md)** vs **[soyence](soyence.md)**
- **[address](address.md)** vs **[pointer](pointer.md)** vs **[reference](reference.md)** vs **[index](index.md)** vs **[vector](vector.md)**
- **[AI](ai.md)** vs **[machine learning](machine_learning.md)** vs **[neural networks](neural_net.md)** vs **[LLM](llm.md)**
- **[algebra](algebra.md)** vs **[arithmetic](arithmetic.md)** vs **[math](math.md)** vs **[logic](logic.md)**
- **[algorithm](algorithm.md)** vs **[program](program.md)** vs **[process](process.md)** vs **[heuristic](heuristic.md)** vs **[source code](source_code.md)** vs **[software](sw.md)**
- **[algorithm](algorithm.md)** vs **[logarithm](logarithm.md)** lol
- **aliquot divisor** vs **divisor** vs **proper divisor** vs **[prime](prime.md) divisor**
- **America** vs **[USA](usa.md)**
- **[anagram](anagram.md)** vs **[palindrome](palindrome.md)**
- **[analog](analog.md)** vs **[mechanical](mechanical.md)** vs **non-electronic**
- **[anarchy](anarchism.md)** vs **[chaos](chaos.md)**
- **[argument](argument.md)** vs **[parameter](parameter.md)** vs **formal parameter** vs **variable**
- **[array](array.md)** vs **[list](list.md)** vs **[vector](vector.md)** vs **[tuple](tuple.md)** vs **[string](string.md)** vs **[set](set.md)** vs **[class](class.md)** vs **[multiset](multiset.md)**
- **[ASCII](ascii.md)** vs **[plain text](plain_text.md)** vs **[Unicode](unicode.md)** vs **[UTF](utf.md)** vs **[ANSI](ansi.md)**
- **[ASCII art](ascii_art.md)** vs **[ANSI art](ansi_art.md)** vs **[Unicode](unicode.md) art** vs **ASCII graphics** vs **[TUI](tui.md)**
- **[asceticism](asceticism.md)** vs **[minimalism](minimalism.md)** vs **[frugality](frugality.md)** vs **poverty** vs **[pseudominimalism](pseudominimalism.md)** vs **[KISS](kiss.md)** vs **[lightweight](lightweight.md)** vs **[suckless](suckless.md)** vs **[Unix philosophy](unix_philosophy.md)** vs **[LRS](lrs.md)**
- **[assembler](assembler.md)** vs **[assembly](assembly.md)** vs **[machine code](machine_code.md)** vs **[bytecode](bytecode.md)**
- **asterisk** vs **asterix** :D
- **[astrology](astrology.md)** vs **[astronomy](astronomy.md)**
- **[attribution](attribution.md)** vs **[credit](credit.md)**
- **automatization** vs **automation**
- **binary** vs **[executable](executable.md)** vs **[program](program.md)**
- **[binary](binary.md)** vs **[boolean](boolean.md)**
- **[binary](binary.md)** vs **[digital](digital.md)** vs **[electronic](electronics.md)**
- **[biocomputing](biocomputing.md)** vs **[bioinformatics](bioinformatics.md)** vs **computational biology**
- **bisexual** (normal) vs **[gay](gay.md)** (not normal)
- **[bitmap](bitmap.md)** vs **image**
- **[black](black.md) [race](race.md)** vs **[nigger](nigger.md)** vs **[negro](negro.md)** vs **afroamerican**
- **[booting](boot.md)** vs **turning on**
- **[brainwashing](brainwashing.md)** vs **[education](education.md)** vs **[indoctrination](indoctrination.md)**
- **[branchless](branchless.md) programming** vs **ifless programming**
- **brightness** vs **intensity** vs **value** vs **lightness** vs **luma** vs **luminance** vs **radiance** and all this kind of crazy stuff :D
- **[brute force](brute_force.md)** vs **[heuristic search](heuristic_search.md)** vs **[trial and error](trial_and_error.md)**
- **[buffer](buffer.md)** vs **[cache](cache.md)** vs **[cash](money.md)**
- **[bug](bug.md)** vs **[glitch](glitch.md)** vs **[error](error.md)** vs **[exception](exception.md)** vs **[fault](fault.md)** vs **[failure](fail.md)** vs **[defect](defect.md)**
- **[byte](byte.md)** vs **octet** vs **word**
- **[capital](capital.md)** vs **[money](money.md)** vs **wealth**
- **cash** vs **[currency](currency.md)** vs **[money](money.md)**
- **[calculator](calculator.md)** vs **[computer](computer.md)**
- **[calculus](calculus.md)** vs **mathematical analysis**
- **call** vs **command** vs **request** vs **statement** vs **[expression](expression.md)** vs **[function](function.md)** vs **control structure** vs **operator**
- **[causation](causation.md)** vs **[correlation](correlation.md)** (le [reddit](reddit.md) scientist rule)
- **[cepstrum](cepstrum.md)** vs **[spectrum](spectrum.md)**
- **[CGI](cgi.md)** vs **VFX**
- **chan board** vs **image board** vs **text board**
- **change** vs **[progress](progress.md)**
- **[chaos](chaos.md)** vs **[randomness](random.md)** vs **[pseudorandomness](pseudorandom.md)** vs **[quasirandomness](quasirandomness.md)** vs **[entropy](entropy.md)** vs **[statistics](statistics.md)** vs **[probability](probability.md)** vs **[stochasticity](stochastic.md)**
- **[character](char.md)** vs **letter** vs **glyph** vs **[phoneme](phoneme.md)** vs **phone** vs **symbol**
- **[cheater](cheating.md)** vs **[cracker](cracking.md)** vs **[hacker](hacking.md)** vs **[programmer](programmer.md)**
- **[checksum](checksum.md)** vs **[hash](hash.md)** vs **[ID](id.md)** vs **[index](index.md)** vs **[token](token.md)** vs **[handle](handle.md)** vs **[identifier](identifier.md)**
- **chroma** vs **saturation** vs **colorfullness**
- **cl** vs **d**
- **[CLI](cli.md)** vs **[TUI](tui.md)** vs **[terminal](terminal_emulator.md)** vs **[console](console.md)** vs **[shell](shell.md)** vs **[TTY](tty.md)**
- **[clipping](clipping.md)** vs **[culling](culling.md)** vs **[pruning](pruning.md)**
- **[closed source](closed_source.md)** vs **[proprietary](proprietary.md)**
- **[cloud](cloud.md)** vs **[server](server.md)**
- **[college](college.md)** vs **[university](university.md)**
- **[color model](color_model.md)** vs **[color space](color_space.md)** vs **[palette](palette.md)** vs **[gamut](gamut.md)**
- **[computation](computation.md)** vs **[computing](computing.md)**
- **[communism](communism.md)** vs **[Marxism](marxism.md)** vs **[socialism](socialism.md)**
- **[complex](complexity.md)** vs **[complicated](complicated.md)**
- **[complex number](complex_number.md)** vs **[imaginary number](imaginary_number.md)**
- **[computability](computability.md)** vs **[decidability](decidability.md)**
- **[computer language](computer_language.md)** vs **[programming language](programming_language.md)**
- **[computer science](compsci.md)** vs **[information technology](it.md)** vs **[informatics](informatics.md)** vs **[cybernetics](cybernetics.md)** vs **[computer engineering](computer_engineering.md)** vs **[software engineering](software_engineering.md)**
- **[compatibility layer](compatibility_layer.md)** vs **[emulator](emulator.md)** vs **[virtual machine](vm.md)** vs **simulator**
- **compositing** vs **composition** (in computer [art](art.md) and [graphics](graphics.md))
- **[comun](comun.md)** vs **[conum](conum.md)**
- **[concatenative](concatenative.md) language** vs **[stack](stack.md) based language**
- **[concurrency](concurrency.md)** vs **[parallelism](parallelism.md)** vs **[quasiparallelism](quasiparallelism.md)** vs **[distribution](distributed.md)**
- **[conjecture](conjecture.md)** vs **[hypothesis](hypothesis.md)** vs **[theory](theory.md)** vs **[theorem](theorem.md)** vs **[lemma](lemma.md)**
- **[consciousness](consciousness.md)** vs **[free will](free_will.md)** vs **self awareness** vs **thinking** vs **[life](life.md)** vs **creativity** vs **intelligence** etc.
- **[constant](constant.md)** vs **[literal](literal.md)** vs **immediate operand** vs **[macro](macro.md)**
- **[coding](coding.md)** vs **[programming](programming.md)** vs **[software engineering](software_engineering.md)**
- **[codec](codec.md)** vs **[container format](container_format.md)**
- **[coherence](coherence.md)** vs **[consistency](consistency.md)**
- **[computational model](computational_model.md)** vs **[model of computation](model_of_computation.md)**
- **computer language** vs **[programming language](programming_language.md)**
- **[convolution](convolution.md)** vs **[correlation](correlation.md)**
- **coordinate** vs **coordination**
- **[copyright](copyright.md)** vs **[patent](patent.md)** vs **[trademark](trademark.md)** vs **[intellectual property](intellectual_property.md)** vs **[moral right](moral_rights.md)** etc.
- **[crossplatform/multiplatform](multiplatform.md)** vs **[portable](portability.md)**
- **[cryptocurrency](crypto.md)** vs **digital currency** vs **virtual currency**
- **[cryptography](cryptography.md)** vs **[security](security.md)** vs **[privacy](privacy.md)** vs **[encryption](encryption.md)**
- **[cynicism](cynicism.md)** vs **[pessimism](pessimism.md)**
- **[dark web](dark_web.md)** vs **[deep web](deep_web.md)** vs **dark net** vs **deep net**
- **[data](data.md)** vs **[information](information.md)** vs **[entropy](entropy.md)** vs **[signal](signal.md)**
- **[data structure](data_structure.md)** vs **[data type](data_type.md)**
- **[decentralized](decentralization.md)** vs **[distributed](distributed.md)**
- **[declaration](declaration.md)** vs **[definition](definition.md)** vs **initialization**
- **[demo](demo.md)** vs **[intro](intro.md)**
- **[democracy](democracy.md)** vs **[voting](voting.md)**
- **demonstration** vs **[proof](proof.md)**
- **[desktop environment](de.md)** vs **[window manager](wm.md)** vs **[windowing system](windowing_system.md)**
- **[derivative](derivative.md)** vs **[differential](differential.md)**
- **[discretization](discretization.md)** vs **[quantization](quantization.md)**
- **disc** vs **disc**
- **display** vs **screen** vs **monitor**
- **[duck typing](duck_typing.md)** vs **[weak typing](weak_typing.md)** vs **[dynamic typing](dynamic_typing.md)** vs **[no typing](untyped.md)**
- **[digit](digit.md)** vs **[number](number.md)** vs **[value](value.md)** vs **figure** vs **numeral**
- **[directed acyclic graph](dag.md)** vs **[tree](tree.md)**
- **[directory](directory.md)** vs **[folder](folder.md)**
- **[discrete Fourier transform](dft.md)** vs **[discrete time Fourier transform](dtft.md)**
- **[distro](distro.md)** vs **[GNU](gnu.md)/Linux** vs **[Linux](linux.md)** vs **[GNU](gnu.md)** vs **[Unix](unix.md)** vs **Unix-like**
- **[dynamic recompilation](dynamic_recompilation.md)** vs **[just in time compilation](jit.md)**
- **dynamic typing** vs **weak typing**
- **[electric](electricity.md)** vs **[electronic](electronics.md)**
- **electronic game** vs **[video game](video_game.md)**
- **[emoticon](emoticon.md)** vs **[emoji](emoji.md)** vs **[smiley](smiley.md)**
- **[emulation](emulation.md)** vs **[simulation](simulation.md)**
- **[encryption](encryption.md)** vs **[security](security.md)** vs **[privacy](privacy.md)**
- **[entity](entity.md)** vs **[object](object.md)**
- **[equation](equation.md)** vs **[expression](expression.md)** vs **[inequality](inequality.md)** vs **statement**
- **[equivalence](equivalence.md)** vs **[implication](implication.md)**
- **[ethics](ethics.md)** vs **[morality](morality.md)**
- **[Euler's number](e.md)** vs **[Euler number](euler_number.md)**
- **[evolutionary programming](evolutionary.md)** vs **[evolutionary algorithm](evolutionary.md)** vs **[genetic programming](genetic_programming.md)** vs **[genetic algorithm](genetic_algorithm.md)**
- **[equality](equality.md)** vs **[identity](identity.md)** (in programming languages)
- **[fail safe](fail_safe.md)** vs **safe** vs **[secure](security.md)** vs **robust** vs **reliable** vs **tested** etc.
- **[floating point number](float.md)** vs **[real number](real_number.md)** vs **[fixed point number](fixed_point.md)** vs **[rational number](rational_number.md)** vs **[fraction](fraction.md)**
- **[font](font.md)** vs **[typeface](typeface.md)**
- **[forwarding](forwarding.md)** vs **[routing](routing.md)** vs **[switching](switching.md)**
- **[framework](framework.md)** vs **[library](library.md)** vs **[module](module.md)**
- **[free software](free_software.md) (libre)** vs **[open source](open_source.md)** vs **[FOSS](foss.md)** vs **[public domain](public_domain.md)** vs **[source available](source_available.md)** vs **[freeware](freeware.md) (gratis)**
- **[gay](gay.md)** vs **[LGBT](lgbt.md)**
- **[geek](geek.md)** vs **[nerd](nerd.md)**
- **[globalism](globalism.md)** vs **[globalization](globalization.md)**
- **[goniometry](goniometry.md)** vs **[trigonometry](trigonometry.md)**
- **[gradient noise](gradient_noise.md)** vs **[value noise](value_noise.md)**
- **[GUI](gui.md)** vs **graphics** vs **[UI](ui.md)** vs **[TUI](tui.md)** vs **[CLI](cli.md)**
- **heading** vs **header**
- **heat** vs **temperature**
- **[historical](history.md)** vs **historic**
- **[hyperlink](hyperlink.md)** vs **[link](link.md)** vs **[URI](uri.md)** vs **[URL](url.md)** vs **[URN](urn.md)**
- **[ideology](ideology.md)** vs **[philosophy](philosophy.md)** vs **[religion](religion.md)** vs **[paradigm](paradigm.md)**
- **[imperative](imperative.md) paradigm** vs **procedural paradigm** vs **[procedural generation](procgen.md)**
- **implementation defined behavior** vs **undefined behavior** vs **unspecified behavior**
- **[infinite](infinity.md)** vs **[arbitrarily large/unbounded](unbounded.md)**
- **intelligence** vs **[IQ](iq.md)**
- **[Internet](internet.md)** vs **[web](web.md)**
- **[interpolation](interpolation.md)** vs **[regression](regression.md)**
- **it's** vs **its**
- **[Java](java.md)** vs **[JavaScript](js.md)**
- **[kB/mB/gB/tB](memory_units.md)** vs **[KiB/MiB/GiB/TiB](memory_units.md)** vs **KB/MB/GB/TB**
- **[latency/ping/lag](latency.md)** vs **[throughput/bandwidth](throughput.md)** vs **speed**
- **[leftism](left_right.md)** vs **[pseudoleftism](pseudoleft.md)**
- **[liberalism](liberalism.md)** vs **[libertarianism](libertarianism.md)**
- **[library](library.md)** vs **[module](module.md)**
- **[license](license.md)** vs **[waiver](waiver.md)**
- **lighting** vs **lightning** :D
- **main [memory](memory.md)** vs **working memory** vs **[RAM](ram.md)**
- **[logic](logic.md)** vs **[math](math.md)** vs **[rationality](rationality.md)**
- **[low poly](low_poly.md)** vs **stylized** vs **[low effort](low_effort.md)**
- **low [resolution](resolution.md)** vs **[pixel art](pixel_art.md)**
- **magic number** vs **magic constant**
- **[malware](malware.md)** vs **[virus](virus.md)**
- **[mass](mass.md)** vs **[weight](weight.md)**
- **[method](method.md)** vs **[methodology](methodology.md)**
- **[mod](mod.md)** vs **[mode](mode.md)**
- **[modem](modem.md)** vs **[router](router.md)** vs **[switch](switch.md)**
- **[modulo](modulo.md)** vs **remainder**
- **[multisampling](multisampling.md)** vs **[supersampling](supersampling.md)**
- **[nationalism](nationalism.md)** vs **[patriotism](patriotism.md)**
- **[Niger](niger.md)** vs **[Nigeria](nigeria.md)**
- **normie** vs **[NPC](npc.md)** vs **[retard](retard.md)**
- **[NP](p_vs_np.md)** vs **[NP-hard](np_hard.md)** vs **[NP-complete](np_complete.md)**
- **nudity** vs **[porn](porn.md)**
- **opaque** vs **solid**
- **orientation** vs **[rotation](rotation.md)**
- **[overflow](overflow.md)** vs **[wrap around](wrap.md)**
- **[packet](packet.md)** vs **package** (:D)
- **[paging](paging.md)** vs **[virtual memory](virtual_memory.md)**
- **[path tracing](path_tracing.md)** vs **[ray tracing](ray_tracing.md)** vs **[ray casting](raycasting.md)**
- **poisonous** vs **venomous**
- **[principal square root](principal_sqrt.md)** vs **[square root](sqrt.md)** (especially when defining [i](i.md))
- **[probability](probability.md)** vs **[probability density](probability_density.md)**
- **[pseudo](pseudo.md)** vs **[quasi](quasi.md)**
- **[pseudoleft](pseudoleft.md)** vs **[left](left.md)**
- **[pseudoskeptic](pseudosceptic.md)** vs **[skeptic](skeptic.md)**
- **racial realism** vs **[racism](racism.md)**
- **reboot** vs **remake** vs **remaster** vs **rerelease** vs **spinoff**
- **[regular expressions](regexp.md)** vs **[wildcards](wildcard.md)**
- **responsive** vs **responsible** :D
- **[shading](shading.md)** vs **[shadows](shadow.md)**
- **space(time)** vs **[universe](universe.md)**
- **[static typing](static_typing.md)** vs **[strong typing](strong_typing.md)** 
- **[strategy](strategy.md)** vs **[tactics](tactics.md)**
- **[sudo](sudo.md)** vs **[root](root.md)**
- **transcript** vs **transcription**
- **[Unicode](unicode.md)** vs **[UTF](utf.md)**
- **[webpage](webpage.md)** vs **[website](website.md)**
- **[wiki](wiki.md)** vs **[Wikipedia](wikipedia.md)**
- **you're** vs **your**
- ...

## See Also

- [often misunderstood](often_misunderstood.md)
