# Morality

Morality is the sense of higher values of an individual and society from which it follows what's ultimately right, wrong, [good](good.md) and [bad](bad.md)/[evil](evil.md) on a greater level, for a "greater good", without succumbing to low instincts such as [self interest](self_interest.md), self preservation, immediate pleasure etc. Morality is what distinguishes (some) men from animals and allows us to act not on mere instincts and pressure of immediate stimuli, it is driven by higher forces such as beliefs, [logic](logic.md), [empathy](empathy.md), [love](love.md), conscience, [religion](religion.md) and [science](science.md). Examples of moral (good) behavior include [altruism](altruism.md), [selflessness](selflessness.md), [communism](communism.md) in general sense, [less retarded society](less_retarded_society.md) and [non violence](non_violence.md), while examples of IMMORALITY (evil) might be [capitalism](capitalism.md), [fascism](fascism.md), [rape](rape.md), [pedophobia](pedophobia.md), [genocide](genocide.md), [marketing](marketing.md), [proprietary software](proprietary.md), [nationalism](nationalism.md) and [LGBT](lgbt.md).

At times morality gets close to **[ethics](ethics.md)**, to the point of the two terms often being [confused](often_confused.md) and used interchangeably, however we may still find slight differences. Whereas morality is seen as something personal and intuitive, predominantly driven by conscience and judged on a case-by-case basis, ethics is perceived more as a set of informal, often unwritten shared rules to assure morality in a larger group of individuals, i.e. ethics is an agreement on a way of behavior between individuals, each of which may have slightly different personal morals. Ethics is also sometimes defined as the branch of [philosophy](philosophy.md) concerned with examining morality.

Let's also stress that **morality is much different from legality.** It is said that, ideally, laws should be the minimum (a proper [subset](subset.md)) of morality, i.e. laws should be the officially codified, approved and enforced rules that ensure the very basic moral behavior is sustained, such as people not murdering others, however laws CANNOT with the best of our effort ever capture the infinitely complex nature of morals (no one can ever write down EXACTLY what is and isn't moral in every single imaginable situation that can arise in real world), so it is seen as inevitable that laws will always allow some slightly immoral actions (imagine e.g. someone giving a bad advice to someone else on purpose just to see the other one fail -- this may be legal but is likely immoral). This is accepted because the other option, i.e. law trying to prevent ALL immoral behavior, would be too restrictive and would also inevitably prevent a huge amount of moral, useful and essential behavior; imagine e.g. law trying to prevent giving bad advice by banning all communication altogether. However, this ideal of "laws as a minimum of morals" doesn't hold in practice because law is hugely abused and manipulated to serve the evil, so not only does it allow immoral behavior (which would be kind of OK), it BANS moral behavior (which is unacceptable from the idealist point of view), for example it is prohibited to share useful information ("[intellectual property](intellectual_property.md)"), repairing ([DRM](drm.md)), living in an abandoned house one doesn't "officially own" etc. Furthermore laws themselves in principle have a negative effect on morality because **people unfortunately start replacing morality with legality**; as laws get more complex and in control of our everyday lives, people only start deciding and judging actions based on a question of "is it legal?" rather than "is it moral?" -- indeed, if nowadays you accuse someone of doing something wrong, he will almost definitely reply something along the lines of "I can legally do that so shut up." (perhaps just with varying degrees of politeness). Indeed, whenever a new issue appears [nowadays](21st_century.md), people hardly even think about solving it in any other way than by making laws to solve the issue -- as an example shortly after a few fatal incident occurred some time in early 2010s due to the new trend of "planking" (people making photos of themselves lying face down in weird places), people immediately started to call for LEGAL bans of planking, not even thinking of what consequences this would have -- literally making it illegal to lie face down on the ground. Laws destroy morality, hence laws have to be canceled (see [anarchism](anarchism.md)) and we have to focus only on developing our sense of morality better.

## See Also

- [superego](superego.md)