# Minimalism

*No gain, no pain.*

In the context of [technology](tech.md) minimalism is a design philosophy which puts great emphasis on [simplicity](kiss.md), it says technology should be as simple as possible while still achieving given goal, possibly even a little bit simpler. Minimalism is one of the most (if not the most) important concepts in [programming](programming.md) and technology in general, it could almost be said that becoming a true expert in technology is strongly connected to realizing the importance of simplicity (see e.g. [Unix philosophy](unix_philosophy.md)). One of the first things to stress about minimalism is that it's firstly about **internal simplicity**, i.e. the simplicity of design/repairing/[hacking](hacking.md), and only secondly about the simplicity from the [user](user.md)'s point of view (otherwise we are only dealing with [pseudominimalism](pseudominimalism.md)). The opposite of minimalism is [maximalism](maximalism.md).

Antoine de Saint-Exupery sums it up with a quote: *we achieve perfection not when there is nothing more to add but when there is nothing left to take away.*

**[Forth](forth.md)** is perhaps the best example of software minimalism and demonstrates that clever, strictly minimalist design can be absolutely superior to the best efforts of maximalists. Languages such as Scheme [Lisp](lisp.md) show that minimalism can also be applied on high level of [abstraction](abstraction.md).

Minimalism as a general concept is also immensely important in [art](art.md), [religion](religion.md) and other parts of [culture](culture.md) and whole society, for example in fine art, architecture and design we find great use of it, and basically every major religion values frugality and letting go of material desire in order to distill the truly important part of one's existence, be it [Christianity](christianity.md), [Islam](islam.md) or [Buddhism](buddhism.md) -- in Buddhism it's even the case that one of the highest principles is that of "emptiness", called Sunyata, and while westerners spoiled by [consumerism](consumerism.md) tend to feel negatively about the word "empty", in east it bears a positive connotation. When asked about getting better at acting, Ben Kingsley answered "You can learn to say something with one gesture instead of nine.", implying that mastery lies in learning to do less. And so with this ever present minimalism it comes as no surprise there also exists the generalized concept of **life minimalism** which applies said wisdom and philosophy to all areas of [life](life.md) and which numerous technological minimalists quite naturally start to follow along the way -- life minimalism is about letting go of objects, thoughts and desires that aren't necessarily needed because such things enslave us and mostly just make us more miserable; from time to time you should meditate a little bit about what it is that you really want and need and only keep that. Indeed this is nothing new under the Sun, this wisdom has been present for as long as humans have existed, most religions and philosophers saw a great value in [asceticism](asceticism.md), frugality and even poverty, as owning little leads to [freedom](freedom.md). For instance owning a [car](car.md) is kind of a slavery, you have to clean it, protect it, repair it, [maintain](maintenance.md) it, pay for parking space, pay for gas, pay for insurance -- this is not a small commitment and you sacrifice a significant part of your life and [head space](head_space.md) to it (especially considering additional commitments of similar magnitude towards your house, garden, clothes, electronics, furniture, pets, bank accounts, social networks and so forth), a minimalist will rather choose to get a simple [suckless](suckless.md) bicycle, travel by public transport or simply walk. Life minimalism is also much healthier both for the individual and for whole society. A man who learns to live with very little starts to find much more enjoyment in mundane things thereafter, a simple pleasure such as an extra meal once a week suddenly feels like it's Christmas, unlike to someone who overeats daily and can hardly take any extra pleasure in food at all. It is also proven (despite you disagreeing with it) that people living in scarcity are friendlier to each other, i.e. a community of people living with little are more [socialist](socialism.md), sharing, loving and caring, without crime and hostility, unlike communities of overstimulated fat depressed consumers addicted to endless increase of pleasure, demanding more and more from the day, eventually ending up only with [competition](competition.md) and hostility on their mind.

Minimalism is a sign of high [IQ](iq.md) and better developed, [more cultivated](unretard.md) mind, it is something that requires an intellect strong enough to overcome the human instinct for hoarding to which the unintelligent is a slave -- an instinct that was important in times of scarce resources but one that's become a harmful curse in times when certain resources became so abundant that they can be consumed without end. It is like with overeating: the intelligent man is able to restrain from unhealthy overeating to which he is pushed by his instinct.

**Minimalism is a prerequisite for technological [freedom](freedom.md)** as free [technology](technology.md) can only be that over which no one holds a [monopoly](bloat_monopoly.md), i.e. which many people and small parties can fully control and make use of, study and modify with affordable effort, without needing armies of technicians just for carrying out [maintenance](maintenance.md). Minimalism stands opposed to creeping overcomplexity of technology that always brings about huge costs and dangers, e.g. the cost of [maintenance](maintenance.md) and further development, costs of required expertise, creeping [obscurity](obscurity.md), inefficiency ("[bloat](bloat.md)", wasting resources) brought by the need for high [abstraction](abstraction.md), increased risk of bugs, errors and failures, [money](money.md) and business leading to [consumerism](consumerism.md) and so on.

{ Apparently some people "disagree" with the above and say that "complexity is OK" in free software. I don't think it is possible to disagree on this, it is only possible to not see the issue because of lack of experience. Someone "disagreeing" here means one of two things: he only pretends to care about freedom while actually pursuing other interests (for example creating a "community" around some highly bloated project), OR he has fewer than one brain cell. ~drummyfish }

**It is a beginner mistake to think that minimalism complicates technology**, by definition it's the exact opposite of complication: a man not experienced with technology only sees short-term benefits and so he believes that bloated technology is a better choice as it lets him immediately [produce](productivity_cult.md) things faster. Indeed this is a mind of a child that wants everything NOW without any thought of the future -- of course, writing software in a minimalist programming language may be more difficult and time consuming, but it's simply an investment in solid foundations, ones that will [last for a very long time](future_proof.md), just like building a house of solid stone will be more difficult than quickly building it out of drywall -- a building made of stone will last many centuries, it pays off many times in the future. Of course there is also [capitalism](capitalism.md) playing a huge part as a system hostile to anything permanent, a dystopia that needs to constantly rebuild things anew so it needs things that never last too long. Peasants play along with the system and just [do what it wants them to](just_doing_my_job.md) as again that gives them immediate benefits in form of salary, however it still holds that this technology is bad, it's just that dystopias require and support bad technology. [We](lrs.md) however don't.

There is a so called *[airplane rule](airplane_rule.md)* that states a plane with two engines has twice as many engine problems than a plane with a single engine.

[Alan Kay](alan_kay.md), a famous [hacker](hacking.md), once said he experienced a revelation upon reading the manual to the [Lisp](lisp.md) programming language once he realized the whole programming language's code was written on half a page in the manual itself. "These are Maxwell’s Equations of software!" he exclaimed -- this is the essence of true programming. Not colossal codebases maintained by hundreds of programmers, but mathematics, seeking minimal equations and [beauty](beauty.md) are the interest of a true programmer.

Up until recently in [history](history.md) it was evident to every engineer that *the better machine is that with fewer moving parts*. This still seems to hold for example in [mathematics](math.md), a field not yet so spoiled by crippling commercialization and mostly inhabited by the smartest people -- there is a tendency to look for the most minimal equations and such equations are considered [beautiful](beauty.md). To laymen it's not obvious and the concept definitely seems counterintuitive, but every programmer eventually learns that a "more sophisticated" solution will not only bring the cost of added overhead, but may oftentimes lead to simply giving worse overall results -- typical example are for example [pseudorandom](pseudorandomness.md) number generators in which adding more operators typically WORSENS the quality of the generated sequence. Science knows the rule of simplicity as the [Occam's razor](occams_razor.md): the simplest explanation should be preferred. In technology invaded by aggressive commercialization the situation is different, minimalism lives only in the underground and is ridiculed by the mainstream propaganda. Some of the minimalist movements, terms and concepts at least somewhat connected to minimalism include (watch out for [SJW](sjw.md)s, [pseudominimalism](pseudominimalism.md), Nazis etc., we don't automatically fully embrace all things on this list):

- [suckless](suckless.md)
- [cat-v](cat_v.md)
- [bitreich](bitreich.md)
- [Collapse OS](collapseos.md)/[Dusk OS](duskos.md), [collapse](collapse.md) computing
- [less retarded software](lrs.md)
- [Unix philosophy](unix_philosophy.md)
- [KISS](kiss.md)
- [countercomplex](countercomplex.md)
- [permacomputing](permacomputing_wiki.md) (SJW cancer warning)
- [less is more](less_is_more.md)/[worse is better](worse_is_better.md)
- [appropriate technology](appropriate_tech.md)
- [neoluddism](neoluddism.md)
- [reactionary software](reactionary_software.md) (bordering with [pseudominimalism](pseudominimalism.md))
- [plan9](plan9.md), [openbsd](openbsd.md), KISS GNU/Linux and similar (however often obsessed with [bloatcryption](encryption.md), may contain [pseudominimalism](pseudominimalism.md))
- [100rabbits](100r.md) (beware of [SJW](sjw.md) poison)
- [small Internet](small_internet.md), web 1.0, web 0.5, [gopher](gopher.md), [gemini](gemini.md) (watch out: gemini is SJW pseudominimalist bloatcryption poison), ...
- [primitivism](primitivism.md)/[anarcho primitivism](anprim.md), [low tech](low_tech.md), ...
- for potential weaker links to minimalism also check out [retro](retro.md)/[old](old.md)/[boomer](boomer.md) tech, [salvage computing](salvage_computing.md), [degrowth](degrowth.md), [Amish](amish.md), [technophobia](technophobia.md), [demoscene](demoscene.md), [code golf](golf.md), [lightweight](lightweight.md) software, [fantasy consoles](fantasy_console.md) (sadly mostly pseudominimalism), communities around [plain text](plain_text.md), [pubnixes](pubnix.md), some GNU/Linux distros (e.g. [Arch](arch.md), [Gentoo](gentoo.md), KISS Linux, ...), [IRC](irc.md) communities and so on.
- ...

Under [capitalism](capitalism.md) technological minimalism is suppressed in the [mainstream](mainstream.md) as it goes against [corporate](corporation.md) interests, i.e. those of having [monopoly](bloat_monopoly.md) control over technology, even if it was to be called "[FOSS](foss.md)" (which then becomes just a cool brand, see [openwashing](openwashing.md)). We may, at best, encounter a "shallow" kind of minimalism, so called [pseudominimalism](pseudominimalism.md), which only strives to make things appear minimal, e.g. aesthetically, and hides ugly overcomplicated internals under the facade. [Apple](apple.md) is infamous for this [shit](shit.md).

**Does minimalism mean we have to give up the nice things?** Well, not really, it is more about giving up the [bullshit](bullshit.md), getting rid of addiction and changing an attitude. People addicted to [modern](modern.md) consumerist technology often worry that with minimalism they will lose their drug, typically [games](game.md) or something similar. Remember that with minimalism **we can still have technology for entertainment**, just a non-consumerist one -- instead of consuming a new game each month we may rather focus on creating deeper games that may last longer, e.g. those of a [easy to learn, hard to master](easy_to_learn_hard_to_master.md) kind and building communities around them, or on modifying existing games rather than creating new ones from scratch over and over. Sure, technology would LOOK different, our computer interfaces may become less of a thing of fashion, our games may rely more on aesthetics than realism, but ultimately minimalism can be seen just as trying to achieve the same effect while minimizing waste. If you've been made addicted to bullshit such as buying a new GPU each month so that you can run games at 1000 FPS at progressively higher resolution then of course yes, you will have to suffer a bit of a withdrawal just as a heroin addict suffers when quitting the drug, but just as him in the end you'll be glad you did it.

Remember, you can't lose if you don't play. Sometimes choosing to play certain games is a loss in itself.

A possible **real life analogy** of the mainstream bloated software vs minimalist software is for example this: the bloated, mainstream computing environment (Windows, Mac, "Linux" distros, mainstream web browsers, virtual machines etc.) is like a skyscraper in a city whereas minimalist software is a small, self-sufficient caravan somewhere in the woods. The skyscraper offers luxury but for an enormous price: it's extremely expensive to just build, just its realization requires tons and tons of bullshit like getting permissions, reviewing environmental and economic impacts, paying architects, planning the building process, ensuring safety, keeping to all regulations, getting enough capital, finding companies to contract and so on -- erecting the building will be an enormously stressful and risky task for many dozens of companies which it will be extremely difficult to just coordinate and once the building stands, it will continue to be extremely expensive to just maintain in habitable state, the rent will be enormous as you're paying for maintenance of the whole building, cleaning the stairs, for energies, clean water pumped to high altitudes, security systems, high speed internet and so on, plus you as someone who even "owns" an apartment in the skyscraper will have practically no control over it besides arranging furniture in the room you "own" while also in the end, for getting this kind of "luxury" of maybe getting a nice view of the city, it will even be inferior in many ways: you'll live in constant [noise](noise.md) of the city, in polluted air, bombarded by ads and neons from the streets, you'll have to take the lift to your apartment (good luck if electricity goes out), you can't make much noise to not bother the neighbors, you'll have to work your ass off to just pay the bills, you'll have to be constantly cleaning all the marble and glass, becoming slave to the apartment, while risking conflicts with neighbors and so on. Your "apartment" (or a computer program) isn't even really a thing you own, it's just basically a tiny bit of something trivial (four walls) on top of some gigantic platform (the skyscraper inside the big city, the enormous operating system inside a virtual sandbox running in a [cloud](cloud.md) etc.), expensive just by being at this "privileged" location -- in this case we may substitute the word *platform* for *prison*. On the other hand your off-the-grid caravan will be cheap to get and maintain, you'll have complete control over it, be able to make absolutely any modifications to it, you can repair most things yourself (unlike e.g. with a "smart" apartment), it won't bother you with bullshit, there are no loud or annoying neighbors, [ads](marketing.md), no lifts, no safety regulations (in case of fire it's even much safer than living in skyscraper), you won't even have to pay extra taxes you'd pay for a "real" building, you'll be living in a nice, quiet and relaxing environment, have cleaner air, be more self sufficient, making your own solar electricity (and generally not needing so much electricity), flexible, able to move anywhere at any time. All this for basically giving up having a bathtub made of marble. Anyone with half a brain must see the stupidity of choosing to live in the skyscraper.

With increased interest in minimalism the word *minimalism* itself gets misused and abused. Let's be reminded that true minimalism aims to minimize everything that's unnecessary, it starts with good, minimalist design, but ultimately grows outwards and becomes a life philosophy that doesn't stop at the internals of machines, it tries to minimize for example even the desires of the user of the technology. Stopping at minimalist design of internals shouldn't be called minimalism because minimalist design is simply good design -- there is no such thing as a good, non-minimalist internal design. And then there is the shallow capitalist pseudominimalism that bets purely on the looks. The following table sums up the differences:

| what             | internal minimalism | external minimalism |
| ---------------- | ------------------- | ------------------- |
| true minimalism  | yes                 | yes                 |
| good design      | yes                 | no                  |
| pseudominimalism | no                  | yes                 |
| bloat            | no                  | no                  |

[Rob Pike](rob_pike.md), who was once a great [hacker](hacking.md), once stated 5 programming rules which besides others say that "fancy algorithms are slow when *n* is small and *n* is usually small" and "fancy algorithms are buggier than simple ones and they are much harder to implement; use simple algorithms as well as simple data structures."

## Importance Of Minimalism: Simplicity Brings Freedom

It can't be stressed enough that minimalism is absolutely required for technological freedom, i.e. people having, in **practical** ways, control over their tools. While in today's society it is important to have legal freedoms, i.e. support [free software](free_software.md), we must not forget that this isn't enough, a freedom on paper means nothing if it can't be practiced. We need both legal AND [de facto](de_facto.md) freedom over technology, the former being guaranteed by a free [license](license.md), the latter by minimalism. Minimal, simple technology will increase the pool of people and parties who may practice the legal freedoms -- i.e. those to use, study, modify and share -- and therefore ensure that the technology will be developed according to what people need, NOT according to what a corporation needs (which is usually the opposite).

Even if a user of software is not a programmer himself, it is important he chooses to use minimal tools because that makes it more likely his tools can be repaired or improved by SOMEONE from the people. Some people naively think that if they're not programmers, it doesn't matter if they have access and rights to the program's source code, but indeed that is not the case. You want to choose tools that can easily be analyzed and repaired by someone, even if you yourself can't do it. This is measure by so called **[freedom distance](freedom_distance.md)**.

Someone once said: "What I cannot build I do not understand". It is indeed so. And that which one doesn't understand one doesn't control. Using tools you don't control is insanity. These tools will control you.

Minimalism and simplicity increase freedom even of [proprietary](proprietary.md) technology which can be seen e.g. on [games](game.md) for old systems such as [GameBoy](gameboy.md) or [DOS](dos.md) -- these games, despite being proprietary, can and are easily and plentifully played, modified and shared by the people, DESPITE not being free legally, simply because it is easy to handle them due to their simplicity. This just further confirms the correlation of freedom and minimalism.

## See Also

- [maximalism](maximalism.md)
- [KISS](kiss.md)
- [primitivism](primitivism.md)
- [frugality](frugality.md)
- [single instruction computer](single_instruction.md)
- [Amish](amish.md) tech
- [anorexia](anorexia.md)