# Library

[Software](software.md) library (often shortened to just *lib*) is [program](program.md) code whose purpose is not to be run on its own but rather be used by other programs, i.e. it is a helpful collection of preprogrammed code that's meant to be [reused](reusability.md). A library provides resources such as [functions](function.md), [macros](macro.md), [classes](class.md) or [constants](constant.md) that are normally related to solving some specific class of problems, so there exist [GUI](gui.md) libraries, [audio](audio.md) libraries, [mathematical](math.md) libraries and so on. Libraries exist mostly to prevent [reinventing wheels](reinventing_wheel.md) by only ever implementing the code once so that next time we can simply reuse it (respecting the [DRY](dry.md) principle), but they also e.g. help assure others are using an already well tested and [optimized](optimization.md) code, they help to implement [modularity](modularity.md) etc. Examples of libraries are the [standard C library](clib.md), [SDL](sdl.md) or [JQuery](jquery.md). Libraries are not to be confused with [frameworks](framework.md) which are larger, more [bloated](bloat.md) environments that often include libraries but also a lot of other stuff on top (such as various tools, [virtual machines](vm.md) etc.). The term library is also very close to the term *[module](module.md)* -- depending on context these may sometimes be synonymous.

**Standard library** (stdlib) is a term that stands for the set of libraries that officially come with given [programming language](programming_language.md) -- these libraries usually offer very basic functionality (such as [I/O](io.md) and basic [math](math.md)) and are required by the language standard to always be present on every system.

Should a programmer decide to use a specific library, he usually has to first somehow [install](install.md) it (if it's not installed already, usually a library is some kind of software [package](package.md)) and then *include* it in his program with a specific command (words like `include`, `using` or `import` are commonly used). Then he is able to use the resources of the library. Depending on the type of the library he may also need to [link](linking.md) the library code after [compilation](compiler.md) and possibly distribute the library files along with his program. A more [KISS](kiss.md) approach is for a library to simply be a code that's somehow copy-pasted on the level of text into his main program (see single header libraries etc.).

In the [Unix](unix.md) world a convention dictates that library [packages](package.md) start with the `lib` prefix, so e.g. the SDL library is named `libsdl` etc.

As a programmer you will encounter the term **library [API](api.md)** -- this is the interface of the library consisting of the elements via which programmer uses the library, mostly the [functions](function.md) the library offers. API is what the programmer interacts with; the rest is library internals (its [implementation](implementation.md)) that's usually supposed to not be touched and stay a bit hidden (see [encapsulation](encapsulation.md)). If a programmer wants to know the library API, he wants to know the names of the functions, what [parameters](parameter.md) they take etc. Sometimes there may be multiple libraries with the same API but different internal implementations, this is nice because these libraries can be easily [drop-in-replaced](drop_in.md). The library API is usually part of its documentation -- when learning a new library *X*, you want to search the internet for something like *X library API reference* to see what functions it offers.

In a specific [programming language](programming_language.md) it IS generally possible to use a library written in a different language, though it may be more difficult to achieve -- see language [bindings](binding.md) and [wrappers](wrapper.md).

We generally divide libraries into two types:

- **[static](static.md)**: The library code is embedded into the executable of the final program so that the library files don't have to be distributed along with the program. This is more convenient and also ensures the program uses exactly the correct version of the library. But of course this often results in a bigger executable, and if we have multiple programs that use the same library which is statically linked, each program will have a [redundant](redundancy.md) copy of the library code, wasting memory (both storage and possibly [RAM](ram.md)). Nevertheless this is still seen as the more [suckless](suckless.md) way as the alternative dynamic linking is usually much more complicated and with good programming the negative impacts of static linking can be reduced to a minimum.
- **[dynamic](dynamic.md)** (also *shared*): The compiled library code resides in a separate file ([DLL](dll.md) on [Windows](windows.md), [.so](so.md) in [GNU](gnu.md)/[Linux](linux.md)) which may need to be distributed along with the program, but this one file can be shared among all programs that use the library so the compiled programs can be smaller. It may also be easier to update the library to a new version by simply replacing the compiled library file. RAM may also be saved as the dynamic library may be loaded just once for multiple simultaneously running programs. This is very often used in the mainstream and although sounding quite logical, dynamic linking is actually very rarely worth the extra complexity and trouble that come along with it (one being e.g. [dependency](dependency.md) hell: it may for example happen that programs *A* and *B* share a library and each one need a different version of it).

Many times a library can have both static and dynamic version available, or the compiler may allow to automatically link the library as static or dynamic. Then it's up to the programmer which way he wants to go.

## C Libraries

*See also [C tutorial](c_tutorial.md).*

TODO: example

**Header only** or **single header** library is a kind of [keep-it-simple](kiss.md) library that's wholly implemented in a single header (.h) file -- this is kind of a [hack](hacking.md) going against "official recommendations" as header files aren't supposed to contain implementation code, just declarations, however single header libraries are [suckless](suckless.md)/[LRS](lrs.md), convenient and very easy to use, as they don't have to be [linked](linking.md) and are nicely self-contained, distributed in one nice file. A traditional library would consist of one or more header (.h) files and one or more implementation (.c) files; such library has to be compiled on its own and then linked to the program that uses it -- the idea behind this was to compile the library only once and so save time on recompiling it again and again; however this justification is invalid if our library is simple enough and compiles very quickly (which it always should, otherwise we are dealing with badly designed [bloat](bloat.md)). A single header library can therefore just be included and [just works](just_werks.md), without any extra hassle -- yes, its code recompiles every time the program is compiled, but as stated, it doesn't hurt if our library is well designed and therefore simple. Single header libraries often include the option (via some #define macro) to include just the declaration or both declarations and implementation code -- this is useful if our main program is composed of multiple source files and needs to be linked. [LRS](lrs.md) libraries, such as [small3dlib](small3dlib.md) or [raycastlib](raycastlib.md), are of course single header libraries.

## LRS Libraries

TODO

## See Also

- [framework](framework.md)