# Internet

Internet (sometimes just the *net*, also *serious business*) is the grand, [decentralized](decentralization.md) global network of interconnected [computer](computer.md) [networks](network.md) that allows advanced, cheap, practically instantaneous intercommunication of people and computers and sharing of large amounts of [data](data.md) and [information](information.md). Over just a few decades since its inception in 1970s it grew over biblical proportions, changed the society tremendously, shifted it to the information age and thereafter stands as possibly the greatest technological invention of our society. It is a platform for many services and applications such as the [web](www.md), [e-mail](email.md), [internet of stinks](iot.md), [torrents](torrent.md), phone calls, video streaming, multiplayer [games](game.md) etc. Of course, once Internet became accessible to [the common folk](npc.md) and turned to largest public forum on [the planet](earth.md), it has also become the largest dump of retards in [history](history.md) and, as always, [capitalism](capitalism.md) turned the dream of Internet into a nightmare.

Before continuing it's important to make a clear **distinction between the Internet as such and the Internet Revolution**. The Internet in itself is a marvel of ingenuity and a good tool with great potential to help all the people, but the so called "Internet Revolution" was a **disaster** due to having a very bad, [capitalist](capitalism.md) society in place, just like the Agricultural and Industrial revolutions presented a disaster for the people despite farming, engineering, mass production and automation being potentially good concepts in themselves. A knife is a tool, it can be used for good, but it's a bad tool in hands of a psychopath, and the same goes about any technology. Therefore we have to distinguish between the Internet alone (good) and the effects that Internet created in our dystopian society (bad).

{ For readers in the [future](future.md): I witnessed this "revolution" first hand, I remember the world before Internet was common and can confirm it brought along the worst horrors I could imagine. ~drummyfish }

Sometimes we distinguish between lowercase *i* "internet", meaning a large computer network, and capital *I* "Internet", signifying the one majestic worldwide internet. As many great networks eventually interconnect with and become part of the "big" Internet, we now seldom pay attention to this distinction, in normal speech both "internet" and "Internet" typically stand for the big Internet.

Internet is built on top of [protocols](protocol.md) (such as [IP](ip.md), [HTTP](http.md) or [SMTP](smtp.md)), standards, organizations (such as [ICANN](icann.md), [IANA](iana.md) or [W3C](w3c.md)) and infrastructure (undersea cables, satellites, [routers](routers.md), ...) that all together work to create a great network based on **[packet switching](packet_switching.md)**, i.e. a method of transferring digital data by breaking them down into small [packets](packet.md) which independently travel to their destination (contrast this to [circuit switching](circuit_switching.md)). The key feature of the Internet is its **[decentralization](decentralization.md)**, i.e. the attribute of having no central node or authority so that it cannot easily be destroyed or taken control over -- this is by design, the Internet evolved from [ARPANET](arpanet.md), a project of the US defense department. Nevertheless there are parties constantly trying to seize at least partial control of the Internet such as governments (e.g. China and its [Great Firewall](great_firewall.md), [EU](eu.md) with its "anti-pedophile" chat monitoring laws etc.) and corporations (by creating centralized services such as [social networks](social_network.md)). Some are warning of possible de-globalization of the Internet that some parties are trying to carry out, which would turn the Internet into so called [splinternet](splinternet.md).

Access to the Internet is offered by [ISPs](isp.md) (internet service providers) but it's pretty easy to connect to the Internet even for free, e.g. via free [wifis](wifi.md) in public places, or in libraries. By 2020 more than half of world's population had access to the Internet -- most people in the first world have practically constant, unlimited access to it via their [smartphones](smartphone.md), and even in [poor countries](shithole.md) [capitalism](capitalism.md) makes these devices along with Internet access cheap as people constantly carrying around devices that display [ads](ad.md) and spy on them is what allows their easy [exploitation](leading_the_pig_to_the_slaughterhouse.md).

Initially the Internet was basically a purely technological marvel but since its wide spread that made it an inseparable part of our everyday lives it also turned into a phenomenon of interest to many other fields such as psychology and sociology. By now the number of various Internet communities and subcultures has grown so much that a sociologist can probably spend a whole career studying only Internet communities, of which many have risen and fallen over the decades. Studying Internet [culture](culture.md) has become a hobby to many, something akin to an alternative to traveling [in real life](irl.md) -- the Internet is quite like an another planet now, with new countries and nations coming to existence, with their own laws and even language dialects forming in the virtual Universe. In the 2000s the situation was basically this: older people didn't know the Internet slang and young people did. By 2020s everyone knows the Internet, it's just that different people are familiar with different corners of it, with different flavors of [memes](meme.md), slang and in-jokes, some are [Facebook](facebook.md) and Twitter normies, some are TikTokers, some are [4channers](4chan.md), [redditors](reddit.md), [Usenet](usenet.md) and [IRC](irc.md) boomers, quake multiplayer enjoyers, some are [suckless](suckless.md) hackers, some fancy deeper underground such as Vidlii, [Bitreich](bitreich.md), [LRS](lrs.md), [gopher](gopher.md), [encyclopedia dramatica](dramatica.md), some love [netstalking](netstalking.md), [darknet](darknet.md) exploration, data archeology and [hoarding](data_hoarding.md). And so on and so forth.

The following are some **statistics** about the Internet as of early 2020s: there are over 5 billion users world-wide (more than half of them from Asia and mostly young people), it is estimated 63% people worldwide use the Internet with the number being as high as 90% in the developed countries. Most Internet users are English speakers (27%), followed by Chinese speakers (25%). It's also estimated over 50 billion individual devices connected, about 2 billion websites (over 60% in [English](english.md)) on the web, hundreds of billions of emails are sent every day, average connection speed is 24 Mbps, there are over 370 million registered [domain](domain.md) names (most popular [TLD](tld.md) is .com), [Google](google.md) performs about 7 billion web searches daily (over 90% of all search engines).

PRO TIP: **you should download and/or print your own offline Internet** (or maybe we should rather say offline [web](www.md)). Collect your favorite websites and other resources ([gopher](gopher.md) holes, [Usenet](usenet.md) threads, images, ...) and make a single dense [PDF](pdf.md) out of them. Process each page so that it's just plain text, remove all graphics and colors, unify the font, make the font small and decrease margins so that you fit as much as possible on a single page to not waste paper. For many pages, like Wikipedia, a small script will be able to do this automatically; the uglier pages may just be edited manually. An easy approach is for example to convert the pages to plain HTML that just contains paragraphs and heading of different levels, then copy-pasting this to LibreOffice, globally editing the font and auto-generate things like table of contents and page numbers, then exporting as PDF. You can even make a script that contains the list of pages you want to scrap so that you can make a newer print a few years later. Once you have the PDF, print it out and have your own tiny offline net :) It will be useful [when the lights go out](collapse.md), it's a physical backup of your favorite sites (the PDF, as a byproduct, is also a single-file backup in electronic form), something no one will be silently censoring under your hands, and it's also just nice to read through printed pages, the experience is better than reading stuff on the screen -- this will be like your own 100% personalized book with stuff you find most interesting, in a form that's comfortable to read. You should also download your favorite and essential websites and other files for offline use, this way you'll be able to browse even when the Internet collapses and/or if you're just somewhere without connection, plus you'll have a backup in case they go offline themselves. Here is a [KISS](kiss.md) script template that does the downloading (it can also at the same time serve as a list of your favorite websites), also feel free to improve it (e.g. compress/minimize the downloaded files etc.):

```
#!/bin/bash

rm -rf offline
mkdir offline

echo "
http://favoritesite1.com
https://favoritesite2.com/page1.html
http://favoritesite3.com/favoritefile1.txt
http://favoritesite4.org/coolimage.jpg
" | shuf | wget -i - -E -e robots=off -nc -nd -U "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)" --tries=3 -k -w 1 -P offline
```

As of 2024 the Internet is dead, like whole society, killed by [capitalism](capitalism.md) -- take a look at the alternatives to the Internet down below.

**Internet is NOT [real life](irl.md)** and as [Ashley Jones](ashley_jones.md) said: you cannot apply real life logic on the Internet. If you try to behave on the Internet like you behave in real life you are [retarded](retard.md) and don't understand how Internet works. If that's the case please fuck off the Internet.

## History

*See also [history](history.md) and [www](www.md).*

{ Some sites with Internet history: https://www.zakon.org/robert/internet/timeline/, https://www.freesoft.org/CIE/Topics/57.htm. ~drummyfish }

It goes without saying that even though in retrospect it looks like the Internet just came to be one day, it wasn't indeed so -- we have to remember large communication networks existed for a long time and were often used in ways very similar to the Internet, even for silly things like playing [games](game.md) (e.g. [chess](chess.md) used to be played over snail mail and even telegraph). Before electronic networks there were networks such as paper mail and optical telegraphs. Electricity opened the door to numerous new, much improved networks, such as the electrical [telegraph](telegraph.md) (~1840), phone and [fax](fax.md) networks (~1880) that even allowed sending images (since early 1900s thanks to Belinographe, used mainly by newspapers), [radio](radio.md) broadcasts (circa first half of 20th century) and [TV](tv.md) broadcasts (~1930). Some of the later networks were very similar to the World Wide Web from user perspective, and they were quite advanced and widely used at the time when Internet was just in its infancy -- for example [teletext](teletext.md) (~1970) allowed people to browse graphical pages on their TVs, [BBS](bbs.md) and [Usenet](usenet.md) networks were already [digital](digital.md) computer networks (accessed through dialup [modems](modem.md)) allowed people to chat, discuss on forums, roleplay, play games and share files, [Minitel](minitel.md) was the most successful Internet like network that worked in France in the 1980s etc. Perhaps not to much surprise visions of Internet as we know it appeared beforehand for example in [sci-fi](sci_fi.md), one particularly famous such work is the 1956 book called *A Logic Named Joe*.

The Internet itself evolved from **[ARPANET](arpanet.md)**, a network designed by [US](usa.md) department of defense; ARPANET started to be developed in 1969 (with first plans appearing in 1966), fueled by Cold War rivalry with the Soviet Union. Of course, this network wasn't intended to become what the Internet is today, no one could probably have foreseen the future, it was just another [military](military.md) project -- as such, ARPANET was designed to be **[decentralized](decentralization.md)** so as to be robust, i.e. there was no central node of the network which would be an easy target for enemies in a war. ARPANET was revolutionary by utilizing so called **[packet switching](packet_switching.md)** (idea published in a paper in 1961), i.e. any data sent over the network were split into small data [packets](packet.md) that would travel through the network independently, each one possibly by different path, and would be reassembled into the whole once they all arrived at the destination (again, this helped keep the network robust -- if one path was destroyed, packets would just find another path). This is in contrast to traditional [circuit switching](circuit_switching.md) used until then e.g. in telephone networks (circuit switching basically just means that direct connections are established between nodes that want to communicate at given time).

In April 1969 the first **[RFC](rfc.md)** ("request for comments") document was published (back then wrote with typewriter) -- RFCs would become a standard type of documents for discussing the design and improvements of ARPANET and later the Internet between the network engineers and scientists -- in RFCs new standards and [protocols](protocol.md) would be suggested, defined and discussed. 29 October 1969 is seen as a historical moment for ARPANET because at that day first data were sent through it from University of California -- it was a letter "L" (a whole word "LOGIN" was supposed to be sent but the computer crashed somewhere at "G"). In November of this year the first permanent ARPANET connection was established between University of California and Stanford Research Institute and shortly after a 4 node network was established.

By 1971 there were 15 ARPANET nodes. In 1974 allegedly the **first use of the word "Internet"** appeared in the specification of the TCP protocol by Cerf et al. The [TCP/IP](tcp_ip.md) protocol they published would become a key part of the Internet -- even today these protocols are the foundation of the Internet. By 1977 ARPANET had about 60 nodes.

In 1983 there were more than 500 registered hosts and in 1984 the number surpassed 1000. Also in 1984 the **[DNS](dns.md)** (domain name system) was introduced -- this would allow network nodes to have "human friendly names" like *mycomputer.com* instead of just numeric addresses. In 1985 the first domain name was registered -- it was symbolics.com. In 1987 the number of hosts was around 10000. In 1989 this was already 100000.

In 1990 ARPANET project was officially ended to let the network, now mostly known as the Internet, live and be developed further mostly by the private sector. In this year [EFF](eff.md) (Electronic Frontier Foundation), a major international non-profit that would help overlooking the Internet, was also founded. Due to the exploding popularity the Internet started to run out of IP addresses in early 1990s which was temporarily fixed by so called [CIDR](cidr.md) with long term plans to transition to bigger [IPv6](ipv6.md) addresses.

Probably the biggest milestone in Internet history was the emergence of the **[World Wide Web](www.md)** -- also www or just "the web" -- in 1989 by [Tim Berners-Lee](berners_lee.md) who was at the time working at [CERN](cern.md) in [Europe](europe.md) (i.e. if we see the [US](usa.md) as the inventor of the Internet, the Europe is who made it widespread and famous). The Web was based on the idea of documents (webpages) written in a special language ([HTML](html.md)), all interconnected via clickable links (so called [hypertext](hypertext.md)) viewed with a program called [web browser](web_browser.md). Web's popularity was also helped by the fact that the programs made by Berners-Lee were released to the [public domain](public_domain.md) so that anyone could jump on the web for free, even use it commercially without any fees and so on. And of course, a prerequisite for wide popularity was the presence of the cheap [personal computer](pc.md). Shortly after its invention web competed with other similar services based on similar ideas, most notably [gopher](gopher.md), however some time in the mid 1990s the web took over and would quickly became by far the most prominent Internet service which would go on to make the Internet mainstream. In 1994 [w3c](w3c.md) (World Wide Web Consortium) was established to be the main organization standardizing the web. The web would gradually push all other networks and competing service -- such as [BBS](bbs.md)es, [Usenet](usenet.md) and [gopher](gopher.md) -- to the deepest underground. Of course, having become the [Earth](earth.md)'s largest public forum, the web would also ultimately become what would kill the Internet because all the major powers (read [corporations](corporation.md) and [states](state.md)) would quickly jump in to abuse it for their own propaganda, [marketing](marketing.md), spying, manipulation, crowd control, cyberattacks and so on. This would still take some time, until around 2005 the web was great, very decentralized with plethora of useful personal web pages. People also weren't shitscared by [security](security.md) hysteria yet, [https](https.md) still wasn't the default, everyone would put his photos online along with his name, address and phone number, you could literally visit elementary school websites and find which children went to which class and so on -- no, nothing bad happened, it was all fine. However after this -- with the onset of so called web 2.0 (more [bloated](blot.md) web) and so called [social networks](social_network.md) -- the downhill ride would start. It would still take around anther decade for the web to die completely, until 2010 the web still kept part of its original glory, but after 2015 it all shattered. After 2020 the web is but a corpse inhabited by grandma's playing games on facebook while being bombarded by ads and the corpse of what used to be the web is just being kicked further to the ground by new capitalist cyberweapons such as the "[AI](ai.md)".

Nowadays not only the web but the Internet as a whole is dying by hardcore [capitalism](capitalism.md), becoming greatly [censored](censorship.md), regulated, split (so called [splinternet](splinternet.md)) and controlled by [corporations](corporation.md) who are absolutely killing the old decentralized, [free as in freedom](free_software.md) Internet that was developed by [free software](free_software.md) enthusiasts, nerds, oldschool [hackers](hacking.md), [free speech](free_speech.md) promoters, by universities, scientists and researches in transparent ways, through the RFCs. It is important to remember what it once used to be so that perhaps one day we can see the true Internet return.

Here is the Internet over time in numbers:

| year |~inet servers|~websites |~domains |~% inet users (glob.)|
| ---- | ----------- | -------- | ------- | ------------------- |
| 1969 | 4           |          |         |                     |
| 1970 | 10          |          |         |                     |
| 1975 | 100         |          |         |                     |
| 1980 | 200         |          |         |                     |
| 1985 | 2000        |          | 1       |                     |
| 1990 | 300000      | 1        | 9300    |                     |
| 1995 | 2000000     | 23000    | 71000   | 1                   |
| 2000 | 100000000   | 7000000  | 40000000| 7                   |
| 2005 | 350000000   | 100000000|100000000| 16                  |
| 2010 | 700000000   | 300000000|200000000| 30                  |
| 2015 | 1000000000  |1000000000|300000000| 43                  |

## Alternatives To/Alternative Ways Of Implementing The Internet

See also https://solar.lowtechmagazine.com/2015/10/how-to-build-a-low-tech-internet/.

Internet overtook the world thanks to having enabled great number of services to be provided very cheaply, at great scales and/or with extremely elevated attributes such as minimal [delay](delay.md) or great [bandwidth](bandwidth.md). This is crucial to many industries who couldn't do without such a network, however to individuals or even smaller organizations Internet is frequently just a tool of comfort -- they could exist without the Internet, just a little less comfortably. As Internet is becoming more and more monitored, controlled, overcrowded, limited and censored, we may start to consider the less comfortable alternatives as [good enough](good_enough.md) ways that actually gain us advantages in some other ways, e.g. more [freedom of expression](free_speech.md), more robust network (independence of the Internet infrastructure), technological independence etc. We have to keep in mind the services allowed by the Internet, such as long distance communication, information searching or playing games still mostly exist even without Internet, just usually separated or somehow suffering a few disadvantages; nevertheless these disadvantages may be bearable and/or made smaller, e.g. by adjusting ourselves to the limitations (if our communication becomes slower, we'll simply write longer messages to which we put more thought and information etc.) or combining these alternative services in a clever way. Additionally we can make use of the lessons learned from the Internet (e.g. cleverly designed [protocols](protocol.md), steganography, broadcasts, [digital](digital.md) data, ...) and apply them to the alternative networks. Let us now list a few alternatives to the Internet:

- **[books](book.md), [encyclopedias](encyclopedia.md), magazines, libraries, printed media, paper, film, ...**: Paper is an awesome medium, it's cheap and can hold quite a lot of information, both digital and analog, it can be used without a [computer](computer.md) but can still be combined with computers (e.g. [printers](printer.md), scanning and [OCR](ocr.md), [bar codes](bar_code.md), ...) and/or lower tech tools like [typewriters](typewriter.md) that may help manually copy books (see e.g. [samizdat](samizdat.md) that heavily utilized the ability of typewriters to produce several copies at once; in Antiquity books were copied by slaves with one reading the original out loud with others writing down many copies). Quality paper can be used for reliable [backups](backup.md) (source code, books, photos, even sound -- consider a high DPI print with each pixel recording one sample with its brightness). Posters can leave information for others to find. Books that have been written throughout history provide enormous amount of data and information, great part of which isn't even accessible through the Internet. Books are generally of much higher quality than websites, older ones are additionally free of modern propaganda and [censorship](censorship.md). Print encyclopedias can here and there be used instead of [Wikipedia](wikipedia.md), and they are extremely cheap (seek second hand book stores, no one wants them anymore). Books also provide entertainment, from traditional fiction, poetry etc. to entertaining reads such as the Guinness World Records book or even interactive [RPG](rpg.md) games (see [gamebooks](gamebook.md)). Making your own small library of quality books isn't expensive at all and can really greatly reduce your dependence on the Internet in many ways. **[Micrography](micrography.md)** (scaling down documents to fit many of them on a small film) can help maximize store quite large amounts of data on small media without computers.
- **[sneakernet](sneakernet.md), [data mules](data_mule.md), [snail mail](snail_mail.md), avian carriers, arrows, messengers, [USB](usb.md) exchange, messages in bottle, ...**: Physically transforming messages is another historically tested option, travelers will always be around wanting to get from point A to point B and while at it they may also serve as information carriers -- information doesn't weight that much. When combined with traditional "modern" data storage media such as USB drives we call this the [sneakernet](sneakernet.md). Special case of this are so called *[data mules](data_mule.md)* -- imagine e.g. a bus that carries a computer with [wifi](wifi.md) and drives from village to village, exchanging data with local computers in each village just by getting in close proximity, carrying data not only between the villages but also between the village network and the "big Internet" once it reaches a city that has connection to it (existing example is e.g. [KioskNet](kiosknet.md)) -- with clever software people can do things like send and receive emails and download websites, just a bit slower than with conventional Internet. There exist volunteer organizations that distribute mail. People used to play correspondence [chess](chess.md) over snail mail, with enough dedication you could probably scale it up to some turn-based [MMORPG](mmorpg.md) game. Owing to the small weight, data can be transferred also by small animals such as pigeons (in some places with very bad Internet this is allegedly still the superior way even nowadays, in wars pigeons helped carry huge numbers of messages on microforms) or even just by "throwing", shooting an arrow with message on it, sending it down the river stream and so on. USB sticks are used by activists to send western propaganda to North Korea (e.g. small helium balloons carrying USB sticks with movies and books over the borders for the inhabitants to find). The disadvantage is high communication delay but even if it's orders of magnitude worse than what Internet offers us, bandwidth can still be excellent, sometimes even beating the Internet! Consider that a truck carrying 1000 1 terabyte harddrives arriving from start to its destination in a week achieves a bandwidth of about 1.6 gigabytes per second. That's pretty solid. Future inhabitants of Mars and other planets will inevitably have to deal with  [interplanetary Internet](interplanetary_internet.md) that's doomed by laws of physics to have high delays -- if they can get around the issue, so can we. An interesting concept might be a "slow" network of people who simply meet up once a week and exchange their USB sticks (or SD cards or diskettes or whatever) on which they pass files and messages to others, such as requests for files etc.
- **leaving signs ([rocks](rock.md), sticks, leaves, messages in sand, bulletin boards, ...)**: Some forest people communicate by leaving signs for others e.g. by leaving tears on leaves or making shapes from sticks or rocks -- these can carry messages like "beware, dangerous animal around", "today I hunted down a monkey here" or "I have extra food, come take some". When improved, we could communicate whole text messages, numbers and any binary data this way -- imagine e.g. a small ["bulletin board"](bbs.md) on some frequently visited crossroads between villages where people leave latest news, offers, demands, requests for information from others, silly jokes etc. In some cities there exist book exchange booths (often made from old phone booths) where people just leave their old books for others to take -- this could be further improved by adding some sort of message board for communication. Similarly networks such as *BookCrossing* work by people marking books with a tag and leaving them for others to find in some public place -- the books are traced on the Internet by their tags and may travel around the world.
- **[intranet](intranet.md), [LAN](lan.md), [WAN](wan.md), ...**: Networks using basically the same technology as the Internet ([TCP](tcp.md)/[IP](ip.md), [ethernet](ethernet.md), [wifi](wifi.md), routers, ...), just on smaller scales -- the technology can actually be simpler: simpler routers can be used, no high performance backbone routers are needed, [Ronja](ronja.md) may be used instead of wifi, [DNS](dns.md) may be omitted and so on. There are many such networks, [military](military.md) has its own isolated networks, North Korea has its famous nation-wide isolated intranet ([Kwangmyong](kwangmyong.md)), Cuba has the famous [SNet](snet.md) -- "street net" that's used for pirating and games -- and so on. In Spain there is the famous [Guifi](guifi.md) network (with as of now nearly 40 thousand nodes) working in decentralized manner just on top of many interconnected wifi devices. The advantage is relative simplicity of implementation -- the technology is all there and quite cheap, you can set up your own network in the neighborhood and have complete control over it, government isn't gonna bully you for sharing movies, it won't spy on your communication (at least not so easily) etc.
- **[radio](radio.md), [telegraph](telegraph.md)**: Plain FM/AM radio communication is a serious competition to Internet in terms of delay, bandwidth and distance of reach, while being very simple in comparison -- a skilled individual can construct or repair a radio with just some basic electronic components, which can't be said about digital computer networks that require extremely complex computer chips. Radio can relatively easily transfer analog information such as voice, but it can also send digital information. With [Morse code](morse_code.md) even the most primitive radio communication system can turn into something extremely powerful.
- **[broadcast](broadcast.md) and alternative network topologies** (see also [world broadcast](world_broadcast.md)): broadcasts (one way communication towards many) can be implemented in many ways: with radio, audio, optically and so on. Broadcast only networks, such as [teletext](teletext.md), [TV](tv.md) or radio station broadcast, can be much simpler than a two way communication -- there don't have to be such complex protocols, there are no handshakes, devices can work on low power (as they're only receivers) and the broadcaster can't be overloaded by client requests. These can cover a great range of services such as news, weather forecast, time synchronization, geolocalization, work organization ("now we need you to produce this and this"), some forms of entertainment or providing generally useful data such as maps and [books](books.md). If we do go for two way communication anyway, we should at least consider simpler network topologies -- with Internet we tend to think in mesh networks, i.e. "everyone connected to everyone", but that may be too complex to implement with other kinds of networks, it may be better to consider something like a ring network.
- **optical telegraph, smoke signals, lanterns, flag semaphores, kites, flares, mirrors and other optical communication**: Optical communication is another technique widely used throughout history -- the advantage here is speed as obviously [light](light.md) is the fastest medium you can ever use. Lighting bonfires on hill tops could send a message about incoming enemy at great distances, ancient Greeks could even send more complex messages this way (see Phryctoria), later on even a more complex information could be sent using optical telegraph -- a chain of towers that forwarded symbols one to another by positioning big arms on their rooftops to form some specific shape, with the next tower copying the symbol and so on. You can leave big symbols in your window to send a few bytes to anyone with a telescope in the line of sight of your house. Basically if you can make someone see something, you can send a message; you can increase the amount of data by utilizing [color](color.md), movement, blinking and so on. Also remember that [optical fiber](optical_fiber.md) doesn't need a computer to work, it could probably be operated even manually provided we have some kind of [laser](laser.md).
- **[audio](audio.md) signals (bells, canon shots, drums, horns, megaphones, ...)**: Audio signal were again used a lot in history, a church bell could tell people many different things by how it was rang, canon shots could warn of incoming enemies and so on, voice can be used too. Drums are still widely used this way in Africa. The principle of string telephone can be considered to make some audio based networks.
- **[pneumatic tube](pneumatic_tube.md)** and similar non-electric networks: A network of tubes using pressured air to transform small capsule containers from one place to another pretty fast, often used in factories -- this can carry written messages but also, unlike the Internet, physical objects! Other mechanism could be explored to construct similar networks, e.g. something based on hydraulics, string pulling, steam engines, gears, simple gravity (sending a marble down some tunnel could be a quite fast message) and so on.
- **phone networks, [phreaking](phreaking.md), power line communication etc.**: phone networks (and possibly other networks like the electric network, TV network etc.) can be used for all kinds of communication, with [modems](modem.md) they can interconnect digital computers (which was widely used before Internet became widespread, see e.g. [BBS](bbs.md) networks); these networks can also be [hacked](hacking.md) to be used for free or cheap communication -- old time hackers knew how to rape phone boots to let them make free calls (see [phreaking](phreaking.md)). Networks primarily used for carrying power can also carry information alongside power (see [power line communication](plc.md)). Nowadays more anti hacking measures are in place but you may still e.g. exploit the fact that merely ringing someone's phone is completely free, which can be used to send a few [bits](bit.md) of information. WARNING: It's generally illegal to mess with these networks in unintended ways, trying this shit's always on you :-) Also touching random electric cables can kill you. If you by accident take down some optical cable or something, you'll be fined to death.
- **normal voice communication**: As stupid as it sounds, we can sometimes just talk to other people, even if they live in another village, simply by going there and talking to them. You can use shouting to reach even people who are far away instantly -- some communities even invented things like [whistling languages](whistling_language.md) to communicate simple messages on extreme distances, this was used by hunters in forests etc. We got too much used to using cell phones to communicate with someone who just happens to be in another room, but this is just stupid, this can be just discarded as human degeneracy.
- **petroglyphs ([rock](rock.md) carving), wood carving, glass painting, knot tying, metal tables etc.**: Data can be recorded manually in many materials, e.g. Incas used Quipu, a special knot tying language. Carving to stone is hard but will last for a long time, it is ideal for preserving small amounts of important information for a long time. See also [rock carved binary data](rcbd.md).
- **[circuit switching](circuit_sqitching.md)**: Network technology based on establishing direct connections between nodes that want to communicate -- this predate [packet switching](packet_switching.md) used by the Internet, i.e. it might be called more primitive and easier to implement.
- **human memory**: Human memory can be used instead of computer memory, though we have to bear in mind its limitations. In very old times, before books became common and cheap, there existed people who made living by memorizing history in forms of long poems and recited them in public (this is how e.g. Iliad and Odyssey survived until they were actually recorded).
- **public fora**: Instead of an Internet discussion forum or chat it's possible to just allocate some public space for people to simply talk. Instead of [YouTube](youtube.md) videos people can go see someone's lecture, with the advantage of being able to actually talk to the guy and ask questions -- again, pretty obvious but the new generation may already be forgetting things can be [done simply](kiss.md).
- **local storage/paper and offline programs instead of [cloud](cloud.md)**: This is again more of a note for the newer generation that's used to storing everything in the cloud and also using "cloud apps" -- you can (and SHOULD) store things locally of course, you can use offline programs and eve boomer solutions like a literal paper notebook for taking notes instead of using some online note taking "app". Similarly you can store your cash [money](money.md) and private photos in a physical safe instead of relying on Internet banking or password protected clouds and voila, suddenly you free of yet another bullshit.
- **[microfilm](microfilm.md) readers**: Microfilms (microfiche) used to be used to back up and store large amounts of text such as newspapers, accounting records or books (although images can be stored too). Whatever is stored on the film is scaled down so that very little physical space can hold a lot of data (stored documents are usually 1/25th of their original size, one reel can hold up to 10000 pages, plus with [color](color.md) film it's possible to use each of the RGB channels to store data in 3 layers, tripling the capacity). To read the data there exist microfilm readers, which typically do nothing more than magnify the film with a lens and shine some light on it, i.e. they are [simple technology](kiss.md). Old libraries would have big microfilm readers with huge screens (resembling CRT monitors a little bit), but there existed even pocket-sized personal readers.
- **doing it yourself, becoming independent**: you can replace many online services by just doing them yourself, for example instead of online weather forecast you can build your own small weather station, instead of online music streaming service you can just buy a harddrive, load it with mp3s and let it play on random, and so on.
- **"online only sometimes"**: An approach contrasted with the "always online" philosophy of the mainstream. This can greatly minimize dependency on connectivity, bandwidth and latency. Though a lot of technology is built with the premise of having constant access to the Internet, practically speaking few tasks require it by nature. You can do most things offline -- reading and replying to emails, reading and searching websites, watching movies, programming and committing to git repositories, playing slow-paced turn based games, all of these require just connecting to the Internet once in quite a long while to refresh the data, send the buffers out and download new queued resources. With just a little effort you can set this up.
- [telepathy](telepathy.md)? :D
- ...

## Internet In LRS

*See also [The Island](island.md) network.*

Would the Internet exist in [less retarded society](less_retarded_society.md)? Is it compatible with it? And if so, how different would it be?

It's very clear the Internet as seen today was shaped by [capitalism](capitalism.md) and thus reflects its (anti)values such as [consumerism](consumerism.md), [censorship](censorship.md) ("[privacy](privacy.md)", "[security](security.md)"), wasteful [maximalism](bloat.md) (maximum bandwidth, maximum speed, ...), centralized control ([DNS](dns.md), content delivery networks, ...) etc. This is what would have to change in less retarded society whose values are mostly opposite: [minimalism](minimalism.md), [simplicity](kiss.md), [selflessness](selflessness.md), non-commerce, absolute openness, slow life etc. In a better form the Internet is indeed completely compatible with ideal society, it is a tool that can be used for the good. Many of the above mentioned alternative and non-traditional ways of data exchange could be used to make Internet "less retarded".

As always nothing can be predicted with certainty, but our Internet would likely be more diverse e.g. in protocols and media used for connecting computers which would depend on location: in some places radio and cables could be used, in other places data mules, light or sound could do better, and highly expensive and complicated methods like satellites would be reduced or eliminated. Computers wouldn't sport the *always online* paradigm like they do today, personal ones mostly wouldn't even use wifis (though they could easily receive [radio broadcasts](world_broadcast.md)) -- common people would carry their personal computers along with the data they need, and would only connect to local Internet hubs if they need to send an email or download some additional data. Two way radio communication would potentially only be used to connect far away hubs if cables would be too expensive, and even so the transmission wouldn't likely be sustained 24/7, it could only happen for example once a day. As a result Internet would be slower, data from far away would be [cached](cache.md) in local hubs and Internet communities would be more local (in the spirit of [BBS](bbs.md) networks in the 80s and 90s), more self sufficient and more independent. Internet would blend together with all other networks and so for example [radio broadcasts](world_broadcast.md) would become part of it, enabling easier, further reaching and more efficient one way transmission of data about weather, news and so on. Instantaneous high-bandwidth communication, such as video calls, would be possible on shorter distances but challenging and sometimes impossible over large distances, but society wouldn't depend on them like it does today.

TODO: moar

## See Also

- [JWICS](jwics.md), [SIPRNet](siprnet.md), [NIPRNet](niprnet.md) (secret/military networks)
- [smol internet](smol_internet.md)
- [sneakernet](sneakernet.md)
- [World Wide Web](www.md)
- [splinternet](splinternet.md)
- [Kwangmyong](kwangmyong.md) (North Korean intranet)
- [Snet](snet.md) (large computer network on Cuba)
- [soynet](soynet.md)
- [interplanetary internet](interplanetary_internet.md)
- [books](books.md)