# Infinity

Infinity (from Latin *in* and *finis*, *without end*) is a quantity so unimaginably large that it has no end. It plays a prominent role especially in [mathematics](math.md) and [philosophy](philosophy.md). As a "largest imaginable quantity" it is sometimes seen to be the opposite of the number [zero](zero.md), the "smallest possible quantity", though other "opposites" can be though of too, such as minus infinity or an infinitely small non-zero number ([infinitesimal](infinitesimal.md)). The symbol for infinity is *lemniscate*, the symbol 8 turned 90 degrees ([unicode](unicode.md) U+221E, looking a bit like `oo`). Keep in mind that mere lack of boundaries doesn't imply infinity -- a [circle](circle.md) has no end but is not infinite; an infinity implies there is always more, no matter how much we get.

The concept of infinity came to firstly be explored by philosophers -- as an abstract concept (similar to those of e.g. [zero](zero.md) or negative numbers) it took a while for it to evolve, be explored and accepted. We can't say who first "discovered" infinity, civilizations often had concepts similar to it that were connected for example to their gods. Zeno of Elea (5th century BC) was one of the earliest to tackle the issue of infinity mathematically by proposing [paradoxes](paradox.md) such as that of Achilles and the tortoise.

The term *infinity* has two slightly distinct meanings:

- **potential infinity**: The unboundedness, lack of upper limit. For example the sequence of odd numbers 1, 3, 5, ... is potentially infinite. This is the less problematic kind of infinity as we know what's going on: we simply lack any limit and can keep going on forever.
- **actual infinity**: Infinity as an actual "object" (for example a number) that's somehow "endlessly large", larger beyond any limits, largest possible etc. This type of infinity poses more issues as we don't know anything like this from [real life](irl.md), we lack experience and intuition about it, we don't know how such an object should behave and we encounter [paradoxes](paradox.md). Stuff can get pretty weird and things we take for granted stop working, such as being able to just randomly pick elements from sets (see [axiom of choice](axiom_of_choice.md)). For example if we have the largest object possible, what happens if we put two of such objects together, will we get yet a larger object or not? How about two infinities minus one infinity -- is that an infinity or zero? What if we shrink infinity to half, what size will it have?

It could be argued that potential infinity is really the reason for the existence of true, high level mathematics as we know it, as that is concerned with constructing mathematical [proofs](proof.md) -- such proofs are needed anywhere where there exist infinitely many possibilities, as if there was only a finite number of possibilities, we could simply enumerate and check them all without much thinking (e.g. with the help of a [computer](computer.md)). For example to confirm [Fermat's Last Theorem](fermats_last_theorem.md) ("for whole numbers and *n > 2* the equation *a^n + b^n = c^n* doesn't have a solution") we need a logical proof because there are infinitely many numbers; if there were only finitely many numbers, we could simply check them all and see if the theorem holds. So infinity, in a sense, is really what forces mathematicians to think.

**Is infinity a [number](number.md)?** Usually no, but it depends on the context. Infinity is not a [real number](real_number.md) (which we usually understand by the term "number"), nor does it belong to any traditionally used set of numbers like integers or rational numbers, because including infinity would break the mathematical structure of these sets (e.g. real numbers would seize to be a [field](field.md)), so the safe implicit answer to the question is no, infinity is not a traditional number, it is rather a concept closely related to numbers. However infinity may sometimes behave like a number and we may want to treat it so, so there also exist "special" number sets that include it -- see for example [transfinite numbers](transfinite_number.md) that are used to work with infinite sets and the numbers can be thought of as "sort of infinity numbers", but again, they are separated from the realm of the "traditional" numbers. This comes to play for example when computing [limits](limit.md) with which we want to be able to get infinity as a result. The first infinite ordinal number **[omega](omega.md)** is often seen as "the infinity number", but this always comes with asterisks, with infinities we have to start distinguishing between cardinal and ordinal numbers, we have to define all the basic operations again, check if they actually work, we also may have to give up some convenient assumptions we could use before as a tradeoff and so on. So ultimately everything depends on our definition of what number is and we can declare infinity to be a number in some systems, see also *extended real number line* and so on.

An important term related to the term *infinite* is **[infinitesimal](infinitesimal.md)**, or *infinitely small*, a  concept very important e.g. for [calculus](calculus.md). While the "traditional" concept of infinity looks beyond the greatest numbers imaginable, the concept of infinitely small is about being able to divide (or "zoom in", see also [fractals](fractal.md)) without end, i.e. it appears while we start dividing by infinity -- this is important for [limits](limit.md) with which we explore values of functions that get "infinitely close" to some value without actually reaching it.
 
When treated as [cardinality](cardinality.md) (i.e. size of a [set](set.md)), we conclude that **there are many infinities, some larger than others**, for example there are infinitely many [rational numbers](rational_number.md) and infinitely many [real numbers](real_number.md), but in a sense there are more real numbers than rational ones -- this is very counter intuitive, but nevertheless was proven by [Georg Cantor](cantor.md) in 1874. He showed that it is possible to create a 1 to 1 pairing of natural numbers and rational numbers and so that these sets are of the same size -- he called this kind of infinity **[countable](countable.md)** -- then he showed it is not possible to make such pairing with real numbers and so that there are more real numbers than rational ones -- he called this kind of infinity **[uncountable](uncountable.md)**. Furthermore this hierarchy of "larger and larger infinities" goes on forever, as for any set we can always create a set with larger cardinality e.g. by taking its [power set](power_set.md) (a set of all subsets).

**In regards to [programming](programming.md)**: programmers are often just engineers and so simplify the subject of infinity in a way which to a mathematician would seem unacceptable. For example it is often a [good enough](good_enough.md) approximation of infinity to just use an extremely large number value, e.g. the largest one storable in given data type, which of course has its limitations, but in practice [just werks](just_werkd.md) (just watch out for [overflows](overflow.md)). Programmers also often resort to breaking the mathematical rules, e.g. they may accept that *x / 0 = infinity*, *infinity + infinity = infinity* etc. Systems based on [symbolic computation](symbolic_computation.md) may be able to handle infinity with exact mathematical precision. Advanced data types, such as [floating point](float.md), often have a special value for infinity -- IEEE 754 floating point, for example, is capable of representing positive and negative infinity.

WATCH OUT: **infinite universe doesn't imply existence of everything** -- this is a common fallacy to think it does. For example people tend to think that since the decimal expansion of the digits of [pi](pi.md) is infinite and basically "random", there should always exist any finite string of digits somewhere in it; this doesn't follow from the mere fact that the series is infinite (though the conclusion MAY or may not be true, we don't actually know this about pi yet). Imagine for example the infinite series of even numbers -- there are infinitely many numbers in it, but you will never find any odd number there.

## See Also

- [zero](zero.md)
- [thrembo](thrembo.md)