# Humidity

Humidity is the relative amount of water vapor present in the air, commonly expressed as a percentage of the maximum possible humidity. Humidity is a [physical](physics.md) property of an environment that depends on location, [temperature](temperature.md), altitude and pressure, rain frequency, proximity to bodies of water and other factors, and it must be considered by both engineers and common folk as one of the variables in certain problems such as choosing building materials, archiving books, designing [electronics](electronics.md) etc. It's also something to know by survivalists because humidity plays a role in things like choosing correct sleeping bags and affects how quickly people get tired (by limiting effectiveness of sweating), how well cloths can be dried etc.

**How does humidity work and how is it measured?** Ordinarily we use a simple [analog](analog.md) device called **hygrometer** which, curiously, often functions by having a human hair inside whose length stretches based on humidity and thus moves a needle over the scale. It's quite cheap and sometimes comes also with thermometer (it may be a good idea to buy two so as to detect if one breaks). The scale shows so called **relative humidity**, i.e. the percentage of how much water vapor there is in the air compared to the maximum possible amount of vapor the air could hold at the current temperature. Knowing how exactly this works is important but [often misunderstood](often_misunderstood.md) -- the percentage does NOT state the ratio of water to how much water the space could have, that would be ridiculous because 100% would imply there is only water and no air, and it's certainly not the case that tropical forest would be submerged underwater for having 100% humidity. Humidity says how much of the air's "vapor carrying capacity" is utilized (and this capacity depends on temperature), i.e. should the humidity be, let's say, 50%, then if we spray small water droplets in the air, they will be absorbed by the air whose humidity will accordingly increase, but once the humidity reaches 100% and we repeat the experiment, the air won't be able to absorb them anymore -- the droplets will fly and land on whatever objects are around and (depending on the material of the objects) will either get soaked in them or just form a puddle. In a 100% humid environment it's hard to dry clothes because the water has nowhere to go and if we dry something with fire for example, it will immediately start to pull water again from the oversaturated air. Since the "vapor capacity" depends on temperature, relative humidity will decrease if we increase air temperature (the total amount of water present is the same, but there will be more "room" for it) and vice versa, so turning your heater up will make your hygrometer immediately show lower humidity but that doesn't mean the water is disappearing, it's just that the air is now taking water from whatever stuff is around. This knowledge will be crucial for subsequent dealing with humidity.

**What humidity do we want?** This depends -- a book archivist will want it low, but if we're growing tropical plants, we want it high :-) Generally for preserving natural materials like wood and paper we aim for low humidity, it's no coincidence that mummies in the dry deserts of Egypt are so well preserved. More water means more chemical reactions and micro life that feeds on shit and destroys it probably (not fact checked but makes sense, no?). [Life](life.md) on the other hand requires water to exist, so it needs humidity, but then also too much is sometimes TOO much -- depends on organism (some cacti presumably won't thank you for too much water). The million dollar question is: **what about electronics?** Most sources seem to recommend staying around 50%, too much humidity can result in corrosion and short circuits, but too little humidity increases risk of static electricity, so we want a balance.

**How to deal with high or low humidity?** First of all (it's logical but just IN CASE) we should probably somewhat isolate the room/box/whatever we want to control humidity in, else the humidity will, naturally, constantly be equalizing with the environment and we just waste time. Next: increasing humidity is not that difficult -- typically it's achieved by spraying water in the air or leaving bowls of water and wet towels around from which water continuously evaporates. Decreasing humidity is a bigger challenge, the first thing to do is to heat the air and have good ventilation and air circulation (turn on the heater, heat it up real high, then open all windows and doors for 10 or 15 minutes, maybe turn on fans if you have some) -- higher temperature allows the air to take hold of all the water from the environment (that previously, at a lower temperature, was soaked into whatever objects were around) and circulating air takes it all away -- however in a very humid climate (forests etc., but even very cold climates can have high humidity!), the air we get out will be replaced by the air from outside that's still very humid and so this may only help so much. And so protecting electronics from humidity in very wet climates turns out to be a challenge, but there are ways to go about it. Firstly some devices are designed to be more durable, short circuit protected, water resistant or even waterproof: we may find them among [military](military.md) and diver technology and [old](old.md), durable pieces of industrial equipment for example. This will be preferable, but keep in mind as well that for example waterproof boxes are worthless if the humidity inside the box itself is high. Stuff can be repaired to some degree, corrosion can be removed. As the next step we can proceed to create a special low humidity box wherein we'll be storing our valuable possessions, be it old books or expensive electronics (in case of books it will also be good to keep the box in darkness, sunlight is no good). Now take it as fact that unless the box is truly airtight, humidity WILL find its way inside slowly (the better the isolation, the slower build up; also smaller boxes may isolate better for having a shorter circumference of the lid which is where the humidity gets it), you can't prevent this, so we have to be somehow dehumidifying the inside constantly. There exist boxes for storing luxury cigars which automatically maintain set humidity -- this is however a [bloated](bloat.md), complicated solution relying on batteries and shit, we can make something similar in a more [KISS](kiss.md) way. Get a plastic box whose lid sits as tightly as possible (although it will never be airtight, the more it isolates the better). It can be transparent so that a hygrometer can be placed inside to indicate the humidity level and letting us know if it works. Next: place dehumidifiers inside -- these are things such as silica gel, rice, cat litter, blotting paper, maybe some sponges and stuff alike. There exist chemical dehumidifiers that work well but have to be refilled every once in a while, but there also exists a nicer product: car dehumidifying bags. These decrease humidity and can be reused! Once they get too wet, they are simply dried in a microwave (stove might possibly work too). { This worked well for me. ~drummyfish } A completely [primitivist](primitivism.md) way could perhaps be a super dry dirt { Haven't tested this tho. ~drummyfish }, but it must be dried real well (put it in fire for a long time). Then just place your stuff in the box and shut it tight, maybe even use duct tape to isolate the lid even better (depending on how often you plan to open the box, it's not necessary), keep it in a warmer (but preferably dark) place. Every once in a while (a few months probably) open it and replace the dehumidifiers with new ones, dry the bags and so on. Pet bottles could perhaps be used for small stuff that fits inside.