# Human Language

Human language is a language used mostly by [humans](human.md) to communicate with each other; these languages are very hard to handle by [computers](computer.md) (only quite recently [neural network](neural_net.md) computer programs became able to show true understanding of human language). They are studied by [linguists](linguistics.md). It is estimated that roughly 5000 human languages exist in the world. Human languages are most commonly **natural languages**, i.e. ones that evolved naturally over many centuries such as [English](english.md), [Chinese](chinese.md), French or [Latin](latin.md), but there also exist a great number of so called **[constructed languages](conlang.md)** (*conlangs*), i.e. artificially made ones such as [Esperanto](esperanto.md), Interslavic or [Lojban](lojban.md). But all of these are still human languages, different from e.g. [computer languages](computer_language.md) such [C](c.md) or [XML](xml.md). Natural human languages practically always show significant irregularities (exceptions to general rules) while constructed languages typically try to eliminate irregularities as much as possible so as to make them easier to learn, but even a constructed human language is still extremely difficult for a computer to understand.

Human language is a social construct so according to [pseudoleftists](pseudoleft.md) it's an illusion, doesn't exist, doesn't work and has no significance.

Languages are sadly often what easily divides people into groups and so fuels [fascism](fascism.md), specifically [nationalism](nationalism.md).

It's worthy of reminding ourselves that human languages don't have to be limited to spoken ones, we mustn't forget sign languages, visual languages etc., but in this article we'll be predominantly concerned with the spoken ones and assume them implicitly. Spoken languages are also often tightly connected to their writing systems and scripts, but we should be aware of the fact that a language and the way it is written are also two separate things.

**Why are human languages so hard for computers to handle?** Well, firstly there are minor annoyances like syntactic ambiguity, irregularities, redundancy, complex rules of grammar -- for example the sentence "I know Bob likes computers, and so does John." can either mean that John knows that Bob likes computers or that both Bob and John like computers. Things like this can be addressed by designing the [grammar](grammar.md) unambiguously, but analyzing already existing natural languages suffers by this. Furthermore in real life there are countless quirks of playing with language, things like sacrasm, parody, exaggerations, indirect hints, politeness, rhetorical questions, fau pax, memes and references. For example when we think of imperative, we imagine sentences such as "Close the window." -- in real life we'll rather say something like "I'm cold, it wouldn't hurt to close the window.", i.e. something that's semantically an imperative but not syntactically, a dumb computer would deduce here we are stating a fact that closing the window will not hurt anyone; it takes human-like intelligence AND experience in how the real life works and abilities like being able to guess feelings and plans of others to correctly conclude this sentence in fact means "Please close the window." Just try to talk to someone for a while and focus on what the sentences mean literally and what they actually imply. So things revolving around this are pose the first issue, but yet a greater issue dwells in how to actually define meanings of words -- human language is not just "text strings" as it might seem on the first glance, behind the text strings lies a deep understanding of the extremely complex [real world](irl.md). More details of the issues of semantic will be given below.

**What is the most [LRS](lrs.md) human language?** This is not [settled](settled.md) yet but [Esparanto](esperanto.md) looks pretty cool. [English](english.md) is actually one of the most [suckless](suckless.md) languages, it's extremely easy and everyone speaks it -- it's not perfect but it is like [C](c.md) in programming, likely the best things we probably have at the moment. As a part of [less retarded society](less_retarded_society.md) we should aim to create a constructed language that will be universally spoken by everyone and which, if at all possible, will solve the issue of the great language curse described below.

## The Grand Curse Of Human Language

{ The following is a thought dump made without much research, please inform me if you're a linguist or philosopher or something and have something enlightening to say, thank you <3 ~drummyfish }

It's been said that language is the source of all misunderstanding. And indeed, on one hand human languages are cool when viewed from cultural or [artistic](art.md) perspective, they allow us to write poetry, describe feelings and nature around us -- in this way they can be considered [beautiful](beauty.md). However from the perspective of others, e.g. programmers or historians, **human languages are a [nightmare](nightmare.md)**. There is unfortunately an **enormous, inherent curse connected to any human language**, both natural or constructed, that comes from its inevitably [fuzzy](fuzzy.md) nature stemming from fuzziness of real life concepts, it's the problem of **defining [semantics](semantics.md)** of words and constructs (no, Lojban doesn't solve this). [Syntax](syntax.md) (i.e. the rules that say which sentences are valid and which are not) doesn't pose such a problem, we can quite easily define what's grammatically correct or not (it's not as hard to write a program that checks gramatical correctness), it is semantics (i.e. meanings) that is extremely hard to grasp and inevitably presents a trench between all living beings -- even in rigorous languages (such as mathematical notation or programming languages) semantics is a bit harder to define (quite often still relying on bits of human language), but while in a programming language we are essentially able to define quite EXACTLY what each construct means (e.g. `a + b` returns the sum of values *a* and *b*), in a natural language we are basically never able to do that, we can only ever form fuzzy connections between other fuzzy concepts and we can never have anything fixed.

Due to this fuzziness human languages inevitably change over time in spite of our best effort, any text written a few thousand years ago is nowadays very hard to understand -- not because the old languages aren't spoken anymore, but because the original meanings of specific words, phrases and constructs are distorted by time and lost; when learning an old language we learn what each word meant by reading its translation to some modern word, but the modern word is always more or less different. Even if it's a very simple word such as "fish", our modern word for fish means a slightly different thing than let's say ancient Roman's word for fish because it had slightly different connotations such as potential references to other things: fish for example used to be the symbol of Christianity, nowadays people don't even commonly make this connection. Fishermen were a despised class of workers, to some fish may have signified food and abundance, to others something that "smells bad", to others something or someone who's "slippery". Some words may have referred to some contemporary "[meme](meme.md)" that's been long forgotten and if some text makes the reference, we won't understand it. The word "book" for example meant something a bit different 2000 years ago than it means now: back then a book might have been just a relatively short scroll, it was expensive and people didn't read books the same way as we do today, they commonly just read them out loud to others, so "reading a book" and the word "book" itself doesn't conjure the same picture in our heads as it did back then. Or another example showing the difference between languages existing at the same time is this: while the Spanish word "perro" translates to English as "dog", the meanings aren't the same; some English speakers use the word as a synonym for "friend" but in Spanish the word can be used as an insult so shouting "perro" and "dog" in the street may lead to different (possibly completely opposite) images popping up in the heads of those who hear it. Westerners who spend a lot of time in eastern countries will confirm that it is absolutely the case that many eastern spiritual terms and texts are untranslatable to English, or translatable only very, very imprecisely: there are words for concepts that western culture simply lacks and even words that have more or less direct translation may carry different connotations, such as the word "void" which in the east has often a positive connotation, unlike in the west. When you study philosophy, you'll be told you have to read philosophers in their original language in order to really understand them. Imagine you speak to an isolated bushmen tribe somewhere in Africa and you have to translate the word "vaporwave" or "doomer meme" when they don't have a word for Internet, computer or electricity, they don't know what depression, multimedia or technological addiction is and can't even comprehend the concept of a social network because they have hard time imagining there could exist many more people in the world, being unable to count beyond 10, thinking the world probably ends beyond the horizon -- you may perhaps say "vaporwave" is "funny music" and "doomer meme" is a "sad idea", but you know it's actually a very poor translation. It's not because their language was poorer than yours (in fact many of such languages have been found to be extremely hard to learn), it will just have evolved to express other things, ones you can't understand, complex things about nature, jungle, hunting, hundreds of different plants, what's edible and what's poisonous (in which ways, to whom, with what certainty, in which quantities, under which circumstances, ...), subtle distinctions of many different species of animals, rocks, water, trees, fire, weather and so on. Even within our own culture we struggle to communicate, depressed people have hard time explaining what depression really is to people who never experienced true depression, we use words like "sorrow", "emptiness", "exhaustion", but once again, only as rough approximations to the true, indescribable feeling.

How do you describe a word precisely if you can only describe it with other imprecise words that are changing constantly? No, not even pictures will help -- if you attach the picture of a cat to the word "cat", it's still not clear what it means -- does it stand for the picture of the cat or for the cat that's in the picture, does it stand ONLY for the one cat that's in the picture or all other animals that are similar to the one in the picture? How similar? Is lion a cat? Is a toy cat or cartoon cat a cat? Or does the picture signify that anything with a fur is a cat? If it looks like cat but walks on two legs and speaks, is it still a cat? Now imagine describing a more abstract term such as *thought*, *number* or *existence*. There is no solid ground, even such essential words as "to want" or "to be" have different meanings between languages ("to be" can stand for "to exist", "to be in a place", "to temporarily have some property", "to permanently have some property" etc.). Even dictionaries admit defeat and are happy with having circular definitions because there aren't any foundations to build upon, circular definitions are inevitable, dictionaries just help you connect fuzzy concepts together. All of this extends to tenses, moods, cases and everything else. This can be very well seen e.g. with people interpreting old texts such as the Bible, for example some say [Jesus](jesus.md) claimed to be the son of God while others reject it, saying that even if he stated the sentence, it actually wasn't meant literally as it was a commonly used phrase that meant something else -- these people will argue about everything and they can comfortably interpret the same text in completely opposite ways. The point is that we just can't know.

{ Just one more of other countless examples I recently encountered: it used to be generally believed that [Jesus](jesus.md) was crucified so that he was nailed on the cross through his palms, however it was shown this wouldn't work and also other evidence showed people were nailed more in the arms, in a way that would hold the weight of the body but wouldn't hit the artery. The confusion came from translation -- the Greek word for "hand" also includes part of an arm, i.e. the word for hand in Greek is different from the word hand in some other languages. ~drummyfish }

In addition there are ALWAYS great many hidden implicit assumptions that both communicating sides have to share to be able to communicate (and these can only be assured by many years of learning, spent in the same environment) -- for example if I tell someone "Drive to the city and buy food.", in fact I mean something like "Right now walk with your feet to our car, open the door, sit in, take the wheel in your hands, start the car, drive only on the road with your eyes open, ..."; the guy can technically satisfy my order by waiting 10 years, then driving a truck through forests with eyes closed over the whole globe and back. Just as it's impossible to perfectly define all words, it is impossible to explicitly recount all assumptions. Though the mentioned example is exaggerated, it shows an ever present phenomenon we have to deal with, a phenomenon which can cause misunderstanding or be easily abused.

Of course this barrier exists between contemporary languages too, the idiom "lost in translation" exists for a reason -- translating something always loses or at least changes something. Translating one sentence over and over to different languages and back to the original one will most likely produce a sentence with very distinct meaning.

This is the grand issue that common people almost universally overlook, most will naively think that with careful effort it is possible to express oneself so clearly that others simply won't be able to misunderstand -- this is sadly false, even with most carefully crafted sentences language always extremely easily allows any word to be twisted by politicians to anything they want, it destroys old knowledge and prevents us from communicating with clarity and recording ideas so that they would last into the future. This damnation of language plagues every book, authors constantly complain "I should have rather used this and that word" but that wouldn't even help, it's impossible to say something so as to not be misunderstood because human language is a weak, crippled tool just based on shouting weird sounds in hopes someone will get a vague idea of what's going on in your head. Due to this limitation of language it is absolutely worthless to discuss anything if after 5 minutes you don't come to agreement, the discussion will lead nowhere, it's best to just leave it at communication being impossible because even if linguistically you speak the same language, you cannot communicate correct meanings, even words like "is", "when", "bad" or "will" will have absolutely different meanings, you would have to define every word of every sentence and then every word of every new sentence you produce for 1000 years until you come to circular definitions when you'll still be disagreeing but won't even be able to waste time further.

This issue is very hard to solve, maybe impossible. It seems that due to the extreme complexity of [real life](irl.md) our language can't operate with precise equations but rather has to settle with concepts that are just fuzzy blobs that our brains -- [neural networks](neural_net.md) in our heads -- learn by trial and error over many years. We learn that if we hear the word *X*, it's best to react by feeling fear or turning our head or closing our eyes etc.

{ The only idea of a solution on how to make a "mathematically precise" human language for real world communication is the following. Firstly make a mathematical model of some artificial world that's similar to ours, for simplicity we can now just consider something like a 2D grid with differently colored cells, i.e. something like a [cellular automaton](cellular_automaton.md). The world changes in steps and each cell can "talk", i.e. at any frame it can emit a text string. Now make a language that's precisely defined in this world; if the world is simple, it's pretty doable e.g. like this: write a function in some programming language that takes the world and check if what the cells are saying classifies as your language used in a correct way within this world (so the function just returns *true/false*, nothing else is needed). Now this single function mathematically defines your language -- by looking at your function's source code anyone can derive the absolutely correct meaning of any word or sentence because he can see how the function checks whether that word of phrase is used correctly, he will know exactly which situations fit given sentence and which don't. Now the final step is only to find correspondence between the real life and your simplified mathematical world, e.g. that cells represent humans and so on (but this will have shortcomings, e.g. our simple world will make it difficult or impossible to talk about body parts since cells have none; also making the connection between the mathematical world and real world relies on intuition). ~drummyfish }

{ Yet another, maybe more practical idea would be to create a set of very few core  words -- let's say 100, which we would try to define extremely precisely by all the current imperfect means but with very elevated effort, i.e. each word would have a detailed description, translations to 20 other natural languages, positive and negative examples, pictures attached etc. Then the rest of the language would be defined only using these core words. But maybe it wouldn't work -- the language would be possibly a bit more stable but would eventually degenerate as well. ~drummyfish }

## Existing Languages

*See also [stereotype](stereotype.md).*

UNDER CONSTRUCTION

Recommendation for a [fun](fun.md) activity: a cool hobby for long winter nights is to compare various passages of text in different languages, you get to discover hilarious words this way. A way to do this is to take a famous movie (Pulp Fiction for instance) and download subtitles in many different languages, or do the same with a famous book, or take a look at some translations of [libre](libre.md) games etc.

This section will now list some of the most notable human languages. In the brackets there will be additional information about the language such as the number of native speakers, translation of the sentence "What's your name" (in *italics*) or three most common letters/sounds (between [ and ] brackets).

- **Indo-European languages** (~3 B native speakers): Most common language family, originating in Eurasia.
  - **Germanic languages** (~500 M native speakers): Come from Scandinavia.
    - **Afrikaans** (~7 M native speakers, *Wat is jou naam?*): Young language, very similar to Dutch and English.
    - **Danish** (~6 M native speakers, *Hvad er dit navn?*): Sounds a little bit like German and Dutch minus the pig sounds.
    - **Dutch** (~25 M native speakers, Netherlands, [ena], *Wat is jouw naam?*): Similar to English but with added "grunting" pig sounds.
    - **[English](english.md)** (~400 M native speakers, [eta], *What's your name?*): Most spoken language in the world (considering also non-native speakers), very simple grammar, fixed word order, no letters with accents, pronounces "r" as if "having a hot potato in mouth", awkward spelling of words, can't say the Spanish "j", is the universal world language of modern age, a must know for everyone. Mutually intelligible with Scots.
      - **Australian**: Very similar to UK.
      - **Irish**: Most prominent feature is probably pronouncing "th" as "t" or "d", pronounce "r"s.
      - **New Zealand**: Pronounce certain letters differently, e.g. "pen" sounds like "pin".
      - **UK** (so called "Bri'ish"): Sounds soft, snobby and arrogant, "r" is often silent, final "a" in a word may be pronounced as "r".
      - **[USA](usa.md)**: Harder sound than UK, always pronounces "r" which also sounds very hard, which makes the language easier to understandable, "t" often sounds like "d", speakers open mouth very wide when talking.
        - south: TODO
      - ...
    - **German** (~100 M native speakers, [eni], *Wie heißt du?*): Hard and rough staccato rhythm sound, unpleasant, very long words, identifiable by characteristic rolling "r" and articles like "das", "der" etc.
    - **Norwegian** (~4 M native speakers, *Hva heter du?*): Frankly a weird language, to a non-speaker sounds at times like a mix of all other languages. Is mutually intelligible with Swedish and Danish.
    - **Scots** (*Whit's yer name?*): Spoken in parts of Scotland, is mutually intelligible with English -- in fact it's often described as "English with funny spelling".
    - **Swedish** (~10 M native speakers, [ean], *Vad heter du?*): Mutually intelligible with Norwegian and Danish, doesn't have the "ch" (as in "chicken") sound.
    - **Yiddish** (~4 M native speakers, *װי הײסטו, "Vi heystu?"*): Language spoken by [Jews](jew.md), developed in Jewish diaspora, an interesting "Frankenstein monster" mix of German, Hebrew and other languages, written right to left.
    - ...
  - **Romance languages** (~1 B native speakers): Evolved from Latin, not the hardest to learn.
    - **French** (~200 M native speakers, [esa], *Comment tu t'appelles?*): Very unique and distinctive [gay](gay.md) sound of French shows to what degree a serious language like Latin can degenerate, especially notable is the soft "r" and phrases like "ooo la la!", duckface when speaking, one the most easily recognizable languages. Loanwords: anecdote, desire, sacrifice, ...
    - **Italian** (~60 M native speakers, [eai], *Come ti chiami?*): Pleasant and melodic, very similar to Latin, sounds like singing, lots of vowels, stresses many times on first syllable. Body language such as waving hands in the air is a big part of speaking Italian correctly, recognizable by iconic phrases such as "spaghetti al dente, mamma mia!". Loanwords: intermezzo, lava, piano, ...
    - **Portuguese** (~250 M native speakers, [aeo], *Como te chamas?*): Basically Spanish with funny pronunciation, speakers of the two languages can understand each other to a high degree. Loanwords: flamingo, tank, jaguar, ...
    - **Romanian** ([eia], *Cum vă numiți?*): Sounds similar to Italian, has a lot borrowed from Slavic languages.
    - **Spanish** (~500 M native speakers, [eao], *¿Cómo te llamas?*): Extremely fast, quite pleasant and similar to Italian, has normal and hard "r" (written *rr*), can't pronounce "h" (it's always silent), recognizable by patterns like "El XXXo", "Los XXXos" etc. Described by [Uncyclopedia](uncyclopedia.md) as "essentially Latin for retards", nonetheless spoken all over the world (it's the second most spoken native language) and therefore very useful to learn. Has a rich vocabulary of swear words and phrases. Among students feared mainly for grammatical mood called subjunctive. In written form weird (and recognizable) by using the upside down question mark to start questions. Loanword: macho, caldera, mosquito, ...
      - **Mexican**: Uses a lot of diminutives (e.g. "ahorita"), uses only formal form of plural "you" (ustedes), has specific words and meanings.
    - ...
  - **Slavic languages** (~300 M native speakers): Hard to learn, many grammatical cases and inflections, spoken in central/east Europe and north Asia.
    - **Bulgarian** (*как се казваш, "Kak se kazvash?"*): TODO
    - **Croatian** ([aio], *Kako se zoveš?*): Kinda similar to Czech/Slovak/Polish, seems to have a lot of "ch" (as in "chicken") sounds, has 7 cases.
    - **[Czech](czechia.md)** (~10 M native speakers, [oea], *Jak se jmenuješ?*): Very similar to Slovak but with a harder sound, stress is on first syllable, has 7 cases and 3 genders, contains the infamous "ř" which some consider the most unique and possibly most difficult sound to pronounce in any language -- by this it can be recognized. Famous loanword coming from Czech is [robot](robot.md).
    - **Polish** ([iae], *Jak się nazywasz?*): Similar to Czech/Slovak, has many "sz", "sh", "ch" sounds, stress usually on penultimate syllable, has 7 cases.
    - **Russian** (~150 M native speakers, [oea], *Как тебя зовут?, "Kak tebia zovut?"*): Written in Cyrillic, characteristic sounds like "blj", speaking with duckface and long end and middle parts of words, has 6 cases. Loanwords: mammoth, tundra, babushka, ...
    - **Slovak** ([aoe], *Ako sa voláš?*): Super similar to Czech (mutually intelligible), sounds much softer and more pleasant, especially e.g. the letter "l", also compared to Czech doesn't have [bullshit](bullshit.md) like "ř" and vocative case, has 6 cases total.
    - **Ukrainian** (~20 M native speakers, [oan], *Як тебе звати?, "Jak tebe zvati?"*): Different from Russian but sounds the same, has 7 cases.
    - ...
  - ...
- **Other languages**:
  - **Arabic** (~400 M native speakers, *ما اسمك؟, "Ma ismuka?"*): Sounds fast, weird script written right to left, difficult to learn, liturgical language of [Islam](islam.md). Loanwords: algebra, coffee, alcohol, ...
  - **[Chinese](chinese.md)** (~1 B native speakers, *你贵姓大名?, "Ni quixing daming?"*): Considered the hardest language ever, has many variants and dialects that are even mutually unintelligible (and as such is actually sometimes rather considered a language family), most notably Cantonese and Mandarin, has most native speakers of all languages, has many soft sounds like "shii", "shoo", "chii", plus those "ching chong" sounds along with weird intonation (the language is tonal, meaning pitch changes meaning of words), writing system is a disaster (one character per word), has no grammatical tenses. Loanwords: tea, [zen](zen.md), [soy](soy.md), ...
  - **[Esperanto](esperanto.md)** ([aie], *Kio estas via nomo?*): Most famous [constructed language](conlang.md), even has a few native speakers, sounds similar to Italian, in general resembled Romance languages, is very easy to learn thanks to completely regular grammar and vocabulary borrowed from many existing languages.
  - **Finnish** ([ena], *Mikä sinun nimesi on?*): Has 14 cases and inflections, so word order is not fixed, stress often on first syllable.
  - **Greek** ([aoi], *Πώς σε λένε?, "Pos se lene?"*): Famously using the weird Greek alphabet, its old version is very historically significant. Loanwords: [democracy](democracy.md), [utopia](utopia.md), chronology, ...
  - **Hebrew** (*מַה שִּׁמְךָ?, "Ma shimkha?"*): TODO
  - **Hindi** (~350 M native speakers, *तुम्हारा नाम क्या हे, "Tumhaara naam kya he?"*): Language of India, sounds quite fast, has that very specific "clicky" pronunciation of certain sounds like "t", "r" and "d", weird script, women talk in high pitch squeaking.
  - **Hungarian**:  Super gibberish, many "sh" sounds, has 18 cases.
  - **Interslavic** (*Kako je tvoje ime?*): [Constructed language](conlang.md) to be understandable by speakers of any Slavic language. { As a Czech native speaker I can understand it very well without ever having studied it, especially in written form, it sounds like Polish or Croatian that I can actually understand. ~drummyfish }
  - **Japanese** (~100 M native speakers, [rnu], *お名前はなんですか?, "Onamae wa nan desu ka"*): Very characteristic sound, recognizable by keywords like "desu" and "ka", can't pronounce "l", everything ends with "u", women talk like squeaky toys, brutally difficult writing system (one character per word, but unlike Chinese at least includes scripts for writing words by sillables), has many different "politeness" levels of speech and only two grammatical tenses (present and past), famously "doesn't have swearwords" (which apparently isn't completely true, they just "insult each other differently"). [Interestingly](interesting.md) the origin of the language is still shrouded in mystery. Loanwords: [anime](anime.md), bonsai, judo, ...
  - **Klingon** (*nuq 'oH ponglIj'e'?*): Fictional constructed language from Star Trek, in real life spoken mainly by [boomer](boomer.md) [nerds](nerd.md). Learning the language will make you [never get laid](wizard.md).
  - **Korean** (~80 M native speakers, *이름이 뭐에요?, "Ileum i mwo eyo?"*): Sounds like Japanese but isn't Japanese (can be recognized by lack of "Japanese keywords"), simple writing system, starts to incorporate many English words. Loanwords: kimchi, taekwondo, ondol, ...
  - **[Latin](latin.md)** ([eit], *Quid est nomen tibi?*): Officially not spoken anymore but many enthusiasts learn it, [historically](history.md) significant, similar to Italian, everything is written WITH CAPSLOCK, doesn't have the letter "U" (uses "V" instead), characteristic word endings such as "us", "um". Loanwords: mundane, altruism, cull, ...
  - **[Newspeak](newspeak.md)** (*Question [moderated](censored.md) for [privacy](privacy.md) concerns.*): Language from a famous dystopian sci-fi book *[1984](1984.md)*, a version of English formed to serve brainwashing and thought control. At the time of writing the book the language was fictional, [nowadays](21st_century.md) it's already being implemented. Loanwords: xer, blocklist, neurodivergent, ...
  - **Sanskrit** (*तव नाम किम्, "Tavva nama kim?"*): Old language, nowadays spoken only by few, sacred most notably to Hinduism, important to Asia where it's something akin to what Latin and old Greek is to Europe. Loanwords: yoga, avatar, nirvana, ...
  - **[Toki Pona](toki_pona.md)** (*nimi sina li seme?*): New constructed language claiming to be highly [minimalist](minimalism.md), however also looks kind of [SJW](sjw.md).
  - **Turkish** (~80 M native speakers, [aei], *İsmin ne?*): Stress on last syllable, written in weird kind of Latin script.
  - **Vietnamese** (~100 M native speakers, *Bạn tên gì?*): Typical Asian "meowing" sound, but despite this it's [interestingly](interesting.md) written in Latin script, which also excessively uses diacritics. It's a tonal language (pitches distinguish meanings of words).
  - ...
  
**Language [curiosities](interesting.md)**: Harold Whitmore Williams (*1876) allegedly spoke 58 languages and is sometimes considered the most accomplished polyglot. The most common sound found in all languages is "a", the most unique probably the Czech "ř". Language with smallest alphabet is probably Rotokas, spoken in Papua New Guinea, with only 12 letters. English word with the most meanings is apparently "set" (almost 200). Longest non-technical word in English is "antidisestablishmentarianism", but if we impose no limits, there is a name of a chemical that's 189819 letters long. TODO: more

TODO: average word length, longest word, number of letters in alphabet, ...

TODO2: maybe let's make it a table instead of a list, include interesting columns such as number of cases, tenses and genders and so on

## How To Learn A Foreign Language

WIP

Here are some tips for learning foreign languages:

- **Learn ONLY the absolute bare basics from a textbook.** Just to get yourself started you probably have to force yourself through the most boring part: memorizing the absolute basics such as pronunciation of letters, basic digits, personal pronouns, colors etc., however only invest small amount of time here, let's say a week or two, then move on to immersing yourself in the language. Sure, every once in a while you may get back to a book when learning a new tense for example, but remember this is always just an initial boost to get the natural learning started.
- **Don't spend too much time learning grammar.** As per above: you only want to spent very little time memorizing theory, you will never learn a language by reading ABOUT it just like you won't learn [programming](programming.md) or [chess](chess.md) by reading about it, to learn something you must do it.
- **Start with bilingual dictionary, move on to monolingual one ASAP.** Do not use phone "apps", buy a paper dictionary. At first, when you're noob, buy the one that translates words to your native language, but once you are able to, buy the monolingual dictionary that gives the meanings of the words in the language itself. It is ideal if you can learn the language using the language itself, this helps immersion greatly, minimizes distracting jumps between languages, and you're learning much more (not just the word you're looking up, but also the words used in the definition).
- **Maximize time when you're immersed in the language.** This is what every language learner will tell you: you learn the language by living surrounded by it. Some things you may do include:
  - **Listen to [music](music.md).** Music is amazing, it's beautiful, you love it, forming emotional bond with the language, and it gets stuck in your head, you learn the lyrics easily and with it all the words and grammar used in it. If you have favorite songs in another language, look for their versions in the language you're learning, you will likely find at least unofficial ones. It is the case that for example many Italian songs have also official Spanish versions.
  - **Read [books](book.md).** Beginners often try to read children books so that the language is not too difficult, but you will likely be bored reading a child book, it may be better to rather choose a book that's genuinely interesting to you (for example about your favorite video game or a topic of interest) and then try to slowly get through it with a dictionary. There exist learning bilingual books that come with a side-by-side translation; you may achieve this also by downloading the book in your native language and in the language you're learning and just reading them side by side, for example by paragraphs. If you're a retard who can't read also consider audio books.
  - **Set your electronic devices to the language.** For example your cell phone, operating system, games you play etc.
  - **Play [games](game.md).** You can set a game's language to the one you're learning or play games specifically designed for language learning.
  - **Watch movies with subtitles in the language you're learning.** Do NOT put on subtitles in your native language, that will just make you read them and not focus on the language you're learning. It may be cool to watch movies you already know and like in the foreign language dub, you will just know what's going on and you'll likely at least remember the memorable lines.
  - **Watch [memes](meme.md), videos etc.**
  - **Move to a country that speaks the language.** Obviously, works probably 100% of the times, but takes some dedication.
  - **Passive "consumption" doesn't really work.** Like [Luke Smith](luke_smith.md) points out oh his website, you will probably learn next to nothing by just having audio playing in your room without actually paying any attention to it (just like you won't learn to program just by sharing a room with a programmer) -- it's good to have the language around, but to learn it one must concentrate and interact with it at least sometimes.
  - ...
- **"Comprehensible input"** is a method promoted by many teachers nowadays, and it seems to be very effective. It basically says: "consume" as much "content" in the language as you can, i.e. watch videos, listen to music, watch TV etc., but you must understand it at least a bit -- this doesn't mean you must understand every word and every sentence, on the contrary if you do, you'll probably learn nothing, but you also mustn't be absolutely clueless about what's going on (so just don't go reading medieval poetry right away). The point is you seeing people talk about things and naturally deducing what words mean e.g. from their body language, AND getting the "feel" for the structures used in the language -- by listening to the language you build the intuiting for knowing when something "sounds wrong", even without knowing the exact rules, and this is how you learn the grammar without memorizing it.
- **Create a steady habit, it's a long run, not a sprint.** It is ideal if you make it a habit to actively study the language EVERY SINGLE DAY, even if it just means watching one 10 minute video every day. You think it's a burden but you'll get into it quickly after a week or two and then it will be as natural as brushing your teeth. It is better to study 10 minutes every day than 70 minutes once a week -- spread the time evenly, this way you'll firstly put in more focus (fully focusing for 70 minutes is impossible, but completely doable for 10 minutes) and secondly you won't allow yourself to ever fall out of the language. Remember: you CANNOT learn a language in a week, not in a month, you need at least several years. If you dedicate 10, 15 minutes to the language every day for three years, it is IMPOSSIBLE you don't learn it at least at some intermediate level.
- **Use the language to learn about what you LIKE.** As stated, rather than choosing a boring children book pick up something more difficult that actually interests you and which you enjoy -- this is not a school class where you have to read generic textbook stories, you can read or watch WHATEVER you love! If you love [Pokemon](pokemon.md), watch videos about Pokemon, if you love math, go read about math, no one is limiting you.
- **Communicate, even just with yourself.** You can learn by only listening and reading, but you will mostly acquire only a PASSIVE vocabulary, you won't be able to actually speak; to learn to speak and build active vocabulary you simply have to speak. If you're super asocial, just talk to yourself in your head: go take a walk and try to describe what you're seeing, or try to switch your inner monologue to the language you're learning. Once you find yourself thinking in the language naturally, you know you're getting genuinely good at it.
- **Do NOT translate word for word in your head.** You don't want to be consciously translating in your head, this is a mistake that beginners often do, they think they must do this but no, that's not your goal. If you feel the need to translate in your head, you're just still too bad at the language -- keep listening to the language more and more, "absorb" it until you just hear the language and you understand it immediately without replacing words with the words from your native language.
- **Don't try to understand 100%.** Another beginner mistake is to listen to something or read something and stop at every single unknown word, being frustrated at not understanding a whole sentence etc. This just makes you spend 10 minutes on every sentence and staying frustrated that even then you don't understand it completely because of some more advanced grammar or slang you couldn't look up. You want to do this: listen, listen, listen, read a paragraph or two and then stop, ask yourself: do I have a clue of what's being talked about? If yes, great! It's enough if you cough let's say 10%, it doesn't matter you missed some words or sentences, keep going. If you're clueless, rewind and listen again, you'll probably catch more. If there is a word that's being repeated in every sentence and you couldn't reason out what it could be, quickly look it up, but don't bother with the rest. You want the language to flow. Don't worry, if you're focusing and have some idea about what's going on, the brain is subconsciously absorbing the language even if you don't know about it, just keep doing it, in a month you'll see you'll be another step ahead. Test it: get back to the same stuff and see if you understand more than last time -- it's almost certain you will.
- **Lover is the best language teacher.** { And vice versa lol? ~drummyfish } However you're probably an [incel](incel.md) virgin so this doesn't matter anyway.
- **Exploit general learning techniques.** For example reading before sleep may be effective to remember study material better. Other people learn very well by making cheatsheets -- you can hang your cheatsheets on a wall so that you see them every day and get reminded about the words you're learning etc. Other people like to make flashcards (cards with a word in native language and its equivalent in the foreign language on the other side) and quiz themselves. Word cards can also be placed around the house etc. Just do whatever works for you.
- Do NOT use fucking [proprietary](proprietary.md) [capitalist](capitalism.md) language "[apps](app.md)", they fucking just give you brain [cancer](cancer.md).
- **Watch out for false friends**. These are words that look and sound very similar to words in a language you already know, but they mean something different, so you may easily end up using them wrong. For example "actual" in Spanish doesn't translate as "actual" in English -- in Spanish it means "current" (as in "current events") whereas in English it means "real".
- If you want to get super serious and git gud even at pronunciation, there are techniques such as shadowing (trying to speak over native speaker recordings, imitating them) etc. But this is not needed if you just want to communicate or if you don't even talk to people [in real life](irl.md), it's just for nerds who wanna flex probably.
- **Necessity teaches best**. Literally needing the language, e.g. due to having moved to another country, reliably leads to learning it.
- Especially if you're learning your first foreign language: be ready, make no assumptions about the new language based on your native language, different language may break all the rules of your language and importantly: different language is not just different words and grammar, it is also a **different [CULTURE](culture.md)**, reflecting the needs and necessities of the people using it. Forget EVERYTHING you think you know and that you assume should hold, many words and sentences will be UNTRANSLATABLE. There will be many rules that make ZERO logical sense, for example a word may have different spelling in different contexts just because, or there will be many words for something that in your language only has one name, just don't ask why, it simply is so. The new language may for example have various politeness levels -- different ways of says "you" for instance, depending on whom you are addressing -- which will have no counterpart in English; there may be completely different tenses and cases, grammatical concepts you never heard of, words may have unclear translations or unexpected connotations, it may be uncommon to make [jokes](jokes.md) you're used to make (for example in [Czech](czech.md) it's not common to make [puns](pun.md) as much as in English), certain phrases will be used much more or much less frequently (e.g. in English it's pretty common to hear family members say "I love you" to one another, but this isn't common in many other languages), in some languages it's very common to greet strangers with many different phrases etc. Don't try to understand these differences logically, these are historical and cultural features which are sometimes untraceable leftovers from something that's already gone, you just have to learn it all by listening and using the language, you can't memorize it.
- **The difficulty of learning a language depends on how close it is to the closest language you already know**. This is just a fact that can help you decide what to learn or understand why a supposedly "easy" language is very difficult for you -- if you're Italian, you'll learn Spanish very easily, if you're German, you'll learn English very easily etc. This is also why polyglots learn languages with seemingly low effort: it becomes easier and easier to learn languages the more of them you know because they somewhat overlap.
- ...

## See Also

- [programming language](programming_language.md)
- [formal language](formal_language.md)
- [lrs dictionary](lrs_dictionary.md)
