# Homelessness

Homelessness (sometimes also houselessness) is the state of having no permanent residence such as a house, flat or other kind of accommodation. Homeless people are colloquially called *hobos* (not to be confused with [homos](gay.md)). Our society imposes the punishment of homelessness (as a replacement for more primitive punishments such as exile) on those who have lose the [capitalist](capitalism.md) game of self interest (or simply refused to participate) and so have fallen into poverty leading to inability of paying for a place to stay, for which homelessness is further associated with poverty, poor health, [depression](depression.md) and other misfortune. Homelessness is capitalism's death sentence: the homeless is either required to repent by accepting yet much amplified levels of inhumane slavery to pay all the "debts", or simply starve or freeze to death or end up as a hunting game for neonazis (in capitalism the homeless can be freely killed because they have no relatives so no one will notice or sue anyone, people also generally applaud killing the homeless). Nonetheless homelessness actually presents the highest [freedom](freedom.md) one can achieve (even if it might not last long), no longer having to care about unimportant things with which a common [wage slave](work.md) is constantly preoccupied, being able to travel freely, not having to be a [slave](work.md) anymore, and thus as a form of asceticism this seemingly undesirable fate is in fact voluntarily chosen and practiced by the wisest among people. No more bills to pay, no more insurance or contracts, crippling mortgages, headaches induced by managing property, no paper work, going insane from broken computers, car maintenance, house maintenance, garden maintenance, no more uncomfortable suits, suicide inducing TV [ads](marketing.md), no longer being chained to the place of work, not having to talk to idiots every day or attend annoying family celebrations, not having to get up early and spend whole day stressed out sucking dicks of the overlords, no need to take sleeping pills to fall asleep early so that the next day you can jump up with the sound of alarm clock to slave until exhaustion for a millionth time, no need to swallow cancer inducing antidepressants to be able to withstand being yelled at every day, no worry about being [canceled](cancel_culture.md), discredited, defamed, sued, ... no more [bullshit](bullshit.md), only a world awaiting you, traveling and observing, good things waiting to be done, out of your free will. Yes, indeed, being homeless is recommended by [LRS](lrs.md).

## Homeless Tips

The following are some tips that may come in handy to the homeless. Officially we do """not""" recommend breaking the law but unofficially it's very nice :D

### General

- Do NOT look for a way to get back to society, STOP fucking going to job interviews, once you're homeless you are homeless FOREVER, and this means you are now FREE, your goal is to make it just more comfortable to be homeless. Enjoy every second of your new life.
- **Staying nice looking and well behaved has many advantages**, people will let you in places where normally dirty homeless aren't allowed. Also double consider options that would make you known as the "troublemaker", that can make police and others hostile to you. And similarly if you make friends by being nice and make yourself known as "that nice homeless guy" -- for example by cleaning the place where you stay, smiling at people and just generally helping them -- they will even like having you around, they may give you food, let you sleep at their property etc.
- **Trash bins are goldmines**, you may find a lot of useful stuff in them, people just throw away perfectly usable things very often.
- **Publicly accessible spaces** are awesome, for example: libraries, universities, hospitals, doctor waiting rooms, hotel lobbies, post offices, airports, train stations, work offices, shopping malls, churches etc. The only condition for entry is usually just looking and smelling normal, that's why it's important to maintain good look. Some of these places keep a minimum kind of security -- such as door access cards in some university buildings -- but usually you can get in, either by passing with a crowd OR by some kind of less visible back entry (there always have to be fire exits etc.). Then you may get a lot for free, including toilets, electricity plugs, free wifi, warmth in winter, comfortable rest areas etc.
- There are sometimes **[electricity](electricity.md) plugs** in underground passages for maintenance, you can use them to charge your phone etc. Also other plugs will probably be found in other public spaces mentioned above.
- Check out **[survival](survival.md) guides**, they may contain a lot of valuable info about food, DIY healthcare etc.
- Don't let it get to you, don't become a depressed drunk or drug addict, rather become the awesome based nomad monk who travels from place to place like a bird, enjoying richness of the world instead of the dystopian consumerist stereotype. Remember, you are now free, unlike majority of the sheeps enslaved by the system. It may be uncomfortable at times, but think of all the things you DON'T have to endure anymore and this which you CAN do that you couldn't do before. Make the best of your situation, enjoy every day.
- Watch out for gangs, mafia, pimps, drug addicts, fascists, asshole police etc. -- it's a jungle in the streets, especially in big cities. You don't experience this until you are homeless, you don't pay attention to the scum, you avoid them, and they avoid you knowing they could get in trouble by hurting you, but an old, weak homeless guy with little money and no relatives is firstly a good target for crime, but mainly a [COMPETITION](competition.md) to other people in the street jungle. Some will be very territorial, good begging spots in big cities will probably be controlled by some local homeless gang, you better stay away from it. Always observe and check out the situation before you do something. It is probably much safer to find a smaller town, maybe have your hideout somewhere in a forest and only come to the city from time to time to get food.
- At night you can do a lot of stuff you can't do during day -- obviously, but it's good to plan this way. Walking street at 3 AM in darkness with absolutely no one around allows you to checks trash cans, people's mail boxes, pick up fruit from people's trees and so on, everyone is sleeping to get up at 7 AM to go to slavery. The only danger may be other people doing the same as you, so again, this is may be not such a great idea in a big city, but on a village night is your friend.
- Breaking into houses is hard and risky -- break ins are discourages in general as it means getting in conflict, potentially causing damage, getting in jail and, of course, doing harm to someone, which is not good. But if it's absolutely necessary, then lonely huts and caravans that aren't permanently lived in are probably best target. For example fisherman huts in lonely places will probably be completely without any people around out of fishing seasons. Inside may be very useful things including money, food, drink, clothes, electronics, tools and so on, however one should always aim to minimize damage done by breaking in and stealing: small theft may slip by, big damage will piss someone off and can result in long prison sentence. Of course in the US you may even get shot by some redneck if you get caught breaking in.
- You can find stuff near construction sites: a lot of useful material is just thrown away, many tools are lying around, maybe there will even be food or something. These are quickly set up temporary places with low security and underpaid people, usually retards.
- You want to become an **opportunist**: as a hobo you'll have little security or stability in anything, you have to learn to seek, spot and take opportunities and adopt the mindset of a gatherer -- you want to save up for worse times, your fate will be subject to a lot of chance and things beyond your control, sometimes you'll be lucky and find good stuff and some days you'll get nothing. Be ready for it, accept it and learn to live like this.
- If you pretend to be (or even truly are) a pilgrim, a Buddhist monk or something similar, more people will likely be willing to help you than if you were an ordinary hobo.
- ...

### Money

*See also [frugality](frugality.md).*

- Check out **charities, homeless shelters, churches, social welfare offices, hippie communities** etc. Charities and churches probably won't give you [money](money.md), but they may give you the things you want to buy (and then you may sell them if you really just want the money :D). Some countries will pay people a bare livable minimum of money if they literally have nothing, there are some laws for that (in US probably tough luck though lol).
- **Begging**: possibly the easiest and most popular way to get money. Remember, be very nice, don't be drunk. Try to look like you're new on the street, that someone kicked you out of home, that you just need to buy a bit of food. Some try to make up stories like "my wallet was stolen and I need money for a bus to get home", but nowadays this seems to no longer work, people don't buy it, honesty may actually be better, just say you need it for food. Don't bother people and don't call too much attention, police might come for you. If someone gets mad, don't argue, thank him anyway and leave, you don't want trouble. Sometimes it may help to ask couples, a guy won't want to look like a greedy bastard in front of his girlfriend. Having a dog with you might help, people like animals and they'll want it to be fed, you will look like a good man for taking care of a dog. Some people try doing some kind of "street art" or just kneeling to show they're real desperate, you just have to experiment and find what works best in your specific area (this will all depend on culture, laws etc.). Don't overeat to be fat even if you can, no one will give you money for food if you're fat -- learn to eat less (you'll get used to it, it's not hard) and become skinny, people will be more likely to give you something. Don't beg every day in the same spot, you don't want to become too annoying and make police do something about you.
- Small amounts of money can possibly be found **near places where people frequently handle cash**, e.g. supermarkets, ATMs, vending machines, parking ticket machines etc. Look in places where dropped coins might end up (cracks in sidewalk etc.). Worthy of checking out are also places such as cycling roads where things are likely to fall off bikes etc.
- Check **vending machines**, people sometimes forget to take returned coins.
- Some coins may be found in **fountains, holy places, shrines** etc. as superstitious people leave spare coins there for good luck. However these places are also often guarded by police, so watch out.
- **Small "jobs"**: just quickly help someone and ask for a tip, get creative. You can lend a hand to people that are repairing something; or maybe try this: near a shop offer an old lady to carry her bags home (don't ask for money yet), while you're doing it talk to her, be nice, friendly, ask about her life (old people are lonely), and once you get to her home very kindly mention that you're homeless and could use some spare money for food. If you have more courage, you may consider even mild prostitution etc. (a quick handjob costs you nothing and can make you quite nice money for the effort), just watch out to not get in trouble.
- **Along train tacks you can find metal stuff to sell** that falls off trains and is left by maintenance workers, you might collect it and sell it.
- **You may return shop carts or beer bottles** near supermarkets to get some small cash.
- You may possibly **sell stuff you find in trash to pawn shops**. Some people even make living as "flippers": they walk between pawn shops, buy low and sell high, but that may already be considered work, so you wanna avoid that.
- **Pickpocketing** is risky and harms people, so not very advised, but some may still choose to do it because a fat wallet may provide months worth of income for a humble hobo, it's just too attractive. This is done in very crowded areas, e.g. in public transport and so on.
- ...

### Food

- Check out **food banks, charities, churches** etc., they will probably give you something for free.
- Some religious groups provide food, specifically e.g. **Sikhs give free food** (called Langar) to everyone who comes no matter their religion, social status etc. But in general all religions are inclined to charity and caring for homeless, including most Christians.
- **Food samples in supermarkets** are said to have fed many immigrants who found themselves in USA without any money at hand -- again, you must look normal, you can't just come there looking like a zombie, they'll kick you out.
- **Fruit, mushrooms and food for animals**: you'll find this in many gardens, forests and even public city places, just collect it at night. Bird food or dog food isn't any worse than human food, it's probably much better than what people in third world must eat. In the fields you might be able to **dig out some potatoes**, find corn or similar stuff. **Jerusalem artichoke** is similar to potatoes but it grows like [cancer](cancer.md) and kills all other plants, to the point of sometimes being illegal to even plant, so you will find it in many places just growing wild -- in fact this fed many people in war times. Of course there are also apples, pears and so on. **Mushroom picking** in forests is a regular hobby activity (especially in [Czechia](czechia.md)) that provides very tasty food, BUT one must be skilled in recognizing the edible mushrooms and preparing them, it's very possible to poisons oneself, plus mushrooms are also hard to digest so you can't keep eating them all the time.
- **Fields** offer an opportunity to just grab food, be it some kind of corn or wheat or whatever. One could possibly even collect wheat at night and then make his own flour, add some water and cook it to make something akin a bread, might be quite a comfy source of food.
- **Vending machines** contain food that's normally not constantly guarded by humans, e.g. near big train stations. It might be not so hard to dig some food out at night (especially if you have slim anorexic arms), but try to not damage the machine (companies won't probably might so much a stolen piece of food but they will mind a damaged equipment, they could remove the machine, or if you get caught you might be forced to pay for the damage).
- **Supermarkets and restaurants throw away perfectly fine food** because they can't sell it anymore if it's older than *X* days -- it's absolutely fine, they just can't sell it for legal reasons. You want to get this (check out the bins where they might be dumping it or perhaps even try to ask someone if they'd just give it to you).
- In shopping malls **food prices are lower late** in the evening, before closing hours, because they need to get rid of what's left, otherwise they have to throw it away. Also damaged packaging lowers the price of food -- sometimes there is a special corner with damaged cans etc., you want to get this.
- Learn **frugality and how to get most for least money** as food will likely be one of your biggest expenses, you want to optimize your spending as much as possible here: don't buy complete meals, only cheaper, raw, nutrient ingredients from which you'll make food (you don't have money but have a lot of time). Stack up long lasting food (buy it in larger quantities for smaller price) so that you're never in immediate danger of starving: then you can afford to wait for discounts and save money. Learn all the other tricks like the damaged packaging, expired food, price changes over the day and so on.
- **Fishing** can provide a food source unless you're a vegetarian (which you should be). Fishing pole is not needed, it's enough to make a net out of a t-shirt on a stick and take some small fish out of water.
- In **fastfoods** and similar kinds of restaurants you may easily find free food people leave there; go there in the busiest hours (around lunch), well dressed and nice looking. There will likely be a long line -- pretend to stand there for a while, look around, then change your mind and turn around; as you're leaving, check out the area where people leave their dishes, many just leave some food on the plate because they were already full or their child didn't eat it or because it fell on the ground -- just slowly, calmly take it (maybe carry a shopping bag) and leave. Don't do it too often in the same place else they do something about it.
- **Attending random weddings and other celebrations**: even many non-homeless people like to do this for fun, you will just need to look very good, i.e. have a suit, nice haircut, be shaved and smell good. This may be hard to achieve for a homeless guy but not impossible. Besides weddings you can try any other kind of gathering such as a funeral or graduation party or whatever, the only requirement is that there be many people so that no one can know everyone else at the same time. Plan ahead and make up some kind of quick identity and excuses if someone talks to you, you don't wanna improvise. It is incredible how people can sneak almost in any place if they just have the right clothes and confidently act as if they simply belong there. Weddings will have luxury food for everyone, just eat as much as you can (slowly, you don't want to get spotted), and at the end try to take more food with you under your clothes (if you get caught here, you already have a full stomach at least).
- Early in the morning when it's still dark **when supplies arrive to small shops**, you might be able to quickly steal something from the truck when no one's around (just quickly "walk by" and take something under your jacket). You should observe their routine for a few days in order to be well prepared.
- **Trash bins** may contain food that's still good. But double check it's really edible. Make sure to **check out trash behind supermarkets, shops and restaurants**, they may just throw away perfectly good food -- it might be good to also just ask them, they'll probably give you something rather than throwing it away.
- **Drinkable water** can sometimes be found near sport and school playgrounds. And again also in publicly accessible toilets (may possibly be found in universities etc., but one must be well dressed). In forests (at least in the Europe) there are commonly found springs of clear, cold mineral water, maintained for anyone to access for free, you can find them on maps.
- **Stealing food delivery**: it may be possible to steal e.g. food delivered in front of the door of elderly people or someone who's not currently at home, however it may also be quite less ethical to rid a poor old lady of her lunch. On the other hand if it's some fat neckbeard you may even be doing him a service. { Now I'm imagining a sci-fi dystopian future of tomorrow in which tribes of homeless people with spears hunt drones delivering food like the cavemen hunted animals lol. ~drummyfish }
- **Shoplifting**: this is risky, one must be VERY careful not to get into trouble with security guards, they take thieves somewhere back and then beat them up to discourage them from returning. Supermarkets have high security, cameras and guards everywhere, magnetic chips in everything, it may be better to lift from smaller shops or open market places. On the other hand a lot of security is just a theatre with fake cameras, fake magnetic detectors and so on (how do you wanna put magnetic chips into food anyway?), security is expensive and many shops likely just pay two fat guys to stand around wearing black glasses, all this with hopes of making people not attempt stealing -- if you can safely spot such weaknesses, you may also exploit them. Choosing busy hours will probably help.
- If you're absolutely starving you can even **eat grass and tree bark** (not the hard bark, you must eat the stuff underneath it), or at least make a soup or something. Similarly in case of extreme hunger **bugs and worms** are an easy source of protein. A fresh roadkill maybe too, but there's probably danger of diseases, rotten meat etc.
- **Everything tastes good with ketchup.** You may invest in buying a bottle of it and then just be able to turn any tastless garbage into yummy "I can't believe it's not McDonalds" meal.
- ...

### Safety/Shelter

- Primitive **heating** (e.g. in a tent) can be achieved with **heated [rocks](rock.md)** or **bottles/bags filled with hot water** (this is even better). { I used heated water bags to sleep in quite cold weather, they are extremely effective. I heated water to near boiling on fire, then poured it in the bag and then left it in my well isolated sleeping bag. It stayed warm for over 12 hours! I even got to a point of feeling too hot. A pet bottle can probably be used if you don't have a bag. ~drummyfish }
- **Tent** is a good, affordable portable shelter, try to get one if you can. More advanced tents (so called hot tents) can even have stoves for heating etc. A **quality sleeping bag** will keep you warm even in freezing temperatures, it's a relatively easy solution to surviving winters compared to building a whole heated house, [keep it simple](kiss.md). Two basic types of sleeping bags are with synthetic insulation and down insulation: synthetic are usually [good enough](good_enough.md) and resist humidity (unlike down). As an alternative to tent (in warmer weather) consider a camping hammock, one with mosquito net and rainfly -- it's quite light, extremely portable, very comfortable and usable in many weather conditions.
- **Fire and stoves** are obviously very cool for keeping warm, cooking, light etc. Again, read survival guides: when making fire, build a heat reflecting wall, collect (dry) wood and leave it nearby so that you can sleep and quickly stack up the fire when cold wakes you up etc. A metal barrel or at least a hole surrounded by [rocks](rock.md) may be better than open fire (protects against wind, holds heat, ...), a stove is even more efficient and better (can regulate power by choking the oxygen supply etc.), but in closed spaces there's a high danger of fire depleting oxygen and killing you in sleep.
- Look up how shelters are built in survival guides. You can e.g. make a dugout or something similar, it can even have a stove for heating and cooking.
- In very cold winters some choose to **voluntarily go to prison** where they get housing, food and health care. Again, in the US prison is hell and you most likely don't want to go there, but e.g. in Scandinavian countries prison is almost like a luxury hotel. However keep in mind that police may get hostile to you in the future if you become the "troublemaker", they may just beat you up or something. Also be sure to commit the right crime, do **NOT** cause material damage or harm anyone, you don't want to get a fine, pay for damage or get a life sentence (OR a death sentence in the US lol). Check your country's laws. One guy for example used the following method: standing in the middle of traffic (slow one so that no accidents happen). There is also a guy who lives in prison because he just refuses to wear clothes -- this may be a cool method as well.
- It may be possible to make a tiny shelter out of a **big trash can** that's stolen from in front of someone's house at night. Then it's washed, taken to a forest, buried horizontally in ground and insulated with leaves, then cloth is put in to sleep on -- pretty cozy.
- Shameless hobos even break into lonely huts that are abandoned for the winter and live there until the owners return in the summer.
- Over time you can even make it quite luxurious, for example you can buy a portable solar panel plus a power bank and then you can charge a phone for playing vidya or read e-books or whatever. However it's better to keep it simple, you will probably find books to be more comfortable.
- ...

### Hygiene

- There are quite many **public showers** in cities or gas stations (for truck drivers), but they're usually paid. { I tested one in some underground passage, it was really nice and clean, and not very expensive at all. ~drummyfish }
- Free **hot water** can sometimes be found flowing from factories to nearby brooks/rivers. It shouldn't be toxic if it flows into a clean river, it was probably just used for cooling.
- **Stealing from paid public toilets** can extremely cheaply buy drinkable water, toilet paper and soap. One just pays the small entry fee, then fills bottles in his backpack and stuffs it with things.
- If you have stove, you can wash yourself even in winter with sponge and hot water, no need for shower or jacuzzi.
- Some people like to buy a super cheap gym membership and just come there to take showers, but this will drain some of your income.
- ...

### Health

- **Hospitals and doctors are obliged by law to help people in immediate emergency** (not sure about [US](usa.md) lol), so if you're real badly sick, probably just drop yourself somewhere near a hospital and look like you're dying, they should help you. You might also try to **fake some mental illness** (again remember to not do damage to anything or anyone) so that they lock you up in a mental hospital for a while where you should get normal health care as well. Same in prison: they can't NOT give you healthcare when keeping you under lock.
- Sometimes doctors and healthcare workers provide free services for the poor every once in a while in some camp or something, especially in the [USA](usa.md) where there is no social security. Try to find these.
- Maybe get some old books about traditional medicine, herbs and shit, can be fine for most things.
- ...

### Transport

- **Hitchhiking** is cool, but you must look (and smell) good. Being a [woman](woman.md) helps.
- **Hopping on trains** can be a way to travel longer distances, but bear in mind it's dangerous: firstly you may hurt yourself, and secondly they may find you and beat you. So think twice.
- **No ticket public transport** can work if you look good, maybe get on a train and lock yourself up in a toilet. If you get caught just run, the inspectors aren't paid enough to chase people.
- You can probably get some kind of older **bicycle** or something similar for cheap or maybe even free, near garbage dumps or garage sales or something, it can be nice for covering short distance travel.
- ...

### Entertainment

- **Newspapers/magazines** can be stolen from people's mailbox, it's enough to wait early in the morning when it's still dark when someone delivers it to the subscriber's box, it's easy to take. Older magazines can probably be stolen e.g. from dentist waiting rooms. Old newspapers are also handy for many things (fire, wiping, ...).
- Check out old timey entertainment: [books](books.md) (e.g. [encyclopedias](encyclopedia.md) are fun), desktop [games](game.md), solitaire card games and so on. It's extremely cool if you manage to make something useful into entertainment, for example knitting or making things out of wood.
- ...

## See Also

- [frugality](frugality.md)
- [freedom](freedom.md)
- [hermit](hermit.md)
- [how to make living](living.md)
