# Free Software

*Not to be [confused](often_confused.md) with [open $ource](open_source.md).*

Free (as in [freedom](freedom.md)) software is a type of ethical [software](software.md) that's respecting its users' freedom and preventing their abuse, generally by availability of its [source code](source_code.md) AND by a [license](license.md) that allows anyone to use, study, modify and share the software without restricting conditions (such as having to pay or get explicit permission from the author). Free software is NOT equal to software whose source code is just available publicly or software that is offered for zero price, the basic legal rights to the software are the key attribute that has to be present. Free software stands opposed to [proprietary software](proprietary_software.md) -- the kind of abusive, closed software that [capitalism](capitalism.md) produces by default. Free software is not to be confused with [freeware](freeware.md) ("gratis", software available for free); although free software is always available for free thanks to its definition, zero price is not its goal. The goal is freedom.

Free software is also known as *free as in freedom*, *free as in speech* software or *libre* software. It is sometimes equated with [open source](open_source.md), even though open source is fundamentally different ([evil](evil.md)), or neutrally labeled FOSS or FLOSS (free/libre and open-source software); sadly free software (as a term and concept) has lost to open source in [mainstream](mainstream.md) popularity. In contrast to free software, software that is merely gratis (freeware) is sometimes called *free as in beer*.

**Examples of free software** include the [GNU](gnu.md) operating system (also known as "[Linux](linux.md)"), [GIMP](gimp.md) (image editor), [Stockfish](stockfish.md) chess engine, or games such as [Xonotic](xonotic.md) and [Anarch](anarch.md). Free software is actually what runs the world, it is a standard among experts and it is possible to do computing with exclusively free software (though this may depend on how far you stretch the definition), even though most normal people don't even know the term free software exists because they only ever come in contact with abusive [proprietary](proprietary.md) consumer software such as [Windows](windows.md) and capitalist [games](game.md). There also exists a lot of big and successful software, such as [Firefox](firefox.md), [Linux](linux.md) (the kernel) or [Blender](blender.md), that's often spoken of as free software which may however be only technically true or true only to a big (but not full) degree: for example even though [Linux](linux.md) is 99% free, in its [vanilla](vanilla.md) version it comes with [proprietary](proprietary.md) [binary blobs](binary_blob.md) which breaks the rules of free software. [Blender](blender.md) is technically free but it is also [capitalist software](capitalist_software.md) which doesn't really care about freedom and may de-facto limit some freedoms required by free software, even if they are granted legally by Blender's license. Such software is better called "[open source](open_source.md)" or [FOSS](foss.md) because it doesn't meet the high standards of free software. This issue of technically-but-not-really free software is addressed by some newer movements and philosophies such as [suckless](suckless.md) and our [less retarded software](lrs.md) who usually also aim for [unbloating](bloat.md) technology so as to make it more free in practice.

```
                               ____________________
    .------------------------>| public source code |<-----.            defined
    ;       .---------------->|____________________|      ; always      mainly _____
    ;       ;            .------^                         ; has ALL        by | FSF |
    ;       ;    "should";      _______________________   ;               ,-->|_____|
    ;       ;        have;     |      unlimited        |  ;              ;     
    ;doesn't;      "most";     | use+stud+modify+share |  ;  _______    ;            _________  high focus on
    ;have   ;  _____     ;     |_______________________|  ; | libre |  ;     main_.>| freedom |<------------.
    ;       ; | OSI |    ;       ^ allows         ^.      ; |_______| ;   goal_.'   |_________|             ;
    ;    has; |_____|    ;       ; by         allows'.    ;      ^   ;   is_.'   ______________             ;
    ;       ;   ^        ;       ; license          by'.  ;  AKA ;  ;  _.'      | free culture |generalizes ;
    ;       ;   ;defined ;   ____;___           license '.;______;_;_.'   __..--|______________|<--.     _.-'
    ;       ;   ;by      '--|  open  |                   |   free   |<--''generalizes           ___;_.-''
    ;       ;   '-----------| source |<----------------->| software |<-------------------------| LRS |--.
 ___;____   ;__________  .--|________|   legally very    |__________|<-..__      generalizes   |_____|  ;
| closed | |  source   | ;  ^ ;      ^.   similar to    .^       ;  ^._    ''--_                  ; ;   ; primary
| source | | available | ;  ; ; neutral'.  _________  .'neutral  ;     '.       ;is               ; ;   ; focus
|________| |___________| ;  ; ;   synonm '| F(L)OSS |'synonym    ;is     ;      ;subset           ; ;   ; on
    ;         ;          ;  ; ;      for  |_________| for        ;always ;      ;of    generalizes; ;  _v_________
    ;       is;          ;  ; ;         ______________           ;       ;   ___;______           ; ; | happiness |
    ;   subset;     main ;  ;  '------>| free of cost |<---------'       ;  | suckless |<---------' ; |  of all   |
    ;       of;  goal is ;  ;     is   |______________|<-._    ________  ;  |__________|            ; |   life    |
    ;         ;          ;  ;   always       ^ ^.       AKA'->| gratis | ;      ;              high ; |___________|
    ;is       ;   _______v  ;                ;   '.AKA        |________| ;      ;primary      focus ;
    ;subset   ;  | profit | ;                ;     'v __________      ^  ;      ;focus on        on ;
    ;of       ;  |________| ; is             ;       | freeware | AKA ;  ;   ___v________           ;
    ;         ;          ^  ; opposite       ;       |__________|<----'  ;  | simplicity |<---------'
    ;         ;     main ;  ; of             ;                           ;  |____________|
    ;         ;  goal is ;  ;                ; may be                 is ;
    ;         ;          ;  '----------.     ;                  opposite ;
    ;         ;          '----------.  ;     ;                        of ;
    ;         ;                    _;__v_____;___________                ;
    ;         '------------------>| proprietary software |<--------------'
    '---------------------------->|______________________|
```

*Knowledge graph illustrating basic relationships between various terms and groups related to free software.*

{ Thanks to Ramon for calling this a "schizo graph" :D ~drummyfish }

Though unknown to common people, the invention and adoption of free software has been **one the most important events in the [history](history.md) of computers** -- mere technology consumers nowadays don't even realize (and aren't told) that what they're using consists and has been enabled possibly mostly by software written non-commercially, by volunteers for free, **basically on [communist](communism.md) principles**. Even if [consumer](consumerism.md) technology is unethical because the underlying free technology has been modified by [corporations](corporation.md) to abuse the users, without free software the situation would have been yet incomparably worse if [Richard Stallman](rms.md) hadn't achieved the small miracle of establishing the free software movement. Without it there would probably be practically no alternative to abusive technology nowadays, everything would be much more closed, there would probably be no "[open source](open_source.md)", "[open hardware](open_hardware.md)" such as [Arduino](arduino.md) and things such as [Wikipedia](wikipedia.md). If the danger of [intellectual property](intellectual_property.md) in software wasn't foreseen and countered by Richard Stallman right in the start, the corporations' push of legislation would probably have continued and copyright [laws](law.md) might have been many times worse today, to the point of not even being able to legally write free software nowadays. We have to be very grateful that this happened and continue to support free software.

[Richard Stallman](rms.md), the inventor of the concept and the term "free software", says free software is about ensuring the freedom of computer users, i.e. people truly owning their tools -- he points out that unless people have complete control over their tools, they don't truly own them and will instead become controlled and abused by the makers (true owners) of those tools, which in [capitalism](capitalism.md) are [corporations](corporation.md). Richard Stallman stressed that **there is no such thing as partially free software** -- it takes only a single line of code to take away the user's freedom and therefore if software is to be free, it has to be free as a whole. This is in direct contrast with [open source](open_source.md) (a term discourages by Stallman himself) which happily tolerates for example [Windows](windows.md) only programs and accepts them as "open source", even though such a program cannot be run without the underlying proprietary code of the platform. It is therefore important to support free software rather than the business spoiled open source.

Fun fact: in Spain there is a street named after free software.

**Free software is not about [privacy](privacy.md)!** That would be quite misleading viewpoint. Free software, as its name suggests, is about freedom in wide sense, which includes the freedom of absolute control over one's devices that may ensure privacy and anonymity, but there are many more freedoms which free software stands for, e.g. the freedom of customization of one's tools or the general freedom of [art](art.md) -- being able to utilize or remix someone else's creation for creating something new or better. Software focused on privacy is called simply privacy respecting software.

The forefront non-profit organization promoting free software has since its invention been the [Free Software Foundation](fsf.md) (FSF) started by Richard Stallman himself alongside his [GNU](gnu.md) project. Nevertheless we must keep in mind that FSF doesn't equal free software, free software as a concept is bigger than its inventor or any organization, the idea -- just as for example political or religious ideas -- has since its birth been adopted with various modifications by many others, it is being expanded, improved, renamed and yes, even twisted and abused. Free software has spawned or influenced for example [Debian](debian.md), [free culture](free_culture.md), [free hardware](free_hardware.md), [FSFE](fsfe.md), [FSFLA](fsfla.md), [open $ource](open_source.md), [suckless](suckless.md), [copyfree](copyfree.md), [freedesktop](freedesktop.md) and many others. FSF itself has become quite spoiled and political, but it has achieved sending out the message about sharing, collaboration and ethics, which at least a few people still try to keep following.

**Is free software [communism](communism.md)?** This is a question often debated by [Americans](usa.md) who have a panic phobia of anything resembling ideas of sharing and giving away for free. The answer is: yes and no. No as in it's not [Marxism](marxism.md), the kind of [evil](evil.md) pseudocommunism that plagued the world not a long time long ago -- that was a hugely complex, twisted violent ideology encompassing whole society which furthermore betrayed many basic ideas of equality and so on. Compared to this free software is just a simple idea of not applying intellectual property to software, and this idea may well function under some form of early capitalism. But on the other hand yes, free software is communism in its general form that simply states that sharing is good, it is communism as much as e.g. teaching a kid to share toys with its siblings.

**Is free software an ideology/cult?** Free software is a movement based on [ethics](ethics.md) of technology and its followers typically do hold strong opinions, so naturally there appear radicals strongly rejecting anything proprietary only out of principle, just like religious people for example refuse to eat certain kinds of food, i.e. the so called "freetards" are oftentimes made fun of and compared to "digital [vegans](veganism.md)". Nonetheless if we talk about free software USERS, more than 99% are moderate people who probably don't even know what free software means, and there are people in between -- still outnumbering the extremists -- who know free software and support it without being too radical. Richard Stallman himself plays along with the joke of "software as religion" and named himself the head of a parody "Church of [Emacs](emacs.md)". Again, however, we can't generalize behavior and culture of one group to the CONCEPT of free software and to other groups that have adopted the concept, most of free software is purely a mode of developing software and a voluntary relaxation of legal restrictions. Practically all computers on Earth work thanks to free software. Extremists appear everywhere and are always in minority but still, given that free software is unquestionably GOOD for the people, can we even claim that being an extremist at doing good is a bad thing to do? Perhaps we may end up arguing about the means of promoting free software, licenses and so on, but to speak in general means to speak only about the underlying commonly shared goal of sharing software, and that is good.

[Fun](fun.md) fact: around 1991 Richard Stallman created the *Free Software Song* which starts with the lyrics: "Join us now and share the software; you'll be free, [hackers](hacking.md)." -- Stallman said he put the lyrics in the [public domain](public_domain.md). The melody is taken from Bulgarian folk song called *Sadi Moma*. The song has a very uncommon 7/8 rhythm that is not easy to follow, especially when singing at the same time, but Richard Stallman always follows it perfectly.

## Definition

Free software was originally defined by [Richard Stallman](rms.md) for his [GNU](gnu.md) project. The definition was subsequently adopted and adjusted by other groups such as [Debian](debian.md) or [copyfree](copyfree.md) and so nowadays there isn't just one definition, even though the GNU definition is usually implicitly assumed. However, all of these definition are very similar and are quite often variations and subsets of the original one. The GNU definition of free software is paraphrased as follows:

Software is considered free if all its users have (forever and without possibility of revoking) the legal and [de facto](de_facto.md) rights to:

0. Use the software for any purpose (even commercial or that somehow deemed unethical by someone).
1. Study the software. For this source code of the program has to be available.
2. Share the software with anyone.
3. Modify the software. For this source code of the program has to be available. This modified version can also be shared with anyone.

Note that as free software cares about real [freedom](freedom.md), the word "[right](rights_culture.md)" here stands for a [de facto](de_facto.md) right, i.e. NOT just a legal right -- legal rights (a free [license](license.md)) are required but if there appears a non-legal obstacle to those freedoms, truly free software communities will address them. Again, open source differs here by just focusing on legality, i.e. open source only cares about technically adhering to legalese while ignoring everything else.

To make it clear, freedom 0 (use for any purpose) covers ANY use, even commercial use or use deemed unethical by society or the software creator. Some people try to restrict this freedom, e.g. by prohibiting use for military purposes or prohibiting use by "fascists", which makes the software NOT free anymore. NEVER DO THIS. The reasoning behind freedom 0 is the same as that behind [free speech](free_speech.md) or freedom of research: allowing any use doesn't imply endorsing or supporting any use, it simply means that we refuse to engage in certain kinds of oppression out of principle. Creator of software shouldn't be the authority deciding how the software can be used just as a scientist mustn't be the authority who decides how his discoveries will be used. We simply don't do this -- to address "wrong" use of technology is a matter of different disciplines such as philosophy.

[Source code](source_code.md) is usually defined as the preferred form in which the software is modified, i.e. things such as [obfuscated](obfuscation.md), [minified](minification.md) or compiled source code don't count as true source code.

Any software that is not free (as in freedom) is called **[proprietary](proprietary.md)**, even if it is for example available free of charge. Alas, a lot of confusion surrounds free software terminology, and so let us give a table summarizing some of the key terms:

| type of software                                                          |free of charge?|source code available?|use+study+modify+share?|
|-------------------------------------------------------------------------- | ------------- | -------------------- | --------------------- |
|free (as in freedom), libre, [open source](open_source.md), [FOSS](foss.md)| yes           | yes                  | yes                   |
| [freeware](freeware.md), gratis, free as in beer                          | yes           | ?                    | ?                     |
| [public domain](public_domain.md)                                         | yes           | ?                    | yes                   |
| source available                                                          | ?             | yes                  | ?                     |
| closed source                                                             | ?             | no                   | no                    |
| [proprietary](proprietary.md)                                             | ?             | ?                    | no                    |

The developers of Debian operating system have created their own guidelines (Debian Free Software Guidelines) which respect these points but are worded in more complex terms and further require e.g. non-functional data to be available under free terms as well ([source](https://people.debian.org/~bap/dfsg-faq.html#not_just_code)), respecting also [free culture](free_culture.md), which GNU doesn't ([source](https://www.gnu.org/distros/free-system-distribution-guidelines.en.html#non-functional-data)). The definition of "[open source](open_source.md)" is yet more complex even though in practice legally free software is eventually also open source and vice versa. The [copyfree](copyfree.md) definition tries to be a lot more strict about freedom and forbids for example [copyleft](copyleft.md) (which GNU promotes) and things such as [DRM](drm.md) clauses (i.e. a copyfree license mustn't impose technology restrictions, even those seen as "justified", for similar reasons why we don't prohibit any kind of use for example).

## Measuring Practical Freedom With Freedom Distance

One big issue related to free software and similar causes (e.g. [free hardware](free_hardware.md)) is slipping into the trap of only apparent freedom and acquiring false feeling of freedom without actually having real, practical freedom; that is having freedom given legally, "on the paper", which may however be [de facto](de_facto.md) extremely hard or impossible to make use of practically in real life. Imagine for example a highly complex software that by its license gives everyone the right to modify it but in practice to make meaningful modifications one needs specialized hardware and deep knowledge and know-how of how the code really works -- this demonstrates for example the [Android](android.md) operating system. This particular example is called [bloat monopoly](bloat_monopoly.md), a modern phenomenon commonly used to mislead users into thinking they have freedom or that they support something ethical while in fact they don't (see also e.g. [openwashing](openwashing.md)). Giving only this apparent freedom is how [capitalism](capitalism.md) adjusted to the wave of free software, it is how businesses silently smother real freedom while pretending to embrace free software (which they rather call [open source](open_source.md)). For this we always have to evaluate practical freedom we have, i.e. whether, and with what difficulties, we can execute the four basic freedoms required by free software -- remember that all are essential and once even a single of the freedoms is lost, the whole software becomes completely [proprietary](proprietary.md) and non-free.

One of possible measures of practical freedom is what we'll call a **freedom distance**. For any piece of software that comes with a free license (i.e. one that gives the four essential freedoms legally) let us define freedom distance as the average minimum distance to the nearest man that can PRACTICALLY execute ALL of the freedoms (taken over all people in the world). In other words it says how far you have to go to reach the freedom you are promised. As any metric it's a bit of a simplification, but while physical distances may seem to not matter much in the age of Internet, the measure contains in it embedded the number of people who have control over the piece of software, it says how centralized the control is and how difficult it will be to for example spot and remove malicious features. Large freedom distance means the freedom is far away, that you are relying on someone in another country to fix your software which of course is dangerous, even the Internet may get split, it is important for you to be able to execute your freedom locally (even if you're not doing it now, it is important that you COULD). It may also happen that the foreign maintainer of your software suddenly turns evil -- e.g. in pursuit of profit -- and then having someone close who can take over fixing and maintaining that software is key for freedom. From this point of view a freedom distance shorter than one's body is ideal -- it would mean that any single individual has complete control over his own tool.

Let's demonstrate it on a few examples:

- A simple program will have very small freedom distance. For example the [suckless](suckless.md) implementation of the [cat](cat.md) program (from the [sbase](sbase.md) package) is written in C and currently has about 50 lines of code. How far on average do you have to go to find someone that will be able to use the program AND understand every part of the source code AND share the program AND make any kind of meaningful modification to it? Using and sharing will be pretty easy for everyone, but remember, we are looking for the closest human that can execute ALL of the freedoms, so we are looking for someone who can compile and modify very basic C programs. As the program is extremely simple, anyone who ever learned complete basics of programming will be able to do this, even if he's not nearly an expert at programming -- this particular program doesn't even use [object oriented programming](oop.md), design patterns and similar "advanced" things that would further reduce the number of people who understand it. If you are reading this wiki, you can almost definitely exercise all the freedoms with this program but even if you can't, it's extremely likely you will find someone who can in the neighborhood of your very street, and if not, then definitely at least the ICT teacher at nearest elementary school will. If the Internet goes down, if your country isolates politically or if the program's maintainer turns nuts or just stops maintaining the program, the program still stays quite safe and in your hands: if it needs fixing or improvement, at worst you'll have to ask your neighbor to help you out. Now if we average this freedom distance for all people on Earth, we may get a freedom distance smaller than the size of a small village -- this is pretty good.
- A very complex program will have big freedom distance. Here let's take a look at the mentioned [Android](android.md) operating system. Compiling Android is very hard, it even requires quite powerful hardware, it's not very likely you'll find someone who can easily do it very near, however to make meaningful modifications to the system will be yet much, much more difficult. Imagine you for example want to change process scheduling in the system's kernel, add new filesystem support, remove all networking and telemetry, port it to run in web browser or you want to replace the GUI system with a completely different one etc. Can you do these things easily? Remember, as a reader of this wiki you are technically skilled, and even so you most likely can't do it -- even if you're an excellent programmer and dedicate all energy to it, you will likely need a few weeks of full time work to add a simple feature to the OS, and you are still a negligible exception among all the normies around, so how far away is someone who has complete control over Android? These people are probably just sitting in Google headquarters. So Android's freedom distance will be quite close to average distance to Google headquarters over all people on Earth, which will be a distance of many countries.

## History

Precursors to free software may reach as far back in [history](history.md) as we are willing to look. They may include for example ancient [mathematicians](math.md) sharing their equations with each other, engineers sharing plans, people sharing recipes for meals, and influence can possibly also come from the general ideas of [communism](communism.md) (not to be [confused](often_confused.md) with [Marxism](marxism.md)). In 20th century the early digital sharing communities on networks such as [BBS](bbs.md) and [Usenet](usenet.md) worked like free software communities "by default", without really articulating or naming the concept -- they shared software informally without [licenses](license.md) as back then it was believed [copyright](copyright.md) didn't even apply to software -- capitalists haven't yet had enough time to fuck everything up, but that slowly started to change with more commercialization of the brand new field and legal cases that would indeed establish that software was copyrightable.

Free software, in a form discussed here, was invented by [Richard Stallman](rms.md) in the 1980s as a reaction to the corporate rape of computer industry. He cites his frustration with a proprietary Xerox printer driver as an initial impulse. The newly imposed [secrecy](censorship.md) of source code and limitations of legal rights for it strongly violated the [hacker](hacking.md) culture based on free sharing of code -- hackers valued openness and sharing so much that Stallman himself was even refusing to use password on his computer (source: the book *Free as in Freedom*). In 1983 he announced the now already legendary project called [GNU](gnu.md) -- one to implement a completely free as in freedom [operating system](os.md), and later on the GNU Manifesto. The announcement described the system as "free", however still more in a sense of "not having to pay for permissions". Additionally in 1985 Stallman established the [Free Software Foundation](fsf.md), a non-profit for promotion and support of free software, and this is when the term *free software* seems to have been clearly distinguished. In late 1980s Stallman wrote [GPL](gpl.md), the major (and now one of the most frequent) free licenses. Other standard free licenses, such as the [MIT](mit.md) or [BSD](bsd.md), also appeared around this time. Before these standard licenses programs had to use custom ones, which was much harder and less legally safe.

In early [1990s](90s.md) a new project called [Linux](linux.md) -- an operating system [kernel](kernel.md) -- joined GNU and as a final missing part completed its main goal. From now on it became practically possible to do one's computing solely with free software, and this would further be facilitated by the creation of various distributions, notably e.g. [Debian](debian.md). Also during mid 90s the BSD operating systems ([FreeBSD](freebsd.md), [NetBSD](netbsd.md) and [OpenBSD](openbsd.md)) were released under a free license as well, offering another alternative of a free [Unix](unix.md) clone. While personal PCs were taken over by [Windows](windows.md) and [Mac](mac.md) due to aggressive [marketing](marketing.md), practically all Internet servers chose some of the free operating systems and many professionals started to highly prefer them because the proprietary systems were, quite simply put, absolute [garbage](shit.md). Free software proved to objectively better.

Free software gained enough momentum to become a serious threat to capitalism and so opposition appeared, most notably [Microsoft](microsoft.md), caught red handed with the leak of so called *Halloween documents* in late [1990s](90s.md), in which they discuss strategies for eliminating the threat of free software. Despite this free software couldn't be stopped and grew in popularity, which is apparent from the huge success of [GNU](gnu.md)/[Linux](linux.md) and from the cases when very valuable software, such as the [Doom](doom.md) engine or [Blender](blender.md), got released under free terms.

Later on free software inspired movements such as [free culture](free_culture.md) (shortly after the year 2000) and the evil [open-source](open_source.md) [fork](fork.md) (1998, a malicious response of business, a kind of "free software" minus ethics). Sister organizations to the original FSF were also established outside the [US](usa.md), notably FSFE (FSF [Europe](europe.md)) and FSFLA (FSF Latin America) in 2001 and 2005 respectively.

Unfortunately around the year of our Lord 2010 (aka the year when everything started to go to [shit](shit.md)) free software slowly gave way to the sinister "open source" tsunami which it would eventually get completely overshadowed by. This was really a part of the grand societal [downfall](collapse.md), the time when dystopian ultracapitalism finally got to finishing off the last remnants of ethical values in society.

**By 2024 free software is dead** -- yes, [FSF](fsf.md) and a few other software "activists" are still around, but they don't bear any significance anymore, the free software movement disappeared just like hippies disappeared with 1960s.  FSF has become just an email spamming organization supporting lesbian [rights](rights_culture.md) on the Internet, and those who truly believe in free software form a community that by its size is comparable to such insignificantly small groups as [suckless](suckless.md) for example. Everything is now "[open $ource](open_source.md)", which only means one thing: it is hosted on [GitHub](github.md), and doesn't at all imply free code, available code, non-malicious features or even perhaps such a laughable thing as pursuit of freedom. Corruption, politics and [free market](capitalism.md) have finally killed the free software movement, [open $ource](open_source.md) prevailed exactly as it was planned by capitalists at the meeting in 1998, and it has now redefined even the basic pillars of the four freedoms (partial openness, [fair use](fair_use.md) or just source availability is now practically synonymous with "open source") -- just like for example "thou shalt not kill" was removed from Christianity because it wasn't convenient for the overlords -- and by this the fate of technology is sealed, free software seems to have only postponed the [capitalist disaster](capitalist_singularity.md) by a few decades, which is still a remarkable feat. { It's been pointed out to me that even some project that call themselves "free" or "libre", such as "Libre"Boot, are in fact breaking the rules of freedom now, for example by including proprietary blobs. ~drummyfish }

## "Free" Software Alternatives, Pseudo Free Environments AKA What Freedom Really Is

**The "free software alternatives" question** is one that comes up often under [capitalism](capitalism.md): [corporations](corporation.md) try to forcefully keep users enslaved by proprietary environments while free software proponents and users themselves want to free the users with "alternatives" made as free software. A very common mistake for a free software newcomer to make is to try to **"drop-in replace proprietary software with free software"**; a user used to proprietary software and its ways just wants the programs he's used to, just "gratis, without ads and subscriptions etc.". This doesn't work, or only to a very small degree, because the whole proprietary world is made and DESIGNED from the ground up to allow user exploitation as much as possible, e.g. with embedding such thing like [consumerism](consumerism.md) right into the design of visual elements of the software etc., i.e. proprietary vs free software is not just about a legal [license](license.md), but whole philosophy of technology, asking things such as [why are we so obsessed over "updates"](update_culture.md), why do we aim for [maximalism](maximalism.md) or [why are we freaking out about privacy](privacy.md). Trying to drop-in replace proprietary technology with 1 to 1 looking free software is like trying to replace whole capitalism with an "environment friendly capitalism" in which everything works the same except we have cars made of wood and skyscrapers made of recycled paper -- indeed, one sees that to get rid of the destructive nature of capitalism we really have to replace capitalism as such with all its basic concepts with something fundamentally different; and the situation is same with proprietary software. If you learned to do computing with proprietary software, you are not only being exploited by proprietary software, you also additionally learned to do computing the WRONG way -- solution is therefore not just in replacing the proprietary software, but also learning to do computing WELL.

For example most users nowadays want [GUI](gui.md) in all programs, which is how they've been nurtured by capitalism, however we have to realize that **a truly ([de facto](de_facto.md), not just legally) free software has to be [minimalist](minimalism.md)** and so most TRULY free software will mostly work only from the [command line](cli.md); a command line program is not necessarily harder or less comfortable to use (users are just nurtured to think so by capitalism), it is however inherently more free than a GUI one in all ways (not only by being more flexible, efficient, [portable](portability.md) and non-discrimination, but also simpler and therefore e.g. modifiable by more people). We have to realize that a **freedom respecting computing environment INHERENTLY LOOKS DIFFERENT from the proprietary one**, the matter is NOT only about the license (free license is just a necessary condition to allow freedom under capitalism, however it is not a sufficient condition for freedom). People confronted with this fact for the first time usually start freaking out and panicking and they go full denial mode and start yelling NO THAT NOT TRUE THAT CAN'T BE TRUE, they erect a mental blocker and start desperately clutching onto ANY excuse at all they can find, they will start googling youtubers who say the opposite so they can remain in they sweet dreamlike state in which they don't have to abandon their favorite belowed Windows games and lovely pimped out GUI and LED keyboards they post on Twitter every day -- nevertheless this is 100% hard to swallow truth pill that is NECESSARY to be accepted if one wants to live in truth; not accepting this means choosing the way of comfortable self deceit of the eternal [NPC](npc.md). Some projects calling themselves "free" (or rather "[open source](open_source.md)") make the mistake (sometimes intentionally, exactly to e.g. more easily pull over more users from the proprietary land) of simply mimicking proprietary ways 1 to 1 -- see e.g. [Fediverse](fediverse.md) ("free" facebook/twitter/etc.), [Blender](blender.md) etc. -- these are technically/legally free, but not actually, de-facto free. While a short-sighted view tells us this wins more users from the proprietary platforms, in long term we see we are just rebuilding dystopias, only painted with brighter colors so as to make them look friendlier (and oftentimes this is exactly the aim of the authors). Transitioning to TRULY free platforms is harder -- **one has to relearn basic things** such as, as has been mentioned, working with command line rather than GUI -- but ultimately right as one really gets more freedom, however under capitalist pressure and nurturing it is a hard thing to do, requiring extorting a lot of energy to resist the pressures of society.

After some years dealing with software freedom (in serious ways, making money doesn't count) many -- including [us](lrs.md) -- realize that the "licensing" fuss and legal questions, though important, are the surface, shallow views of freedom; one that also gets exploited by many (see e.g. [openwashing](openwashing.md)). Those who seek real freedom will sooner or later find themselves focusing on [minimalism](minimalism.md) and simplicity, e.g. [LRS](lrs.md), [suckless](suckless.md), [Bitreich](bitreich.md), [DuskOS](duskos.md) etc. Going yet further, one starts to see the inherent interconnections of technology and whole society, and has to become interested also in social concepts, hence our proposal of [less retarded society](less_retarded_society.md).

## See Also

- [GNU](gnu.md) and [FSF](fsf.md)
- [free hardware](free_hardware.md)
- [open source](open_source.md)
- [free culture](free_culture.md)
- [creative commons](creative_commons.md)
- [copyfree](copyfree.md)
- [freedom distance](freedom_distance.md)
- [FreeLore](freelore.md)
- [freeware](freeware.md)
- [shareware](shareware.md)
- [kosher software](kosher_software.md)
