# Fork

In [technology](technology.md) forking generally means splitting, or better said duplicating an abstract entity (such as a computer process or development project) into two or more such entities so that each one can from then on develop differently; this is very similar to how biological cells duplicate by splitting. The term *fork* is used in many contexts, for example in software development (project forking), in [operating systems](operating_system.md) ([process](process.md) forking), in [cryptocurrencies](crypto.md) (blockchain forking), [nondeterministic](determinism.md) computing (computation forking) etc. Though the term *fork* may be quite recent, the concept is not -- throughout all [history](history.md) we can observe for example various religions and churches splitting off of main branches -- this is forking as well.

## Project Forking

In context of [projects](project.md) fork is a branch that splits from the main branch of a project and continues to develop in a different direction as a separate version of that project, possibly becoming a completely new one. This may happen with any "intellectual work" or idea such as [software](software.md), movement, theory, literary universe, religion or, for example, a [database](database.md). Forks may later be *merged* back into the original project or continue and diverge far away, forks of different projects may also combine into a single project as well.

For example the [Android](android.md) [operating system](os.md) and [Linux-libre](linux_libre.md) [kernel](kernel.md) have both been forked from [Linux](linux.md). [Linux distributions](distro.md) highly utilize forking, e.g. [Devuan](devuan.md) or [Ubuntu](ubuntu.md) and [Mint](mint.md) are forked from [Debian](debian.md). [Free software movement](free_software.md) was forked into [open source](open_source.md), [free culture](free_culture.md) and [suckless](suckless.md), and suckless was more or less forked into [LRS](lrs.md). [Wikipedia](wikipedia.md) also has forks such as [Metapedia](metapedia.md). [Memes](meme.md) evolve a lot on the basis of forking.

Forking takes advantage of the ability to freely duplicate [information](information.md), i.e. if someone sees how to improve an intellectual work or use it in a novel way, he may simply copy it and start developing it in a new diverging direction while the original continues to exist and going its own way. That is **unless copying and modification of information is artificially prevented**, e.g. by [intellectual property](intellectual_property.md) laws or purposeful obscurity standing in the way of remixing. For this reason forking is very popular in [free culture](free_culture.md) and [free software](free_software.md) where it is allowed both legally and practically -- in fact it plays a very important role there.

In software development temporary forking is used for implementing individual features which, when completed, are merged back into the main branch. This is called **[branching](branch.md)** and is supported by [version control systems](vcs.md) such as [git](git.md).

There are two main kinds of forks:

- **soft forks** (also dynamic forks): Soft fork introduces changes that somehow stay compatible with the original project and can potentially even be merged back later, the fork exists as a different but synchronized version of the original project and as the original gets updates, the fork automatically gets these updates as well. Temporary [git](git.md) forks during development are soft forks, also for example [Linux-libre](linux_libre.md) is a soft fork of [Linux](linux.md) as it adds a set of scripts that automatically remove proprietary blobs from the current version of Linux; [patches](patch.md) of [suckless](suckless.md) software can also be seen as soft forks. It is typical that a soft fork somehow maintains just a set of changes against the original, e.g. in a form of a [diff](diff.md) or [script](script.md), i.e. soft fork is kind of a lightweight fork for which the original project stays a [dependency](dependency.md).
- **hard forks**: Hard fork splits from the original project in such a way that it can no longer be easily merged back, it diverges in a very different way and stops being synchronized with the original. For example [darkplaces](darkplaces.md) is a hard fork of the [Quake](quake.md) 1 engine. Hard fork typically just copies all the data of the original project to a new repository and start modifying them freely. This has the disadvantage of having to repeat work on the original and the fork (e.g. if a new bug is discovered in the original after the split, it has to be manually fixed in both versions). This is one of the reasons why hard forks very often split off of projects that aren't actively developed anymore.

**Is forking good?** Yes, to create anything new it is basically necessary to build on top of someone else's work, stand on someone else's shoulders. Some people criticize too much forking; for example some cry about [Linux](linux.md) [distro](distro.md) fragmentation, they say there are too many of distros and that people should rather focus their energy on creating a single or at least fewer good operating systems, i.e. that forking is kind of "wasting effort". [LRS](lrs.md) supports any kind of wild forking and experimentation, we believe the exploration of many directions to be necessary in order to find the right one, in a [good society](less_retarded_society.md) waste of work won't be happening -- that's an issue of a [competitive society](capitalism.md), not forking.

In fact we think that (at least soft) forking should be incorporated on a much more basic level, in the way that the [suckless](suckless.md) community popularized. In suckless **everyone's copy of software is a personal fork**, i.e. software is distributed in source form and is so extremely easy to compile and modify that every user is supposed to do this as part of the installation process (even if he isn't a programmer). Before compilation user applies his own selected patches, custom changes and specific configuration (which is done in the source code itself) that are unique to that user and which form source code that is the user's personal fork. Some of these personal forks may even become popular and copied by other users, leading to further development of these forks and possible natural rise of very different software. This should lead to natural selection, survival and development of the good and useful forks.

## Process Forking

*See also [fork bomb](fork_bomb.md).*

TODO

## See Also

- [clone](clone.md)
- [spoon](spoon.md)