# Flatland

*Flatland: A Romance of Many Dimensions* is an amazing [book](book.md) from 1884, now completely in the safe/strong [public domain](public_domain.md), whose story takes place in a flat [plane](plane.md), a [two dimensional](2d.md) world inhabited by sentient two dimensional geometric shapes (men being [polygons](polygon.md), [women](woman.md) just [line](line.md) segments). The book is classified as [mathematical](math.md) [fantasy](fantasy.md) -- besides being a very rare case of an exceptional quality completely public domain fantasy before [The Lord of the Rings](lotr.md), it is also both a social criticism and an [interesting](interesting.md) and entertaining examination of mathematical and scientific concepts such as "how would two dimensional beings build their houses?", "how would they see?" etc. Flatland was written by Edwin Abbott Abbott, an English theologian, priest and teacher. There were sequels and spinoffs written by other people, even movies, but these aren't generally in the public domain yet.

{ As the book is in the safe public domain, I won't restrain from going on deeper on summarizing the plot etc., legal dangers of any "infringements" are quite definitely zero here. YES, I know I can summarize plots even of proprietary works, but this wiki goes further, it want to also ensure that someone can e.g. take the plot and turn in into a video game, which in cases like fair use could lead to infringements. ~drummyfish }

From now on expect **spoilers** :)

The book is written as a narration by a square, an upper middle class shape, and describes all the peculiarities of living in Flatland, talking directly to the reader, a supposed inhabitant of "Spaceland" (the 3D world). The year in the book is 1999 of the Flatland world. The book explains and explores spaces of different [dimensions](dimension.md), firstly mathematically and then as a social topic -- the square protagonist essentially starts thinking about the possibility that besides his 2D universe there might exist worlds of different dimensions -- at first he dreams about being in 1D land -- Lineland -- and later, at the turn of the millennium, he is visited by a [sphere](sphere.md) from the 3D world, a sort of alien to the square, but the sphere is able to convince the square that it came from a higher dimensional space. The ideas of existence of different dimensions are consequently seen as a kind of lunacy and heresy by others, he is basically seen as a [schizo](schizo.md) and conspiracy theorist and gets in trouble for his freethinking, just like many of those who in the past questioned religious orthodoxy or those who nowadays question [official "science"](soyence.md). Examination of the 0 dimensional space, Pointland, also appears in the story.

The following are some further details about the work:

- **Men are [polygons](polygon.md), more sides implies higher class**, within a single class the polygon regularity further implies one's social standing. [Triangles](triangle.md) are lowest class of men, among these the lowest are irregular triangles (soldiers, their sharp point makes them good at fighting) with two long and one short side because these are kind of closer to a mere line segment (woman). Equal sided triangles are the middle class. [Squares](square.md) and [pentagons](pentagon.md) are professional workers. Noblemen begin at [hexagons](hexagon.md). The highest class are [circles](circle.md), i.e. polygons in which the number of sides is so numerous they appear to be smooth all around -- these are the priests. A man's male descendant will typically have one more side than his father, rising in social class, but this doesn't always happen and is less common among lower classes, with isoscele soldiers only rarely having such children (it requires some effort, like spiritual exercise and intermarriages).
- **[Women](woman.md) are just [line](line.md) segments**, implying several things -- firstly a line segment is basically the lowest possible polygon, a degenerated triangle, i.e. by this a woman is even below the lowest class of men (triangles). Furthermore for its geometric shape a woman is dangerous and can be sneaky as from certain angles she just cannot be seen -- one can bump into her and get injured (as a one dimensional shape she is very sharp, even more than a soldier), which, as the author notes, is further made worse by women being extremely dumb and acting mostly just on instinct. For this women are required by law to wiggle their butts (which they actually started to like doing as a kind of fashion trend -- yes, just like twerking) and make noise when moving around in public.
- **World directions** can be distinguished thanks to a law of nature in Flatland that creates a slight but constant attraction towards south, making rain fall from north. This could be explained by Flatland being located on a slightly tilted plane within Spaceland.
- **Sight** of Flatlanders is also explained -- seeing in this world poses difficulties -- everything looks like a line and a Flatlander always has just one eye -- so the senses of hearing and touch are mentioned to be highly developed to provide additional help (though distinguishing by voice is seen as more of a pleb thing, not much practiced by aristocrats who prefer using sight). Fog also helps. **[Colors](color.md)** exist and could aid seeing greatly, but their use is highly regulated (read forbidden) by the Universal Color Bill because in [history](history.md) color firstly caused some trouble (like women shading themselves to look like circles) and secondly nobility wanted to keep the precious art of sight recognition to themselves, so they just banned it despite it killing all [art](art.md) etc. (Basically what [copyright](copyright.md) does nowadays etc.)
- Sizes are mentioned in common units, a Flatlander is about a foot or so in size, though whether their foot corresponds to our foot isn't clear.
- **[Light](light.md)** is present everywhere and at all times -- the origin of light is unknown to Flatland society but the protagonist hints on the heretic idea that light in fact comes from the Spaceland, in which Flatland is embedded.
- **Houses** are most commonly pentagonal (sharper shapes are forbidden to prevent injuries), with roofs protecting against rain and they have no windows (as light is everywhere). West side has a big entrance for men, east a smaller entrance for women.
- The book spawns a possible **[free universe](free_universe.md)**, which may furthermore be quite friendly to e.g. making computer [games](game.md) (2D games are easier to make than 3D ones, also no need for many assets etc.).
- The book is in the **safe [public domain](public_domain.md)**, i.e. it was published before 1900, author has been dead for nearly 100 years, so even in countries with strictest copyright it should be fine.
- There is some **nice sexist bashing of women** :D E.g. "[soldiers are] creatures almost on a level with women in their lack of intelligence", "[women are]  wholly devoid of brainpower" etc. That's very cool and refreshing.
- ...