# Encyclopedia

Encyclopedia (also encyclopaedia, cyclopedia or cyclopaedia, from Greek *enkyklios paideia*, roughly "general education") is a large [book](book.md) (or a series of books) providing structured summary of wide knowledge in one or many fields of knowledge (such as [mathematics](math.md), [history](history.md), engineering, general knowledge etc.), usually structured as a collection of alphabetically ordered articles on terms used in the field. Paper encyclopedias are oftentimes printed in several volumes as the amount of contained information is too great for a single book (in large ones you may even see one or two volumes dedicated ONLY for the [index](index.md)). The largest and most famous encyclopedia to date is the online [Wikipedia](wikipedia.md) created by volunteers in [free culture](free_culture.md) spirit, however Wikipedia suffers from significant issues such as [censorship](censorship.md), high political propaganda and low quality of writing, therefore it is crucial to also stay interested in other encyclopedias such as Britannica, Americana or [LRS wiki](lrs_wiki.md).

**Encyclopedias are [awesome](awesome.md)**, get as many of them as you possibly can, especially the printed ones -- they are usually relatively cheap (especially second hand books) and provide an ENORMOUS amount of information, FOREVER (no one can cancel your physically owned paper book, you will retain it even after the [collapse](collapse.md) when such books will become practically your only source of human knowledge). Also remember, paper books are still of much higher quality than online resources such as [Wikipedia](wikipedia.md) -- even if they lose in terms of shear volume, they make up in quality of writing and still many times contain information that's not available online, and the older ones are more objective and trustworthy, considering the decline of [free speech](free_speech.md) online. Shorter articles may also do a better job at providing overall summary of a topic and filtering out less important information, as opposed to a gigantic Wikipedia article. Furthermore even if such a book isn't [free as in freedom](free_culture.md), the knowledge, information and data contained in it is in the [public domain](public_domain.md) as such things cannot (yet) be owned, therefore it is possible to legally paraphrase the information into a new source which we may make public domain itself (however watch out to not merely copy-paste texts from encyclopedias as text CAN be [copyrighted](copyright.md), as well as e.g. the mere selection of which facts to include; always be very careful).

Since an encyclopedia will typically focus on encompassing broad knowledge, as the other side of the coin it may suffer from shallowness, it will only dive deeper into very important topics, although very big encyclopedias largely eliminate this issue and go fairly deep on all subjects; encyclopedias specialized on some particular subject can also afford to provide in-depth knowledge.

{ A favorite pastime of mine is looking up the same term in different encyclopedias and comparing them -- this can help get to the essence of actually understanding the term, as well as revealing censorship and different views of the authors. ~drummyfish }

The nerdiest of [nerds](nerd.md) read encyclopedias linearly, cover to cover like a prose, which may help expand one's knowledge as well as ignite curiosity in new subjects and help come over new, [interesting](interesting.md) facts. { And yet bigger nerds write their own encyclopedias. ~drummyfish }

**Similar terms:** encyclopedias, which also used to be called **cyclopedias** in the past, are similar to **dictionaries** and these types of books often overlap (many encyclopedias call themselves dictionaries); the main difference is that a dictionary focuses on providing linguistic information and generally has shorter term definitions, while encyclopedias have longer articles (which however limits their total number, i.e. encyclopedias will usually prefer quality over quantity). Encyclopedias are also a subset of so called **reference works**, i.e. works that serve to provide [information](information.md) and reference to it (other kinds of reference works being e.g. world maps, tabulated values or [API](api.md) references). A **universal/general** encyclopedia is one that focuses on human knowledge at wide, as opposed to an encyclopedia that focuses on one specific field of knowledge. **Compendium** can be seen almost as a synonym to encyclopedia, with encyclopedias perhaps usually being more general and extensive. **Almanac** is also similar to encyclopedia, more focusing on tabular data. **Micropedia** is another term, sometimes used to denote a smaller encyclopedia (one edition of Britannica came with a micropedia as well as a larger macropedia). There are also **catalogs** which often serve commercial purposes but in practice can be useful as well. [World wide web](www.md) recently invented a new form of encyclopedia: a so called **[wiki](wiki.md)** that's essentially a purely electronic, constantly changing and [updating](update_culture.md) encyclopedia (i.e. changes aren't published periodically but instantly) with hyperlinked (containing clickable links in the text) articles, typically edited by many different people, very often unpaid volunteers.

These are some **nice/interesting/benchmark articles** to look up in encyclopedias: [algorithm](algorithm.md),  [anarchism](anarchism.md), Andromeda (galaxy), Antarctica, Atlantis, atom, [axiom of choice](axiom_of_choice.md), [Bible](bible.md), [big bang](big_bang.md), [black hole](black_hole.md), [brain](brain.md), [Buddhism](buddhism.md), [C](c.md) (programming language), [cannibalism](cannibalism.md), [capitalism](capitalism.md), castle, [cat](cat.md), [censorship](censorship.md), [central processing unit](cpu.md), [chess](chess.md), Chicxulub, China, [color](color.md), comet, [communism](communism.md), [computer](computer.md), [Creative Commons](creative_commons.md), [Deep Blue](deep_blue.md), [democracy](democracy.md), Democratic People's Republic of Korea, [depression](depression.md), [determinism](determinism.md), [dinosaur](dinosaur.md), dodo, [dog](dog.md), [Doom](doom.md) (game), [Earth](earth.md), [Einstein](einstein.md), [Elo](elo.md), [Encyclopedia](encyclopedia.md), [entropy](entropy.md), [ethics](ethics.md), [Euler's Number](e.md), [evolution](evolution.md), [font](font.md), [football](football.md), [fractal](fractal.md), [free software](free_software.md), [game](game.md), gigantopythecus, [go](go.md) (game), [god](god.md), [GNU](gnu.md) project, [hacker](hacking.md), Hanging Gardens of Babylon, [hardware](hardware.md), [Hitler](hitler.md), [Holocaust](holocaust.md), [homosexual](gay.md), [human](human.md), [infinity](infinity.md), [information](information.md), intelligence, [Internet](internet.md), [IQ](iq.md), Japan, [Jesus](jesus.md), [Jew](jew.md), [language](language.md), [Latin](latin.md), [life](life.md), [light](light.md), lightning, [Linux](linux.md), [logarithm](log.md), [logic](logic.md), [love](love.md), Mammoth, [mathematics](math.md), Mariana Trench, Mars, Milky Way, Moon, [morality](morality.md), Mount Everest, [music](music.md), [necrophilia](necropiilia.md), [number](number.md), [Open Source](open_source.md), negro, [nigger](nigger.md), pacifism, [pedophilia](pedophilia.md), [penis](penis.md), [pi](pi.md), Pluto, [prime number](prime.md), [quaternion](quaternion.md), Pompei, [Quran](quran.md), [race](race.md), Roman Empire, [sex](sex.md), [sine](sin.md), [schizophrenia](schizo.md), [software](sw.md), [Stallman](rms.md) (Richard), [star](star.md), Stonehenge, [suicide](suicide.md), Sun, Tibet, [technology](technology.md), Tetris, [time](time.md), Titanic, [transistor](transistor.md), Troy, Tyrannousaurus Rex, [UFO](ufo.md), [universe](universe.md), [Unix](unix.md), Uruk, [Usenet](usenet.md), Valonia Ventricosa (bubble algae), Vatican, Venus, video game, [Wikipedia](wikipedia.md), [woman](woman.md), [World War II](wwii.md), [World Wide Web](www.md), ...

**What is the best letter in an encyclopedia?** If you are indeed so [autistic](autism.md) to ask questions like this, you may begin your journey for finding out the ultimate encyclopedia starting letter -- this is [fun](fun.md) and may also help you for example decide which volume of your favorite encyclopedia to pack in your bag when on the travel. Which letter will be the best depends on many factors, e.g. the language of the encyclopedia, its size, your area of interest and so on. Assuming [English](english.md) and topics that would appeal to an average [LRS wiki](lrs_wiki.md) reader, the best letter is most likely C -- it is the second most common starting letter in dictionaries, has a great span and includes essential and curious terms such as [calculator](calculator.md), [computer](computer.md), [C](c.md) programming language, [cat](cat.md), [communism](communism.md), [capitalism](capitalism.md), [chess](chess.md), [christianity](christianity.md), [collapse](collpase.md), [CPU](cpu.md), [color](color.md), [culture](culture.md), [copyleft](copyleft.md), [compiler](compiler.md), [creative commons](creative_commons.md), [cryptography](cryptography.md), [copyright](copyright.md), [car](car.md), [cancer](cancer.md), [cellular automata](cellular_automaton.md), [consumerism](consumerism.md), [cosine](cosine.md), [Chomsky](chomsky.md), [CIA](cia.md), [cybernetics](cybernetics.md), [cracking](cracking.md), [chaos](chaos.md), [carbon](carbon.md), [curvature](curvature.md), [chemistry](chemistry.md), [censorship](censorship.md) and others. As close second comes S, the most frequent letter in dictionaries, with terms such as [Stallman](rms.md), [science](science.md), [shader](shader.md), [semiconductor](semiconductor.md), [silicon](silicon.md), [software](software.md), [sound](sound.md), [socialism](socialism.md), [state](state.md), [selflessness](selflessness.md), [speech recognition](speech_recognition.md), [steganography](steganography.md),  [square root](square_root.md), [sudoku](sudoku.md), [suicide](kys.md), [speedrun](speedrun.md), [space](space.md), [star](star.md), [Sun](sun.md), [sine](sin.md), [Soviet union](ussr.md), [schizophrenia](schizo.md), [set](set.md), [suckless](suckless.md), [shit](shit.md), [sex](sex.md) and others. { This is based on a list I made where I assigned points to each letter. The letters that follow after C and S are P, M, A, E, T, L, R, F, D, G, I, B, H, U, N, W, V, J, O, K, Q, Z, Y, X. ~drummyfish }

## Notable/Nice Encyclopedias

Here is a list of notable encyclopedias, focused on general knowledge English language ones. The most notable ones are in bold. Please do check also encyclopedias in other languages that you speak (or which you can easily autotranslate), we can't list those here but there are many large and awesome ones, for example the Russian [Lurkmore](lurkmore.md)/neolurk/etc. (e.g. https://neolurk.org).

{ See also https://wikiindex.org/. ~drummyfish }

| name                           | year  |  legal status    | format      | ~articles | comment                                                                                                    |
| ------------------------------ | ----- | ---------------- | ----------- | --------- | ---------------------------------------------------------------------------------------------------------- |
| Britannica 9th edition         | 1889  | PD (old)         | 25 vol.     |           |legendary enc., major edition, one of "Big Three", partly digitized (archive.org, wikisource, ...)          |
| **Britannica 11th edition**    | 1910  | PD (old)         | 29 vol.     | 40K       |legendary enc., major edition, one of "Big Three", mostly digitized (both scan and txt), PC incorrect :)    |
| Britannica Concise Encyclopedia| 2002  | proprietary      | 1 vol. 2000p| 28K       | nice, short descriptions, condensed from the main multivol. Brit., piratable pdf                           |
| **Britannica online**          |...now | proprietary      | online      | 130K      | bloated, high quality articles, unpaid is limited and with ads                                             |
| [Citizendium](citizendium.md)  |2006...|proprietary? (NC) | online      | 18K       | Wikipedia alternative, high censorship, faggots have unclear license                                       |
| Chambers Encyclopedia (new)    | 2001  | proprietary      | 1 vol. 980p |           | 1 vol republication of old multivol. enc. (going back to 1800s, already PD), topic-sorted                  |
| Collier's New Encyclopedia     | 1921  | PD (old)         | 10 vol.     |           | NOT TO BE CONFUSED with Collier's Encyclopedia (different one), digitized on Wikisource (txt)              |
| Columbia Encyclopedia          |1935...| proprietary      | 1 vol. ~3Kp | ~50K      | high quality, lots of information { Read the 1993 edition, it's super nice. ~drummyfish }                  |
|[Conservaped.](conservapedia.md)|2006...| proprietary      | online      | 52K       | American fascist wiki, has basic factual errors                                                            |
| Larousse Desk Reference Enc.   | 1995  | proprietary      | 1 vol. 800p | 200K?     | by James Hughes, nice, quality general overviews, topic-ordered { I bought this, it's nice. ~drummyfish }  |
| Domestic Encyclopaedia         | 1802  | PD (old)         | 4 vol.      |           | shorter articles, partially digitized on Wikisource                                                        |
| Encyclopedia Americana         |1820...| PD (old)         | ~30 vol.    |           | longer articles, one of "Big Three", several editions (1906, 1920) partly digitized on wikisource          | 
| Encyclopedia Dramatica         |2004...| PD (CC0)         | online      | 15K       | informal/fun/"offensive" but valuable info (on society, tech, ...), basically no censorship, no propaganda |
| Encyclopedia of Marxism        |1999...| CC BY-SA         | online      | ~3K       | focused on Marxism, quality, shorter articles                                                              |
| Everybodywiki                  |2017...| CC BY-SA         | online      | ~300K     | alternative to Wikipedia allowing articles on non notable things and people                                |
| Google Knol                    | ~2010 | proprietary      | online      |           | failed online enc. by Google, archived on archive.org                                                      |
| Grolier Multimedia Encyclopedia| 2003  | proprietary      | CD          |           |                                                                                                            |
| GNU CIDE                       |2012...| GPL              | online/elec.| ~123K     | GNU English dictionary, forked from old Webster's dictionary                                               |
|Illustrated Family Encyclopedia | 1997  | proprietary      | 2 vol. 920p | 5K        | kid-friendly, nice pictures, USA bias, piratable                                                           |
|[Infogalactic](infogalactic.md) |2016...| CC BY-SA         | online      | 2M        | Wikipedia fork, no SJW censorship, FOR PROFIT (you can buy article control lol), can't make accounts       |
| Justapedia                     |2023...| CC BY-SA         | online      | 6M        | Wikipedia fork, wants to "fix" some issues of Wikipedia but still looks quite mainstream and censored      |
| [Leftypedia](leftypedia.md)    |2020...| GFDL             | online      | ~200      | Leftist encyclopedia, currently NOT littered by SJWs, writing about all branches of the "left"             |
| [LRS wiki](lrs_wiki.md)        |2021...| PD (CC0)         | online/elec.| 500       | best encyclopedia, focused on tech/society, no censorship                                                  | 
| [Metapedia](metapedia.md)      |2006...| GFDL             | online      | 7K        | Wikipedia fork, online, no SJW censorship, ATM limited account creation, "pro-European" fascism            |
|Microsoft [Encarta](encarta.md) |...2009| proprietary      | electronic  | 62K       | Micro$oft enc., low quality articles (errors), MS propaganda (no free software etc. lol), is on archive.org|
| New World Encyclopedia         |2005...| CC BY-SA         | online      | ~15K      | made by some church, quite nice articles (often heavily rewritten from Wikipedia)                          | 
| [ProleWiki](prolewiki.md)      |2020...| proprietary      | online      | ~3K       | Proletariat wiki, similar to Leftypedia but focused on Marxism-Leninism.                                   | 
| Simple English Wikipedia       |2001...| CC BY-SA         | online      | 200K      | Wikipedia with simpler language and simpler explanations, censored                                         |
| The New American Cyclopaedia   | 1879  | PD (old)         | 16 vol.     |           | partially digitized on Wikisource (txt)                                                                    |
| The New International Encyc.   | 1905  | PD (old)         | 20 vol.     |           | partially digitized on Wikisource                                                                          |
| The Nuttall Encyclopaedia      | 1907  | PD (old)         | 1 vol.      | 16K       | short articles, oldschool, digitized (gutenberg)                                                           |
| [Vikidia](vikidia.md)          |2006...| CC BY-SA         | online      | 4K        | "Wikipedia for kids", probably as censored as Wikipedia                                                    |
|Webster's Unabridged Dictionary |1864   | PD (old)         | paper       | 476K      | short descriptions, digitized (gutenberg)                                                                  |
| [Wikidata](wikidata.md)        |2012...| PD (CC0)         | online/elec.| 109M      | database, Wikipedia sister project                                                                         |
| **[Wikipedia](wikipedia.md)**  |2001...| CC BY-SA         | online      | 6M        | largest and most famous, EXTREME PSEUDOLEFTIST CENSORSHIP AND POLITICAL PROPAGANDA, free culture           |
| Wiktionary                     |2002...| CC BY-SA         | online      | 1M        | dictionary, Wikipedia's sister project, many language versions                                             |
| Old Wikipedia                  | 2001  | GFDL             | online      | 19K       | archived old Wikipedia, less censorship, https://nostalgia.wikipedia.org                                   |
| Pears' Cyclopedia              | 1897  | PD (old)         | 1 vol. 740p |           | contains dictionary, general knowl. maps, reference etc., scanned on archive.org                           |
| World Almanac and Book of Facts|1868...| some PD (old)    | 1 vol.      |           | interesting and useful information, data and facts from old to new age, US-centered                        |
| **The World Book**             |1917...| proprietary      | 22 vol.     | 17K       | best selling print enc., large, high quality but for younger audience, US propaganda (anticommunism etc.)  |
| The World Book 1917            |1917   | PD (old)         | 8 vol.      | 3K        | nicely readable                                                                                            |
| Uncyclopedia                   |2005...| proprietary (NC) | online      | 37K       | parody, [fun](fun.md) enc., "more normie friendly dramatica"                                               |

## See Also

- [wiki](wiki.md)
- [wikidata](wikidata.md)
- [Jargon File](jargon_file.md)
- [wikiwikiweb](wikiwikiweb.md)
- [memopedia](memopedia.md)
- the incredibly fucking deep [soyjak](soyjak.md) rabbithole
