# Duke Nukem 3D

Duke Nukem 3D (often just *duke 3D*) is a legendary first man shooter video [game](game.md) released in January 1996 (as [shareware](shareware.md)), one of the best known such games and possibly the second greatest [90s](90s.md) FPS right after [Doom](doom.md). It was made by 3D realms, a company competing with Id software (creators of Doom), in engine made by [Ken Silverman](key_silverman.md) -- the game was developed by around 10 people and was in the making since 1994. Duke 3D is a big sequel to two previous games which were just 2D platformers (and a prequel to the infamously unsuccessful *Duke Nukem Forever*); when this 3rd installment came out, it became a hit. It is remembered not only for being very technologically advanced, further pushing advanced fully textured 3D graphics that Doom introduced, but also for its great gameplay, iconic music and above all for its humor and excellent parody of the prototypical 80s overtestosteroned [alpha male](chad.md) hero, the protagonist Duke himself -- it showed a serious game didn't have to take itself too seriously and became loved exactly for things like weird alien enemies or correct portrayal of [women](woman.md) as mere sexual objects which nowadays makes [feminists](feminism.md) screech in furious rage of thousand suns. Only idiots criticised it. Duke was later ported to other platforms (there was even a quite impressive 3D port for [GBA](gba.md)) and received a lot of additional "content".

Of course, Duke is sadly [proprietary](proprietary.md), as most gaymes, though the source code was later released as [FOSS](foss.md) under [GPL](gpl.md) (excluding the game data and proprietary engine, which is only [source available](source_available.md)). A self-proclaimed [FOSS](foss.md) engine for Duke with GPU accelerated graphics exists: [EDuke32](eduke32.md) -- the repository is kind of a mess though and it's hard to tell if it is legally legit as there are parts of the engine's proprietary code (which may be actually excluded from the compiled binary), so... not sure.

Duke was very much influenced by a very cool anticapitalist movie called *They Live*, up to the point of completely copy pasting some of the most memorable lines.

## Code

The codebase (including Build engine) is roughly 100000 [LOC](loc.md) of [C](c.md), with some parts in [assembly](assembly.md). [Programming style](programming_style.md) looks like a disaster, formatting of the code isn't nicest (at least in the version reviewed here, got somewhere from the net), tabs are mixed with spaces, there are large parts of code commented out, inserting spaces and newlines is inconsistent, looks like a work in progress temporary code. There is A GREAT DEAL of [magic constants](magic_constant.md) and spaghetti code (for example just randomly found: *if* inside *while* inside *if* inside *if* inside *if* inside *else if* inside *switch* inside *while* -- doing it may be OK sometimes, but here it's all over the place constantly). Yes, there are even [gotos](goto.md). { I think John Carmack also said the code looked like complete garbage. ~drummyfish }

The original system requirements were roughly following: 66 MHz [CPU](cpu.md), 16 MB [RAM](ram.md) and 30 MB storage space.

Duke ran on **[Build](build.md) engine**, a legendary [software rendering](sw_rendering.md) [primitive 3D](pseudo3d.md) engine that had limitations similar to those of [Doom](doom.md) engine, i.e. the camera could not genuinely rotate up or down (though it could fake this with kind of a "tilting") and things like rooms above other rooms in a level were allowed only in limited ways ([hacks](hacking.md) such as extra rendering passes or invisible teleports were used to allow this). The engine was not unsimilar to that of Doom, enemies and other objects were represented with 2D [sprites](sprite.md) and levels were based on the concept of sectors (a level was really made as a 2D map in which walls were assigned different heights and textures), however it had new features -- most notably [dynamic](dynamic.md) environment, meaning that levels could change on the fly without the need for [precomputation](precomputation.md), allowing e.g. destructible environments. How the fuck did they achieve this? Instead of [BSP](bsp.md) rendering (used by Doom) Build engine used **[portal rendering](portal_rendering.md)**: basically (put in a quite simplified way) there was just a set of sectors, some of which shared walls ("portals") -- rendering would first draw the sector the player stood in (from the inside of course) and whenever it encountered a portal wall (i.e. a wall that sees into another sector), it would simply [recursively](recursion.md) render that too in the same way -- turns out this was just fine. Other extra features of the engine included tilted floors and ceilings, fake looking up/down, 3rd man view etc. The Build engine was also used in many other games (most notably [Shadow Warrior](shadow_warrior.md) and [Blood](blood.md)) and later incorporated even more advanced stuff, such as [voxel](voxel.md) models, though these weren't yet present in Duke. Just like Doom, Build engine **only used [fixed point](fixed_point.md)**, no [float](float.md)! { Hmm, actually maybe there was a small exception, see the link below. ~drummyfish }

The game uses [256](256.md) [colors](color.md) and [palettes](palette.md).

[Pseudorandom](pseudorandomness.md) number generation is done with linear congruential generator (function `krand`), using multiplier 27584621 and adding 1, returning highest 16 bits of the result.

{ Here are some details on the engine internals from a guy who specializes on this stuff: https://fabiensanglard.net/duke3d/build_engine_internals.php. ~drummyfish }

## See Also

- [Doom](doom.md)
- [Anarch](anarch.md)
- [Quake](quake.md)
- [Wolf3D](wolf3d.md)
- [Jedi engine](jedi_engine.md)
- [Dick Suckem](dick_suckem.md)
- [They Live](they_live.md)
- [Dink Smallwood](dink_smallwood.md)
- [Ashley Jones](ashley_jones.md)