# Copyright

*"When copying is outlawed, only outlaws will have culture."* --[Question Copyright website](https://questioncopyright.org/)

Copyright (better called *copyrestriction*, *copyrape* or *copywrong*) is one of many types of so called "[intellectual property](intellectual_property.md)" (IP), a legal concept that allows "ownership", i.e. restriction, [censorship](censorship.md) and artificial [monopoly](monopoly.md) on certain kinds of [information](information.md), for example prohibition of sharing or viewing useful [information](information.md) or improving [art](art.md) works. Copyright specifically allows the copyright holder (not necessarily the author) a monopoly (practically absolute power) over [art](art.md) creations such as images, songs or texts, which also include source code of computer [programs](program.md). Copyright is a [capitalist](capitalism.md) mechanism for creating [artificial scarcity](artificial_scarcity.md), enabling censorship and elimination of the [public domain](public_domain.md) (a pool of freely shared works that anyone can use and benefit from). It is a mechanism that by definition smothers true, useful [progress](progress.md) -- in a world that advanced technologically so much that it is already possible to freely copy and share information instantly, with zero cost, with anyone anywhere, copyright tries to set up artificial measures to prevent this so as to keep the old ways of allowing only the privileged to copy and publish intellectual works, it is quite literally force sustaining mechanism of Middle Ages. Copyright is not to be confused with [trademarks](trademark.md), [patents](patent.md) and other kinds of "intellectual property", which are similarly [harmful](harmful.md) but legally different. Copyright is symbolized by C in a circle or in brackets: (C), which is often accompanies by the phrase "all rights reserved".

When someone creates something that can even remotely be considered artistic expression (even such things as e.g. a mere collection of already existing things), he automatically gains copyright on it, without having to register it, pay any tax, announce it or let it be known anywhere in any way. He then practically has a full control over the work and can successfully sue anyone who basically just touches the work in any way (even unknowingly and unintentionally). Therefore **any work (such as computer code) without a [free](free_software.md) license attached is implicitly fully "owned" by its creator** (so called "all rights reserved") and can't be used by anyone without permission. It is said that copyright can't apply to ideas (ideas are covered by [patents](patent.md)), only to expressions of ideas, however that's [bullshit](bs.md), the line isn't clear and is arbitrarily drawn by judges; for example regarding stories in books it's been established that the story itself can be copyrighted, not just its expression (e.g. you can't rewrite the [Harry Potter](harry_potter.md) story in different words and start selling it).

As if copyright wasn't bad enough of a [cancer](cancer.md), **there usually exist extra oppressive copyright-like restrictions called related rights or neighboring rights  such as "[moral rights](moral_rights.md)", "[personal rights](personal_rights.md)" etc.** Such "rights" differ a lot by country and can be used to restrict and censor even copyright-free works. This is a stuff that makes you want to commit [suicide](suicide.md). Waivers such as [CC0](cc0.md) try to waive copyright as well as neighboring rights (to what extent neighboring rights can be waived is debatable though).

The current extreme form of copyright (as well as other types of IP such as software patents) has been highly criticized by many people, even those whom it's supposed to "protect" (small game creators, musicians etc.). Strong copyright laws basically benefit mainly [corporations](corporation.md) and "trolls" on the detriment of everyone else. It smothers creativity and efficiency by prohibiting people to reuse, remix and improve already existing works -- something that's crucial for art, science, education and generally just making any kind of [progress](progress.md). Copyright absolutely devastates works of art with epidemic censorship, it increases the probability of any practically made work to be censored to a high level so works don't last for long, they die regularly: if you e.g. make a video, sooner or later you won't be able to share it because one of its many elements (music in it, sound effects, images, fonts, ...) will hit the copyright wall (your license runs out, you get a YouTube strike, author changes his mind about permission he has given, ...) -- this is convenient and needed for creating information [consumerism](consumerism.md) that corporations need; to keep the business based on art consumerism it is necessary to keep removing old art, and copyright does this very well. Therefore despite most people still probably believing in "some" (much different) form of copyright, most also oppose the current extreme form which is absolutely crazy: **copyright applies to everything without any registration or notice and last usually 70 years (!!!) AFTER the author has died (!!!)** and is already rotting in the ground. This is 100 years in some countries. In some countries it is not even possible to waive copyright to own creations -- just think about what kind of twisted society we are living in when it PROHIBITS people from making a selfless donation of their own creations to others. Some people, including [us](lrs.md), are against the very idea of copyright (those may either use waivers such as [CC0](cc0.md) or [unlicense](unlicense.md) or protest by not using any licenses and simply ignoring copyright which however will actually discourage other people from reusing their works). Though copyright was originally intended to ensure artists can make living with their works, it has now become the tool of states and corporations for universal censorship, control, bullying, surveillance, creating scarcity and [bullshit jobs](bullshit_job.md); states can use copyright to for example take down old politically inconvenient books shared on the Internet even if such takedowns do absolute not serve protection of anyone's living but purely political interests.

Prominent critics of copyright include [Lawrence Lessig](lessig.md) (who established [free culture](free_culture.md) and [Creative Commons](creative_commons.md) as a response), [Nina Paley](nina_paley.md) and [Richard Stallman](rms.md). There are many movements and groups opposing copyright or its current form, most notably e.g. the [free culture](free_culture.md) movement, [free software](free_software.md) movement, [Creative Commons](creative_commons.md) etc.

The book *Free Culture* by Lessig talks, besides others, about how copyright has started and how it's been shaped by corporations to becoming their tool for monopolizing art. The concept of copyright has appeared after the invention of [printing press](printing_press.md). The so called *Statute of Anne* of 1710 allowed the authors of books to control their copying for **14 years** and only after **registartion**. The term could be prolonged by anothert 14 years if the author survived. The laws started to get more and more strict as control of information became more valued and eventually the term grew to **life of author plus 70 years**, without any need for registration or deposit of the copy of the work. Furthermore with new technologies, the scope of copyright has also extended: if copyright originally only limited *copying* of books, in the Internet age it started to cover basically any use, as any manipulation of [digital](digital.md) data in the computer age requires making local copies. Additionally the copyright laws were passing despite being unconstitutional as the US constitution says that copyright term has to be finite -- the corporations have found a way around this and simply regularly increased the copyright's term, trying to make it [de-facto](de_facto.md) [infinite](infinity.md) (technically not infinite but ever increasing). Their reason, of course, was to firstly forever keep ownership of their own art but also, maybe more importantly, to **kill the [public domain](public_domain.md)**, i.e. prevent old works from entering the public domain where they would become a completely free, unrestricted work for all people, competing with their [proprietary](proprietary.md) art (who would pay for movies if there were thousands of movies available for free?). Nowadays, with coprporations such as [YouTube](youtube.md) and [Facebook](facebook.md) de-facto controlling most of infromation sharing among common people, the situation worsens further: they can simply make their own laws that don't need to be passed by the government but simply implemented on the platform they control. This way they are already killing e.g. the right to [fair use](fair_use.md), they can simply remove any content on the basis of "copyright violation", even if such content would normally NOT violate copyright because it would fall under fair use. This would normally have to be decided by court, but a corporation here itself takes the role of the court. So in terms of copyright, corporations have now a greater say than governments, and of course they'll use this power against the people (e.g. to implement censorship and surveillance).

Copyright rules differ greatly by country, most notably the US measures copyright length from the publication of the work rather than from when the author died. It is possible for a work to be copyrighted in one country and not copyrighted in another. It is sometimes also very difficult to say whether a work is copyrighted because the rules have been greatly changing (e.g. a notice used to be required for some time), sometimes even retroactively copyrighting public domain works, and there also exists no official database of copyrighted works (you can't safely look up whether your creation is too similar to someone else's). All in all, copyright is a huge mess, which is why we choose [free licenses](free_software.md) and even [public domain](public_domain.md) waivers.

Not even lawyers have any clue about copyright in all its complexity, it's so hugely complicated by now that apart from very clear cases no one can usually safely tell you what's copyrighted and what not, it's not defined clearly, different countries have different rules and precedents and if you win a copyright court case or not depends many times on who the judge is, whether he got laid that night and if he took a good shit in the morning. The moral of the story is this: KEEP IN THE SAFE ZONE, never go to copyright gray areas, make everything yourself from scratch, minimize reusing someone else's works.

Copyright does [cultural](culture.md) harm as well: for example it tightly connects people with ideas and art, their "property", and extorts a force against attempts at separating humans from ideas, which is necessary for critical evaluation of ideas. While past philosophers correctly saw art as rather being discovered than created, as when we're discovering new land or laws of nature, copyright removes any subconscious humility, it makes man into a god who CONJURES a thing, owns it, controls it and has absolute authority over it, further fueling the extinction of humble individuals. If now someone discovers a new way of arranging colors on a canvas so that it pleases human eye, people see it as "logical" that he can forbid anyone from doing it or demand money wherever this arrangement appears. It is not logical at all, but it now seems logical -- the power of evil is [unlimited](yes_they_can.md) and can bend even [logic](logic.md).

In some countries copyright terrorists already establishes a kind of tax that is paid when buying a storage device such as a USB stick -- it is now assumed the device will be used to share copyrighted material so you pay extra money in advance to copyright holders for this crime you are found guilty of before you commit it. Welcome to [21st century](21st_century.md).

[Copyleft](copyleft.md) (also share-alike) is a concept standing against copyright, a kind of anti-copyright, invented by [Richard Stallman](rms.md) in the context of [free software](free_software.md). It's a license that grants people the rights to the author's work on the condition that they share its further modification under the same terms, which basically [hacks](hacking.md) copyright to effectively spread free works like a "virus".

Copyright does **not** (or at least should not) apply to facts (including mathematical formulas) (even though the formulation of them may be copyrighted), ideas (though these may be covered by [patents](patent.md)) and single words or short phrases (these may however still be [trademarked](trademark.md)) and similarly trivial works. As such copyright can't e.g. be applied to game mechanics of a computer [game](game.md) (it's an idea). It is also basically proven that copyright doesn't cover [computer languages](programming_language.md) (Oracle vs Google). Also even though many try to claim so, copyright does NOT arise for the effort needed to create the work -- so called "sweat of the brow" -- some say that when it took a great effort to create something, the author should get a copyright on it, however this is NOT and must NOT be the case (otherwise it would be possible to copyright mere ideas, simple mathematical formulas, rules of games etc.). Depending on time and location there also exist various peculiar exceptions such as the freedom of panorama for photographs or uncopyrightable utilitarian design (e.g. no one can own the shape of a generic car). But it's never good to rely on these peculiarities as they are specific to time/location, they are often highly subjective, fuzzy and debatable and may even be retroactively changed by law. This constitutes a huge legal [bloat](bloat.md) and many time legal unsafety. Do not stay in the gray area, try to stay safely far away from the fuzzy copyright line.

A work which is not covered by copyright (and any other IP) -- which is nowadays pretty rare due to the extent and duration of copyright -- is in the **[public domain](public_domain.md)**.

[Free software](free_software.md) (and free art etc.) is **not** automatically public domain, it is mostly still copyrighted, i.e. "owned" by someone, but the owner has given some key rights  to everyone with a free software license and by doing so minimized or even eliminated the negative effects of full copyright. The owner may still keep the rights e.g. to being properly credited in all copies of the software, which he may enforce in court. Similarly software that is in public domain is **not** automatically free software -- this holds only if source code for this software is available (so that the rights to studying and modifying can be executed).

**Copyright encourages murder.** The sooner the author dies, the sooner his material will run out of copyright, so if you want some nice work to enter public domain soon, you are literally led by the law to try for him to die as soon as possible.


A commonly used **trick for legally bypassing copyright restrictions** is to use [patches](patch.md). It can help legally modify proprietary works and distribute these modifications by publishing ONLY the changes without redistributing the copyrighted work along. Say there is for example a proprietary video game with [ads](marketing.md) in it and some good programmer decides to modify the game and remove the ads -- like a good human he would subsequently like to share this modified game with others to spare them of suffering from the advertisement torture, but he can't publicly upload the modified version anywhere because it's a derivative work (a modification of something "owned" by someone else), the copyright belongs not to him but to the game company and that can order an instant takedown of this version and even punish the uploader with a lawsuit. What he can do instead is to publish only a patch, a set of changes that can be automatically applied to the original game to create the modified ad-free version. This patch can legally be distributed because it's technically not a derivative work, it's an original code not containing the game, it's just a set of instruction saying how to remove ads from the video game. To obtain the modified ad-free version it is therefore necessary to already own the original version, but this is still a better situation than not being able to have an ad-free video game at all. This technique works very well and patches are even a very elegant way of sharing that saves bandwidth and storage, but it's true there may be some potential hurdles we have to watch for. For instance the patch MAY sometimes end up legally constituting a derivative work -- imagine for example a fan-fiction patch that can be applied to a [Harry Potter](harry_potter.md) book to obtain a longer, more detailed version of the book; this specific patch will probably have to carry with it new text that contains copyrightable elements such as characters and parts of the original plot. So in summary patches are awesome in bypassing some restrictions, but ultimately do not solve the copyright problem.

## Step By Step Instructions For Dummies To Determine Copyright Status Etc.

DISCLAIMER: Fuck you.

NO ONE EXCEPT [DRUMMYFISH](drummyfish.md) UNDERSTANDS COPYRIGHT for some reason, not even copyright lawyers, judges, people with 10 Nobel prizes in law and people dealing with copyright for their whole lives, it's incredible how people somehow cannot grasp the basic idea of copyright. It is a bit more complex than wiping your butt but it's not rocket science, for some reason everyone keeps coming up with weird conspiracy theories about how copyright works when there are relatively simple rules that allow us to analyze every single case exactly, save for subjective judgments such as where the threshold of originality lies etc. Here is an attempt at dumbing it all down to a simple summary that anyone with half a brain can hopefully follow.

Preface: we must reiterate that copyright is NOT the only form of intellectual property, there are many others (trademarks, patents, personal rights, trade dress, ...). Here we will focus on copyright because that's usually what causes us trouble, but even if we check that copyright isn't burdening a specific work, it's still possible it will be burdened by another shit, always keep this on your mind. Also copyright laws differ by country etcetc., you know the drill.

Next, STOP ASSUMING WEIRD COMMON SENSE THEORIES, that's not how law works, law is not about common sense or feelings or fairness or justice or morality or anything else but completely arbitrary rules established by drunk idiots for fun which must be followed absolutely blindly even if it makes zero sense because we live in a dystopia full of idiots who do fucked up shit. To understand copyright you must first understand this as reality, copyright doesn't work as you would wish or assume it worked. To understand copyright just learn the rules and don't ask why they are so because if we wanted to be reasonable, first of all we'd get rid of whole copyright altogether. Some shit theories people often come up with include:

- "I put a lot of work in X so I deserve copyright on it." DOESN'T FUCKING MATTER, NO ONCE CARES
- "The guy made a tutorial on how to make X so he actually kinda gave up his copyright on X because he wants people to make X." DOESN'T FUCKING MATTER
- "The author uploaded it on the Internet by which he kinda gave permission to people to download it." DOESN'T FUCKING MATTER, HE CAN SUE YOU FOR YOUR LAST PENNY
- "People normally do this and I've seen even Wikipedia did it so it's fine." NO ONE FUCKING CARES
- "The guy said do whatever you want so it's basically public domain." NO
- "I got permission of the author on using X in my libre game, so my game remains libre." NO unless he released X under a libre license
- "The author [abandoned](abandonware.md) X and no longer cares about it so it's kinda free now." NO
- "The author died so no one has copyright on it now." NO, copyright typically lasts at least 70 years after the author's death
- "[AI](ai.md) (or insert any new technology) was involved in this so we have no idea about how copyright works here." NO, AI IS LITERALLY A COMPUTER TOOL, WE HAVE 100% IDEA ABOUT HOW COPYRIGHT WORKS HERE
- "I used some convoluted process (such as letting 1000 monkeys type random things for 1000 years) to produce a derivative work of a copyrighted work so I bypassed the rules and it's not a derivative work haha." NO, IT IS DERIVATIVE WORK, DERIVATIVE WORK IS ONLY BASED ON SIMILARITY, NOT THE PROCESS OF CREATION (see below)
- "I found this 50 year old piece of decorative furniture in a yard sale, surely it cannot be covered by copyright, I can happily use it as a 3D model in my game." PROBABLY NOT, 50 YEARS IS TOO NEW
- "I bought this texture (font, soundfont, image, sound effect, ...) so I can use it in my libre art." NO, you probably bought a license to use the texture in a certain way but it most likely doesn't allow literally making the texture free, i.e. literally making it free as in freedom for everyone on the planet (which is required for every part of a libre work), that would completely break the whole business of the seller on the spot
- ...

Now suppose we have an intellectual work *W*, such as a picture, video game, an invented word, circuit schematic, sound effect, logo, music, font, book, fictional character, book translation, mathematical formula, language, a collection of quotes by famous people and so on -- anything that's a non-physical work, anything that can by any stretch be considered a creative [art](art.md) requiring some intellectual "work", i.e. thinking, intuition, creativity etc. Of course this intellectual work MAY be mixed in with a physical work (for example a painting will be PHYSICALLY present on a canvas, or a car design will be present on a PHYSICAL car) -- here we must see that these are two works connected together: the intellectual work and the physical work. There is no issue here, we are still dealing with intellectual work, even if it's only a part of something that's inherently a combination of the abstract and the physical.

Now let's examine the intellectual work's status in terms of copyright. Again, we will now make a simplification (that often holds in practice, but not always) and suppose the work is NOT further burdened by other intellectual property such as patents or trademarks, so we're assuming that the only form over the work *W* that can now be present is copyright. We'll ask who holds the copyright, if the work is free etc.

**Who has the copyright over work W (i.e. who "owns" it)?** If the work is copyrightable (see below), then that who created it (even multiple people or a company etc.) automatically has the copyright (without registering it or declaring it or anything, also note that sometimes the creator sells the copyright to someone else, e.g. a recording studio, and so transfers the copyright to someone else), UNLESS the work is a **derivative work** of some already existing copyrighted work, in which case the creator of the original work has the copyright on the "copied" parts while the creator of the new work has copyright over the independent, newly added parts only. Derivative work PRACTICALLY means that the work was "not created from scratch", i.e. that it is rather a modification of something else and so that who created it can't own it as a whole, it contains something "owned" by someone else -- for example a fan fiction of [Harry Potter](harry_potter.md) is a derivative work because it's heavily based on an existing copyrighted work of Harry Potter, so the owner of Harry Potter now also own parts of all Harry Potter fan fictions, ok? However anything "completely new and original" (such as a completely new invented character) that was added to the original work can SEPARATELY be considered an original work owned by the creator of the derivative work (the fanfiction). Makes sense, right? There is a (sometimes quite subjectively drawn) fine line between a derivative work and a work merely lightly inspired by something that already exists, the latter of which is NOT considered a derivative work: no one can really tell you where the line is exactly, but a basic helper is asking for example "Am I only borrowing trivial, non-copyrightable parts of an existing work?" -- for example borrowing a name of a fantasy race from an existing work may be fine because words are non-copyrightable (but again, if you borrow too many of them it may be a violation because a collection or a whole terminology may already be considered a non-trivial work). Also ask this: if my work were to be judged a derivative work of another work, what consequences would it have? For example if a court judged that you borrowing names of fantasy races from Harry Potter was more than just mere inspiration, then they would also have to admit that the author of Harry Potter was also violating other older works (such as Lord of the Rings) in exactly the same way and so can't have copyright on them, so me doing so is most likely OK, the author can't (well, shouldn't able to) sue me for doing *X* if his work alone (and furthermore basically 99% of all other existing works) is based on the assumption that *X* is legal.

Important note: **the status of derivative work is only based on similarity**. Derivative work is defined simply as a work that is "too similar" to an already existing work, it doesn't matter at all if you LITERALLY made your work based on something or if you accidentally made something too similar to something that already exists because proving HOW the work was made is impossible, it is assumed that if you make something too similar to something else (which is older), it couldn't have happened by chance (even if there is a non-zero probability of it being possible and even if you could prove you made it independently), there would be a mess of two conflicting copyrights and shit, it will just be declared you copied the work even if you didn't and everyone knows it, it's just the rules. So don't try any tricks here. Imagine the world of intellectual works literally as a land: if someone creates something, he basically farms a piece of unoccupied land and by that starts owning it, and along with it also some NEARBY AREA he didn't farm yet (the land of derivative works) -- no one can simply use that nearby area without his permission, no matter by what way he gets there (intentionally or accidentally, in good faith or not), the original farmer simply owns the land by the virtue of having farmed a nearby land first. Again it's a mega retarded rule but it's the rule that exist because without it copyright couldn't work (anyone would be able to bypass copyright by just changing a single pixel in a picture for example).

Examples of derivative works are:

- fanfiction (you are including the universe, characters, terminology etc. made by someone else)
- works made by following a tutorial (you are recreating something made by someone else, usually the creator of the tutorial)
- fan movie edits
- detailed movie plot summaries
- someone else's song with changed lyrics
- book translations
- cover versions of other artist's songs
- videos in which people wear T-shirts with popular TV cartoon characters on them
- books written using a proprietary font (you own the abstract text but NOT the book as a whole as it includes the proprietary font)
- collections of other people's images
- game levels with assets made by a third party
- 3D model using someone else's textures
- modified computer programs
- music made using third party soundfonts and effects
- ...

So yes, a work can have MULTIPLE copyright holders: it may be that different (even overlapping) subparts of the work are "owned" by different people or that the whole is owned by multiple people etc.

Now let's ask this: **Is the work W libre ([free as in freedom](free_culture.md))?** Spoiler: **If the work has a free license, it is not necessarily free!** Currently based on observations it may be that let's say only 70% of works with a free license you will find on the Internet are ACTUALLY free. In theory a free license should imply a free work, but in practice this is just not so, just like for example an "eco" label doesn't automatically mean something is eco-friendly, it's simply a sticker that became either misused or downright abused, so you cannot rely on a sticker, even the forefront "free content" websites often distribute non-free works under free licenses. It's probably not even that the guy who illegitimately puts a free license on his work is doing something illegal, it may be completely legal to do (if you read the license carefully, you may find it states that it only applies to what the author actually created), the point is that the license is likely ineffective (or only partially effective, not applied to the work as a whole, just to some parts), so you may get into legal trouble by using such works in ways you think you are allowed to but in fact aren't. People just stick the licenses on works without knowing how copyright works AND some purposefully use ineffective free licenses as a form of [openwashing](openwashing.md) -- the best example is probably [Wikipedia](wikipedia.md) which is popularly known as the "free" encyclopedia and while it's true that a great part of it IS free, it's also true a great deal of it simply is NOT truly free (for example the free use images or detailed plot summaries of proprietary movies -- yes, it is LEGAL but it's not free, we'll explain this later on). Same with [Linux](linux.md) etc. Remember that a free license can be put on anything, you can write anything on a piece of paper, nothing will happen even if you download a 100% proprietary Hollywood movie and put a [CC0](cc0.md) on it, the world will not explode -- only when it starts to cause the copyright holder significant financial losses to be worth it for him to sue you and drag through months or years of court battles will you learn that in fact the license was ineffective, but this will almost never happen, there are millions and millions of "fake free" works on the Internet that no one cares about because in 99% cases they don't harm anyone's wallet, and because they keep happily existing like this thanks to being tolerated (despite not being legit), a common public perception arose that it's actually legitimate to use licenses like this, but it's nothing but a myth, a misconception widely believed even by many people "in the business".

Not to digress, let's reiterate the definition of a [libre (free)](free_culture.md) work: if a work is to be libre, it must [PRACTICALLY](de_facto.md) grant the basic four freedoms: to use, study, modify and share. Now the key here is NOT to just look at legal rights but rather ask about **[de facto](de_facto.md) freedom**, i.e. don't ask whether it's written somewhere you can do something with that work, firstly ask whether you REALLY can do it practically. Literally ask yourself questions such as: "Can I now go and modify this work in any way I want? Or am I prevented from doing so, e.g. by not having any available tools for it or the source code literally not being available for download anywhere?". If on paper it says you can modify the work but then in practice you can't because the source code is [obfuscated](obfuscation.md), you DO NOT have the right practically and therefore the work is NOT free (at best you can argue it is free legally without being free practically, which is the same as e.g. being legally alive while actually being physically dead). If you find you don't have even just one of the basic four freedoms de facto available, the work is NOT free. But if it passes the test, we can move on.

Now a prerequisite (but, as we said, NOT a sufficient condition) for the main, practical freedom is that you also must have these basic four freedoms granted LEGALLY, because in today's world any work is by default owned by someone and if you don't get explicit permission to do something with it, you may get legally bullied which eventually results in you PHYSICALLY becoming unable to utilize the freedoms (as you'll end up in jail and your work will be burned etc.), and so here is where we start to check the licenses and stuff. So as a next step we have to take a look at the legal side: ask yourself "Can I legally exercise ALL of the four basic freedoms?". You can if:

- The work is non-copyrightable, for example because it's too trivial. There are rules for what is copyrightable and what isn't (it's not like the judge goes "[LMAO](lmao.md) I think you can't copyright here because I feel like it"). Copyright doesn't apply to every form of intellectual works (but other forms of intellectual property may), such as ideas, facts and very simple works (single words, simple shapes, single colors, ...). There are also further exceptions that usually excerpt copyright from applying to languages, utilitarian design etc., this is not so simple but you can look it up. Here a bit of common sense can help you guess (but you must NEVER rely on it, always look up the rules): for example it's quite clear the individual letters of alphabet can't be copyrighted because if someone could forbid the whole world from using the letter "a", the world just couldn't function (it may happen in the [future](future.md), but today it's still considered "too crazy"). So if you invent a new word, you won't have copyright on it (BUT you may for example trademark it). HOWEVER if you invent many new words and make a fictional dictionary of them, then the collection of the words AS A WHOLE is no longer trivial and will be copyrightable (while the single words will still be uncopyrightable). OR
- The work is VERY old and therefore no longer has any "owner" because the copyright has evaporated (so the work is now in the [public domain](public_domain.md)). How old exactly will depend on other details (such as the country of origin) but imagine something around at least 100 years. OR
- The work is new (and therefore probably still has an "owner") but the "owner" somehow granted EVERYONE on the planet ALL the basic rights needed to exercise the basic four freedoms, typically using a free [license](license.md) or a [waiver](waiver.md), i.e. he no longer holds EXCLUSIVE (only available to him) rights to the four basic freedoms. This means the work is technically owned by someone, i.e. it is not in the [public domain](public_domain.md), but thanks to the owner officially giving up some of the key essential rights it can now PRACTICALLY be seen as almost as good as a public domain (it may still be limited by some conditions that "aren't in conflict with the four basic freedoms", e.g. by requirement to give credit, but some licenses go as far as to impose no conditions at all). Needless to say the license must be applied correctly etc. (if in court you claim the guy once told you privately he releases the work under GPL while he was drunk at some party it probably isn't legit, he can just deny it). OR
- It somehow happens to not have any copyright holder. This is rare but in some specific cases this may happen, for example works made by government or animals often remain without copyright etc. BUT WATCH OUT: it's not like that whatever a government touches magically turns into public domain, it's just that government in some countries cannot spawn its own copyright because it's a publicly funded something or whatever, so if a government makes a video with Harry Potter in it, Harry Potter is still proprietary. Again, it couldn't even NOT be so because then a government could go LMAO we can just trollolo take anyone's multibillion dollar copyright away even if he's from another country by just posting a picture on our instagram, the world couldn't function like this.

**Now this is the key part: in your copyright analysis you MUST always also consider ALL subparts of the work and any possible combination and modification thereof AND any possible use (even nonsensical, unethical etc.).** This is what people often don't realize, they think that as long as we take a libre work and do only legal things with, it will remain libre, and that's a 100% FATAL MISTAKE: being libre is a MORE STRICT attribute than being legal, it is something extra, not necessarily guaranteed by legality (even proprietary software is legal), and adding something legal to a free work can make it non-free. You must always ask yourself questions such as: "If I cut out this part of the work, can I do anything with it? Can I extract the font from this work and start selling it?" This is part of the modification and redistribution freedom and it must always be unlimited, else the work isn't libre. You cannot argue like "Who would want to extract font from my game just to sell it? That's a weird use and I don't want people to do it." -- the basic part of the definition of a free cultural work is to allow ANY kind of use, including that which doesn't make sense or which the author is against. If you want to disallow certain uses of your work you (sadly) can, simply by using a non-free license, but you CANNOT claim your work is free if you do this. So remember: **even if it's legal, it's not necessarily libre.** -- really this is possibly a NUMBER ONE mistake people make. They think that if they can legally include something under fair use or with permission in their libre game, the game will remain libre. It will NOT! This is because now the work doesn't allow anyone to do anything with it as fair use limits what can be done with the work, typically disallowing for example commercial use: so if you have a fair use asset in your game, it is now IMPOSSIBLE to cut out that asset and start selling it, and therefore the work is NOT LIBRE (even though the work in its form is still legal). Ask yourself another hypothetical question: "If I send this work to an alien who won't have access to any other works besides the one I sent, WILL HE BE ABLE (omitting unreasonably miraculously improbable cases) to recreate a proprietary work from this if he wants?" If your work is to be considered TRULY libre, the answer must be NO. A libre work must guarantee that if someone takes it and randomly messes with in any way (without mixing in other works of course), it won't suddenly become proprietary. I.e. for example the Wikipedia's article about Harry Potter is NOT truly libre because if I send the page to an alien, he can take the plot summary and expand it a little bit to a book that will be too similar to the original Harry Potter book, violating its copyright, which means the Wikipedia article doesn't permit any kind of modification due to relying on fair use, the essential freedom of modification is limited because in order for the article to stay legally safe it must remain unmodified or can be modified in only limited ways -- expanding the plot summary into a whole book is not allowed, and so the article is not free/libre. Another example: there is for example so called "freedom of panorama" rule that says you can use photographs of buildings that contain copyrightable elements as a part of wide panorama BUT here is the catch: such photograph cannot be free as in freedom because modification is limited here by the inability to crop the building out -- then freedom of panorama would seize to apply, so cropping the picture is forbidden. Do you fucking understand it now? I know you wish it wasn't so but you goddamn bet it is so, we live in a shittopia, don't mistake your [wishful thinking](optimism.md) for reality.

## See Also

- [bullshit](bullshit.md)
- [trade dress](trade_dress.md)
- ["moral rights"](moral_rights.md)
- [free culture](free_culture.md)
- [copyleft](copyleft.md)
- [derivative work](derivative_work.md)
- [fair use](fair_use.md)
- [creative commons](cc.md)
- [license](license.md)
- [patent](patent.md)
- [trademark](trademark.md)
- [public domain](pd.md)
- [intellectual property](intellectual_property.md)
- [plagiarism](plagiarism.md)






