# Copyleft

Copyleft (also share-alike) is a concept of allowing sharing and modifications of intellectual works (such as pictures, music or computer programs) on the legal condition that others will share it under the same terms (i.e. that they will also allow the work's further free sharing and modification etc.); it was created by the critics of [copyright](copyright.md) as a "more sane" take on this concept. The symbol of copyleft is a mirrored copyright symbol, i.e. horizontally flipped C in circle (C looking "to the left", [Unicode](unicode.md) U+1F12F). Copyleft is widely utilized by some proponents of [free (as in freedom) software](free_software.md) and [culture](free_culture.md) to legally (i.e. with a [license](license.md)) ensure this software/art and its modifications will always remain free (as in freedom), however other camps of freedom proponents argue that copyleft is still too restrictive and share their works under [even more relaxed](premissive.md) legal conditions. Copyleft kind of [hacks](hacking.md) [copyright](copyright.md) to [de-facto](de_facto.md) remove copyright (the monopoly it creates) by its own power. Typical examples of copyleft licenses are the [GPL](gpl.md) (mostly used for [software](sw.md)) and [CC BY-SA](cc_by_sa.md) (mostly used for non-software works).

Copyleft has been by its mechanisms likened to a virus because once it is applied to a certain work, it "infects" it and will force its conditions on any [descendants](fork.md) of that work, i.e. it will spread itself -- the word virus here bears less of a negative connotation, at least to some who see it as a "good virus".

For free/open-source software the alternative to copyleft is so called **[permissive](permissive.md)** licensing which (same as with copyleft) grants all the necessary freedom rights, but, unlike copyleft, does NOT require further modified versions to grant these rights as well. This allows free software being forked and developed into [proprietary](proprietary.md) software and is what copyleft proponents criticize. However, both copyleft and permissive licensing are free as in freedom.

In the [FOSS](foss.md) world there is a huge **battle between the copyleft camp and permissive camp** (our [LRS](lrs.md) advocates permissive licenses with a preference for 100% [public domain](public_domain.md)). These debates go beyond mere technology and law for the basic disagreement lies in whether freedom should be forced and if forced freedom really is freedom, thereby getting into questions of politics, ideologies, philosophy, morality and [ethics](ethics.md). Some groups opposing copyleft include [copyfree](copyfree.md), [GNG](gng.md) and [LRS](lrs.md).

## Issues With Copyleft

In the great debate of copyleft vs permissive free licenses we, as technological [anarchists](anarchism.md) who oppose any "intellectual property" laws and their enforcement, stand on the permissive side. Here are some reasons for why we reject copyleft:

- It **burdens the reuser of the work by requiring him to do something extra** -- while a public domain and many permissive licensed works can simply be taken and used without taking any extra action, just as it should ideally be, a work under copyleft requires its user to take an action, for example copying the license file (and then forever making sure it doesn't get lost), giving credit etc. While one may think this is not such a big deal, it's a form of friction that can get in the way of creativity, especially when combining many works under possibly different copyleft licenses which suddenly becomes quite cumbersome to handle.
- By adopting copyleft one is **embracing and supporting the copyright laws and perpetuating the [capitalist](capitalism.md) ways** ("marrying the lawyers") because copyleft relies on and uses copyright laws to function; to enforce copyleft (prevent "disallowed" use) one has to make a legal action (while with permissive license we simply basically give up the rights to make a legal action). Copyleft chooses to play along with the capitalist bullshit [intellectual property](intellectual_property.md) game and threatens to [fight](fight_culture.md) and use force and bullying in order to enforce *correct* usage of information.
- In a way it is **[bloat](bloat.md)**. Copyleft introduces **legal complexity**, [friction](friction.md) and takes programmers' [head space](head_space.md) (every programmer has to study a bit of copyright law nowadays due to such BS), especially considering that copyleft is also probably largely ineffective as **detecting its violation and actual legal enforcement is difficult, expensive and without a guaranteed positive outcome** ([FSF](fsf.md) encourages programmers to hand over their copyright to them so they can defend their programs which just confirms existence and relevance of this issue). The effort spent on dealing with this is a wasted human time. Sure, corporations can probably "abuse" permissive (non-copyleft) software easier, but we argue that this is a problem whose roots lie in the broken basic principles of our society ([capitalism](capitalism.md)) and so the issue should be addressed by improving our socioeconomic system rather than by bullshit legal techniques that just imperfectly and many times completely ineffectively try to cure the symptoms while strengthening the system's mechanisms.
- **The scope of copyleft is highly debatable, introducing doubt/uncertainty** (which is why we have different kind of copyleft such as *strong*, *weak*, *network* etc.). I.e. it can't be objectively said what exactly should classify as violation of copyleft AND increasing copyleft scope leads to copylefted software being practically unusable. You may say "so what", but in law clarity is extremely important, it may also discourage people because they don't really know what they sign up for, commercial use may also be discouraged by this for the same reason which may have a similar effect to a non-free license that downright disallows commercial use. Consider this **example**: [Linux](linux.md) is copylefted which means we can't create a proprietary version of Linux, nevertheless we can create a proprietary operating system of which Linux is part (e.g. [Android](android.md) in which its proprietary app store makes it de-facto owned by [Google](google.md)), and so Linux is effectively used as a part of proprietary software. **So copyleft can really be bypassed** (see e.g. [bloat monopoly](bloat_monopoly.md)). One might try to increase the copyleft scope here by saying *"everything Linux ever touches has to be free software"* which would however render Linux unusable on practically any computer as most computers contain at least some small proprietary software and hardware. The restriction would be too great. You may of course try to combat the giants further until eternity, but then you are wasting your life being a shitty lawyer rather than doing useful programming.
- **Copyleft drags people into [activism](fight_culture.md), leaving less place for actual creativity** -- one of the best examples is [Richard Stallman](rms.md) and his [GNU](gnu.md) project, who were quite active in programming at their beginning but soon turned more or less just into a political activist group, spending time on petitions, propaganda, certifications ([RYF](ryf.md), ...) and generally just the same kind of bullshit [fights](fight_culture.md) that capitalists like (often attacking even those who make free software, e.g. the *GNU boot* project for infringing on the name GNU without permission). Stallman himself said "he no longer programs because he has more important things to do". Maybe you say this has nothing to do with copyleft, but it's not a coincidence, copyleft is a mindset of constantly having to "protect" (as opposed to "letting go", the permissive mindset), for example once web applications appeared, the GNU people were suddenly all about having to make new licenses such as [AGPL](agpl.md) to [update](update_culture.md) to the newest trends in technology and society. Any time a new technology or kind of legal abuse emerges, they have to update their licenses. Choosing copyleft really means choosing to be this kind of warrior and guard of right and wrong, which of course takes away some of your creative potential, with many people just giving in completely.
- **Copyleft licenses have to be complex and ugly** because they have to strictly describe the copyleft scope and include lots of legal [boilerplate](boilerplate.md) in order to make them well defendable in court (copyleft is really about preparing for a legal war) -- and as we know, complexity comes with bugs, vulnerabilities, it makes it incomprehensible to common people and imposes many additional burdens. Indeed, we see this in practice: the only practically used copyleft licenses are the various versions of GPL of which all are ugly and have historically shown many faults (which is again evident from e.g. looking at GPL v1 vs v2 vs v3). This introduces great **license compatibility issues**, headaches for programmers who should rather be spending time programming and other similar bullshit. Permissive licenses on the other hand are simple, clear and well understandable, they aren't as much preparing for a court battle as trying to give other hackers a peace of mind and make them free of legal worries.
- **Copyleft prevents not only inclusion in proprietary software but also in permissive FREE software.** I.e. as a consequence of denying code to corporations collateral damage is done by also denying code to ethical free software that wishes to be distributed without copyleft conditions. Similarly to how proprietary software forces free software programmers to reinvent wheels by rewriting software as free, copyleft forces permissive free software programmers to reinvent wheels and rewrite copylefted code as permissive. In this way copyleft [fights](fight_culture.md) not only proprietary software, but also other kinds of free software.
- **There are currently no nice copyleft licenses** -- this of course isn't argument against copyleft itself but it's a practical argument nevertheless. Copyleft nowadays basically means GPL and GPL has a shitton of burdening stuff like requiring credit etc. If you want pure copyleft without anything on top, good luck looking for a license (keep in mind that making your own license or using some obscure, legally untested license is mostly a bad idea).
- A real gem: **copyleft may even make it illegal to share your software at all**. You read that correctly, this is an example of the legal complications that may arise from going down the road of copyleft -- as hinted on at https://www.gnu.org/philosophy/linux-gnu-freedom.html, it may for example be questionable whether [Linux](linux.md) binaries can legally be shared at all, as they come with binary blobs to which no source code is provided, and GPL requires source code of the whole software to be provided. Can this be solved? Possibly yes, by adding more paragraphs, exceptions, by downloading the blobs from the Internet instead of distributing them etcetc., but do we really want to go through this? { Thanks to my friend for sending this to me <3 ~drummyfish }
- ...

## See Also

- [permissive](permissive.md)
- [copyfree](copyfree.md)
- [copyright](copyright.md)
