# Books

Here there will be a constantly WIP list of [books](book.md) that might be of interest to supporters of [LRS](lrs.md):

{ Let's aim for quality rather than quantity here, don't put any book that has some connection to our cause here, but rather the ones you've read and which you judge as a quality book that enriched you in some way. ~drummyfish }

- **Blackout** (2017, Elsberg): Fiction, telling a story of a large blackout in Europe that shows to really be caused by [bloated](bloat.md) tech. For [collapse](collapse.md) enjoyers this is an interesting read if only for the detailed description of the consequences of a sudden loss of electric power.
- **Day of the Triffids** (1951, Wyndham): Excellent sci-fi in which civilization comes to an end due to a disaster (won't spoil), very nice for collapse preppers or just people enjoying a great story narrated in captivating way :-) The movie is a joke, don't even search for it. Also other books by Wyndham are awesome.
- **[Einstein](einstein.md): His Life and Universe** (Isaacson, 2008): [Einstein](einstein.md)'s biography, quite a nice read about a pretty awesome man who's image has been so distorted by the mainstream shit. 
- **Encyclopedia Britannica 11th edition** (1911): Gigantic old uncensored [encyclopedia](encyclopedia.md), mostly digitized and fulltext searchable, also completely [public domain](public_domain.md), with very long articles on all topics up to the date of its publication. Great source of lesser known information and an alternative to modern censored sources. Also check out other similar encyclopedias.
- **[Flatland](flatland.md)** (Abbott, 1884): Absolutely amazing fantasy story set in two dimensional land with characters being geometric shapes, also criticizing contemporary society to a degree. It discusses practical and mathematical aspects of actually living in two dimensions, how the characters see, how they build their houses etc. It is now absolutely [public domain](public_domain.md)!
- **Free as in Freedom** (Sam Williams, 2002): Free-licensed official biography of [Richard Stallman](rms.md), contains many historical details about how [free software](free_software.md) came to be, how [open source](open_source.md) spoiled it etc.
- **Free Culture** (Lessig, 2004): Creative-commons licensed (non-free but gratis) book by the founder of [Creative Commons](creative_commons.md) and [free culture](free_culture.md), goes into details on how copyright became abused by capitalism, why public domain is being smothered and why we must support free culture.
- **Game Engine Black Book: Doom** (Sanglard, 2019): Gratis, very nice book dissecting all the details about the legendary [Doom](doom.md) engine and its internals -- how it worked, why was it so fast, what hacks went into it, written so that a reader of any programming skill (even none) will find something interesting. A must read for fans of oldschool game programming.
- **Game Engine Black Book: Wolfenstein 3D** (Sanglard, 2019): Same as the Doom engine book from the same author, just about the older game Wolfenstein 3D, also amazing.
- **Guinness Book of World Records, BEFORE 2000**: The older books were excellent, ideally get some from 80s or earlier, there are funny records like most rats killed by a cat in one hour, most primitive languages and so on. Do NOT buy the new editions, these are uttermost absolute garbage equivalent to an expensive toilet paper.
- **[Harry Potter](harry_potter.md)** (1997 to 2007): Quite comfy, relaxed fantasy read, despite having been written by a [woman](woman.md). WARNING: do NOT read anything published later such as various spinoffs and new censored editions, it's all lesbian poison now, read only the original books.
- **Industrial Society and Its Future** (Kaczynski, 1995): A bit boring read by the famous [Unabomber](ted_kaczynski.md), criticizing rapid technology advancement, but an important read for those who are more into technology/minimalism/etc., if only for the memes :)
- **ISO/IEC 9899:1999** (1999): Specification of the [C](c.md) programming language in a version that [suckless](suckless.md)/[LRS](lrs.md) very often uses. It's nice to skim over it to get an idea how a language is actually specified. You'll also probably learn something new about C in the process.
- **Just for Fun** (2001): Official biography of [Linus Torvalds](torvalds.md), the original creator of [Linux](linux.md). It recounts valuable historical moments with comments by Linus himself, revealing many interesting details and also a bit of Torvalds' personality (shows some of his evil side).
- **Larousse Desk Reference Encyclopedia** (1995): Very nice single-volume [encyclopedia](encyclopedia.md) that's sorted by topic, with many nice illustrations, published back then when censorship wasn't so extreme, provides overview of all topics of human knowledge.
- **[Lord of the Rings](lotr.md)** (1954, also The Hobbit, Silmarillion etc.): Epic fantasy, mandatory read, period. Like with other popular works you must NOT read any newer renditions/editions/spinoffs, they are all cancerous poison, it's a serious danger to one's mental health. Only read the original books (watching the 2000s LotR movies is also allowed, but NOT the Hobbit etc.).
- **Masters of Doom** (Kushner, 2003): Another nice book for [Doom](doom.md) fans, this time not really technical but rather just retelling the story of the game's development -- quite comfy, a lot if interesting trivia.
- **[The Jargon File](jargon_file.md)** (1975...): [Hacker culture](hacking.md) dictionary, a lot of wisdom, inside jokes, and things related to oldschool hacking.
- **Rebel Code** (Moody, 2001): A bit of a mainstream view at the whole "[open source](open_source.md)" history -- though it's a small brain business view which we have to keep in mind at all times, it's a nice introduction to the whole FOSS world for the newcomers, as the book covers most of the relevant projects and [people](people.md).
- **Starting Forth** (Leo Brodie, 1981): Good book to learn [Forth](forth.md).
- **The Chrysalids** (John Wyndham, 1955): Apocalyptic sci-fi about a middle-age-like deeply religious dystopia after a nuclear war, it's among the author's best works.
- **The Country of the Blind** by H. G. Wells (1911): Very nice story, also in the public domain and digitized online, easily accessible. Though not related to technology, it's a great food for thought as it entertains an idea of a population of people who are completely blind which has interesting implications for their lives, and furthermore it shows that if you place someone too competent in a group of retards, they won't recognize his competence, in fact they'll see him as someone yet more retarded than they are themselves.
- **The Nostalgia Nerd's Retro Tech**: Nice small database of all the old consoles/computers (SNES, Amiga, C64, ...), each one with high quality photos, short summary, specs and notable games. There is not much text, it's more like tl;drs of the most important stuff, it's an ideal overview of the old computers for a newcomers but can also serve as a quick reference to anyone.
- older books by **Andreas Eschbach** { The new ones seemed to have some Feminist shit etc., had to stop reading it :D ~drummyfish }, mainly **Carpet Makers** and **Jesus Video**: This is not directly related to LRS but it feels right to mention one of the most underrated [sci-fi](sci_fi.md) authors here -- many LRS followers will probably appreciate high quality sci-fi dealing with super interesting topics that are at least loosely related to LRS. Really Eschbach is so superior to just 99% of all sci-fi you'll encounter, his books are extremely readable, believable and greatly interesting in choosing topics, he makes you think about society, religion etcetc. Spoilers probably won't help, just go check out the books.
- **The Pig and the Box** (MCM, 2009): A short story for kids showing the dangers of [DRM](drm.md), released under [CC0](cc0.md)!
- **The Tao of Programming** (James, 1987): Famous piece of [hacker culture](hacking.md) literature, wisdom of programming written in taoist style.
- **Tricks of the Game Programming Gurus** (1994): Very nice, readable book, that implements a whole 90s shooter game in [C](c.md), without drowning the reader in tons of equations and smartass talk. It's written with the 90s mindset and in common language, contains many practical tricks for optimizing the code etc.
- **Truly Tasteless Jokes**: A collection of dark humor [jokes](joke.md), very useful since they can no longer be found on the [Internet](internet.md).
- ...

{ TODO (have to read first): Lisp From Nothing (implementing minimal self-hosted Lisp, CC0 code!). ~drummyfish }