# Art

*There is no indecency in art.*

Art is nowadays mostly understood to be an endeavor (and by extension also its results) that seeks discovery and creation of [beauty](beauty.md) and primarily relies on intuition, its value being mainly in feelings it gives rise to, but it can also stand for a "craft" and skills that are difficult to learn -- both of these meanings however highly overlap as beauty is often connected to that which is difficult to create (as by definition such creations are very rare and therefore valuable). While the most immediate examples of art that come to mind are for example [music](music.md) and painting, fine arts, literature etc., even the most [scientific](science.md) and rigorous effort like [math](math.md) and [programming](programming.md) becomes art when pushed to the highest level, to the boundaries of current knowledge where intuition becomes important for further development. It is sadly the case that modern western culture tries to reduce art to something with no other utility than to be aesthetic or otherwise immediately pleasing to people at large, but [we](lrs.md) must rather see art as something much deeper -- as it has been in the past, for example in ancient Greece -- i.e. that which is beautiful by utility, design, craftsmanship, and whose beauty may be hidden and revealed only to those with enough insight (for example a well written program can only be appreciated by those skilled at programming). Where exactly to draw the boundary between art and non-art is a matter of philosophy, [culture](culture.md) and personal opinion, but usually art is thought to e.g. require attributes of a living human being such as something akin to "soul", thinking, intuition, experience, creativity and emotion -- that which is performed only mechanically is not seen as art. Even though latest [artificial intelligence](ai.md) shows that art can possibly be produced even by a machine, the machine has to be very sophisticated and mimic very complex human thinking -- even if made by a machine, there must be an element of [magic](magic.md) present, a touch of muse, something not completely understood, for a work to be classified as art. At [LRS](lrs.md) we use the word "art" quite broadly, not just for fine art, but also for any craft, and for that which might normally be called "[work](work.md)", as the word "work" to us carries a negative connotation.

**Good art always takes time**, usually a lot of time, and you cannot predict how much time it will need, **art cannot be made on schedule** or as a product. By definition creating true art is never a routine (though it requires well trained skills in routine tasks), it always invents something new, something no one has done before (otherwise it's just copying that doesn't need an artist) -- in this sense the effort is the same as that of research and [science](science.md) or exploring previously unwalked land, you can absolutely never know how long it's going to take you to invent something new, what complications you'll encounter or what you will find in an unknown land. You simply do it, fail many times, mostly find nothing, you repeat and repeat for years until one day you finally stumble upon something worthy of attention. For this art also requires a lot of effort -- yes, there have been cases of masterpieces made very casually, but those are as rare as someone finding a treasure by accident. Art is to a great degree a matter of chance, trial and error, the artist himself doesn't understand his own creation when he makes it, he is only skilled at searching and spotting the good, but in the end he is just someone who invests a lot of time into searching, many times blindly.

Mastery of art comes with **transcending the tool** in the sense of no longer being focused on the tool as well as no longer being its [slave](tool_slave.md). An amateur is obsessed with his tools, he keeps [hopping](hopping.md) editors, [languages](programming_language.md), distros, keyboards, headphones, drills, clothes, he says he can't work without his specific tools; a master comes and creates the art -- if he has no paintbrush, he does it with a pencil and if he doesn't have a pencil, he draws it in the sand. Master is only thinking about art and he can achieve it with most tools he can get his hands on. Chess master doesn't need a chessboard, football master can play barefoot, master climber doesn't need climbing equipment, master drummer can play with a stick he picks from the ground. Great composers, such as Bedrich Smetana, kept composing the best music even after they went deaf and lost what might seem like the most essential tool for composing: that of hearing the music; and yet a "composer" of the [21st century](21st_century.md) finds the audacity to call himself a "professional" while at the same time being unable to compose music without his favorite [DAW](daw.md) at hand. By eliminating the [dependency](dependency.md) on specific tools a mastery of art can be seen as a form of [freedom](freedom.md).

**Art is discovered**, not made. The author of art is merely a discoverer of some beautiful pattern of nature, he may not even fully comprehend or understand that which he discovered, he must in no way be considered its "owner" or arbiter of its use (as capitalism wants to make it with bullshit such as [copyright](copyright.md)). Author has no higher authority in interpretation of his art than anyone else.

Art, like a [woman](woman.md), is beautiful and just like a woman it too often sells itself and becomes a whore, it is difficult to find sincere, pure art like it is difficult to find a sincere love of a woman.

**Art is about acquiring big picture view.** Doing something by following steps of some [algorithm](algorithm.md) is not an art: this is something anyone can do without any experience, creativity or making use of intuition -- even a dumb machine can do this. A process turns into art once it becomes largely driven by very complex decision making done by the brain based on years and years of experience and deep, interconnected knowledge of all the the possible what ifs. A filmmaker cannot just start shooting a movie without having a head loaded with good knowledge of how cameras work, knowing about composition, visual aesthetics, sound, music, colors, acting, writing, editing, doing practical effects, digital effect and many, many other things -- it's not possible to say "I'll first shoot the movie and I'll learn about editing when I get to editing" because editing has to be taken into account already when shooting the movie, the work can only be started when it's already finished in the filmmaker's head. One must know what's important and what to focus on, have an idea of how long something will take to shoot in order to be able to even do any planning, and, importantly, be able to improvise, make spontaneous decisions that will be GOOD, because unexpected things will happen and the ability to make the correct decision in such a situation REQUIRES seeing into the future, seeing the context, the consequences and costs of possible decisions. That's why a director cannot be just someone who knows how to direct actors, he must be someone who knows EVERYTHING about all parts of the movie. Therefore if you want to become a true artist in your craft, you have to learn everything around it. A [capitalist](capitalism.md) will tell you to just learn one thing and ignore everything else that's "out of your responsibility" -- that won't make you an artist, that will just make you a tool. When you want to become an excellent programmer, you can't just limit yourself to learning one programming language and ignore areas that don't interest you too much, claiming "you'll learn it when you need it". You must learn all the areas to acquire different angle views, to collect a set of tools out of which you'll be able to always pick the most appropriate one; knowing just one way means you have just one tool, like going to build a house with just a screwdriver. So go and learn as much as you can, do not overspecialize, do not think you can just know very little and follow a tutorial to make art -- you cannot.

## See Also

- [beauty](beauty.md)
- [databending](databending.md)
- [music](music.md)