#pragma once

#include <boost/functional.hpp>

namespace utl {

// Xe[^Xo[
struct StatusFormat {
	struct Format {
		Format()
			: enable(true)
			, type(0)

		{}

		bool enable; // ύX
		int type; // 
	};

	Format name; // O
	Format bitrate; // rbg[g
	Format fps; // fps
	Format size; // ʃTCY
	Format time; // Đ
	Format volume; // 
};

class StatusLayout {
public:
	enum { SLIDER_MARGIN = 8 };

	struct Layout {
		Layout()
			: width(0)
			, fix(0)
			, reset(false)
			, enable(true)
			, type(0)
			, old(0)
		{}

		std::wstring text;
		int width; // 
		int fix; // Cfg
		bool reset; // CfgZbg
		bool enable; // \/\
		int type; // 
		int old; // Ȍ
		CRect rect; // Oڋ`
	};

	Layout name;
	Layout text;
	Layout bitrate;
	Layout fps;

	Layout size;
	Layout time;
	Layout slider;// enable͒x\̂߂̈ꎞgpŕۑȂ
	Layout volume;// enableŃXC_[\؂ւ

public:
	void init(const StatusFormat& format, const boost::function<void(CRect&)>& callback);
	void draw(CDC& dc, const CRect& rc, const std::wstring& desc, const std::wstring& nametext);
	void reset(); // CfgZbg

private:
	int middleWidth();
	int rightWidth();
	
	void leftDraw(CDC& dc, const CRect& rc);
	void rightDraw(CDC& dc, const CRect& rc);
	

	void namePrepare(CDC& dc, const std::wstring& name);
	void textPrepare(CDC& dc, bool online, long state);
	void bitratePrepare(CDC& dc, bool online);
	void fpsPrepare(CDC& dc, bool online, long state);

	void sizePrepare(CDC& dc);
	void timePrepare(CDC& dc, bool online);
	void sliderPrepare(CDC& dc);
	void volumePrepare(CDC& dc);

	void calcurect(CDC& dc, Layout& layout, const std::wstring& text, bool indent);

private:
	boost::function<void(CRect&)> getVideoRect_;
};

} // namespace utl

