#include "stdafx.h"

namespace utl {

const static DWORD bindKeyCode[] = {
	VK_BACK,
	VK_TAB,
	VK_CLEAR,
	VK_RETURN,
	VK_SHIFT,
	VK_CONTROL,
	VK_MENU,
	VK_PAUSE,
	VK_CAPITAL,
	VK_ESCAPE,
	VK_SPACE,
	VK_PRIOR,
	VK_NEXT,
	VK_END,
	VK_HOME,
	VK_LEFT,
	VK_UP,
	VK_RIGHT,
	VK_DOWN,
	VK_PRINT,
	VK_INSERT,
	VK_DELETE,
	VK_LWIN,
	VK_RWIN,
	VK_NUMPAD0,
	VK_NUMPAD1,
	VK_NUMPAD2,
	VK_NUMPAD3,
	VK_NUMPAD4,
	VK_NUMPAD5,
	VK_NUMPAD6,
	VK_NUMPAD7,
	VK_NUMPAD8,
	VK_NUMPAD9,
	VK_MULTIPLY,
	VK_ADD,
	VK_SEPARATOR,
	VK_SUBTRACT,
	VK_DECIMAL,
	VK_DIVIDE,
	VK_F1,
	VK_F2,
	VK_F3,
	VK_F4,
	VK_F5,
	VK_F6,
	VK_F7,
	VK_F8,
	VK_F9,
	VK_F10,
	VK_F11,
	VK_F12,
	VK_F13,
	VK_F14,
	VK_F15,
	VK_F16,
	VK_NUMLOCK,
	VK_SCROLL,
	0xBA,
	0xBB,
	0xBC,
	0xBD,
	0xBE,
	0xBF,
	0xC0,
	0xDB,
	0xDC,
	0xDD,
	0xDE,
	0xE2,
};

const static wchar_t *bindKeyName[] = {
	L"BackSpace",
	L"Tab",
	L"Clear",
	L"Enter",
	L"Shift",
	L"Ctrl",
	L"Alt",
	L"Pause",
	L"CapsLock",
	L"Esc",
	L"Space",
	L"PageUp",
	L"PageDown",
	L"End",
	L"Home",
	L"",
	L"",
	L"",
	L"",
	L"PrintScreen",
	L"Insert",
	L"Delete",
	L"Left Windows",
	L"Right Windows",
	L"Num 0",
	L"Num 1",
	L"Num 2",
	L"Num 3",
	L"Num 4",
	L"Num 5",
	L"Num 6",
	L"Num 7",
	L"Num 8",
	L"Num 9",
	L"Num *",
	L"Num +",
	L"Num Enter",
	L"Num -",
	L"Num .",
	L"Num /",
	L"F1",
	L"F2",
	L"F3",
	L"F4",
	L"F5",
	L"F6",
	L"F7",
	L"F8",
	L"F9",
	L"F10",
	L"F11",
	L"F12",
	L"F13",
	L"F14",
	L"F15",
	L"F16",
	L"NumLock",
	L"ScrollLock",
	L":",
	L";",
	L",",
	L"-",
	L".",
	L"/",
	L"@",
	L"[",
	L"\\",
	L"]",
	L"^",
	L"\\",
};



inline DWORD toKey(char chara)
{
	return static_cast<DWORD>(chara);
}


std::wstring getKeyText(DWORD key)
{
	if (key == 0x00)
	{
		return L"Ȃ";
	}

	if ((key >= 0x30 && key <= 0x39) || // 0-9
		(key >= 0x41 && key <= 0x5A)) // A-Z
	{
		std::wstring tmp;
		tmp = wchar_t(key);
		return tmp;
	}

	const int count = sizeof(bindKeyName) / sizeof(bindKeyName[0]);
	for (int i = 0; i < count; ++i)
	{
		if (key == bindKeyCode[i])
		{
			return bindKeyName[i];
		}
	}

	return (boost::wformat(L"(0x%1$02X)") % key).str();
}

std::wstring getModText(DWORD mod)
{
	std::wstring tmp;
	if (mod == MODIFY_CODE_NONE)
	{
		return L"";
	}

	if (mod & (DWORD_MAX ^ MODIFY_CODE_MASK))
	{
		return L"Unknown";
	}
	
	if (mod & MODIFY_CODE_SHIFT)
	{
		tmp += L"Shift";
	}

	if (mod & MODIFY_CODE_CTRL)
	{
		if (tmp != L"")
		{
			tmp += L" + ";
		}
		tmp += L"Ctrl";
	}

	if (mod & MODIFY_CODE_ALT)
	{
		if (tmp != L"")
		{
			tmp += L" + ";
		}
		tmp += L"Alt";
	}
	return tmp;
}


std::wstring getIDText(DWORD id)
{
	switch(id)
	{
	// {
	case IDM_WINDOW_ZOOM_RANGE_BEGIN:	return L"EBhE{1";
	case IDM_WINDOW_ZOOM_RANGE_BEGIN+1:	return L"EBhE{2";
	case IDM_WINDOW_ZOOM_RANGE_BEGIN+2:	return L"EBhE{3";
	case IDM_WINDOW_ZOOM_RANGE_BEGIN+3:	return L"EBhE{4";
	case IDM_WINDOW_ZOOM_RANGE_BEGIN+4:	return L"EBhE{5";
	case IDM_WINDOW_ZOOM_RANGE_BEGIN+5:	return L"EBhE{6";
	case IDM_WINDOW_ZOOM_RANGE_BEGIN+6:	return L"EBhE{7";
	case IDM_WINDOW_ZOOM_RANGE_BEGIN+7:	return L"EBhE{8";
	case IDM_WINDOW_ZOOM_RANGE_BEGIN+8:	return L"EBhE{9";
	case IDM_WINDOW_ZOOM_RANGE_BEGIN+9:	return L"EBhE{10";

	// TCY
	case IDM_WINDOW_SIZE_RANGE_BEGIN:	return L"EBhETCY1";
	case IDM_WINDOW_SIZE_RANGE_BEGIN+1:	return L"EBhETCY2";
	case IDM_WINDOW_SIZE_RANGE_BEGIN+2:	return L"EBhETCY3";
	case IDM_WINDOW_SIZE_RANGE_BEGIN+3:	return L"EBhETCY4";
	case IDM_WINDOW_SIZE_RANGE_BEGIN+4:	return L"EBhETCY5";
	case IDM_WINDOW_SIZE_RANGE_BEGIN+5:	return L"EBhETCY6";
	case IDM_WINDOW_SIZE_RANGE_BEGIN+6:	return L"EBhETCY7";
	case IDM_WINDOW_SIZE_RANGE_BEGIN+7:	return L"EBhETCY8";
	case IDM_WINDOW_SIZE_RANGE_BEGIN+8:	return L"EBhETCY9";
	case IDM_WINDOW_SIZE_RANGE_BEGIN+9:	return L"EBhETCY10";

	// AXyNg
	case IDM_WINDOW_ASPECT_DEFAULT:			return L"AXyNg:ftHg";
	case IDM_WINDOW_ASPECT_NONE:			return L"AXyNg:EBhEɍ킹";
	case IDM_WINDOW_ASPECT_RANGE_BEGIN:		return L"AXyNg1";
	case IDM_WINDOW_ASPECT_RANGE_BEGIN+1:	return L"AXyNg2";
	case IDM_WINDOW_ASPECT_RANGE_BEGIN+2:	return L"AXyNg3";
	case IDM_WINDOW_ASPECT_RANGE_BEGIN+3:	return L"AXyNg4";
	case IDM_WINDOW_ASPECT_RANGE_BEGIN+4:	return L"AXyNg5";

	// \
	case IDM_WINDOW_TOPMOST:		return L"őOʕ\";

	case IDM_WINDOW_FRAME:			return L"EBhEt[\";
	case IDM_WINDOW_TITLE:			return L"^Cgo[\";
	
	case IDM_WINDOW_STATUS:			return L"Xe[^Xo[\";
	case IDM_WINDOW_SEEK:			return L"V[No[\(ItC)";
	case IDM_WINDOW_BBS:			return L"BBSo[\(IC)";

	case IDM_WINDOW_EDIT:			return L"BBSo[̏ݗ\";

	case IDM_WINDOW_BROWSER:		return L"BBSuEU\";

	case IDM_WINDOW_BROWSER_TOP:	return L"BBSuEU\ʒuF";
	case IDM_WINDOW_BROWSER_BOTTOM:	return L"BBSuEU\ʒuF";
	case IDM_WINDOW_BROWSER_LEFT:	return L"BBSuEU\ʒuF";
	case IDM_WINDOW_BROWSER_RIGHT:	return L"BBSuEU\ʒuFE";

	case IDM_WINDOW_BROWSER_TOGGLE_TOP:		return L"BBSuEU\ʒu(gO)F";
	case IDM_WINDOW_BROWSER_TOGGLE_BOTTOM:	return L"BBSuEU\ʒu(gO)F";
	case IDM_WINDOW_BROWSER_TOGGLE_LEFT:	return L"BBSuEU\ʒu(gO)F";
	case IDM_WINDOW_BROWSER_TOGGLE_RIGHT:	return L"BBSuEU\ʒu(gO)FE";

	case IDM_TITLEBAR_SHOW_PLAYER_NAME:		return L"^Cgo[ɃvC[\";
	case IDM_TITLEBAR_SHOW_WINDOW_SIZE:		return L"^Cgo[ɉʃTCY\";
	case IDM_TITLEBAR_SHOW_SOURCE_SIZE:		return L"^Cgo[Ƀ\[XTCY\";
	case IDM_STATUSBAR_SHOW_FPS:			return L"Xe[^Xo[fps\(ItC)";
	case IDM_STATUSBAR_SHOW_WINDOW_SIZE:	return L"Xe[^Xo[ɉʃTCY\";
	case IDM_STATUSBAR_TIME:				return L"Xe[^Xo[̎Ԃϕ\(IC)";
	case IDM_STATUSBAR_PLAY:				return L"Xe[^Xo[ōĐD\";
	case IDM_SEEKBAR_SHOW_FILENAME:			return L"V[No[Ƀt@C\";
	case IDM_BBSBAR_SHOW_COUNTER:			return L"BBSo[ɃXbhXVJE^[\";

	// EBhE
	case IDM_WINDOW_SCREEN_SNAP:	return L"XN[Xibv";
	case IDM_WINDOW_WINDOW_SNAP:	return L"EBhEXibv";

	case IDM_WINDOW_FIXED_RATIO:	return L"TCYύXɔ䗦Œ";
	case IDM_WINDOW_PLAY_RATIO:		return L"ĐJnɎIɔ䗦Kp";
	case IDM_WINDOW_HEIGHT_RATIO:	return L"䗦KpƂɂ";
	case IDM_WINDOW_INSCRIBE_RATIO:	return L"䗦KpƂ̃TCYɎ߂";

	case IDM_START_WINDOW_ZOOM_100:	return L"Nɔ{100%";
	case IDM_SLEEP_STOP:			return L"Đj^[dOFFƃX^oC}~";

	case IDM_FULLSCREEN_HIDE_BARS:			return L"SʉɃo[IɉB";
	case IDM_FULLSCREEN_FLOATING:			return L"SʉɃo[IɉBƂt[eBO\";
	case IDM_FULLSCREEN_MOUSE:				return L"SʉɎIɃ}EXJ[\";
	case IDM_FULLSCREEN_TOPMOST:			return L"SʉɍőOʕ\";

	case IDM_MIXIMIZE_TO_FULLSCREEN:		return L"ő剻{^őSʉ";
	case IDM_MIXIMIZE_SHOW_TASKBAR:			return L"ő剻Ƀ^XNo[̈BȂ";

	// }EX
	case IDM_VOLUME_UP:				return L"ʂグ";
	case IDM_VOLUME_DOWN:			return L"ʂ";
	case IDM_VOLUME_UP_LOW:			return L"ʂグ()";
	case IDM_VOLUME_DOWN_LOW:		return L"ʂ()";
	case IDM_VOLUME_UP_HIGH:		return L"ʂグ()";
	case IDM_VOLUME_DOWN_HIGH:		return L"ʂ()";

	case IDM_SEEK_FORWARD:			return L"iޕɃV[N";
	case IDM_SEEK_BACK:				return L"߂ɃV[N";
	case IDM_SEEK_FORWARD_LOW:		return L"iޕɃV[N()";
	case IDM_SEEK_BACK_LOW:			return L"߂ɃV[N()";
	case IDM_SEEK_FORWARD_HIGH:		return L"iޕɃV[N()";
	case IDM_SEEK_BACK_HIGH:		return L"߂ɃV[N()";

	case IDM_THREAD_NEXT:			return L"փXbhXN[";
	case IDM_THREAD_PREV:			return L"OփXbhXN[";
	case IDM_THREAD_NEXT_LOW:		return L"փXbhXN[()";
	case IDM_THREAD_PREV_LOW:		return L"OփXbhXN[()";
	case IDM_THREAD_NEXT_HIGH:		return L"փXbhXN[()";
	case IDM_THREAD_PREV_HIGH:		return L"OփXbhXN[()";

	case IDM_SCALE_UP:				return L"EBhEg";
	case IDM_SCALE_DOWN:			return L"EBhEk";
	case IDM_SCALE_UP_LOW:			return L"EBhEg()";
	case IDM_SCALE_DOWN_LOW:		return L"EBhEk()";
	case IDM_SCALE_UP_HIGH:			return L"EBhEg()";
	case IDM_SCALE_DOWN_HIGH:		return L"EBhEk()";

	case IDM_MUTE:					return L"~[g";
	case IDM_MINIMIZE_MUTE:			return L"ŏ~[g";

	case IDM_PAUSE:					return L"ꎞ~";
	case IDM_MINIMIZE_PAUSE:		return L"ŏꎞ~";

	case IDM_THREAD_RESET:			return L"XbhXN[Zbg";
	case IDM_THREAD_RELOAD:			return L"XbhXV";
	case IDM_THREAD_REFRESH:		return L"Xbh蓮XV";
	case IDM_BBS_SAGE:				return L"sageŏ";

	case IDM_FULLSCREEN:			return L"Sʉ";
	case IDM_MAXIMIZE:				return L"ő剻";

	case IDM_BALANCE_CENTER:		return L"ʃoX";
	case IDM_BALANCE_LEFT:			return L"ʃoX";
	case IDM_BALANCE_RIGHT:			return L"ʃoXE";

	/////////////////////////////////
	case IDM_UPDATE_CHANNEL_INFO:	return L"`lXV";
	case IDM_CHANNEL_INFO_NAME:		return L"`l\F`l";
	case IDM_CHANNEL_INFO_TYPE:		return L"`l\F^Cv";
	case IDM_CHANNEL_INFO_GENRE:	return L"`l\FW/ڍ";
	case IDM_CHANNEL_INFO_COMMENT:	return L"`l\FRg";
	case IDM_CHANNEL_INFO_PLAYING:	return L"`l\FA[eBXg/^Cg/Ao";
	case IDM_CHANNEL_INFO_RELAY:	return L"`l\FXi[/[";

	case IDM_BBS_BROWSER:			return L"BBSuEUŃR^NgURLJ";
	case IDM_WEB_BROWSER:			return L"R^NgURLJ";
	case IDM_CLIPBOARD_URL:			return L"R^NgURLNbv{[hփRs[";

	case IDM_PEERCAST_BUMP:			return L"`lĐڑ";
	case IDM_PEERCAST_STOP:			return L"`lؒf";

	case IDM_PLAYER_REBUILD:		return L"Đ/č\z";
	case IDM_PLAYER_TERMINATE:		return L"~";


	// tB^Ot

	// t@C/URL
	case IDM_OPENFILE_DIALOG:		return L"t@C/URLJ...";
	case IDM_OPENFILE_CLIPBOARD:	return L"Nbv{[ht@C/URLJ";
	case IDM_CLIPBOARD_PATH:		return L"t@C/URLNbv{[hփRs[";

	// ItCĐ
	case IDM_PREV_FILE:				return L"Õt@C";
	case IDM_NEXT_FILE:				return L"̃t@C";
	case IDM_PREV_FILE_LOOP:		return L"Õt@C([v)";
	case IDM_NEXT_FILE_LOOP:		return L"̃t@C([v)";

	case IDM_PLAY_MODE_NORMAL:		return L"ʏĐ";
	case IDM_PLAY_MODE_REPEAT:		return L"s[gĐ";
	case IDM_PLAY_MODE_FOLDER:		return L"tH_Đ";
	case IDM_PLAY_MODE_FOLDER_LOOP:	return L"tH_[vĐ";

	// XibvVbg
	case IDM_SNAPSHOT_SAVE:			return L"XibvVbgۑ";
	case IDM_SNAPSHOT_FOLDER:		return L"XibvVbgۑtH_J...";

	// sDx
	case IDM_PROCESS_PRIORITY_REALTIME:		return L"sDxFA^C";
	case IDM_PROCESS_PRIORITY_HIGH:			return L"sDxF";
	case IDM_PROCESS_PRIORITY_ABOVE_NORMAL:	return L"sDxFʏȏ";
	case IDM_PROCESS_PRIORITY_NORMAL:		return L"sDxFʏ";
	case IDM_PROCESS_PRIORITY_BELOW_NOMAL:	return L"sDxFʏȉ";
	case IDM_PROCESS_PRIORITY_IDLE:			return L"sDxF";

	// ̑
	case IDM_LOG:					return L"O\...";
	case IDM_VERSION:				return L"o[W...";

	case IDM_OPTION:				return L"IvV...";

	case IDM_QUIT_STOP:				return L"`lؒfďI";
	case IDM_QUIT:					return L"I";

	default:
		break;
	}
	return L"Unknown";
}

///////////////////////////////////////////////////////////////////////////

ShortcutManager::ShortcutManager()
	: movement(24)
{
	// {
	data.push_back(Shortcut(IDM_WINDOW_ZOOM_RANGE_BEGIN,	toKey('1'), MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_WINDOW_ZOOM_RANGE_BEGIN+1,	toKey('2'), MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_WINDOW_ZOOM_RANGE_BEGIN+2,	toKey('3'), MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_WINDOW_ZOOM_RANGE_BEGIN+3,	toKey('4'), MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_WINDOW_ZOOM_RANGE_BEGIN+4,	toKey('5'), MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_WINDOW_ZOOM_RANGE_BEGIN+5,	toKey('6'), MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_WINDOW_ZOOM_RANGE_BEGIN+6,	toKey('7'), MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_WINDOW_ZOOM_RANGE_BEGIN+7,	toKey('8'), MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_WINDOW_ZOOM_RANGE_BEGIN+8,	toKey('9'), MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_WINDOW_ZOOM_RANGE_BEGIN+9,	toKey('0'), MODIFY_CODE_CTRL));

	// TCY
	data.push_back(Shortcut(IDM_WINDOW_SIZE_RANGE_BEGIN,	toKey('1'), MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_WINDOW_SIZE_RANGE_BEGIN+1,	toKey('2'), MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_WINDOW_SIZE_RANGE_BEGIN+2,	toKey('3'), MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_WINDOW_SIZE_RANGE_BEGIN+3,	toKey('4'), MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_WINDOW_SIZE_RANGE_BEGIN+4,	toKey('5'), MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_WINDOW_SIZE_RANGE_BEGIN+5,	toKey('6'), MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_WINDOW_SIZE_RANGE_BEGIN+6,	toKey('7'), MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_WINDOW_SIZE_RANGE_BEGIN+7,	toKey('8'), MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_WINDOW_SIZE_RANGE_BEGIN+8,	toKey('9'), MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_WINDOW_SIZE_RANGE_BEGIN+9,	toKey('0'), MODIFY_CODE_SHIFT));

	// AXyNg
	data.push_back(Shortcut(IDM_WINDOW_ASPECT_DEFAULT,			toKey('1'), MODIFY_CODE_ALT));
	data.push_back(Shortcut(IDM_WINDOW_ASPECT_NONE,				toKey('2'), MODIFY_CODE_ALT));
	data.push_back(Shortcut(IDM_WINDOW_ASPECT_RANGE_BEGIN,		toKey('3'), MODIFY_CODE_ALT));
	data.push_back(Shortcut(IDM_WINDOW_ASPECT_RANGE_BEGIN+1,	toKey('4'), MODIFY_CODE_ALT));
	data.push_back(Shortcut(IDM_WINDOW_ASPECT_RANGE_BEGIN+2,	toKey('5'), MODIFY_CODE_ALT));
	data.push_back(Shortcut(IDM_WINDOW_ASPECT_RANGE_BEGIN+3,	toKey('6'), MODIFY_CODE_ALT));
	data.push_back(Shortcut(IDM_WINDOW_ASPECT_RANGE_BEGIN+4,	toKey('7'), MODIFY_CODE_ALT));

	// \
	data.push_back(Shortcut(IDM_WINDOW_TOPMOST,		toKey('T')));

	data.push_back(Shortcut(IDM_WINDOW_FRAME,		toKey('Z')));
	data.push_back(Shortcut(IDM_WINDOW_TITLE,		toKey('X')));
	data.push_back(Shortcut(IDM_WINDOW_STATUS,		toKey('B')));
	data.push_back(Shortcut(IDM_WINDOW_SEEK,		toKey('V')));
	data.push_back(Shortcut(IDM_WINDOW_BBS,			toKey('C')));

	data.push_back(Shortcut(IDM_WINDOW_EDIT,		VK_TAB));

	data.push_back(Shortcut(IDM_WINDOW_BROWSER,			VK_NUMPAD5));
	
	data.push_back(Shortcut(IDM_WINDOW_BROWSER_TOP));
	data.push_back(Shortcut(IDM_WINDOW_BROWSER_BOTTOM));
	data.push_back(Shortcut(IDM_WINDOW_BROWSER_LEFT));
	data.push_back(Shortcut(IDM_WINDOW_BROWSER_RIGHT));

	data.push_back(Shortcut(IDM_WINDOW_BROWSER_TOGGLE_TOP,		VK_NUMPAD8));
	data.push_back(Shortcut(IDM_WINDOW_BROWSER_TOGGLE_BOTTOM,	VK_NUMPAD2));
	data.push_back(Shortcut(IDM_WINDOW_BROWSER_TOGGLE_LEFT,		VK_NUMPAD4));
	data.push_back(Shortcut(IDM_WINDOW_BROWSER_TOGGLE_RIGHT,	VK_NUMPAD6));

	data.push_back(Shortcut(IDM_TITLEBAR_SHOW_PLAYER_NAME));
	data.push_back(Shortcut(IDM_TITLEBAR_SHOW_WINDOW_SIZE));
	data.push_back(Shortcut(IDM_TITLEBAR_SHOW_SOURCE_SIZE));
	data.push_back(Shortcut(IDM_STATUSBAR_SHOW_FPS));
	data.push_back(Shortcut(IDM_STATUSBAR_SHOW_WINDOW_SIZE));
	data.push_back(Shortcut(IDM_STATUSBAR_TIME));
	data.push_back(Shortcut(IDM_STATUSBAR_PLAY));
	data.push_back(Shortcut(IDM_SEEKBAR_SHOW_FILENAME));
	data.push_back(Shortcut(IDM_BBSBAR_SHOW_COUNTER));

	// EBhE
	data.push_back(Shortcut(IDM_WINDOW_SCREEN_SNAP));
	data.push_back(Shortcut(IDM_WINDOW_WINDOW_SNAP));

	data.push_back(Shortcut(IDM_WINDOW_FIXED_RATIO));
	data.push_back(Shortcut(IDM_WINDOW_PLAY_RATIO));
	data.push_back(Shortcut(IDM_WINDOW_HEIGHT_RATIO));
	data.push_back(Shortcut(IDM_WINDOW_INSCRIBE_RATIO));

	data.push_back(Shortcut(IDM_START_WINDOW_ZOOM_100));
	data.push_back(Shortcut(IDM_SLEEP_STOP));

	data.push_back(Shortcut(IDM_FULLSCREEN_HIDE_BARS));
	data.push_back(Shortcut(IDM_FULLSCREEN_FLOATING));
	data.push_back(Shortcut(IDM_FULLSCREEN_MOUSE));
	data.push_back(Shortcut(IDM_FULLSCREEN_TOPMOST));

	data.push_back(Shortcut(IDM_MIXIMIZE_TO_FULLSCREEN));
	data.push_back(Shortcut(IDM_MIXIMIZE_SHOW_TASKBAR));


	// }EX
	data.push_back(Shortcut(IDM_VOLUME_UP,			VK_UP));
	data.push_back(Shortcut(IDM_VOLUME_DOWN,		VK_DOWN));
	data.push_back(Shortcut(IDM_VOLUME_UP_LOW,		VK_UP, MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_VOLUME_DOWN_LOW,	VK_DOWN, MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_VOLUME_UP_HIGH,		VK_UP, MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_VOLUME_DOWN_HIGH,	VK_DOWN, MODIFY_CODE_CTRL));

	data.push_back(Shortcut(IDM_SEEK_FORWARD,		VK_RIGHT));
	data.push_back(Shortcut(IDM_SEEK_BACK,			VK_LEFT));
	data.push_back(Shortcut(IDM_SEEK_FORWARD_LOW,	VK_RIGHT, MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_SEEK_BACK_LOW,		VK_LEFT, MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_SEEK_FORWARD_HIGH,	VK_RIGHT, MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_SEEK_BACK_HIGH,		VK_LEFT, MODIFY_CODE_CTRL));

	data.push_back(Shortcut(IDM_THREAD_NEXT));
	data.push_back(Shortcut(IDM_THREAD_PREV));
	data.push_back(Shortcut(IDM_THREAD_NEXT_LOW));
	data.push_back(Shortcut(IDM_THREAD_PREV_LOW));
	data.push_back(Shortcut(IDM_THREAD_NEXT_HIGH));
	data.push_back(Shortcut(IDM_THREAD_PREV_HIGH));

	data.push_back(Shortcut(IDM_SCALE_UP,			VK_ADD));
	data.push_back(Shortcut(IDM_SCALE_DOWN,			VK_SUBTRACT));
	data.push_back(Shortcut(IDM_SCALE_UP_LOW,		VK_ADD, MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_SCALE_DOWN_LOW,		VK_SUBTRACT, MODIFY_CODE_SHIFT));
	data.push_back(Shortcut(IDM_SCALE_UP_HIGH,		VK_ADD, MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_SCALE_DOWN_HIGH,	VK_SUBTRACT, MODIFY_CODE_CTRL));
	
	data.push_back(Shortcut(IDM_MUTE,				toKey('M')));
	data.push_back(Shortcut(IDM_MINIMIZE_MUTE));

	data.push_back(Shortcut(IDM_PAUSE,				VK_SPACE));
	data.push_back(Shortcut(IDM_MINIMIZE_PAUSE));

	data.push_back(Shortcut(IDM_THREAD_RESET));
	data.push_back(Shortcut(IDM_THREAD_RELOAD));
	data.push_back(Shortcut(IDM_THREAD_REFRESH));
	data.push_back(Shortcut(IDM_BBS_SAGE));

	data.push_back(Shortcut(IDM_FULLSCREEN));
	data.push_back(Shortcut(IDM_MAXIMIZE));

	data.push_back(Shortcut(IDM_BALANCE_CENTER));
	data.push_back(Shortcut(IDM_BALANCE_LEFT));
	data.push_back(Shortcut(IDM_BALANCE_RIGHT));

	/////////////////////////////////

	data.push_back(Shortcut(IDM_UPDATE_CHANNEL_INFO));
	data.push_back(Shortcut(IDM_CHANNEL_INFO_NAME));
	data.push_back(Shortcut(IDM_CHANNEL_INFO_TYPE));
	data.push_back(Shortcut(IDM_CHANNEL_INFO_GENRE));
	data.push_back(Shortcut(IDM_CHANNEL_INFO_COMMENT));
	data.push_back(Shortcut(IDM_CHANNEL_INFO_PLAYING));
	data.push_back(Shortcut(IDM_CHANNEL_INFO_RELAY));

	data.push_back(Shortcut(IDM_BBS_BROWSER));
	data.push_back(Shortcut(IDM_WEB_BROWSER));
	data.push_back(Shortcut(IDM_CLIPBOARD_URL));

	data.push_back(Shortcut(IDM_PEERCAST_BUMP,		toKey('B'), MODIFY_CODE_ALT));
	data.push_back(Shortcut(IDM_PEERCAST_STOP,		toKey('Z'), MODIFY_CODE_ALT));

	data.push_back(Shortcut(IDM_PLAYER_REBUILD,		toKey('R'), MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_PLAYER_TERMINATE,	toKey('S'), MODIFY_CODE_CTRL));

	// tB^Ot

	// t@C/URL
	data.push_back(Shortcut(IDM_OPENFILE_DIALOG));
	data.push_back(Shortcut(IDM_OPENFILE_CLIPBOARD,	toKey('V'),	MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_CLIPBOARD_PATH,		toKey('C'),	MODIFY_CODE_CTRL));

	// ItCĐ
	data.push_back(Shortcut(IDM_PREV_FILE,			VK_PRIOR));
	data.push_back(Shortcut(IDM_NEXT_FILE,			VK_NEXT));
	data.push_back(Shortcut(IDM_PREV_FILE_LOOP,		VK_PRIOR,	MODIFY_CODE_CTRL));
	data.push_back(Shortcut(IDM_NEXT_FILE_LOOP,		VK_NEXT,	MODIFY_CODE_CTRL));

	data.push_back(Shortcut(IDM_PLAY_MODE_NORMAL));
	data.push_back(Shortcut(IDM_PLAY_MODE_REPEAT));
	data.push_back(Shortcut(IDM_PLAY_MODE_FOLDER));
	data.push_back(Shortcut(IDM_PLAY_MODE_FOLDER_LOOP));

	// XibvVbg
	data.push_back(Shortcut(IDM_SNAPSHOT_SAVE,		toKey('P')));
	data.push_back(Shortcut(IDM_SNAPSHOT_FOLDER,	toKey('O')));

	// sDx
	data.push_back(Shortcut(IDM_PROCESS_PRIORITY_REALTIME));
	data.push_back(Shortcut(IDM_PROCESS_PRIORITY_HIGH));
	data.push_back(Shortcut(IDM_PROCESS_PRIORITY_ABOVE_NORMAL));
	data.push_back(Shortcut(IDM_PROCESS_PRIORITY_NORMAL));
	data.push_back(Shortcut(IDM_PROCESS_PRIORITY_BELOW_NOMAL));
	data.push_back(Shortcut(IDM_PROCESS_PRIORITY_IDLE));

	// ̑
	data.push_back(Shortcut(IDM_LOG, toKey('L')));
	data.push_back(Shortcut(IDM_VERSION));

	data.push_back(Shortcut(IDM_OPTION));

	data.push_back(Shortcut(IDM_QUIT_STOP,	toKey('X'), MODIFY_CODE_ALT));
	data.push_back(Shortcut(IDM_QUIT));
}

ShortcutManager::~ShortcutManager()
{
}

std::vector<Shortcut>::iterator ShortcutManager::find(DWORD key, DWORD mod)
{
	return std::find_if(data.begin(), data.end(), [=](const Shortcut& x)->bool{
		return x.key == key && x.mod == mod;
	});
}

std::vector<Shortcut>::iterator ShortcutManager::find(const std::vector<int>& gesture)
{
	return std::find_if(data.begin(), data.end(), [=](const Shortcut& x)->bool{
		return x.gesture == gesture;
	});
}

void ShortcutManager::reset(DWORD key, DWORD mod)
{
	if (key == 0 && mod == 0) { return; }
	for (auto it = data.begin(); it != data.end(); ++it)
	{
		if (it->key == key && it->mod == mod)
		{
			it->key = 0;
			it->mod = 0;
		}
	}
}

void ShortcutManager::reset(const std::vector<int>& gesture)
{
	if (gesture.empty()) { return; }
	for (auto it = data.begin(); it != data.end(); ++it)
	{
		if (it->gesture == gesture)
		{
			it->gesture.clear();
		}
	}
}

void ShortcutManager::reset(DWORD key, DWORD mod, const std::vector<int>& gesture)
{
	if (key == 0 && mod == 0) { reset(gesture); return; }
	if (gesture.empty()) { reset(key, mod); return; }

	for (auto it = data.begin(); it != data.end(); ++it)
	{
		if (it->gesture == gesture)
		{
			it->gesture.clear();
		}

		if (it->key == key && it->mod == mod)
		{
			it->key = 0;
			it->mod = 0;
		}
	}
}

} // namespace bind