#pragma once

namespace sl {

////////////////////////////////////////////////////////////////////////
// ݒ

// }EXzC[
enum MOUSE_WHEEL {
	MOUSE_WHEEL_NONE = -1,
	MOUSE_WHEEL_VOLUME = 0, // 
	MOUSE_WHEEL_SEEK, // V[N
	MOUSE_WHEEL_THREAD, // XbhXN[
	MOUSE_WHEEL_ZOOM, // EBhEg/k
};

// }EX~hNbN
enum MOUSE_MCLICK {
	MOUSE_MCLICK_NONE = -1, // Ȃ
	MOUSE_MCLICK_MUTE = 0, // ~[g
	MOUSE_MCLICK_MINIMIZE_MUTE, // ŏ~[g
	MOUSE_MCLICK_PAUSE, // ꎞ~
	MOUSE_MCLICK_MINIMIZE_PAUSE, // ŏꎞ~
	MOUSE_MCLICK_THREAD_RESET, // XbhXN[Zbg
	MOUSE_MCLICK_THREAD_RELOAD, // XbhXV
	MOUSE_MCLICK_BBS_EDIT, // BBSo[̏ݗ\
};

// }EX_uNbN
enum MOUSE_LDBLCLICK {
	MOUSE_LDBLCLICK_NONE = -1, // Ȃ
	MOUSE_LDBLCLICK_FULLSCREEN = 0, // Sʉ
	MOUSE_LDBLCLICK_MAXIMIZE, // ő剻
	MOUSE_LDBLCLICK_ZOOM100, // {100%
	MOUSE_LDBLCLICK_ZOOM100_FULLSCREEN, // {100%/Sʉ
	MOUSE_LDBLCLICK_ZOOM100_MAXIMIZE, // {100%/ő剻
};

// }EX
struct MouseOperation {
	// ʏ
	struct Screen {
		Screen(bool invert, int wheel, bool rinvert, int rwheel, int mclick, int ldblclick)
			: invert(invert)
			, wheel(wheel)
			, rinvert()
			, rwheel(rwheel)
			, mclick(mclick)
			, ldblclick(ldblclick)
		{}

		bool invert; // }EXzC[]
		int wheel; // }EXzC[
		bool rinvert; // ENbN+}EXzC[]
		int rwheel; // ENbN+}EXzC[
		int mclick; // }EX~hNbN
		int ldblclick; // }EX_uNbN
	};

	// o[
	struct Bar {
		Bar(bool transfer, bool invert, int wheel, int mclick)
			: transfer(transfer)
			, invert(invert)
			, wheel(wheel)
			, mclick(mclick)
		{}
		bool transfer; // ʏ̓
		bool invert; // }EXzC[]
		int wheel; // }EXzC[
		int mclick; // }EX~hNbN
	};

	MouseOperation()
		: online(Screen(false, MOUSE_WHEEL_VOLUME, false, MOUSE_WHEEL_ZOOM, MOUSE_MCLICK_MUTE, MOUSE_LDBLCLICK_FULLSCREEN))
		, offline(Screen(false, MOUSE_WHEEL_SEEK, false, MOUSE_WHEEL_ZOOM, MOUSE_MCLICK_PAUSE, MOUSE_LDBLCLICK_FULLSCREEN))
		, status(Bar(false, false, MOUSE_WHEEL_VOLUME, MOUSE_MCLICK_MUTE))
		, seek(Bar(false, false, MOUSE_WHEEL_SEEK, MOUSE_MCLICK_PAUSE))
		, bbs(Bar(false, false, MOUSE_WHEEL_THREAD, MOUSE_MCLICK_THREAD_RESET))
	{}

	Screen online;
	Screen offline;
	Bar status;
	Bar seek;
	Bar bbs;
};



// zC[ω
struct Variation {
	// ω
	struct Value {
		Value(int normal, int low, int high)
			: normal(normal)
			, low(low)
			, high(high)
		{}

		int normal; // ʏ
		int low; // 
		int high; // 
	};

	Variation()
		: volume(Value(5, 1, 10))
		, seek(Value(5000, 1000, 20000))
		, scroll(Value(10, 1, 100))
		, scale(Value(10, 5, 20))
	{}

	Value volume; // ʕω
	Value seek; // V[Nړ
	Value scroll; // XbhXN[
	Value scale; // EBhEg/k
};

// EBhE
struct WindowOperation {
	WindowOperation()
		: frame(30)
	{}

	int frame; // t[ȂEBhẼTCYύXg
	utl::SnapDistance snap; // Xibv
};


// ݒ
struct OperationConfig {
	utl::ShortcutManager shortcut; // V[gJbgݒ
	MouseOperation mouse; // }EX
	Variation variation; // zC[ω
	WindowOperation window; // EBhE
};

} // namespace sl