#pragma once

namespace sl {

////////////////////////////////////////////////////////////////////////
// ڍאݒ
struct NetworkConfig : public dsp::NetworkControl {
	NetworkConfig()
		: stop(false)
	{}
	bool stop; // vC[I`lؒf
};

// ^Cvʐݒ
struct TypeConfig : public dsp::TypeControl {
};

// fR[_
struct DecoderInfo {
	DecoderInfo()
		: enable(false)
		, name()
		, id()
	{}

	bool enable; // L
	std::wstring name; // tB^
	GUID id; // tB^ID
};

// uEU
struct BrowserConfig {
	BrowserConfig()
		: def(true)
		, bbs(L"PCRBrowser.exe")
		, close(false)
	{}

	bool def; // ̃uEUg
	std::wstring web; // URLJWebuEU
	std::wstring bbs; // BBSuEU
	bool close; // IBBSuEUI
};

// XibvVbg
struct SnapshotConfig {
	SnapshotConfig()
		: folder(L"snapshot")
		, format(utl::GRAPHIC_FORMAT_PNG)
		, jpegQuality(100)
		, display(false)
		, fit(false)
	{}

	std::wstring folder; // ۑtH_
	int format; // ۑ`
	int jpegQuality; // JPEGi
	bool display; // \𑜓xŕۑ
	bool fit; // ̉𑜓xkȂ
};

// N
struct StartConfig {
	StartConfig()
		: recent(true)
	{}

	bool recent; // ŌɍĐt@CĐ
};

// I
struct EndConfig {
	EndConfig()
		: pos(true)
		, size(true)
		, aspect(false)
		, volume(true)
		, balance(false)
		, mute(true)
	{}

	bool pos; // EBhEʒuۑ
	bool size; // EBhETCYۑ
	bool aspect; // AXyNgۑ
	bool volume; // ʂۑ
	bool balance; // ʃoXۑ
	bool mute; // ~[gԂۑ
};

// BBSo[
struct BoardConfig : public bbs::BoardControl {
	// X|bvAbvʒu
	enum POPUP_POSITION {
		POPUP_POSITION_CENTER, // J[\
		POPUP_POSITION_LEFT, // J[\
		POPUP_POSITION_RIGHT, // J[\E
		POPUP_POSITION_BOTH, // J[\E
		POPUP_POSITION_COUNT, // enum
	};

	enum EDIT_SHORTCUT {
		EDIT_SHORTCUT_SHIFT_ENTER, // Shift + Enter
		EDIT_SHORTCUT_CTRL_ENTER, // Ctrl + Enter
		EDIT_SHORTCUT_ALT_ENTER, // Alt + Enter
	};

	struct Movable {
		struct Pair {
			Pair()
				: board(true)
				, thread(false)
			{}

			bool board; // f
			bool thread; // Xbh
		};

		Movable()
			: contact(true)
			, commandline(true)
			, manual(false)
		{}

		bool contact; // R^NgURL
		bool commandline; // R}hC
		bool manual; // AhXo[
		Pair favorite; // Cɓ
		Pair history; // 
	};

	BoardConfig()
		: contact(true)
		, change(true)
		, retry(false)
		, delay(50)
		, position(POPUP_POSITION_CENTER)
		, under(false)
		, align(true)
		, order(false)
		, scroll(false)
		, shortcut(EDIT_SHORTCUT_SHIFT_ENTER)
		, hide(false)
		, log(false)
		, path(L"log.txt")
		, focus(false)
		, newly(true)
		, def(50)
		, partial(1010)
	{}

	bool contact; // R^NgURLǂݍ
	bool change; // URLύX𔽉f
	bool retry; // gCIɃXbhXV~
	int delay; // |bvAbv
	int position; // |bvAbvʒu
	bool under; // o[̉ɂ
	bool align; // XN[cɂ͂ݏoȂ悤ɕ\
	bool order; // X]
	bool scroll; // XbhXN[]
	int shortcut; // ݃V[gJbgL[
	bool hide; // ݂珑ݗ\ɂ
	bool log; // ݐɏ݃O쐬
	std::wstring path; // ݃Ot@CpX
	bool focus; // ݗ\͏ݗɃtH[JXŒ肷
	Movable movable; // Xbhړ铮
	bool newly; // V\
	int def; // VK\X
	int partial; // ǂݍ݃X
	bbs::Links links; // f
	bbs::Links threads; // Xbh
};

struct FontConfig {
	struct Font {
		Font()
			: name(L"MS UI Gothic")
			, point(9)
			//, pixel(12)
		{}

		void set(const LOGFONT& lf)
		{
			name = lf.lfFaceName;
			point = abs(utl::heightToPoint(lf.lfHeight));
			//pixel = abs(lf.lfHeight);
		}

		void get(LOGFONT& lf)
		{
			CFont cf;
			cf.CreatePointFont(point * 10, name.c_str());

			memset(&lf, 0, sizeof(LOGFONT));
			cf.GetLogFont(&lf);
			cf.DeleteObject();
		}

		std::wstring name; // tHg
		int point; // tHg|Cg
		//int pixel; // tHgsNZ
	};

	Font thread;
	Font search;
	Font extract;
};

// XN[
struct ScrollConfig {
	ScrollConfig()
		: init(false)
		, latest(true)
		, refresh(false)
		, manual(true)
		, last(true)
		, delta(1)
		, interval(10)
	{}

	struct Position {
		Position()
			: init(true)
			, latest(false)
		{}

		bool init; // VKǂݍݎɖփWv
		bool latest; // VX擾ɖێ
	};

	bool init; // VKǂݍݎɊJn
	bool latest; // VX擾ɊJn
	bool refresh; // 蓮XVɊJn
	bool manual; // 蓮XN[Œ~
	bool last; // Œ~
	int delta; // XN[
	int interval; // XN[Ԋu(~b)
	Position position;
};

// Xvb^
struct SplitterConfig {
	SplitterConfig()
		: split(6)
		, edge(true)
		, face(RGB(240, 240, 240))
		, border(RGB(208, 208, 208))
	{}

	int split;
	bool edge;
	COLORREF face;
	COLORREF border;
};

#define DEFAULT_SKIN_THREAD L"chat"
#define DEFAULT_SKIN_POPUP L"default"

// CAEg
struct SkinConfig {
	SkinConfig()
		: thread(DEFAULT_SKIN_THREAD, RGB(240, 240, 240), bbs::SKIN_NAME_FORMAT_NODEFAULT, false)
		, popup(DEFAULT_SKIN_POPUP, RGB(255, 255, 224), bbs::SKIN_NAME_FORMAT_NORMAL, true)
	{}
	bbs::SkinConfig thread; // XbhXL
	bbs::SkinConfig popup; // |bvAbvXL
};

// ڍאݒ
struct DetailConfig {
	NetworkConfig network; // lbg[N
	TypeConfig type; // ^Cvʐݒ
	dsp::DecoderControl decoder; // fR[_
	std::vector<DecoderInfo> video; // rfIfR[_
	std::vector<DecoderInfo> audio; // I[fBIfR[_
	BrowserConfig browser; // uEU
	SnapshotConfig snapshot; // XibvVbg
	StartConfig start; // N
	EndConfig end; // I

	BoardConfig board; // BBSo[
	FontConfig font; // tHg
	PopupBrowserConfig popup; // BBSuEU|bvAbv
	ScrollConfig scroll; // BBSuEUXN[
	SplitterConfig splitter; // Xvb^
	SkinConfig skin; // BBSuEUXL
};

void put(XmlParser& p, const bbs::Link& link);
void get(const XmlParser& p, bbs::Link& link);

} // namespace sl