#pragma once

#include "SerializeDisplay.h"
#include "SerializeOperation.h"
#include "SerializeVideo.h"
#include "SerializeDetail.h"


namespace sl {

// pX
struct PathInfo {
	PathInfo() : commandline(false) {}

	std::wstring path; // URLpX/t@CpX
	std::wstring name; // `l
	std::wstring contact; // R^NgURL
	bool commandline; // R}hC
};

// AXyNg
typedef enum {
	WINDOW_ASPECT_DEFAULT = 0, // ftHg
	WINDOW_ASPECT_NONE = 1, // EBhEɍ킹
	WINDOW_ASPECT_CUSTOM = 2, // [U[ݒ
} WINDOW_ASPECT;

// sDx
typedef enum {
	PROCESS_PRIORITY_IDLE, // 
	PROCESS_PRIORITY_BELOW_NOMAL, // ʏȉ
	PROCESS_PRIORITY_NORMAL, // ʏ
	PROCESS_PRIORITY_ABOVE_NORMAL, // ʏȏ
	PROCESS_PRIORITY_HIGH, // 
	PROCESS_PRIORITY_REALTIME, // A^C
} PROCESS_PRIORITY;

// EBhEݒ
struct WindowControl {
	// \
	struct Show {
		Show()
			: topmost(false)
			, title(true)
			, frame(true)
			, bbs(true)
			, seek(true)
			, status(true)
			, edit(false)
			, browser(false)
			, side(CLayoutCtrl::SIDE_BOTTOM)
			, idealX(300)
			, idealY(100)
		{}

		bool topmost; // őOʕ\
		bool title; // ^Cgo[\
		bool frame; // t[\
		bool bbs; // BBSo[\
		bool seek; // V[No[\
		bool status; // Xe[^Xo[\
		bool edit; // BBSo[ݗ\
		bool browser; // BBSuEU\
		int side; // BBSuEU\ʒu
		int idealX; // uEUTCYX
		int idealY; // uEUTCYY
	};

	// 䗦Kp
	struct Ratio {
		Ratio() : fixed(true), play(false), height(true), inscribe(true) {}

		bool fixed; // TCYύXɔ䗦Œ
		bool play; // ĐJnɎIɔ䗦Kp
		bool height; // 䗦KpƂ
		bool inscribe; // 䗦KpƂ̃TCYɎ߂
	};

	// Xibv
	struct Snap {
		Snap() : screen(true), window(true) {}

		bool screen; // XN[Xibv
		bool window; // EBhEXibv
	};

	// S
	struct Fullscreen {
		Fullscreen() : hide(false), floating(false), mouse(true), topmost(true) {}

		bool hide; // o[IɉB
		bool floating; // o[IɉBƂɃt[eBO\
		bool mouse; // IɃ}EXJ[\
		bool topmost; // őOʕ\
	};

	// ő剻
	struct Maximize {
		Maximize() : fullscreen(false), taskbar(true) {}

		bool fullscreen; // Sʉ
		bool taskbar; // ^XNo[̈BȂ
	};

	// ^Cgo[
	struct Title {
		Title() : player(false), size(false), source(false) {}

		bool player; // vC[\
		bool size; // ʃTCY\
		bool source; // \[XTCY\
	};

	// Xe[^Xo[
	struct Status {
		// `l
		struct Channel {
			Channel() : name(true), type(true), genre(true), comment(true), playing(true), relay(true) {}

			bool name; // `l
			bool type; // ^Cv
			bool genre; // W/ڍ
			bool comment; // Rg
			bool playing; // A[eBXg/^Cg/Ao
			bool relay; // Xi[/[
		};

		Status() : fps(true), size(false), time(true), play(true) {}

		bool fps; // fps\(ItC)
		bool size; // ʃTCY\
		bool time; // Ԃϕ\(IC)
		bool play; // ĐD\
		Channel channel;
	};

	// V[No[
	struct Seek {
		Seek() : filename(true) {}

		bool filename; // t@C\
	};

	// BBSo[
	struct BBS {
		BBS() : counter(false) {}

		bool counter; // XVJE^\
	};

public:
	WindowControl()
		: aspect(WINDOW_ASPECT_DEFAULT)
		, priority(PROCESS_PRIORITY_NORMAL)
		, stop(true)
		, zoom(false)
	{}

	int aspect; // AXyNg̃^Cv
	int priority; // sDx
	bool stop; // Đj^[dOFFƃX^oC}~
	bool zoom; // Nɔ{100%

	Show show; // \
	Ratio ratio; // 䗦Kp
	Snap snap; // Xibv
	Fullscreen fullscreen; // Sʉ
	Maximize maximize; // ő剻
	Title title; // ^Cgo[
	Status status; // Xe[^Xo[
	Seek seek; // V[No[
	BBS bbs; // BBSo[

	DWORD getPriority()
	{
		switch(priority)
		{
		case PROCESS_PRIORITY_IDLE:			return IDLE_PRIORITY_CLASS;
		case PROCESS_PRIORITY_BELOW_NOMAL:	return BELOW_NORMAL_PRIORITY_CLASS;
		case PROCESS_PRIORITY_NORMAL:		return NORMAL_PRIORITY_CLASS;
		case PROCESS_PRIORITY_ABOVE_NORMAL:	return ABOVE_NORMAL_PRIORITY_CLASS;
		case PROCESS_PRIORITY_HIGH:			return HIGH_PRIORITY_CLASS;
		case PROCESS_PRIORITY_REALTIME:		return REALTIME_PRIORITY_CLASS;
		default: break;	
		}
		return NORMAL_PRIORITY_CLASS;
	}
};

// ItCĐ[h
typedef enum {
	PLAY_MODE_NORMAL,
	PLAY_MODE_REPEAT,
	PLAY_MODE_FOLDER,
	PLAY_MODE_FOLDER_LOOP,
} PLAY_MODE;

// ItCĐ
struct PlayControl {
	PlayControl()
		: mode(PLAY_MODE_NORMAL)
	{}

	int mode; // ItCĐ[h
};

// e_CAOݒ
struct DialogConfig {
	// BBSo[j[
	struct BBS {
		BBS()
			: sage(true)
		{}

		bool sage; // sageŏ
	};

	// XbhI
	struct Thread {
		Thread()
			: width(600)
			, height(300)
			, stop(false)
			, stretch(true)
			, datetime(true)
			, close(true)
		{
			column[0] = 0; // _~[
			column[1] = 40; // No.
			column[2] = 300; // ^Cg
			column[3] = 50; // X
			column[4] = 60; // 
			column[5] = 110; // Since
		}

		int width; // EBhE
		int height; // EBhE
		std::array<int, 6> column; // J
		bool stop; // IXbh\
		bool stretch; // JLk
		bool datetime; // \
		bool close; // XbhIɃEBhE
		bbs::Links links; // Cɓf
		bbs::Links threads; // CɓXbh
	};

	// t@C/URLJ
	struct File {
		File()
			: width(600)
			, height(150)
		{}

		int width; // EBhE
		int height; // EBhE
	};

	// 
	struct Search {
		Search()
			: width(400)
			, height(300)
		{}

		int width; // EBhE
		int height; // EBhE
	};

	// o
	struct Extract {
		Extract()
			: width(400)
			, height(300)
		{}

		int width; // EBhE
		int height; // EBhE
	};

	// O
	struct Log {
		Log()
			: graph(true)
			, filter(true)
			, bbs(true)
			, peercast(true)
			, none(true)
		{}
		
		bool graph; // Ot
		bool filter; // tB^
		bool bbs; // BBS
		bool peercast; // PeerCast
		bool none; // ̑
	};

	BBS bbs; // BBSo[j[
	Thread thread; // XbhI
	File file; // t@C/URLJ
	Search search; // 
	Extract extract; // o
	Log log; // O
};

// IvV_CAO
struct OptionConfing {
	// I/^u
	struct Select {
		Select()
			: option(0)
			, network(0)
			, type(0)
			, information(0)
			, res(0)
		{}
		int option; // IvV
		int network; // ڍאݒ/lbg[N^u
		int type; // ڍאݒ/^Cv^u
		int information; // \ݒ/`l^u
		int res; // CAEg/X|bvAbv^u

		struct BBS {
			BBS()
				: common(0)
				, bar(0)
				, browser(0)
			{}

			int common; // BBSݒ/ʃ^u
			int bar; // BBSݒ/BBSo[^u
			int browser; // BBSݒ/BBSuEU^u
		} bbs;
	};

	// ڍאݒ/vpeBObh
	struct Detail {
		struct Network {
			utl::PropSetting general;
			utl::PropSetting peercast;
		} network;

		struct Type {
			utl::PropSetting wmv;
			utl::PropSetting flv;
		} type;

		utl::PropSetting browser;
		utl::PropSetting snapshot;
		utl::PropSetting start;
	};

	// BBSݒ/vpeBObh
	struct BBS {
		struct Common {
			utl::PropSetting general;
			utl::PropSetting network;
			utl::PropSetting thread;
			utl::PropSetting font;
		};
		struct Bar {
			utl::PropSetting thread;
			utl::PropSetting popup;
			utl::PropSetting post;
		};
		struct Browser {
			utl::PropSetting thread;
			utl::PropSetting popup;
			utl::PropSetting scroll;

			struct Skin {
				utl::PropSetting thread;
				utl::PropSetting popup;
			};
			Skin skin;
		};
		Common common;
		Bar bar;
		Browser browser;
	};

	// ݒ/vpeBObh
	struct Operation {
		utl::PropSetting mouse;
		utl::PropSetting variation;
		utl::PropSetting window;
	};

	// \ݒ/vpeBObh
	struct Display {
		struct Information {
			utl::PropSetting general;
		};

		Information information;
	};

	OptionConfing()
	{}

	Select select; // I/^u
	Detail detail;
	BBS bbs;
	Operation operation;
	Display display;
};

//////////////////////////////////////////////////////////////

// LOGFONT
void put(XmlParser& p, const LOGFONT& font);
void get(const XmlParser& p, LOGFONT& font);

void put(XmlParser& p, const std::vector<utl::ReplaceElement>& data);
void get(const XmlParser& p, std::vector<utl::ReplaceElement>& data);

void put(XmlParser& root, const VideoConfig& video);
void get(const XmlParser& root, VideoConfig& video);

void put(XmlParser& root, const DetailConfig& detail);
void get(const XmlParser& root, DetailConfig& detail);

void put(XmlParser& root, const OperationConfig& operation);
void get(const XmlParser& root, OperationConfig& operation);

void put(XmlParser& root, const DisplayConfig& display);
void get(const XmlParser& root, DisplayConfig& display);







// ۑf[^
struct SerializeValues {
	PathInfo recent; // ŋ߂̃pX 

	RECT placement; // EBhEʒu

	WindowControl window; // EBhEݒ

	PlayControl play; // ItCĐ

	dsp::AudioControl audio; // I[fBI

	utl::StatusFormat format; // Xe[^Xo[

	DialogConfig dialog; // e_CAOݒ

	OptionConfing option; // IvV_CAO
	VideoConfig video; // f
	DetailConfig detail; // ڍאݒ
	OperationConfig operation; // ݒ
	DisplayConfig display; // \ݒ

	////////////////////////////////////////
	void load(const std::wstring& current);
	void save(const std::wstring& current);
};

} // namespace sl