// OperationMouseDlg.cpp : t@C
//

#include "stdafx.h"
#include "PCRPlayer.h"
#include "OperationMouseDlg.h"
#include "afxdialogex.h"


// COperationMouseDlg _CAO

IMPLEMENT_DYNAMIC(COperationMouseDlg, CBasePropDlg)

COperationMouseDlg::COperationMouseDlg(utl::PropSetting& setting, sl::MouseOperation& mouse)
	: CBasePropDlg(setting)
	, cfg_(mouse)
{

}

COperationMouseDlg::~COperationMouseDlg()
{
}

void COperationMouseDlg::DoDataExchange(CDataExchange* pDX)
{
	CBasePropDlg::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(COperationMouseDlg, CBasePropDlg)
END_MESSAGE_MAP()


// COperationMouseDlg bZ[W nh[

BOOL COperationMouseDlg::OnInitDialog()
{
	CBasePropDlg::OnInitDialog();

	auto bindWheel = [this](const std::wstring& name, int& value)->CMFCPropertyGridProperty*{
		auto prop = prop_.combo(name, value);
		prop->AddComboValue(L"Ȃ", sl::MOUSE_WHEEL::MOUSE_WHEEL_NONE);
		prop->AddComboValue(L"ʕύX", sl::MOUSE_WHEEL::MOUSE_WHEEL_VOLUME);
		prop->AddComboValue(L"V[N", sl::MOUSE_WHEEL::MOUSE_WHEEL_SEEK);
		prop->AddComboValue(L"XbhXN[", sl::MOUSE_WHEEL::MOUSE_WHEEL_THREAD);
		prop->AddComboValue(L"EBhEg/k", sl::MOUSE_WHEEL::MOUSE_WHEEL_ZOOM);
		return prop;
	};

	auto bindInvert = [this](const std::wstring& name, bool& value)->CMFCPropertyGridProperty*{
		auto prop = prop_.check(name, value);
		return prop;
	};
	
	auto bindMClick = [this](int& value)->CMFCPropertyGridProperty*{
		auto prop = prop_.combo(L"~hNbN", value);
		prop->AddComboValue(L"Ȃ", sl::MOUSE_MCLICK::MOUSE_MCLICK_NONE);
		prop->AddComboValue(L"~[g", sl::MOUSE_MCLICK::MOUSE_MCLICK_MUTE);
		prop->AddComboValue(L"ŏ~[g", sl::MOUSE_MCLICK::MOUSE_MCLICK_MINIMIZE_MUTE);
		prop->AddComboValue(L"ꎞ~", sl::MOUSE_MCLICK::MOUSE_MCLICK_PAUSE);
		prop->AddComboValue(L"ŏꎞ~", sl::MOUSE_MCLICK::MOUSE_MCLICK_MINIMIZE_PAUSE);
		prop->AddComboValue(L"XbhXN[Zbg", sl::MOUSE_MCLICK::MOUSE_MCLICK_THREAD_RESET);
		prop->AddComboValue(L"XbhXV", sl::MOUSE_MCLICK::MOUSE_MCLICK_THREAD_RELOAD);
		prop->AddComboValue(L"BBSݗ\", sl::MOUSE_MCLICK::MOUSE_MCLICK_BBS_EDIT);
		return prop;
	};

	auto bindLDBLClick = [this](int& value)->CMFCPropertyGridProperty*{
		auto prop = prop_.combo(L"_uNbN", value);
		prop->AddComboValue(L"Ȃ", sl::MOUSE_LDBLCLICK::MOUSE_LDBLCLICK_NONE);
		prop->AddComboValue(L"Sʉ", sl::MOUSE_LDBLCLICK::MOUSE_LDBLCLICK_FULLSCREEN);
		prop->AddComboValue(L"ő剻", sl::MOUSE_LDBLCLICK::MOUSE_LDBLCLICK_MAXIMIZE);
		prop->AddComboValue(L"{100%", sl::MOUSE_LDBLCLICK::MOUSE_LDBLCLICK_ZOOM100);
		prop->AddComboValue(L"100%/Sʉ", sl::MOUSE_LDBLCLICK::MOUSE_LDBLCLICK_ZOOM100_FULLSCREEN);
		prop->AddComboValue(L"100%/ő剻", sl::MOUSE_LDBLCLICK::MOUSE_LDBLCLICK_ZOOM100_MAXIMIZE);
		return prop;
	};

	auto bindScreen = [&](CMFCPropertyGridProperty* group, sl::MouseOperation::Screen& value){
		group->AddSubItem(bindWheel(L"zC[", value.wheel));
		group->AddSubItem(bindInvert(L"zC[]", value.invert));
		group->AddSubItem(bindWheel(L"ENbN+zC[", value.rwheel));
		group->AddSubItem(bindInvert(L"ENbN+zC[]", value.rinvert));
		group->AddSubItem(bindMClick(value.mclick));
		group->AddSubItem(bindLDBLClick(value.ldblclick));
	};

	auto bindBar = [&](CMFCPropertyGridProperty* group, sl::MouseOperation::Bar& value){
		auto check = prop_.check(
			L"ʏƓ", value.transfer);
		group->AddSubItem(check);

		auto wheel = bindWheel(L"zC[", value.wheel);
		auto invert = bindInvert(L"zC[]", value.invert);
		auto mclick = bindMClick(value.mclick);

		group->AddSubItem(wheel);
		group->AddSubItem(invert);
		group->AddSubItem(mclick);

		check->AddLink(wheel, TRUE);
		check->AddLink(invert, TRUE);
		check->AddLink(mclick, TRUE);
	};

	auto group = prop_.group(L"ʏ(IC)");
	prop_.add(group);
	{
		bindScreen(group, cfg_.online);
	}

	group = prop_.group(L"ʏ(ItC)");
	prop_.add(group);
	{
		bindScreen(group, cfg_.offline);
	}

	group = prop_.group(L"Xe[^Xo[");
	prop_.add(group);
	{
		bindBar(group, cfg_.status);
	}

	group = prop_.group(L"V[No[");
	prop_.add(group);
	{
		bindBar(group, cfg_.seek);
	}

	group = prop_.group(L"BBSo[");
	prop_.add(group);
	{
		bindBar(group, cfg_.bbs);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
				  // O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void COperationMouseDlg::OnGetProp()
{
	prop_.get();
}

void COperationMouseDlg::OnSetProp()
{
	cfg_ = sl::MouseOperation();

	prop_.set();
}

