#pragma once

#include "BBSManager.h"
#include "BBSSkin.h"

#include <boost/thread.hpp>
#include <boost/thread/recursive_mutex.hpp>

#define DEFAULT_BBS_USERAGENT	L"Monazilla/1.00 (PCRPlayer/1.00)"
#define DEFAULT_BBS_TIMEOUT		10000
#define DEFAULT_BBS_SHITARABA	L"jbbs\\.shitaraba\\.net"
#define DEFAULT_BBS_INTERVAL	7
#define DEFAULT_BBS_BLOCK		true
#define DEFAULT_BBS_BROWSER		false
#define DEFAULT_BBS_LATEST		false
#define DEFAULT_BBS_RANGE		5
#define DEFAULT_BBS_HISTORY		30
#define DEFAULT_BBS_RES			10
#define DEFAULT_BBS_WRITE		true

namespace bbs {

// 
#define HISTORY_MAX 100

struct Link {
	std::wstring title;
	std::wstring url;
};

typedef std::vector<Link> Links;

// fݒ
struct BoardControl {
	BoardControl()
		: userAgent(DEFAULT_BBS_USERAGENT)
		, timeout(DEFAULT_BBS_TIMEOUT)
		, shitaraba(DEFAULT_BBS_SHITARABA)
		, block(DEFAULT_BBS_BLOCK)
		, reload(true)
		, interval(DEFAULT_BBS_INTERVAL)
		, thread(true)
		, board(true)
		, move(true)
		, browser(DEFAULT_BBS_BROWSER)
		, latest(DEFAULT_BBS_LATEST)
		, range(DEFAULT_BBS_RANGE)
		, res(DEFAULT_BBS_RES)
		, write(DEFAULT_BBS_WRITE)
	{
		typedef utl::ReplaceElement RE;
		url.push_back(RE(true, L"΋hCu", L"jbbs\\.livedoor\\.jp/", L"jbbs.shitaraba.net/", false));
		url.push_back(RE(true, L"LiteŃAhXu", L"jbbs\\.shitaraba\\.net/bbs/lite/", L"jbbs.shitaraba.net/bbs/", false));
		url.push_back(RE(true, L"΃XbhꗗfURLɒu", L"jbbs\\.shitaraba\\.net/bbs/subject\\.cgi/", L"jbbs.shitaraba.net/", false));
		url.push_back(RE(false, L"URLu", L"^$", L"http://", false));

		message.push_back(RE(true, L"󔒂ɒu", L"&#160;", L"&nbsp;", false));
		message.push_back(RE(true, L"̉s폜", L"^([ @]*<br>)+", L"", false));
		message.push_back(RE(true, L"̉s폜", L"(<br>[ @]*)+$", L"", false));
		message.push_back(RE(true, L"s̋󔒂폜", L"^[ @]|(<br>)[ @]", L"$1", false));
		message.push_back(RE(true, L"s̋󔒂폜", L"[ @](<br>)|[ @]$", L"$1", false));
		message.push_back(RE(true, L"sȏ̋sȗ", L"([ @]*<br>){2,}", L"<br><br>", false));
		message.push_back(RE(false, L"s폜", L"([ @]*<br>)+", L"<br>", false));
		message.push_back(RE(false, L"10s葽sȗ", L"((.*?<br>){10})(.*)", L"$1iȗ܂j", false));
		message.push_back(RE(false, L"A邗ȗ", L"[wWv]{2,}(?![A-Za-z0-9_%&\\--/=])", L"", false));
	}

	struct History {
		History()
			: board(DEFAULT_BBS_HISTORY)
			, thread(DEFAULT_BBS_HISTORY)
		{}

		int board; // fۑ
		int thread; // Xbhۑ
	};

	std::wstring userAgent; // userAgent
	int timeout; // ^CAEg(ms)
	std::wstring shitaraba; // ΌfhC
	bool block; // X|bvAbv\ĂƂXV
	bool reload; // XbhXV
	int interval; // XbhXVԊu
	bool thread; // Xbhړ/VKXbhI
	bool board; // Xbhړ/VKf
	bool move; // Xbhړ/XbhI
	bool browser; // uEU[h
	bool latest; // VKǂݍݎ̃XɐVtO𗧂Ă
	int range; // QƃX͈
	History history; // ۑ
	int res; // X\(res < 0łׂẴX)
	bool write; // ݂XbhXV
	network::Proxy proxy; // vNV
	std::vector<utl::ReplaceElement> url; // URLu
	std::vector<utl::ReplaceElement> message; // X{u
};

struct BoardControlEx : public BoardControl {
	BoardControlEx()
	{
		block = false; // X|bvAbv\ĂƂXV
		browser = true; // uEU[h
	}
};

// XVR[obNR}h
enum UPDATE {
	UPDATE_ALL,
	UPDATE_COUNTER,
	UPDATE_TITLE,
	UPDATE_STATUS,
	UPDATE_POST,
	//UPDATE_DELAY_TITLE,
	UPDATE_DELAY_STATUS,
	UPDATE_DELAY_POST,
};

class BBSOperator : protected utl::Logger {
private:
	struct Callback {
		Callback()
			: update([](long){})
			, post([](bool){})
			, subject([](bool){})
			, dat([](bool){})
			, extract([](){})
		{}

		utl::SyncValue<boost::function<void(long)> > update; // Xe[^XXV(TITLE/STATUS/POST/ALL)
		utl::SyncValue<boost::function<void(bool)> > post; // e(SUCCEEDED/FAILED)
		utl::SyncValue<boost::function<void(bool)> > subject; // Xbhꗗ擾(START/END)
		utl::SyncValue<boost::function<void(bool)> > dat; // dat擾(SCROLL/UPDATE)
		utl::SyncValue<boost::function<void()> > extract; // extract擾
	};

	// XbhdN
	struct Thread {
		utl::SyncThread reload;
		utl::SyncThread dat;
		utl::SyncThread create;
		utl::SyncThread subject;
		utl::SyncThread change;
		utl::SyncThread post;
	};

	// Xbhds
	struct Mutex {
		boost::recursive_mutex execute;
		boost::recursive_mutex reload;
		boost::recursive_mutex dat;
		boost::recursive_mutex create;
		boost::recursive_mutex subject;
		boost::recursive_mutex change;
		boost::recursive_mutex post;

		boost::recursive_mutex history;
	};

	utl::SyncValue<BoardControl> cfg_;

	utl::SyncValue<std::wstring> path_; // ĐĂ铮̃pX ύXꂽ烊Zbg
	utl::SyncValue<std::wstring> source_; // Xbh/fURL URLȂXbhꗗXV
	utl::SyncValue<bool> once_; // path_ ύXƂɗL
	utl::SyncValue<bool> block_; // XVubN

	Thread thread_;
	Mutex mutex_;
	BBSManager bbs_;

	utl::SyncOptional<std::vector<ResInfo> > dat_;
	utl::SyncOptional<std::vector<ResInfo> > partial_;
	utl::SyncOptional<bool> init_;
	utl::SyncOptional<std::vector<ResInfo> > extract_;
	utl::SyncOptional<std::vector<ThreadInfo> > subject_;

	utl::SyncOptional<std::wstring> title_;
	utl::SyncOptional<std::wstring> status_;
	utl::SyncOptional<std::wstring> post_;

	utl::SyncOptional<SYSTEMTIME> time_;
	utl::SyncOptional<int> counter_;
	utl::SyncOptional<std::vector<std::wstring> > links_;

	Callback callback_;

	struct History {
		Links board;
		Links thread;
	};

	History history_;

	void initialize();

public:
	BBSOperator(utl::SyncLog& log);
	virtual ~BBSOperator();

	operator bool() { return bbs_; }

	void terminate();

public:
	void setConfig(const BoardControl& cfg) { cfg_ = cfg; reset(); }

	void setUpdateCallback(const boost::function<void(long)>& callback) { callback_.update = callback; }
	void setPostCallback(const boost::function<void(bool)>& callback) { callback_.post = callback; }
	void setSubjectCallback(const boost::function<void(bool)>& callback) { callback_.subject = callback; }
	void setDatCallback(const boost::function<void(bool)>& callback) { callback_.dat = callback; }
	void setExtractCallback(const boost::function<void()>& callback) { callback_.extract = callback; }

	void setBlock(bool block) { block_ = block; }

public:
	// t@Cςɏ
	bool init(const std::wstring path);
	// ݒǂݍ݂ƃXbhǂݍ
	void execute(const std::wstring& board, const BoardControl& cfg, bool move = true, bool once = false);
	bool refresh();
	bool reload();
	void interrupt();
	bool create();
	bool reset();
	bool scroll(int diff);
	bool extract();
	bool extract(const std::wstring& text, bool convert, int size = 0, bool head = true);
	bool extract(const bbs::Range& range, int size = 0, bool head = true);
	bool extract(const std::wstring& id, int size = 0, bool head = true);
	bool extract(int ref, int size = 0, bool head = true);
	bool extract(const std::vector<int>& vec, int size = 0, bool head = true);
	bool subject(); // ꗗXV
	bool change(const std::wstring& key); // XbhύXƓǂݍ
	bool post(const std::wstring& name, const std::wstring& mail, const std::wstring& message);

public:
	bool getDat(std::vector<ResInfo>& dat, bool& init)
	{
		if (dat_.get(dat) && init_.get(init))
		{
			init_ = false;
			return true;
		}
		return false;
	}
	bool getDat(std::vector<ResInfo>& dat)
	{
		if (partial_.get(dat))
		{
			utl::HTMLEscape esc;
			utl::NameSplitter split;
			for (auto it = dat.begin(); it != dat.end(); ++it)
			{// GXP[v
				split(it->name, it->split);//GXP[vOɕ
				esc.replace(it->name);
				esc.replace(it->mail);
				esc.replace(it->datetime);
				esc.replace(it->message);
				esc.replace(it->title);
				esc.replace(it->id);
			}
			return true;
		}
		return false;
	}
	bool getExtract(std::vector<ResInfo>& dat) { return extract_.get(dat); }
	bool getLinks(std::vector<std::wstring>& links) { return links_.get(links); }
	bool getSubject(std::vector<ThreadInfo>& subject) { return subject_.get(subject); }

public:
	void getSourceURL(std::wstring& url) { url = source_.get(); }
	bool getURL(std::wstring& url) { return bbs_.getURL(url); }
	bool getBoardURL(std::wstring& url) { return bbs_.getBoardURL(url); }
	bool getThreadURL(std::wstring& url) { return bbs_.getThreadURL(url); }
	bool getBoardTitle(std::wstring& title) { return bbs_.getBoardTitle(title); }
	bool getThreadTitle(std::wstring& title) { return bbs_.getThreadTitle(title); }
	bool getNoName(std::wstring& noname) { return bbs_.getNoName(noname); }
	bool getCount(int& count) { return bbs_.getCount(count); }
	bool getKey(std::wstring& key) { return bbs_.getKey(key); }
	bool isThread() { return bbs_.hasKey(); }
	bool getStop(int& stop) { return bbs_.getStop(stop); }
	bool isStop() { return bbs_.isStop(); }

public:
	void setTitle(const std::wstring& title) { title_ = title; }
	bool getTitle(std::wstring& title) { return title_.get(title); }
	void setStatus(const std::wstring& status) { status_ = status; }
	bool getStatus(std::wstring& status) { return status_.get(status); }
	void setPost(const std::wstring& post) { post_ = post; }
	bool getPost(std::wstring& post) { return post_.get(post); }
	void clearPost() { post_.clear(); }
	bool getCounter(int& counter) { return counter_.get(counter); }
	bool isReload() { return counter_; }
	bool getTime(SYSTEMTIME& time) { return time_.get(time); }

public:
	void addHistory(bool thread);
	void resizeHistory(bool thread);
	void getHistory(bool thread, Links& links);
	void setHistory(bool thread, const Links& links);
	void clearHistory(bool thread);

private:
	bool isValid();
	bool isBrowser();
	std::wstring getSourceTitle();
	std::wstring getBoardTitle();
	std::wstring getThreadTitle();
	bool getFastest(ThreadInfo& info);
	void cut(std::vector<ResInfo>& dat, int size, bool head = true);

private:
	struct ReloadControl {
		ReloadControl(bool reload, bool stop, bool move, bool once)
			: reload(reload)
			, stop(stop)
			, move(move)
			, once(once)
		{}

		bool reload; // XV
		bool stop; // XȂ~
		bool move; // X̂ƂXbhړL
		bool once; // 񂾂JE^[𖳎đɍXV(ݐ)
	};

	void executeThread(const std::wstring& board, const BoardControl& cfg, bool move, bool once);
	void reloadThread(const ReloadControl& ctrl);
	void datThread(const ReloadControl& ctrl);
	void createThread(int diff, bool reset, bool scroll);
	void extractThread();
	void extractThread(const std::wstring& text, bool convert, int size, bool head);
	void extractThread(const bbs::Range& range, int size, bool head);
	void extractThread(const std::wstring& id, int size, bool head);
	void extractThread(int ref, int size, bool head);
	void extractThread(const std::vector<int>& vec, int size, bool head);
	bool subjectThread();
	void changeThread(const std::wstring& key, const ReloadControl& ctrl);
	void postThread(const std::wstring& name, const std::wstring& mail, const std::wstring& message);
};


} // namespace bbs