#pragma once

#include "name.hpp"
#include "serialize.hpp"
#include <llarp/net/net_int.hpp>

#include <memory>
#include <vector>

namespace llarp
{
  namespace dns
  {
    using RRClass_t = uint16_t;
    using RRType_t = uint16_t;
    using RR_RData_t = std::vector<byte_t>;
    using RR_TTL_t = uint32_t;

    struct ResourceRecord : public Serialize
    {
      ResourceRecord() = default;
      ResourceRecord(const ResourceRecord& other);
      ResourceRecord(ResourceRecord&& other);

      explicit ResourceRecord(std::string name, RRType_t type, RR_RData_t rdata);

      bool
      Encode(llarp_buffer_t* buf) const override;

      bool
      Decode(llarp_buffer_t* buf) override;

      util::StatusObject
      ToJSON() const override;

      std::string
      ToString() const;

      bool
      HasCNameForTLD(const std::string& tld) const;

      std::string rr_name;
      RRType_t rr_type;
      RRClass_t rr_class;
      RR_TTL_t ttl;
      RR_RData_t rData;
    };
  }  // namespace dns
}  // namespace llarp

template <>
constexpr inline bool llarp::IsToStringFormattable<llarp::dns::ResourceRecord> = true;
