#!/sbin/sh

ui_print "Making Essential Files..."
ui_print " "
ui_print "Setting Variables..."
ui_print " "
BB=/data/adb/magisk/busybox
MK=$MODPATH/bin/MK
MKO=$TMP/O
MKOU=$TMP/system1
MKOU2=$TMP/mkadp1
MKOBU=$TMP/zzzzbutters-files
MKUTIL=$TMP/Util
MKUTILU=$TMP/MKUtils
MKUTILSU=$TMP/Utils
ui_print "Extracting Files to correct places..."
ui_print " "

cp -rf $MODPATH/bin/7 $TMP/
set_perm_recursive $TMP 0 0 0777 0777
$TMP/7 "x" "-y" "$MK" "*" "-o$TMP/" >&2
rm -f $MK
set_perm_recursive $TMP 0 0 0777 0777
$TMP/7 "x" "-y" "$MKO" "*" "-o$TMP/" >&2
rm -rf $MKO
cp -rf $MKOU/* $MODPATH
rm -rf $MKOU
cp -rf $MKOU2/* /data/
rm -rf $MKOU2
cp -rf $MKBU /data/media/0/
rm -rf $MKBU
set_perm_recursive $TMP 0 0 0777 0777
$TMP/7 "x" "-y" "$MKUTIL" "*" "-o$TMP/" >&2
set_perm_recursive $TMP 0 0 0777 0777
$TMP/7 "x" "-y" "$MKUTILU" "*" "-o$TMP/" >&2
cp -rf $MKUTILSU/* $TMP/
set_perm_recursive $TMP 0 0 0777 0777
#Menu print
MKADPO=/data/mkadp/O

dojob() {
sh -x $TMP/bb_utils.sh $1 $2 $3 $4 $5
}
   flag=true
   echo -n >$MKADPO/secureflag
   ui_print " "   

rm -rf $MODPATH/bin

#$BB cp -rf $MODPATH/system/etc/mkadp/be.sh /data/adb/service.d/

if defined flag; then
	ui_print "⚡Disabling Secure Flag⚡..."
ui_print " "
	ui_print "This will take a few moments. Please have patience..."
ui_print " "
#Files to patch
stock_services="/system/framework/services.jar"
mod_services="$MODPATH/system/framework/services.jar"

#Check DEODEX 
if ! unzip -l "$stock_services" | grep classes.dex >/dev/null; then
   ui_print " "
   abort " You need a deodexed services.jar"
fi

#Making magisk space
ui_print " -- Making magisk space "
ui_print " "
mkdir -p $(dirname "$mod_services")


#Defining smali methods
#Some methods cannot be defined directly as variables (define them in a text file)

disable='
    .locals 1

    const/4 v0, 0x0

    return v0
'

#Decompiling with standard apktool for use custom actions(Only .dex)
   ui_print " -- Decompiling services.jar..."
   apktool d "$stock_services" -o "$TMP/services"

smali_kit -c -m "isSecureLocked" -re "$disable" -d "$TMP/services"
smali_kit -c -m "preventTakingScreenshotToTargetWindow" -re "$disable" -d "$TMP/services"
ui_print " "

#Recompiling
   ui_print " "
   ui_print " -- Recompiling services.jar..."
   apktool --copy-original b "$TMP/services" -o "$mod_services"
ui_print " "
ui_print " "

sdk_version=$(cat /system/build.prop | grep 'ro.build.version.sdk=' | cut -d= -f2)

# Check if the version is greater than or equal to 34
if [[ $sdk_version -ge 34 ]]; then
stock_services="/system/framework/services.jar"
mod_services="$MODPATH/system/framework/services.jar"
mkdir "$TMP/s"
mkdir "$TMP/m"

# Unzip stock_services
unzip -q "$stock_services" -d "$TMP/s" &> /dev/null
unzip -q "$mod_services" -d "$TMP/m" &> /dev/null
rm -rf "$TMP/s/classes3.dex"
cp -f "$TMP/m/classes3.dex" "$TMP/s" &> /dev/null
cd "$TMP/s"
zip -q -r "$mod_services" . 
fi


   #Check build
   if [ ! -e "$mod_services" ]; then
      abort " -- Some ERROR occurred during the recompilation of services.jar ! "
   elif ! unzip -l "$mod_services" | grep classes.dex >/dev/null; then
      abort " -- Invalid file: services.jar "
   fi
fi
ui_print "[*] Setting permissions..."
ui_print " " 
set_perm_recursive $MODPATH 0 0 0755 0755 
set_perm_recursive $MODPATH/system 0 0 0755 0644
set_perm_recursive $MODPATH/system/xbin 0 2000 0777 0777
set_perm_recursive $MODPATH/system/bin 0 0 0777 0755 
ui_print " Done "
ui_print " "
ui_print "Now Please Reboot your device"
ui_print " "
ui_print "to complete this installation..."
ui_print " "
ui_print " "
