<?php

// Flag code to name mapping
function get_board_flags_array() {
  static $board_flags = array(
    'AAP' => 'AAP',
    'ACE' => 'Asexual',
    'ACH' => 'Achillean',
    'AFB' => 'AFAB',
    'AGP' => 'AGP',
    'AGR' => 'Agender',
    'ALL' => 'LGBT',
    'ALY' => 'Ally',
    'AMB' => 'AMAB',
    'AND' => 'Androgynous',
    'ARO' => 'Aromantic',
    'BCH' => 'Butch',
    'BI' => 'Bisexual',
    'BOY' => 'Boymoder',
    'BR' => 'Bear',
    'CHR' => 'Chaser',
    'CIS' => 'Cis',
    'DOM' => 'Dom',
    'DRO' => 'Demiromantic',
    'DSX' => 'Demisexual',
    'FBY' => 'Femboy',
    'FFB' => 'FtM Femboy',
    'FR' => 'FtM Repressor',
    'GAY' => 'Gay',
    'GFL' => 'Genderfluid',
    'GQR' => 'Genderqueer',
    'HFB' => 'HRT Femboy',
    'HON' => 'Hon',
    'HST' => 'HSTS',
    'INT' => 'Intersex',
    'LAB' => 'Labrys',
    'LES' => 'Lesbian',
    'MBT' => 'MtF Butch',
    'MR' => 'MtF Repressor',
    'NB' => 'Nonbinary',
    'OG' => 'Original',
    'PAN' => 'Pansexual',
    'PBI' => 'Prison Bi',
    'PG' => 'Prison Gay',
    'PLY' => 'Poly',
    'PNR' => 'Pooner',
    'PRG' => 'Progress',
    'QES' => 'Questioning',
    'QR' => 'Queer',
    'REP' => 'Repressor',
    'SPH' => 'Sapphic',
    'STR' => 'Straight',
    'SUB' => 'Sub',
    'SW' => 'Switch',
    'TF' => 'Transfem',
    'TKH' => 'Twinkhon',
    'TMA' => 'Transmasc',
    'TNK' => 'Twink',
    'TRN' => 'Transgender',
    'UKR' => 'Woke'
  );
  
  return $board_flags;
}

// Flag names as they appear in the selection menu
function get_board_flags_selector() {
  static $board_flags = array(
    'AAP' => 'AAP',
    'ACE' => 'Asexual',
    'ACH' => 'Achillean',
    'AFB' => 'AFAB',
    'AGP' => 'AGP',
    'AGR' => 'Agender',
    'ALL' => 'LGBT',
    'ALY' => 'Ally',
    'AMB' => 'AMAB',
    'AND' => 'Androgynous',
    'ARO' => 'Aromantic',
    'BCH' => 'Butch',
    'BI' => 'Bisexual',
    'BOY' => 'Boymoder',
    'BR' => 'Bear',
    'CHR' => 'Chaser',
    'CIS' => 'Cis',
    'DOM' => 'Dom',
    'DRO' => 'Demiromantic',
    'DSX' => 'Demisexual',
    'FBY' => 'Femboy',
    'FFB' => 'FtM Femboy',
    'FR' => 'FtM Repressor',
    'GAY' => 'Gay',
    'GFL' => 'Genderfluid',
    'GQR' => 'Genderqueer',
    'HFB' => 'HRT Femboy',
    'HON' => 'Hon',
    'HST' => 'HSTS',
    'INT' => 'Intersex',
    'LAB' => 'Labrys',
    'LES' => 'Lesbian',
    'MBT' => 'MtF Butch',
    'MR' => 'MtF Repressor',
    'NB' => 'Nonbinary',
    'OG' => 'Original',
    'PAN' => 'Pansexual',
    'PBI' => 'Prison Bi',
    'PG' => 'Prison Gay',
    'PLY' => 'Poly',
    'PNR' => 'Pooner',
    'PRG' => 'Progress',
    'QES' => 'Questioning',
    'QR' => 'Queer',
    'REP' => 'Repressor',
    'SPH' => 'Sapphic',
    'STR' => 'Straight',
    'SUB' => 'Sub',
    'SW' => 'Switch',
    'TF' => 'Transfem',
    'TKH' => 'Twinkhon',
    'TMA' => 'Transmasc',
    'TNK' => 'Twink',
    'TRN' => 'Transgender',
    'UKR' => 'Woke'
  );
  
  return $board_flags;
}

function board_flag_code_to_name($code) {
  $board_flags = get_board_flags_array();
  return isset($board_flags[$code]) ? $board_flags[$code] : 'None';
}
