function newid()
	rolling_id = rolling_id + 1
	return rolling_id
end

function gettid(x,y)
	return x + y * map.w
end

function findunit(id)
	for i,unit in ipairs(units) do
		if (unit.values[ID] == id) and (unit.flags[DEAD] == false) then
			return unit
		end
	end
end

function findunits(name,orteam_)
	local result = {}
	local orteam = orteam_ or false
	
	for i,unit in ipairs(units) do
		if ((unit.name == name) or ((unit.strings[TEAM] == name) and orteam)) and (unit.flags[DEAD] == false) then
			table.insert(result, unit)
		end
	end
	
	return result
end

function delete(id)
	local unit = findunit(id)
	local fixed = unit.fixed
	local text = unit.strings[TYPE]
	
	if (unit.flags[DEAD] == false) then
		if (gdata.values[SELECTED] == id) then
			gdata.values[SELECTED] = 0
			cancel()
		end
		
		if (#unit.strings[TEAM] > 0) then
			trymessage(unit,"defeat")
		end
		
		for i,unit in ipairs(texts) do
			if (unit.fixed == fixed) then
				table.remove(texts, i)
				break
			end
		end
		
		for i,unit in ipairs(units) do
			if (unit.fixed == fixed) then
				table.remove(units, i)
				break
			end
		end
		
		if (text == "text") then
			updaterules = true
		end
		
		gdata.undo = {}
		gdata2.values[UNDO] = 0
	end
end

function anymovers()
	for i,v in ipairs(units) do
		if ((v.step > 0) or (#v.queue > 0)) and (v.flags[DEAD] == false) then
			return true
		end
	end
	
	return false
end

function inbounds(x,y)
	return (x >= 0) and (y >= 0) and (x < map.w) and (y < map.h)
end

function namehere(x,y,name)
	for i,unit in ipairs(units) do
		if (unit.xpos == x) and (unit.ypos == y) and (unit.name == name) and (unit.flags[DEAD] == false) then
			return true
		end
	end
	
	return false
end

function getgameid()
	return gdata.strings[WORLD] .. "_" .. tostring(gdata2.values[SAVE])
end

function here(x,y,onlyobs_,notthis_)
	local result = {}
	local onlyobs = onlyobs_ or false
	local notthis = notthis_ or 0
	
	for i,unit in ipairs(units) do
		if (unit.xpos == x) and (unit.ypos == y) and (unit.values[ID] ~= notthis) and (unit.flags[DEAD] == false) then
			if (onlyobs == false) or unit.solid or unit.stop then
				table.insert(result, unit)
			end
		end
	end
	
	return result
end

function here_solids(x,y,notthis_)
	local result = {}
	local notthis = notthis_ or 0
	
	for i,unit in ipairs(units) do
		if (unit.xpos == x) and (unit.ypos == y) and (unit.values[ID] ~= notthis) and (unit.flags[DEAD] == false) then
			if unit.solid then
				table.insert(result, unit)
			end
		end
	end
	
	return result
end

function here_mechs(x,y,notthis_)
	local result = {}
	local notthis = notthis_ or 0
	
	for i,unit in ipairs(units) do
		if (unit.xpos == x) and (unit.ypos == y) and (unit.values[ID] ~= notthis) and (unit.flags[DEAD] == false) then
			if (unit.strings[TEAM] == "mech") then
				table.insert(result, unit)
			end
		end
	end
	
	return result
end

function here_obs(x,y,notthis_)
	local result = false
	local result_ = {}
	local notthis = notthis_ or 0
	
	for i,unit in ipairs(units) do
		if (unit.xpos == x) and (unit.ypos == y) and (unit.values[ID] ~= notthis) and (unit.flags[DEAD] == false) then
			if unit.solid or unit.stop then
				result = true
				table.insert(result_, unit)
			end
		end
	end
	
	return result,result_
end

function countunits(name)
	local result = 0
	
	for i,u in ipairs(units) do
		if ((u.name == name) or (u.strings[TEAM] == name)) and (u.flags[DEAD] == false) then
			result = result + 1
		end
	end
	
	return result
end

function countunvisited(name)
	local result = 0
	
	for i,u in ipairs(units) do
		if ((u.name == name) or (u.strings[TEAM] == name)) and (u.visited == false) and (u.flags[DEAD] == false) then
			result = result + 1
		end
	end
	
	return result
end

function getpath(unit,targets_,steps,flying_)
	local dijkstra = {}
	local done = {}
	local route = ""
	local finish = false
	local target
	local ex,ey = unit.xpos,unit.ypos
	local flying = flying_ or false
	
	local targets = {}
	for i,v in ipairs(targets_) do
		if (v ~= "protect") then
			table.insert(targets, v)
		else
			for a,b in ipairs(objectives) do
				if b.enemytarget and (b.targetunit ~= nil) then
					table.insert(targets, b.targetunit)
				end
			end
		end
	end
	
	for dir=1,4 do
		local drs = dirs[dir]
		local ox,oy = drs[1],drs[2]
		local nx,ny = unit.xpos + ox, unit.ypos + oy
		local tid = gettid(nx,ny)
		
		if inbounds(nx,ny) and (done[tid] == nil) then
			done[tid] = 1
			table.insert(dijkstra, {1, nx, ny, tostring(dir)})
		end
	end
	
	local limit = 0
	while (#dijkstra > 0) and (finish == false) do
		local this = dijkstra[1]
		local x = this[2]
		local y = this[3]
		local flycheck = this[5] or false
		ex,ey = x,y
		limit = limit + 1
		
		local r,r_ = here_obs(x,y)
		if (flying == false) or (flycheck == false) then
			for i,v in ipairs(r_) do
				for a,b in ipairs(targets) do
					if (v.name == b) or (v.strings[TEAM] == b) then
						route = this[4]
						finish = true
						local final = ""
						
						if (#route <= steps + 1) then
							target = v
						end
						
						if (#route <= steps) then
							final = string.sub(route, #route, #route)
							route = string.sub(route, 1, #route-1)
						else
							final = string.sub(route, steps, steps)
							route = string.sub(route, 1, steps)
						end
						
						ex,ey = unit.xpos,unit.ypos
						if (#route > 0) then
							for j=1,#route do
								local dir = tonumber(string.sub(route, j, j)) or 1
								local drs = dirs[dir]
								local ox,oy = drs[1],drs[2]
								ex = ex + ox
								ey = ey + oy
							end
						end
						
						local final_ = tonumber(final) or 1
						return route,ex,ey,final_-1,target
					end
				end
			end
		end
		
		table.remove(dijkstra, 1)
		
		if (r == false) or flying then
			for dir=1,4 do
				local drs = dirs[dir]
				local ox,oy = drs[1],drs[2]
				local nx,ny = x + ox, y + oy
				local tid = gettid(nx,ny)
				
				if inbounds(nx,ny) and (done[tid] == nil) then
					done[tid] = 1
					local dist = math.abs(unit.xpos - nx) + math.abs(unit.ypos - ny)
					
					if (#dijkstra == 0) then
						table.insert(dijkstra, {dist, nx, ny, this[4] .. tostring(dir), r})
					else
						for i,v in ipairs(dijkstra) do
							if (v[1] > dist) then
								table.insert(dijkstra, i, {dist, nx, ny, this[4] .. tostring(dir), r})
								break
							elseif (i == #dijkstra) then
								table.insert(dijkstra, {dist, nx, ny, this[4] .. tostring(dir), r})
								break
							end
						end
					end
				end
			end
		end
	end
	
	return route,ex,ey,unit.values[DIR],nil
end